/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.playmanage;

import com.alibaba.fastjson.JSONArray;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.bid.business.bill.IBidPayFileService;
import kd.scm.bid.business.bill.serviceImpl.BidPayFileServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.entity.BidPayConstant;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.util.CommonUtil;

public class BidPayRefundPay
extends AbstractBillPlugIn
implements RowClickEventListener,
UploadListener,
CellClickListener {
    private IBidPayFileService bidPayFileService = new BidPayFileServiceImpl();

    public void beforeBindData(EventObject e) {
        Long projectId;
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
        if (bidsection == null || bidsection.size() == 0) {
            String bidproject = (String)this.getView().getFormShowParameter().getCustomParam("bidproject");
            DynamicObject bProject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidproject), (String)(this.getAppId() + "_project"));
            this.generBasicInfo(dataEntity, bProject);
            this.generPayMsg(dataEntity, bProject);
        }
        if (bidsection != null) {
            for (DynamicObject sectionRow : bidsection) {
                DynamicObjectCollection supplierentry = sectionRow.getDynamicObjectCollection("supplierentry");
                for (DynamicObject row : supplierentry) {
                    DynamicObject file;
                    DynamicObject payRecord = BusinessDataServiceHelper.loadSingle((Object)row.get("paylistid"), (String)(this.getAppId() + "_pay_list"));
                    DynamicObjectCollection payback = payRecord.getDynamicObjectCollection("payback");
                    if (payback != null && payback.size() > 0) {
                        DynamicObject packRow = (DynamicObject)payback.get(payback.size() - 1);
                        row.set("backtime", packRow.get("backtime"));
                        row.set("backuser", packRow.get("backuser"));
                        row.set("reason", packRow.get("freason"));
                    }
                    if (null == (file = this.bidPayFileService.getOneFileRecordByPaylistid(Long.valueOf(row.getLong("paylistid")), "id"))) continue;
                    List attachments = AttachmentServiceHelper.getAttachments((String)(this.getAppId() + "_pay_file"), (Object)file.get("id"), (String)"attachmentpanelap");
                    List attachmentList = BidFileHelper.copyToEntryAttachment((List)attachments);
                    DynamicObjectCollection certificate_new = row.getDynamicObjectCollection("certificate_new");
                    certificate_new.clear();
                    attachmentList.forEach(attachment -> certificate_new.addNew().set("fbasedataid", attachment));
                    int num = attachments.size();
                    row.set("certificate", (Object)num);
                }
            }
        }
        RequestContext context = RequestContext.get();
        String userId = context.getUserId();
        boolean isAdmin = CommonUtil.isBidAdmin((String)this.getAppId(), (Long)RequestContext.get().getCurrUserId());
        if (!isAdmin && (projectId = Long.valueOf(dataEntity.getDynamicObject("bidproject").getLong("id"))) != 0L) {
            QFilter qFilter = new QFilter("user", "=", (Object)Long.parseLong(userId));
            QFilter qFilter1 = new QFilter("bidproject", "=", (Object)projectId);
            QFilter qFilter2 = new QFilter("respbusiness", "like", (Object)"%16%");
            QFilter qFilter3 = new QFilter("isdirector", "=", (Object)"1");
            qFilter.and(qFilter1).and(qFilter2).and(qFilter3);
            DynamicObject[] leaders = BusinessDataServiceHelper.load((String)"bid_leadermemberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter});
            QFilter qFilter4 = new QFilter("user", "=", (Object)Long.parseLong(userId));
            qFilter4.and(qFilter1).and(qFilter2);
            DynamicObject[] members = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter4});
            if (!(leaders != null && leaders.length >= 1 || members != null && members.length >= 1)) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
            QFilter qFilter5 = new QFilter("user", "=", (Object)Long.parseLong(userId));
            qFilter5.and(new QFilter("bidproject", "=", (Object)projectId)).and(new QFilter("isdirector", "=", (Object)"1"));
            DynamicObject[] isdirectorMembers = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter5});
            if (isdirectorMembers.length > 0) {
                formShowParameter.setStatus(OperationStatus.EDIT);
            }
        }
        this.getView().updateView("supplierentry");
        this.getView().updateView("bidsection");
    }

    public String getBidAdminRoleID(String formId) {
        String[] s;
        if (formId != null && !"".equals(formId) && (s = formId.split("_")).length > 0) {
            if ("bid".equals(s[0])) {
                return "/FFXFSRKI73+";
            }
            if ("rebm".equals(s[0])) {
                return "/V6OAY0JH+8R";
            }
        }
        return "";
    }

    public void generBasicInfo(DynamicObject dataEntity, DynamicObject bProject) {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String respbusiness = this.getBidProjectRespbusiness(bProject);
        if (StringUtils.equals((CharSequence)"bid", (CharSequence)this.getAppId())) {
            dataEntity.set("bidproject", (Object)BusinessDataServiceHelper.loadSingle((Object)bProject.getPkValue(), (String)"bidproject_f7"));
        } else {
            dataEntity.set("bidproject", (Object)BusinessDataServiceHelper.loadSingle((Object)bProject.getPkValue(), (String)"rebm_bidproject_f7"));
        }
        dataEntity.set("org", bProject.get("org"));
        dataEntity.set("respbusiness", (Object)respbusiness);
        dataEntity.set("isOpen", (Object)Boolean.TRUE);
        dataEntity.set("currency", bProject.get("currency"));
        dataEntity.set("entitytypeid", (Object)(this.getAppId() + "_refund_pay"));
        dataEntity.set("type", (Object)type);
        dataEntity.set("costtype", (Object)"02");
    }

    public void generPayMsg(DynamicObject dataEntity, DynamicObject bidProject) {
        List paylistids = (List)this.getView().getFormShowParameter().getCustomParam("paylistid");
        String selectStr = "id,status,type,sectionname,supplier,suresum,realsum,paytime,certificate,explain,payback,payback.freason,payback.backuser,payback.backtime";
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)(this.getAppId() + "_pay_list"), (String)selectStr, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)paylistids)});
        Map<String, List<DynamicObject>> sectionList = Arrays.stream(loads).collect(Collectors.groupingBy(item -> {
            String sectionname = item.getString("sectionname");
            if (StringUtils.isBlank((CharSequence)sectionname)) {
                return ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"BidPayRefundPay_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            }
            return sectionname;
        }));
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
        if (enablemultisection) {
            for (Map.Entry<String, List<DynamicObject>> entry : sectionList.entrySet()) {
                String key = entry.getKey();
                bidsection.addNew().set("sectionname", (Object)key);
            }
        } else {
            bidsection.addNew().set("sectionname", (Object)ResManager.loadKDString((String)"\u6807\u6bb5\u4e00", (String)"BidPayRefundPay_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject section : bidsection) {
            List<DynamicObject> payList = sectionList.get(section.getString("sectionname"));
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject payRecord : payList) {
                DynamicObject row = supplierentry.addNew();
                row.set("status", payRecord.get("status"));
                row.set("entrytype", payRecord.get("type"));
                row.set("supplier", payRecord.get("supplier"));
                row.set("suresum", payRecord.get("suresum"));
                row.set("realsum", payRecord.get("realsum"));
                row.set("paytime", payRecord.get("paytime"));
                row.set("explain", payRecord.get("explain"));
                row.set("paylistid", payRecord.getPkValue());
            }
        }
    }

    public void afterBindData(EventObject e) {
        String billstatus;
        DynamicObject pay = this.getModel().getDataEntity(true);
        DynamicObject bidProject = pay.getDynamicObject("bidproject");
        boolean isdeposit = bidProject.getBoolean("isdeposit");
        boolean issupplierget = bidProject.getBoolean("issupplierget");
        int type = pay.getInt("type");
        SplitContainer splitContainer = (SplitContainer)this.getControl("sectionsplitcontainer");
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        DynamicObject org = pay.getDynamicObject("org");
        Object orgPk = null;
        orgPk = org != null ? org.getPkValue() : Long.valueOf(RequestContext.get().getOrgId());
        if (orgPk != null) {
            Boolean isExit = CodeRuleServiceHelper.isExist((String)(this.getAppId() + "_pay"), (DynamicObject)pay, (String)orgPk.toString());
            String billno = pay.getString("billno");
            if (!isExit.booleanValue() && StringUtils.isBlank((CharSequence)billno)) {
                String string = pay.getDynamicObject("bidproject").getString("billno");
                pay.set("billno", (Object)string);
                this.getView().updateView("billno");
            }
        }
        if (StringUtils.equals((CharSequence)(billstatus = this.getView().getModel().getDataEntity(true).getString("billstatus")), (CharSequence)"I")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap", "save", "submit", "audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanel1"});
        }
        if (splitContainer != null) {
            if (!enablemultisection) {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
            } else if (0 == type) {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
            } else if (isdeposit || issupplierget) {
                splitContainer.changeFlexStatus(SplitDirection.left, false);
            } else {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
            }
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("supplierentry");
        DynamicObjectCollection bidSections = pay.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection supllierEntry = ((DynamicObject)bidSections.get(0)).getDynamicObjectCollection("supplierentry");
        this.changeEntryFieldColor(grid, supllierEntry);
        boolean isopen = pay.getBoolean("isOpen");
        if (isopen) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"reason"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            grid.setColumnProperty("realsum", "l", (Object)55);
            grid.setColumnProperty("paytime", "l", (Object)55);
            grid.setColumnProperty("explain", "l", (Object)55);
            this.getView().setStatus(OperationStatus.VIEW);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reason"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            grid.setColumnProperty("realsum", "l", (Object)0);
            grid.setColumnProperty("paytime", "l", (Object)0);
            grid.setColumnProperty("explain", "l", (Object)0);
            this.getView().setStatus(OperationStatus.EDIT);
            for (int i = 0; i < bidSections.size(); ++i) {
                DynamicObject section = (DynamicObject)bidSections.get(i);
                DynamicObjectCollection supllierEntrys = section.getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supllierEntrys.size(); ++j) {
                    Long paylistId = ((DynamicObject)supllierEntrys.get(j)).getLong("paylistid");
                    DynamicObject file = this.bidPayFileService.getOneFileRecordByPaylistid(paylistId, "id");
                    if (null == file) continue;
                    List attachments = AttachmentServiceHelper.getAttachments((String)(this.getAppId() + "_pay_file"), (Object)file.get("id"), (String)"attachmentpanelap");
                    int num = attachments.size();
                    for (int k = 0; k < num; ++k) {
                        this.getPageCache().put(pay.getString("id") + "_file_" + i + "_" + j + "_" + k, JSONArray.toJSONString(attachments.get(k)));
                    }
                    this.getPageCache().put(pay.getString("id") + "_" + i + "_" + j + "_filesize", num + "");
                    this.getPageCache().put(pay.getString("id") + "_" + i + "_" + j + "_fileId", file.get("id").toString());
                }
            }
            this.getView().updateView("bidsection");
            this.getView().updateView("supplierentry");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("supplierentry");
        IDataModel operate = grid.getModel();
        DynamicObjectCollection supllierEntry = operate.getEntryEntity("supplierentry");
        this.changeEntryFieldColor(grid, supllierEntry);
        EntryGrid entryGrid4Session = (EntryGrid)this.getView().getControl("bidsection");
        entryGrid4Session.addRowClickListener((RowClickEventListener)this);
        grid.addCellClickListener((CellClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"close") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getModel().setDataChanged(false);
            DynamicObject pay = this.getModel().getDataEntity(true);
            boolean isopen = pay.getBoolean("isOpen");
            if (!isopen) {
                DynamicObjectCollection bidSections = pay.getDynamicObjectCollection("bidsection");
                for (int i = 0; i < bidSections.size(); ++i) {
                    DynamicObject section = (DynamicObject)bidSections.get(i);
                    DynamicObjectCollection supllierEntrys = section.getDynamicObjectCollection("supplierentry");
                    for (int j = 0; j < supllierEntrys.size(); ++j) {
                        MainEntityType t;
                        Throwable throwable;
                        TXHandle h;
                        Long paylistId = ((DynamicObject)supllierEntrys.get(j)).getLong("paylistid");
                        String fileId = this.getPageCache().get(pay.getString("id") + "_" + i + "_" + j + "_fileId");
                        if (null != fileId && !"".equals(fileId)) {
                            int num = Integer.parseInt(this.getPageCache().get(pay.getString("id") + "_" + i + "_" + j + "_filesize"));
                            ArrayList<Map> attachments = new ArrayList<Map>();
                            if (0 != num) {
                                for (int k = 0; k < num; ++k) {
                                    String temp = this.getPageCache().get(pay.getString("id") + "_file_" + i + "_" + j + "_" + k);
                                    Map map = (Map)JSONArray.parse((String)temp);
                                    String url = (String)map.get("url");
                                    map.put("url", BidPayRefundPay.getUrlPath(url));
                                    attachments.add(map);
                                }
                                h = TX.requiresNew();
                                throwable = null;
                                try {
                                    try {
                                        BidFileHelper.removeAllFile((String)"bid_pay_file", (Object)fileId, (String)"attachmentpanelap");
                                    }
                                    catch (Throwable ex) {
                                        h.markRollback();
                                        throw ex;
                                    }
                                }
                                catch (Throwable ex) {
                                    throwable = ex;
                                    throw ex;
                                }
                                finally {
                                    if (h != null) {
                                        if (throwable != null) {
                                            try {
                                                h.close();
                                            }
                                            catch (Throwable ex) {
                                                throwable.addSuppressed(ex);
                                            }
                                        } else {
                                            h.close();
                                        }
                                    }
                                }
                                AttachmentServiceHelper.upload((String)"bid_pay_file", (Object)fileId, (String)"attachmentpanelap", attachments);
                                continue;
                            }
                            h = TX.requiresNew();
                            throwable = null;
                            try {
                                try {
                                    BidFileHelper.removeAllFile((String)"bid_pay_file", (Object)fileId, (String)"attachmentpanelap");
                                }
                                catch (Throwable ex) {
                                    h.markRollback();
                                    throw ex;
                                }
                            }
                            catch (Throwable ex) {
                                throwable = ex;
                                throw ex;
                            }
                            finally {
                                if (h != null) {
                                    if (throwable != null) {
                                        try {
                                            h.close();
                                        }
                                        catch (Throwable ex) {
                                            throwable.addSuppressed(ex);
                                        }
                                    } else {
                                        h.close();
                                    }
                                }
                            }
                            t = EntityMetadataCache.getDataEntityType((String)"bid_pay_file");
                            BusinessDataServiceHelper.delete((IDataEntityType)t, (Object[])new Object[]{fileId});
                            continue;
                        }
                        DynamicObject file = this.bidPayFileService.getOneFileRecordByPaylistid(paylistId, "id");
                        if (null == file) continue;
                        String pkId = file.get("id").toString();
                        h = TX.requiresNew();
                        throwable = null;
                        try {
                            try {
                                BidFileHelper.removeAllFile((String)"bid_pay_file", (Object)fileId, (String)"attachmentpanelap");
                            }
                            catch (Throwable ex) {
                                h.markRollback();
                                throw ex;
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (h != null) {
                                if (throwable != null) {
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    h.close();
                                }
                            }
                        }
                        t = EntityMetadataCache.getDataEntityType((String)"bid_pay_file");
                        BusinessDataServiceHelper.delete((IDataEntityType)t, (Object[])new Object[]{pkId});
                    }
                }
            }
        }
    }

    private static String getUrlPath(String url) {
        String[] urlArr = url.split("path=/");
        try {
            if (urlArr.length > 1) {
                String[] desUrlArr = urlArr[1].split("&kdedcba");
                return URLDecoder.decode(desUrlArr[0], "UTF-8");
            }
            String[] desUrlArr = urlArr[0].split("&kdedcba");
            return URLDecoder.decode(desUrlArr[0], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBidProjectRespbusiness(DynamicObject bidProject) {
        String temp = "";
        StringBuilder sb = new StringBuilder();
        if (null != bidProject) {
            DynamicObjectCollection memberEntry = bidProject.getDynamicObjectCollection("memberentity");
            RespBusiness rb = RespBusiness.valueOf((String)"BidPay");
            for (int i = 0; i < memberEntry.size(); ++i) {
                DynamicObject member = (DynamicObject)memberEntry.get(i);
                DynamicObject user = member.getDynamicObject("user");
                String respbusiness = member.getString("respbusiness");
                if (respbusiness.indexOf(rb.getVal()) < 0) continue;
                sb.append(user.getPkValue());
                sb.append(',');
            }
            if (sb.length() > 0) {
                temp = sb.substring(0, sb.length() - 1);
            }
        }
        return temp;
    }

    public void changeEntryFieldColor(EntryGrid grid, DynamicObjectCollection supllierEntry) {
        String[] sColor = BidPayConstant.colorFields();
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(supllierEntry.size());
        for (int j = 0; j < supllierEntry.size(); ++j) {
            DynamicObject entry = (DynamicObject)supllierEntry.get(j);
            int status = entry.getInt("status");
            CellStyle style = new CellStyle();
            style.setRow(j);
            style.setFieldKey("status");
            style.setForeColor(sColor[status]);
            styles.add(style);
        }
        grid.setCellStyle(styles);
    }

    public void cellClick(CellClickEvent arg0) {
        String reason;
        DynamicObject pay = this.getModel().getDataEntity(true);
        boolean isopen = pay.getBoolean("isOpen");
        EntryGrid grid1 = (EntryGrid)this.getView().getControl("supplierentry");
        int[] selectRows = grid1.getSelectRows();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < selectRows.length; ++i) {
            String str = selectRows[i] + ",";
            sb.append(str);
        }
        int selectSection = this.getModel().getEntryCurrentRowIndex("bidsection");
        this.getPageCache().put(pay.getPkValue() + "_" + selectSection, sb.toString());
        int row = arg0.getRow();
        if (row < 0) {
            return;
        }
        EntryGrid grid = (EntryGrid)arg0.getSource();
        IDataModel operate = grid.getModel();
        DynamicObject supplierEntry = operate.getEntryRowEntity(grid.getKey(), row);
        Long paylistid = supplierEntry.getLong("paylistid");
        String billstatus = supplierEntry.getString("status");
        String itemName = arg0.getFieldKey();
        if ("reason".equals(itemName) && !"".equals(reason = supplierEntry.getString("reason"))) {
            HashMap<String, String> map = new HashMap<String, String>();
            String appId = this.getAppId();
            String formId = appId + "_pay_list";
            map.put("formId", formId);
            map.put("pkId", paylistid.toString());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u6253\u56de\u539f\u56e0", (String)"BidPayRefundPay_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.getView().showForm(showParameter);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public String getAppId() {
        return "bid";
    }
}

