/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.project;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.enums.BidProjectDateEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.DateUtils;
import kd.scm.bid.formplugin.bill.AbstractCommontDateChange;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;

public class BidProjectPlanDateDeal
extends AbstractCommontDateChange {
    public static final Set<String> PLAN_DATE_FLAG = new HashSet<String>(16);
    public static final Set<String> DATE_END_FLAG = new HashSet<String>(16);
    public static final Set<String> PLAN_DATE_END = new HashSet<String>(16);
    private IBidAnnocumentService annocumentService = new BidAnnocumentServiceImpl();
    private ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        this.openProjectVisitable(dataEntity.getString("doctype"), dataEntity.getString("backbidway"), dataEntity.getString("bidopentype"), dataEntity.getDynamicObject("bidmode"));
    }

    public void dealTimeVisitable() {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        this.getPageCache().put("isChanged", "1");
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal == null) {
            return;
        }
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bidmode")) {
            DynamicObject bidmode = (DynamicObject)newVal;
            this.setVisitBackPlantime(dataEntity.getString("doctype"), dataEntity.getString("backbidway"));
            this.setVisitTypePlantime(dataEntity.getString("doctype"), dataEntity.getString("bidopentype"), bidmode);
            this.cleanPlanDate(9, 11);
        }
        if (StringUtils.equals((CharSequence)"doctype", (CharSequence)fieldKey) && StringUtils.isNotEmpty((CharSequence)(newValue = newVal.toString())) && StringUtils.equals((CharSequence)newValue, (CharSequence)"BUSSINESS")) {
            this.getModel().setValue("backbidway", (Object)"");
            this.getModel().setValue("bidopentype", (Object)"");
            this.getView().updateView("backbidway");
            this.getView().updateView("bidopentype");
        }
        if (StringUtils.equals((CharSequence)"backbidway", (CharSequence)fieldKey)) {
            String backbidway = newVal.toString();
            if (StringUtils.equals((CharSequence)"totaltechnical", (CharSequence)backbidway)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bidopentype"});
                dataEntity.set("bidopentype", (Object)"UNIONOPEN");
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bidopentype"});
                dataEntity.set("bidopentype", (Object)"TECHBUSINESS");
            }
            this.getView().updateView("bidopentype");
            this.setVisitBackPlantime(dataEntity.getString("doctype"), backbidway);
        }
        if (StringUtils.equals((CharSequence)"bidopentype", (CharSequence)fieldKey)) {
            String bidopentype = newVal.toString();
            this.setVisitTypePlantime(dataEntity.getString("doctype"), bidopentype, dataEntity.getDynamicObject("bidmode"));
        }
        if (PLAN_DATE_FLAG.contains(fieldKey)) {
            Date date = (Date)newVal;
            boolean supplierinvitation = dataEntity.getBoolean("supplierinvitation");
            DynamicObject bidModel = dataEntity.getDynamicObject("bidmode");
            boolean openBidingFlag = BidModeHelper.isPublicBiddingByModel(bidModel);
            HashSet<String> status = new HashSet<String>();
            status.add("technicaldocenddate");
            status.add("commercialdocenddate");
            status.add("enrolldeadline");
            status.add("invitationdeadline");
            if ((supplierinvitation || openBidingFlag) && status.contains(fieldKey)) {
                this.compareDate(fieldKey, date, (Date)oldVal, true, openBidingFlag);
                return;
            }
            this.compareDate(fieldKey, date, (Date)oldVal, false, openBidingFlag);
            if (StringUtils.equals((CharSequence)"bidopendeadline", (CharSequence)fieldKey)) {
                Object bidopendeadline = dataEntity.get("bidopendeadline");
                dataEntity.set("techbackbidtime", bidopendeadline);
                dataEntity.set("busbackbidtime", bidopendeadline);
            }
            if (StringUtils.equals((CharSequence)"bidopentime", (CharSequence)fieldKey)) {
                Object bidopentime = dataEntity.get("bidopentime");
                dataEntity.set("techopenbidtime", bidopentime);
                dataEntity.set("busopenbidtime", bidopentime);
            }
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            String entitytypeid = dataEntity.getString("entitytypeid");
            for (String key : PLAN_DATE_END) {
                Date date;
                if (StringUtils.equals((CharSequence)key, (CharSequence)"designdrawingenddate")) {
                    if (!entitytypeid.startsWith("rebm")) continue;
                    date = dataEntity.getDate(key);
                    date = DateUtils.endOfDay((Date)date);
                    dataEntity.set(key, (Object)date);
                    continue;
                }
                date = dataEntity.getDate(key);
                date = DateUtils.endOfDay((Date)date);
                dataEntity.set(key, (Object)date);
            }
        }
    }

    public void compareDate(String dateType, Date date, Date oldDate, boolean flag, boolean isPublicBid) {
        if (date == null) {
            return;
        }
        Map<String, Boolean> status = this.hasLinkStatus(isPublicBid);
        BidProjectDateEnum curDate = BidProjectDateEnum.valueOf((String)dateType);
        int index = curDate.getIndex();
        Object pkvalue = this.getModel().getDataEntity().getPkValue();
        String billStatus = this.annocumentService.getBillStatus(pkvalue, (Object)"bidproject");
        DynamicObject invitation = this.supplierInvitationService.getInvitationByProjectId(Long.valueOf(pkvalue.toString()));
        if (DATE_END_FLAG.contains(dateType)) {
            date = DateUtils.endOfDay((Date)date);
        }
        List dates4Later = Arrays.stream(BidProjectDateEnum.values()).filter(dateEnum -> dateEnum.getIndex() < index).collect(Collectors.toList());
        Collections.sort(dates4Later, (d1, d2) -> d2.getIndex() - d1.getIndex());
        String entitytypeid = this.getView().getModel().getDataEntity(true).getString("entitytypeid");
        String appId = "rebm";
        if (entitytypeid.startsWith("bid")) {
            appId = "bid";
        }
        for (BidProjectDateEnum date4Project : dates4Later) {
            Boolean isUsed = status.get(date4Project.name());
            if (isUsed != null && !isUsed.booleanValue() || BidProjectDateEnum.designdrawingenddate.name().equals(date4Project.name()) && "bid".equals(appId)) continue;
            Date compareDate = (Date)this.getModel().getValue(date4Project.name());
            if (flag) {
                String removeFlag = date4Project.name();
                if (("enrolldeadline".equals(dateType) || "invitationdeadline".equals(dateType) || "designdrawingenddate".equals(dateType)) && ("technicaldocenddate".equals(removeFlag) || "commercialdocenddate".equals(removeFlag)) || ("technicaldocenddate".equals(dateType) || "commercialdocenddate".equals(dateType)) && ("enrolldeadline".equals(removeFlag) || "invitationdeadline".equals(removeFlag) || "designdrawingenddate".equals(removeFlag))) continue;
            }
            if (compareDate == null || DateUtils.compareDate((Date)date, (Date)compareDate) >= 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u987b\u665a\u4e8e\u7b49\u4e8e%2$s", (String)"BidProjectPlanDateDeal_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), curDate.getAlias(), date4Project.getAlias() + "\uff01"));
            if (curDate == BidProjectDateEnum.enrolldeadline) {
                if (billStatus != null) {
                    if (date != null && oldDate != null) {
                        this.getModel().setValue(curDate.name(), (Object)oldDate);
                    }
                } else {
                    this.getModel().setValue(curDate.name(), null);
                }
            } else if (curDate == BidProjectDateEnum.invitationdeadline) {
                if (invitation != null && BillStatusEnum.SUBMIT.getVal().equals(invitation.getString("status"))) {
                    if (date != null && oldDate != null) {
                        this.getModel().setValue(curDate.name(), (Object)oldDate);
                    }
                } else {
                    this.getModel().setValue(curDate.name(), null);
                }
            } else {
                this.getModel().setValue(curDate.name(), null);
            }
            return;
        }
        List dates4Early = Arrays.stream(BidProjectDateEnum.values()).filter(dateEnum -> dateEnum.getIndex() > index).collect(Collectors.toList());
        Collections.sort(dates4Early, (d1, d2) -> d1.getIndex() - d2.getIndex());
        for (BidProjectDateEnum date4Project : dates4Early) {
            Boolean isUsed = status.get(date4Project.name());
            if (isUsed != null && !isUsed.booleanValue()) continue;
            Date compareDate = (Date)this.getModel().getValue(date4Project.name());
            if (flag) {
                String removeFlag = date4Project.name();
                if (("enrolldeadline".equals(dateType) || "invitationdeadline".equals(dateType)) && ("technicaldocenddate".equals(removeFlag) || "commercialdocenddate".equals(removeFlag)) || ("technicaldocenddate".equals(dateType) || "commercialdocenddate".equals(dateType)) && ("enrolldeadline".equals(removeFlag) || "invitationdeadline".equals(removeFlag))) continue;
            }
            if (compareDate == null || DateUtils.compareDate((Date)date, (Date)compareDate) <= 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)" %1$s\u987b\u65e9\u4e8e\u7b49\u4e8e%2$s\u3002", (String)"BidProjectPlanDateDeal_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), curDate.getAlias(), date4Project.getAlias() + "\uff01"));
            if (curDate == BidProjectDateEnum.enrolldeadline) {
                if (billStatus != null) {
                    if (date != null && oldDate != null) {
                        this.getModel().setValue(curDate.name(), (Object)oldDate);
                    }
                } else {
                    this.getModel().setValue(curDate.name(), null);
                }
            } else if (curDate == BidProjectDateEnum.invitationdeadline) {
                if (invitation != null && BillStatusEnum.SUBMIT.getVal().equals(invitation.getString("status"))) {
                    if (date != null && oldDate != null) {
                        this.getModel().setValue(curDate.name(), (Object)oldDate);
                    }
                } else {
                    this.getModel().setValue(curDate.name(), null);
                }
            } else {
                this.getModel().setValue(curDate.name(), null);
            }
            return;
        }
    }

    public Map<String, Boolean> hasLinkStatus(boolean isPublicBid) {
        boolean isSupplierInvitation = (Boolean)this.getModel().getValue("supplierinvitation");
        boolean isBidDocument = (Boolean)this.getModel().getValue("biddocument");
        boolean isBidPublish = (Boolean)this.getModel().getValue("bidpublish");
        boolean isBidOpen = (Boolean)this.getModel().getValue("bidopen");
        boolean isBidEvaluation = (Boolean)this.getModel().getValue("bidevaluation");
        boolean isBidBustalk = (Boolean)this.getModel().getValue("bidbustalk");
        boolean isBidDecision = (Boolean)this.getModel().getValue("biddecision");
        boolean isBidAnswerQuestion = (Boolean)this.getModel().getValue("bidanswerquestion");
        boolean isClarificaiton = (Boolean)this.getModel().getValue("clarificaiton");
        boolean isBidBottomMake = (Boolean)this.getModel().getValue("bidbottommake");
        boolean visitbidopendeadline = (Boolean)this.getModel().getValue("visitbidopendeadline");
        boolean visittechbackbidtime = (Boolean)this.getModel().getValue("visittechbackbidtime");
        boolean visitbusbackbidtime = (Boolean)this.getModel().getValue("visitbusbackbidtime");
        boolean visitbidopentime = (Boolean)this.getModel().getValue("visitbidopentime");
        boolean visittechopenbidtime = (Boolean)this.getModel().getValue("visittechopenbidtime");
        boolean visitbusopenbidtime = (Boolean)this.getModel().getValue("visitbusopenbidtime");
        HashMap<String, Boolean> status = new HashMap<String, Boolean>(16);
        status.put("enrolldeadline", isPublicBid);
        status.put("supplierinvienddate", isSupplierInvitation);
        status.put("invitationdeadline", !isPublicBid);
        status.put("technicaldocenddate", isBidDocument);
        status.put("commercialdocenddate", isBidDocument);
        status.put("bidpublishdate", isBidPublish);
        status.put("bidopendeadline", isBidOpen);
        status.put("bidevaluationdate", isBidEvaluation);
        status.put("bidbustalkdate", isBidBustalk);
        status.put("biddecisiondate", isBidDecision);
        status.put("answerquestiontime", isBidAnswerQuestion);
        status.put("answercomplete", isBidAnswerQuestion);
        status.put("bidbottommakedate", isBidBottomMake);
        status.put("clarificaitondate", isClarificaiton);
        status.put("techbackbidtime", visittechbackbidtime);
        status.put("busbackbidtime", visitbusbackbidtime);
        status.put("bidopentime", visitbidopentime);
        status.put("techopenbidtime", visittechopenbidtime);
        status.put("busopenbidtime", visitbusopenbidtime);
        return status;
    }

    static {
        PLAN_DATE_FLAG.add("enrolldeadline");
        PLAN_DATE_FLAG.add("invitationdeadline");
        PLAN_DATE_FLAG.add("supplierinvienddate");
        PLAN_DATE_FLAG.add("designdrawingenddate");
        PLAN_DATE_FLAG.add("technicaldocenddate");
        PLAN_DATE_FLAG.add("commercialdocenddate");
        PLAN_DATE_FLAG.add("bidpublishdate");
        PLAN_DATE_FLAG.add("answerquestiontime");
        PLAN_DATE_FLAG.add("answercomplete");
        PLAN_DATE_FLAG.add("clarificaitondate");
        PLAN_DATE_FLAG.add("bidbottommakedate");
        PLAN_DATE_FLAG.add("bidopendeadline");
        PLAN_DATE_FLAG.add("techbackbidtime");
        PLAN_DATE_FLAG.add("busbackbidtime");
        PLAN_DATE_FLAG.add("bidopentime");
        PLAN_DATE_FLAG.add("techopenbidtime");
        PLAN_DATE_FLAG.add("busopenbidtime");
        PLAN_DATE_FLAG.add("bidevaluationdate");
        PLAN_DATE_FLAG.add("bidbustalkdate");
        PLAN_DATE_FLAG.add("biddecisiondate");
        PLAN_DATE_FLAG.add("approachdate");
        PLAN_DATE_END.add("supplierinvienddate");
        PLAN_DATE_END.add("designdrawingenddate");
        PLAN_DATE_END.add("technicaldocenddate");
        PLAN_DATE_END.add("commercialdocenddate");
        PLAN_DATE_END.add("bidpublishdate");
        PLAN_DATE_END.add("answercomplete");
        PLAN_DATE_END.add("clarificaitondate");
        PLAN_DATE_END.add("bidbottommakedate");
        PLAN_DATE_END.add("bidevaluationdate");
        PLAN_DATE_END.add("bidbustalkdate");
        PLAN_DATE_END.add("biddecisiondate");
        PLAN_DATE_END.add("approachdate");
        DATE_END_FLAG.add("supplierinvienddate");
        DATE_END_FLAG.add("designdrawingenddate");
        DATE_END_FLAG.add("technicaldocenddate");
        DATE_END_FLAG.add("commercialdocenddate");
        DATE_END_FLAG.add("bidpublishdate");
        DATE_END_FLAG.add("answercomplete");
        DATE_END_FLAG.add("clarificaitondate");
        DATE_END_FLAG.add("bidbottommakedate");
        DATE_END_FLAG.add("bidevaluationdate");
        DATE_END_FLAG.add("bidbustalkdate");
        DATE_END_FLAG.add("biddecisiondate");
        DATE_END_FLAG.add("approachdate");
    }
}

