/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.quotedetails;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.formplugin.bill.quotedetails.TenderHisEntity;

public class QuoteDetailsViewEdit
extends AbstractFormPlugin {
    private static final String FLEX_KEY = "quote_";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = e.getFormShowParameter();
        String serviceAppId = showParameter.getServiceAppId();
        Long supplierId = Long.parseLong((String)showParameter.getCustomParam("supplierid"));
        Object sectionName = showParameter.getCustomParam("sectionName");
        Object bidOpenId = showParameter.getCustomParam("bidOpenId");
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)(serviceAppId + "_bidopen"));
        Long bidpublishid = bidOpen.getLong("bidpublishid");
        Object bidProjectId = bidOpen.getDynamicObject("bidproject").getPkValue();
        List<TenderHisEntity> tenderHisList = this.getOnlineTenHis(serviceAppId, bidProjectId, supplierId, sectionName, bidpublishid);
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)(showParameter.getServiceAppId() + "_project"), (String)"bidtype, isratebidding");
        showParameter.setCustomParam("bidType", bidProject.get("bidtype"));
        showParameter.setCustomParam("isratebidding", bidProject.get("isratebidding"));
        showParameter.setCustomParam("tenderHisList", (Object)JSON.toJSONString(tenderHisList));
    }

    public List<TenderHisEntity> getOnlineTenHis(Object serviceAppId, Object bidProjectId, Object supplierId, Object sectionName, Long bidpublishid) {
        Integer curRounds = this.getCurRounds(serviceAppId, supplierId, bidpublishid);
        ArrayList<TenderHisEntity> tenderHisList = new ArrayList<TenderHisEntity>();
        QFilter qFilter = new QFilter("bidproject", "=", bidProjectId);
        qFilter.and("supplier", "=", supplierId);
        qFilter.and("billstatus", "=", (Object)"XX");
        qFilter.and("rounds", "<", (Object)curRounds);
        String formId = "ten_online_bid";
        String detailFormId = "ten_online_bid_detail";
        if ("rebm".equals(serviceAppId)) {
            formId = "resp_online_bid";
            detailFormId = "resp_online_bid_detail";
        }
        DynamicObject[] onlineBidArr = BusinessDataServiceHelper.load((String)formId, (String)"supplier, rounds, sectionname", (QFilter[])qFilter.toArray());
        Object[] onlineBidIdArr = Arrays.stream(onlineBidArr).map(DataEntityBase::getPkValue).toArray();
        qFilter = new QFilter("onlinebidid", "in", (Object)onlineBidIdArr);
        qFilter.and("sectionname", "=", sectionName);
        DynamicObject[] detailArr = BusinessDataServiceHelper.load((String)detailFormId, (String)"onlinebidid", (QFilter[])qFilter.toArray());
        Object[] detailIdArr = Arrays.stream(detailArr).map(DataEntityBase::getPkValue).toArray();
        detailArr = BusinessDataServiceHelper.load((Object[])detailIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)detailFormId));
        Map<Long, List<DynamicObject>> detailMap = Arrays.stream(detailArr).collect(Collectors.groupingBy(detail -> detail.getLong("onlinebidid")));
        Arrays.stream(onlineBidArr).forEach(onlineBid -> {
            List detailList = (List)detailMap.get(onlineBid.getLong("id"));
            if (detailList == null || detailList.isEmpty()) {
                return;
            }
            detailList.forEach(detail -> {
                TenderHisEntity tenderHis = new TenderHisEntity();
                tenderHis.setSupplierId(onlineBid.getLong("id"));
                tenderHis.setSectionName(detail.getString("sectionname"));
                tenderHis.setRounds(onlineBid.getInt("rounds"));
                tenderHis.setOnlineDetailId(detail.getLong("id"));
                tenderHisList.add(tenderHis);
            });
        });
        return tenderHisList;
    }

    public Integer getCurRounds(Object serviceAppId, Object supplierId, Long bidpublishid) {
        DynamicObject[] onlineBidArr;
        Integer curRounds = 0;
        QFilter qFilter = new QFilter("supplier", "=", supplierId);
        qFilter.and("bidpublishid", "=", (Object)bidpublishid);
        String formId = "ten_online_bid";
        if ("rebm".equals(serviceAppId)) {
            formId = "resp_online_bid";
        }
        if ((onlineBidArr = BusinessDataServiceHelper.load((String)formId, (String)"supplier, rounds", (QFilter[])qFilter.toArray())).length > 0) {
            curRounds = Arrays.stream(onlineBidArr).max(Comparator.comparingInt(a -> a.getInt("rounds"))).map(item -> item.getInt("rounds")).get();
        }
        return curRounds;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String tenderHisStr = (String)showParameter.getCustomParam("tenderHisList");
        List<TenderHisEntity> tenderHisList = JSONArray.parseArray((String)tenderHisStr, TenderHisEntity.class);
        tenderHisList = tenderHisList.stream().sorted(Comparator.comparingInt(TenderHisEntity::getRounds)).collect(Collectors.toList());
        FlexPanelAp flexAp = this.createFlexAp(tenderHisList);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "content");
        mapHead.put("items", (String)flexAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    protected FlexPanelAp createFlexAp(List<TenderHisEntity> tenderHisList) {
        FlexPanelAp headAp = new FlexPanelAp();
        headAp.setKey("details_flex");
        for (int i = 0; i < tenderHisList.size(); ++i) {
            TenderHisEntity tenderHis = tenderHisList.get(i);
            FlexPanelAp flexPanelAp = new FlexPanelAp();
            flexPanelAp.setKey(FLEX_KEY + tenderHis.getSectionName() + "_" + tenderHis.getRounds());
            String str = String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u62a5\u4ef7\u660e\u7ec6", (String)"QuoteDetailsViewEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), tenderHis.getRounds());
            flexPanelAp.setName(new LocaleString(str));
            flexPanelAp.setCollapsible(true);
            flexPanelAp.setGrow(0);
            headAp.getItems().add(flexPanelAp);
        }
        return headAp;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String serviceAppId = formShowParameter.getServiceAppId();
        boolean isratebidding = (Boolean)formShowParameter.getCustomParam("isratebidding");
        String bidType = (String)formShowParameter.getCustomParam("bidType");
        String tenderHisStr = (String)formShowParameter.getCustomParam("tenderHisList");
        List tenderHisList = JSONArray.parseArray((String)tenderHisStr, TenderHisEntity.class);
        tenderHisList.forEach(item -> this.showHis((TenderHisEntity)item, isratebidding, bidType, serviceAppId));
    }

    public void showHis(TenderHisEntity tenderHisEntity, boolean isratebidding, String bidType, String serviceAppId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(serviceAppId + "_quote_details_entry");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(FLEX_KEY + tenderHisEntity.getSectionName() + "_" + tenderHisEntity.getRounds());
        showParameter.setCustomParam("tenderHisEntity", (Object)JSON.toJSONString((Object)tenderHisEntity));
        showParameter.setCustomParam("isratebidding", (Object)isratebidding);
        showParameter.setCustomParam("bidType", (Object)bidType);
        this.getView().showForm(showParameter);
    }
}

