/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.tranfer;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.bid.business.bill.serviceImpl.BidTransferServiceImpl;
import kd.scm.bid.common.constant.entity.BidTransferConstant;
import kd.scm.bid.formplugin.util.BidTransferUtil;

public class BidTransferAddEntryFormPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONArray bidProjectIdArrays = (JSONArray)formShowParameter.getCustomParam("bidProjects");
        List bidprojectIds = JSONArray.parseArray((String)bidProjectIdArrays.toJSONString(), Object.class);
        BidTransferServiceImpl bidTransferService = new BidTransferServiceImpl(this.getAppId());
        DynamicObject[] bidProjects = bidTransferService.getBidProjectF7ByIdsAndFields(bidprojectIds, BidTransferConstant.getBidProjectSelectFields());
        if (bidProjects == null || bidProjects.length == 0) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection transferEntry = dataEntity.getDynamicObjectCollection("transferentry");
        transferEntry.clear();
        Object oldMemberId = formShowParameter.getCustomParam("oldMemberId");
        for (DynamicObject bidProject : bidProjects) {
            DynamicObject entry;
            DynamicObject entry2;
            DynamicObject newEntry = transferEntry.addNew();
            newEntry.set("entry_bidproject", (Object)bidProject);
            String purProjectName = bidTransferService.getBidProjectSubEntryPurProjectName(bidProject);
            newEntry.set("entry_purproject", (Object)purProjectName);
            String currentStepStatus = BidTransferUtil.getCurrentStepStatus(bidProject, this.getAppId());
            newEntry.set("entry_curstepstatus", (Object)currentStepStatus);
            if (oldMemberId == null) continue;
            Map memberLeaderEntryMap = bidTransferService.getBidProjectMemberLeaderEntry(bidProject);
            if (memberLeaderEntryMap != null && (entry2 = (DynamicObject)memberLeaderEntryMap.get(oldMemberId)) != null) {
                newEntry.set("respbusiness", entry2.get("respbusinessleader"));
                continue;
            }
            Map memberEntryMap = bidTransferService.getBidProjectMemberEntityEntry(bidProject);
            if (memberEntryMap == null || (entry = (DynamicObject)memberEntryMap.get(oldMemberId)) == null) continue;
            newEntry.set("respbusiness", entry.get("respbusiness"));
        }
        this.getView().updateView("transferentry");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("confirm".equals(operateKey)) {
            this.returnDataToParent();
        }
    }

    public void returnDataToParent() {
        EntryGrid transferEntryGrid = (EntryGrid)this.getView().getControl("transferentry");
        int[] selectRows = transferEntryGrid.getSelectRows();
        if (selectRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u64cd\u4f5c\u3002", (String)"BidTransferAddEntryFormPlugin_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection transferEntry = dataEntity.getDynamicObjectCollection("transferentry");
        ArrayList<Object> returnDataList = new ArrayList<Object>(16);
        for (int selectRow : selectRows) {
            returnDataList.add(transferEntry.get(selectRow));
        }
        this.getView().returnDataToParent(returnDataList);
    }

    public String getAppId() {
        return ((Object)((Object)this)).getClass().getName().split("\\.")[2];
    }
}

