/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.util.HashSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidHistoryUtil {
    public static QFilter getBidProjectQFilter(Object bidProjectId) {
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidProjectId);
        return bidProjectFilter;
    }

    private static QFilter getDocumentHistoryQFilter_BidInX() {
        QFilter bidXFilter = new QFilter("bidproject.billstatus", "=", (Object)"XX");
        QFilter parentFilter = new QFilter("parent", "!=", (Object)0);
        return bidXFilter.and(parentFilter);
    }

    private static QFilter getDocumentHistoryQFilter_BidNotX() {
        HashSet<String> status = new HashSet<String>();
        status.add("J");
        status.add("XX");
        QFilter billstatusFilter = new QFilter("billstatus", "in", status);
        QFilter bidNotXFilter = new QFilter("bidproject.billstatus", "!=", (Object)"XX");
        return billstatusFilter.and(bidNotXFilter);
    }

    public static QFilter getDocumentHistoryQFilter(Object bidProjectId) {
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter documentHistoryBidXQFilter = BidHistoryUtil.getDocumentHistoryQFilter_BidInX();
        QFilter documentHistoryBidNotXQFilter = BidHistoryUtil.getDocumentHistoryQFilter_BidNotX();
        return bidProjectFilter.and(documentHistoryBidXQFilter.or(documentHistoryBidNotXQFilter));
    }

    public static QFilter getDocumentListQFilter() {
        HashSet<String> status = new HashSet<String>();
        status.add("J");
        status.add("XX");
        QFilter billstatusFilter = new QFilter("billstatus", "not in", status);
        QFilter bidprojectFilter = new QFilter("bidproject.billstatus", "=", (Object)"XX");
        QFilter parentFilter = new QFilter("parent", "=", (Object)0);
        return billstatusFilter.or(bidprojectFilter.and(parentFilter));
    }

    public static Boolean haveDocumentHistory(String appId, Object bidProjectId) {
        QFilter documentHistoryQFilter = BidHistoryUtil.getDocumentHistoryQFilter(bidProjectId);
        return QueryServiceHelper.exists((String)BidHistoryUtil.getDocumentFormIdByApp(appId), (QFilter[])new QFilter[]{documentHistoryQFilter});
    }

    private static String getDocumentFormIdByApp(String appId) {
        if ("rebm".equals(appId)) {
            return "rebm_biddocument_edit";
        }
        return "bid_biddocument_edit";
    }

    private static QFilter getPublishHistoryQFilter_BidInX() {
        QFilter bidXFilter = new QFilter("bidproject.billstatus", "=", (Object)"X");
        QFilter sourcepublishFilter = new QFilter("sourcepublish", "!=", (Object)0L);
        return bidXFilter.and(sourcepublishFilter);
    }

    private static QFilter getPublishHistoryQFilter_BidNotX() {
        HashSet<String> status = new HashSet<String>();
        status.add("X");
        QFilter billstatusFilter = new QFilter("billstatus", "in", status);
        QFilter bidNotXFilter = new QFilter("bidproject.billstatus", "!=", (Object)"X");
        bidNotXFilter.and("sourcebillstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal());
        return billstatusFilter.and(bidNotXFilter);
    }

    public static QFilter getPublishHistoryQFilter(Object bidProjectId) {
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter publishHistoryBidXQFilter = BidHistoryUtil.getPublishHistoryQFilter_BidInX();
        QFilter publishHistoryBidNotXQFilter = BidHistoryUtil.getPublishHistoryQFilter_BidNotX();
        return bidProjectFilter.and(publishHistoryBidXQFilter.or(publishHistoryBidNotXQFilter));
    }

    public static QFilter getPublishListQFilter() {
        HashSet<String> status = new HashSet<String>();
        status.add("X");
        QFilter billstatusFilter = new QFilter("billstatus", "not in", status);
        QFilter bidprojectFilter = new QFilter("bidproject.billstatus", "=", (Object)"X");
        QFilter newBillFilters = new QFilter("isnewbill", "=", (Object)Boolean.TRUE);
        return billstatusFilter.or(bidprojectFilter.and(newBillFilters));
    }

    public static Boolean havePublishHistory(String appId, Object bidProjectId) {
        QFilter publishHistoryQFilter = BidHistoryUtil.getPublishHistoryQFilter(bidProjectId);
        return QueryServiceHelper.exists((String)BidHistoryUtil.getPublishFormIdByApp(appId), (QFilter[])new QFilter[]{publishHistoryQFilter});
    }

    private static String getPublishFormIdByApp(String appId) {
        if ("rebm".equals(appId)) {
            return "rebm_bidpublish";
        }
        return "bid_bidpublish";
    }

    public static QFilter getTenderHistoryQFilter(Object bidProjectId, Object supplier) {
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter supplierFilter = new QFilter("supplier.id", "=", supplier);
        HashSet<String> status = new HashSet<String>();
        status.add("J");
        status.add("XX");
        QFilter billstatusFilter = new QFilter("billstatus", "in", status);
        return bidProjectFilter.and(supplierFilter).and(billstatusFilter);
    }

    public static Boolean haveTenderHistory(String appId, Object bidProjectId, Object supplier) {
        QFilter tenderHistoryQFilter = BidHistoryUtil.getTenderHistoryQFilter(bidProjectId, supplier);
        return QueryServiceHelper.exists((String)BidHistoryUtil.getTenderFormIdByApp(appId), (QFilter[])new QFilter[]{tenderHistoryQFilter});
    }

    private static String getTenderFormIdByApp(String appId) {
        if ("resp".equals(appId)) {
            return "resp_online_bid";
        }
        return "ten_online_bid";
    }

    public static QFilter getEvaluationListQFilter() {
        HashSet<String> status = new HashSet<String>();
        status.add("J");
        status.add("XX");
        QFilter billstatusFilter = new QFilter("billstatus", "not in", status);
        QFilter bidprojectFilter = new QFilter("bidproject.billstatus", "=", (Object)"XX");
        QFilter sourcepublishFilter = new QFilter("bidpublishid", "=", (Object)0L);
        return billstatusFilter.or(bidprojectFilter.and(sourcepublishFilter));
    }

    public static QFilter getEvaluationHistoryQFilter(Object bidProjectId) {
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter evaluationHistoryBidXQFilter = BidHistoryUtil.getEvaluationHistoryQFilter_BidInX();
        evaluationHistoryBidXQFilter.and("sourcebillstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal());
        return bidProjectFilter.and(evaluationHistoryBidXQFilter);
    }

    private static QFilter getEvaluationHistoryQFilter_BidInX() {
        QFilter bidXFilter = new QFilter("billstatus", "=", (Object)"XX");
        return bidXFilter;
    }

    public static Boolean haveEvaluationHistory(String appId, Object bidProjectId) {
        QFilter evaluationHistoryQFilter = BidHistoryUtil.getEvaluationHistoryQFilter(bidProjectId);
        return QueryServiceHelper.exists((String)BidHistoryUtil.getEvaluationFormIdByApp(appId), (QFilter[])new QFilter[]{evaluationHistoryQFilter});
    }

    private static String getEvaluationFormIdByApp(String appId) {
        if ("rebm".equals(appId)) {
            return "rebm_bidevaluation";
        }
        return "bid_bidevaluation";
    }
}

