/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidProjectProcessUtil {
    public static boolean isSeparateOpen(DynamicObject bidProjectData) {
        if (bidProjectData == null) {
            return false;
        }
        String docType = bidProjectData.getString("doctype");
        if (!"MULTI".equals(docType)) {
            return false;
        }
        String openType = bidProjectData.getString("bidopentype");
        return !"UNIONOPEN".equals(openType);
    }

    public static DynamicObject getBidProjectData(Object bidProjectId, String entityId) {
        return BusinessDataServiceHelper.loadSingle((String)entityId, (String)String.join((CharSequence)",", "isonlineeval", "doctype", "bidopentype", "bidopen", "bidevaluation", "memberleaderentity", "respbusinessleader", "userleader", "memberentity", "user", "respbusiness", "currentstep", "techopenbidtime", "busopenbidtime", "bidevaluationdate", "org", "entrustmentorgunit", "entitytypeid"), (QFilter[])new QFilter[]{new QFilter("id", "=", bidProjectId)});
    }

    public static Set<String> allHasPermissionEntityBill(DynamicObject bidProjectData) {
        HashSet<String> hasPermEntityBillSet = new HashSet<String>(6);
        String appId = bidProjectData.getString("entitytypeid").split("_")[0];
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALID.getVal()));
        Boolean onlineEvalFlag = QueryServiceHelper.exists((String)(appId + "_bidopen"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectData.getPkValue()), billStatusFilter, new QFilter("isonlineeval", "=", (Object)Boolean.TRUE)});
        DynamicObjectCollection memberLeaderEntry = bidProjectData.getDynamicObjectCollection("memberleaderentity");
        memberLeaderEntry.stream().filter(entry -> entry.getDynamicObject("userleader") != null).forEach(entry -> BidProjectProcessUtil.getRespBusinessValue(entry, hasPermEntityBillSet, "respbusinessleader"));
        DynamicObjectCollection memberEntityEntry = bidProjectData.getDynamicObjectCollection("memberentity");
        memberEntityEntry.stream().filter(entry -> entry.getDynamicObject("user") != null).forEach(entry -> BidProjectProcessUtil.getRespBusinessValue(entry, hasPermEntityBillSet, "respbusiness"));
        if (onlineEvalFlag.booleanValue()) {
            hasPermEntityBillSet.add("13t");
            hasPermEntityBillSet.add("14s");
        }
        return hasPermEntityBillSet;
    }

    public static Set<String> hasPermissionEntityBill(DynamicObject bidProjectData) {
        long currUserId = RequestContext.get().getCurrUserId();
        HashSet<String> hasPermEntityBillSet = new HashSet<String>(6);
        String appId = bidProjectData.getString("entitytypeid").split("_")[0];
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALID.getVal()));
        Boolean onlineEvalFlag = QueryServiceHelper.exists((String)(appId + "_bidopen"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectData.getPkValue()), billStatusFilter, new QFilter("isonlineeval", "=", (Object)Boolean.TRUE)});
        DynamicObjectCollection memberLeaderEntry = bidProjectData.getDynamicObjectCollection("memberleaderentity");
        memberLeaderEntry.stream().filter(entry -> entry.getDynamicObject("userleader") != null).filter(entry -> entry.getDynamicObject("userleader").getLong("id") == currUserId).forEach(entry -> BidProjectProcessUtil.getRespBusinessValue(entry, hasPermEntityBillSet, "respbusinessleader"));
        DynamicObjectCollection memberEntityEntry = bidProjectData.getDynamicObjectCollection("memberentity");
        memberEntityEntry.stream().filter(entry -> entry.getDynamicObject("user") != null).filter(entry -> entry.getDynamicObject("user").getLong("id") == currUserId).forEach(entry -> BidProjectProcessUtil.getRespBusinessValue(entry, hasPermEntityBillSet, "respbusiness"));
        if (onlineEvalFlag.booleanValue()) {
            hasPermEntityBillSet.add("13t");
            hasPermEntityBillSet.add("14s");
        }
        return hasPermEntityBillSet;
    }

    public static void getRespBusinessValue(DynamicObject entry, Set<String> hasPermEntityBillSet, String businessFieldName) {
        String[] businessArr;
        String respBusiness = entry.getString(businessFieldName);
        for (String s : businessArr = respBusiness.split(",")) {
            if (!BidProjectProcessUtil.businessFlagList().contains(s)) continue;
            hasPermEntityBillSet.add(s);
        }
    }

    public static List<String> businessFlagList() {
        return Arrays.asList("11", "12", "13", "14", "13t", "14s");
    }
}

