/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.SupplierHelper;
import kd.scm.bid.formplugin.bill.entity.IntationEntity;

public class InvItationMessageAuxiliary {
    public void publicIntationMessage(DynamicObject supplierInvitation, String appId, DynamicObject bidProject) {
        long invitationId = (Long)supplierInvitation.getPkValue();
        supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)invitationId, (String)(appId + "_supplierinvitation"));
        DynamicObjectCollection bidEnrollSectionColl = supplierInvitation.getDynamicObjectCollection("bidenrollsection");
        DynamicObjectCollection bidSectionColl = supplierInvitation.getDynamicObjectCollection("bidsection");
        if (bidSectionColl == null || bidSectionColl.isEmpty()) {
            return;
        }
        ArrayList intationEntityList = new ArrayList();
        bidEnrollSectionColl.forEach(second -> {
            String sectionName = second.getString("entrysectionname");
            DynamicObjectCollection supplierEntrys = second.getDynamicObjectCollection("supplierenrollentry");
            supplierEntrys.forEach(subRow -> {
                IntationEntity intationEntity = this.buildInfo(appId, (DynamicObject)subRow, sectionName, bidProject, invitationId);
                intationEntityList.add(intationEntity);
            });
        });
        if (intationEntityList.isEmpty()) {
            return;
        }
        intationEntityList.forEach(intationEntity -> {
            DynamicObject msgObj = "bid".equals(appId) ? BusinessDataServiceHelper.newDynamicObject((String)"bid_invitationsendmessage") : BusinessDataServiceHelper.newDynamicObject((String)"rebm_invitationsendmessag");
            msgObj.set("invitationid", (Object)intationEntity.getInvitationid());
            msgObj.set("section", (Object)intationEntity.getSectionName());
            msgObj.set("projectname", (Object)intationEntity.getProjectname());
            msgObj.set("project", intationEntity.getProjectId());
            msgObj.set("supplier_name", (Object)intationEntity.getSupplierName());
            msgObj.set("suppliercomment", (Object)intationEntity.getSuppliercomment());
            msgObj.set("type", (Object)intationEntity.getType());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{msgObj});
            this.sendMsg(appId, msgObj, (IntationEntity)intationEntity);
        });
    }

    public IntationEntity buildInfo(String appId, DynamicObject subRow, String sectionName, DynamicObject bidProject, Long invitationId) {
        DynamicObject bdSupplier;
        IntationEntity intationEntity = new IntationEntity();
        DynamicObject supplier = "supplierentry".equals(subRow.getDynamicObjectType().getName()) ? subRow.getDynamicObject("supplier") : subRow.getDynamicObject("enrollsupplier");
        intationEntity.setSupplierName(supplier.getString("name"));
        intationEntity.setSectionName(sectionName);
        intationEntity.setProjectname(bidProject.getString("name"));
        intationEntity.setProjectId(bidProject.getPkValue());
        intationEntity.setInvitationid(String.valueOf(invitationId));
        if (!"bid".equals(appId) && (bdSupplier = SupplierHelper.getSysSupByRESMSup((Long)supplier.getLong("id"))) != null) {
            supplier = bdSupplier;
        }
        Long adminUserId = SupplierHelper.listAdminUserIdBySupplier((Long)supplier.getLong("id"));
        intationEntity.getReceiveuserIdList().add(adminUserId);
        if ("supplierentry".equals(subRow.getDynamicObjectType().getName())) {
            if (subRow.getBoolean("isrecommend")) {
                intationEntity.setType("1");
            } else {
                intationEntity.setType("0");
            }
            DynamicObject user = subRow.getDynamicObject("projectpartner");
            if (null != user) {
                intationEntity.getReceiveuserIdList().add(user.getLong("id"));
            }
            intationEntity.setSuppliercomment(subRow.getString("suppliercomment"));
        } else {
            if (subRow.getBoolean("isinvitation")) {
                intationEntity.setType("1");
            } else {
                intationEntity.setType("0");
            }
            DynamicObject user = subRow.getDynamicObject("applyuser");
            if (null != user) {
                intationEntity.getReceiveuserIdList().add(user.getLong("id"));
            }
            intationEntity.setSuppliercomment(subRow.getString("enrollsuppliercomment"));
        }
        return intationEntity;
    }

    public void privateInvitation(DynamicObject supplierInvitation, String appId, DynamicObject bidProject) {
        Long invitationId = supplierInvitation.getLong("id");
        supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)invitationId, (String)(appId + "_supplierinvitation"));
        DynamicObjectCollection bidSectionColl = supplierInvitation.getDynamicObjectCollection("bidsection");
        long sourcebillid = supplierInvitation.getLong("sourcebillid");
        boolean isAgain = sourcebillid != 0L;
        ArrayList intationEntityList = new ArrayList();
        bidSectionColl.forEach(second -> {
            String sectionName = second.getString("sectionname");
            DynamicObjectCollection supplierEntrys = second.getDynamicObjectCollection("supplierentry");
            supplierEntrys.forEach(subRow -> {
                String invitationstatus = subRow.getString("invitationstatus");
                if ("ACCEPTED".equals(invitationstatus)) {
                    if (isAgain) {
                        if (subRow.getBoolean("isnew")) {
                            IntationEntity intationEntity = this.buildInfo(appId, (DynamicObject)subRow, sectionName, bidProject, invitationId);
                            intationEntityList.add(intationEntity);
                        }
                    } else {
                        IntationEntity intationEntity = this.buildInfo(appId, (DynamicObject)subRow, sectionName, bidProject, invitationId);
                        intationEntityList.add(intationEntity);
                    }
                }
            });
        });
        if (intationEntityList.isEmpty()) {
            return;
        }
        intationEntityList.forEach(intationEntity -> {
            DynamicObject msgObj = "bid".equals(appId) ? BusinessDataServiceHelper.newDynamicObject((String)"bid_invitationsendmessage") : BusinessDataServiceHelper.newDynamicObject((String)"rebm_invitationsendmessag");
            msgObj.set("invitationid", (Object)intationEntity.getInvitationid());
            msgObj.set("section", (Object)intationEntity.getSectionName());
            msgObj.set("projectname", (Object)intationEntity.getProjectname());
            msgObj.set("project", intationEntity.getProjectId());
            msgObj.set("suppliercomment", (Object)intationEntity.getSuppliercomment());
            msgObj.set("supplier_name", (Object)intationEntity.getSupplierName());
            msgObj.set("type", (Object)intationEntity.getType());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{msgObj});
            this.sendMsg(appId, msgObj, (IntationEntity)intationEntity);
        });
    }

    public void sendMsg(String appId, DynamicObject msgObj, IntationEntity intationEntity) {
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("appId", appId);
        msgParam.put("operation", "audit");
        msgParam.put("title", null);
        msgParam.put("content", null);
        msgParam.put("pkId", intationEntity.getInvitationid());
        if ("bid".equals(appId)) {
            msgParam.put("formId", "bid_supplierinvitation");
        } else {
            msgParam.put("formId", "rebm_supplierinvitation");
        }
        msgParam.put("msgentity", "bid_invitationsendmessage");
        msgParam.put("id", msgObj.getPkValue());
        if (intationEntity.getType().equals("1")) {
            msgParam.put("tplScene", "success");
        } else {
            msgParam.put("tplScene", "fail");
        }
        String notifyTypes = MessageChannelUtil.getNotifyType((String)msgParam.get("tplScene").toString(), (String)msgParam.get("msgentity").toString());
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)false, intationEntity.getReceiveuserIdList(), (String)notifyTypes);
    }

    protected Set<Long> getReceiveUserIds(Set<Long> supplierIds, Map<Long, Long> supplierBizUsers) {
        HashSet<Long> receiveUserIds = new HashSet<Long>(16);
        if (CollectionUtils.isEmpty(supplierBizUsers)) {
            return receiveUserIds;
        }
        for (Long supplierId : supplierIds) {
            if (!supplierBizUsers.containsKey(supplierId)) continue;
            receiveUserIds.add(supplierBizUsers.get(supplierId));
        }
        return receiveUserIds;
    }
}

