/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.SupplierStatisticServiceImpl;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;

public class InvalidBillUtil {
    protected static final IQuestionClarifyService clarifyService = new QuestionClarifyServiceImpl();

    public static void invalidLaterBillByCurrentStep(DynamicObject bidProject, Object sourceSupplierInvitationId, Object supplierInvitationId, Object bidPublishId, BidStepEnum currentStep) {
        if (bidProject == null || currentStep == null) {
            return;
        }
        List<BidStepEnum> invalidBillList = InvalidBillUtil.getAllInvalidStep(currentStep);
        if (!CollectionUtils.isEmpty(invalidBillList)) {
            for (BidStepEnum billName : invalidBillList) {
                switch (billName) {
                    case SupplierInvitation: {
                        InvalidBillUtil.invalidSupplierInvitation(bidProject.getPkValue(), supplierInvitationId, sourceSupplierInvitationId);
                        break;
                    }
                    case BidPublish: {
                        InvalidBillUtil.invalidOtherBill(bidProject.getPkValue(), sourceSupplierInvitationId, "bid_bidpublish", bidPublishId);
                        break;
                    }
                    case BidOpen: {
                        InvalidBillUtil.invalidOtherBill(bidProject.getPkValue(), sourceSupplierInvitationId, "bid_bidopen", bidPublishId);
                        break;
                    }
                    case BidEvaluation: {
                        InvalidBillUtil.invalidOtherBill(bidProject.getPkValue(), sourceSupplierInvitationId, "bid_bidevaluation", bidPublishId);
                        InvalidBillUtil.invalidOtherBill(bidProject.getPkValue(), sourceSupplierInvitationId, "bid_onlinebideval", bidPublishId);
                        break;
                    }
                    case BidDecision: {
                        InvalidBillUtil.invalidOtherBill(bidProject.getPkValue(), sourceSupplierInvitationId, "bid_decision", bidPublishId);
                        break;
                    }
                }
            }
        }
    }

    public static void validLaterBillByCurrentStep(DynamicObject bidProject, Object sourceSupplierInvitationId, Object supplierInvitationId, BidStepEnum currentStep, Object bidpublishId) {
        if (bidProject == null || currentStep == null) {
            return;
        }
        List<BidStepEnum> invalidBillList = InvalidBillUtil.getAllInvalidStep(currentStep);
        if (!CollectionUtils.isEmpty(invalidBillList)) {
            for (BidStepEnum billName : invalidBillList) {
                switch (billName) {
                    case SupplierInvitation: {
                        InvalidBillUtil.validSupplierInvitation(supplierInvitationId, sourceSupplierInvitationId);
                        break;
                    }
                    case BidPublish: {
                        InvalidBillUtil.validOtherBill(bidProject.getPkValue(), supplierInvitationId, "bid_bidpublish", bidpublishId);
                        break;
                    }
                    case BidOpen: {
                        InvalidBillUtil.validOtherBill(bidProject.getPkValue(), supplierInvitationId, "bid_bidopen", bidpublishId);
                        break;
                    }
                    case BidEvaluation: {
                        InvalidBillUtil.validOtherBill(bidProject.getPkValue(), supplierInvitationId, "bid_bidevaluation", bidpublishId);
                        InvalidBillUtil.validOtherBill(bidProject.getPkValue(), supplierInvitationId, "bid_onlinebideval", bidpublishId);
                        break;
                    }
                    case BidDecision: {
                        InvalidBillUtil.validOtherBill(bidProject.getPkValue(), supplierInvitationId, "bid_decision", bidpublishId);
                        break;
                    }
                }
            }
        }
    }

    public static List<BidStepEnum> getAllInvalidStep(BidStepEnum currentStep) {
        ArrayList<BidStepEnum> invalidBillList = new ArrayList<BidStepEnum>();
        for (BidStepEnum key : BidStepEnum.values()) {
            if (key.getIndex() != 2 && currentStep.getIndex() >= key.getIndex()) continue;
            invalidBillList.add(key);
        }
        return invalidBillList;
    }

    public static void invalidOtherBill(Object bidProjectPk, Object supplierInvitationId, String entityName, Object bidPublishId) {
        String invalidBillStatus;
        String string = invalidBillStatus = entityName.endsWith("bidpublish") ? BillStatusEnum.INVALID.getVal() : BillStatusEnum.INVALIDXX.getVal();
        QFilter[] qFilters = supplierInvitationId == null ? (!entityName.endsWith("decision") ? new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("bidpublishid", "=", bidPublishId), new QFilter("billstatus", "!=", (Object)invalidBillStatus)} : new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("billstatus", "!=", (Object)invalidBillStatus)}) : (!entityName.endsWith("decision") ? new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("supplierinvitationid", "=", (Object)Long.parseLong(supplierInvitationId.toString())), new QFilter("billstatus", "!=", (Object)invalidBillStatus)} : new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("billstatus", "!=", (Object)invalidBillStatus)});
        String selectProperties = "id,entitytypeid,billstatus,bidpublishid";
        if (supplierInvitationId != null && "bid_bidevaluation".equals(entityName)) {
            qFilters = new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("supplierinvitationid", "=", (Object)supplierInvitationId.toString()), new QFilter("billstatus", "!=", (Object)invalidBillStatus)};
        }
        DynamicObject[] tempList = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])qFilters);
        TreeSet<String> publishIdSet = new TreeSet<String>();
        if (tempList != null && tempList.length > 0) {
            ArrayList<DynamicObject> currentBillList = new ArrayList<DynamicObject>(10);
            for (DynamicObject temp : tempList) {
                String entityTypeId = temp.getString("entitytypeid");
                DynamicObject currentBill = BusinessDataServiceHelper.loadSingle((Object)temp.getPkValue(), (String)entityTypeId);
                if (currentBill == null) {
                    return;
                }
                String appId = entityTypeId.startsWith("rebm") ? "rebm" : "bid";
                clarifyService.autiAndunAutiInvalidByProject((Long)temp.getPkValue(), appId, true);
                QFilter[] qFilterList = null;
                if (entityName.endsWith("onlinebideval")) {
                    qFilterList = new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal()), new QFilter("sourcebillstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal()), new QFilter("bidevaluator", "=", currentBill.getDynamicObject("bidevaluator").getPkValue()), new QFilter("evaltype", "=", (Object)currentBill.getString("evaltype"))};
                } else if (entityName.endsWith("bidevaluation")) {
                    qFilterList = new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal()), new QFilter("sourcebillstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal()), new QFilter("evaltype", "=", (Object)currentBill.getString("evaltype"))};
                } else if (entityName.endsWith("bidpublish")) {
                    qFilterList = new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("sourcebillstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal()), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALID.getVal())};
                } else if (entityName.endsWith("bidopen")) {
                    qFilterList = new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("sourcebillstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal()), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal())};
                } else if (entityName.endsWith("decision")) {
                    qFilterList = new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal())};
                }
                DynamicObject[] invalidDataArray = BusinessDataServiceHelper.load((String)entityTypeId, (String)"id,bidpublishid", qFilterList);
                if (!entityName.endsWith("decision")) {
                    if (BillStatusEnum.DISBEGIN.getVal().equals(currentBill.getString("billStatus"))) {
                        currentBill.set("rounds", (Object)-1);
                    } else {
                        for (DynamicObject invalidData : invalidDataArray) {
                            if (!entityName.endsWith("bidpublish")) {
                                if (temp.getString("bidpublishid").equals(invalidData.getString("bidpublishid"))) continue;
                                publishIdSet.add(invalidData.getString("bidpublishid"));
                                continue;
                            }
                            publishIdSet.add(invalidData.getString("id"));
                        }
                        int rounds = publishIdSet == null ? 1 : publishIdSet.size() + 1;
                        currentBill.set("rounds", (Object)rounds);
                        String listRounds = "";
                        if (entityName.endsWith("bidpublish")) {
                            listRounds = String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u53d1\u6807", (String)"InvalidBillUtil_41", (String)"scm-bid-formplugin", (Object[])new Object[0]), InvalidBillUtil.toChinese(rounds + ""));
                        }
                        if (entityName.endsWith("bidpublish")) {
                            currentBill.set("listrounds", (Object)listRounds);
                        }
                    }
                    currentBill.set("sourcebillstatus", (Object)currentBill.getString("billstatus"));
                }
                if (entityName.endsWith("bidpublish")) {
                    currentBill.set("billstatus", (Object)BillStatusEnum.INVALID.getVal());
                } else {
                    currentBill.set("billstatus", (Object)BillStatusEnum.INVALIDXX.getVal());
                }
                currentBillList.add(currentBill);
            }
            if (!CollectionUtils.isEmpty(currentBillList)) {
                DynamicObject[] currentArray = new DynamicObject[currentBillList.size()];
                currentBillList.toArray(currentArray);
                SaveServiceHelper.save((DynamicObject[])currentArray);
            }
        }
    }

    public static void validOtherBill(Object bidProjectPk, Object supplierInvitationId, String entityName, Object bidpublishId) {
        QFilter[] qFilters = null;
        if (supplierInvitationId != null) {
            DynamicObject currentBill = BusinessDataServiceHelper.loadSingle((Object)supplierInvitationId, (String)"bid_supplierinvitation");
            qFilters = !entityName.endsWith("decision") ? (bidpublishId != null ? (!entityName.endsWith("publish") ? new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("bidpublishid", "=", bidpublishId)} : new QFilter[]{new QFilter("id", "=", bidpublishId)}) : (entityName.endsWith("bidevaluation") ? new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("supplierinvitationid", "=", (Object)currentBill.getString("sourcebillid"))} : new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("supplierinvitationid", "=", (Object)currentBill.getLong("sourcebillid"))})) : new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk)};
        } else {
            qFilters = !entityName.endsWith("decision") ? new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("bidpublishid", "=", bidpublishId)} : new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk)};
        }
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectPk, (String)"bid_project");
        String bidOpenType = bidProject.getString("bidopentype");
        if (qFilters != null) {
            DynamicObject[] currentBillInfoArrays;
            if (entityName.endsWith("open")) {
                if (StringUtils.isNotEmpty((CharSequence)bidOpenType) && !bidOpenType.equals("UNIONOPEN")) {
                    int index = qFilters.length;
                    QFilter[] qOpFilters = Arrays.copyOf(qFilters, index + 1);
                    qOpFilters[index] = new QFilter("opentype", "=", (Object)"TECHNICAL");
                    DynamicObject[] openBillTechArrays = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus,opentype", (QFilter[])qOpFilters, (String)"createtime desc");
                    if (openBillTechArrays.length > 0) {
                        InvalidBillUtil.updateCurrentBill(openBillTechArrays[0], entityName);
                    }
                    qOpFilters[index] = new QFilter("opentype", "=", (Object)"BUSSINESS");
                    DynamicObject[] openBillBussArrays = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus,opentype", (QFilter[])qOpFilters, (String)"createtime desc");
                    if (openBillBussArrays.length > 0) {
                        InvalidBillUtil.updateCurrentBill(openBillBussArrays[0], entityName);
                    }
                } else {
                    DynamicObject[] currentBillInfoArrays2 = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus", (QFilter[])qFilters, (String)"createtime desc");
                    if (currentBillInfoArrays2.length > 0) {
                        InvalidBillUtil.updateCurrentBill(currentBillInfoArrays2[0], entityName);
                    }
                }
            } else if (entityName.endsWith("publish")) {
                DynamicObject[] currentBillInfoArrays3 = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus", (QFilter[])qFilters, (String)"createtime desc");
                if (currentBillInfoArrays3.length > 0) {
                    InvalidBillUtil.updateCurrentBill(currentBillInfoArrays3[0], entityName);
                }
            } else if (entityName.endsWith("evaluation")) {
                if (StringUtils.isNotEmpty((CharSequence)bidOpenType) && !bidOpenType.equals("UNIONOPEN")) {
                    int index = qFilters.length;
                    QFilter[] qOpFilters = Arrays.copyOf(qFilters, index + 1);
                    qOpFilters[index] = new QFilter("evaltype", "=", (Object)"TECHNICAL");
                    DynamicObject[] evaBillTechArrays = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus", (QFilter[])qOpFilters, (String)"createtime desc");
                    if (evaBillTechArrays.length > 0) {
                        InvalidBillUtil.updateCurrentBill(evaBillTechArrays[0], entityName);
                    }
                    qOpFilters[index] = new QFilter("evaltype", "=", (Object)"BUSSINESS");
                    DynamicObject[] evaBillBussArrays = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus", (QFilter[])qOpFilters, (String)"createtime desc");
                    if (evaBillBussArrays.length > 0) {
                        InvalidBillUtil.updateCurrentBill(evaBillBussArrays[0], entityName);
                    }
                } else {
                    DynamicObject[] currentBillInfoArrays4 = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus", (QFilter[])qFilters, (String)"createtime desc");
                    if (currentBillInfoArrays4.length > 0) {
                        InvalidBillUtil.updateCurrentBill(currentBillInfoArrays4[0], entityName);
                    }
                }
            } else if (entityName.endsWith("onlinebideval")) {
                if (StringUtils.isNotEmpty((CharSequence)bidOpenType) && !bidOpenType.equals("UNIONOPEN")) {
                    int index = qFilters.length;
                    QFilter[] qOpFilters = Arrays.copyOf(qFilters, index + 1);
                    qOpFilters[index] = new QFilter("opentype", "=", (Object)"TECHNICAL");
                    DynamicObject[] openBillTechArrays = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"id,entitytypeid,billstatus", (QFilter[])qOpFilters, (String)"createtime desc");
                    if (openBillTechArrays.length > 0) {
                        DynamicObject[] onlineBillTechArrays;
                        DynamicObject openBillTech = openBillTechArrays[0];
                        QFilter[] onlineQfilters = new QFilter[]{new QFilter("bidopenid", "=", openBillTech.getPkValue())};
                        for (DynamicObject currentBillInfo : onlineBillTechArrays = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus", (QFilter[])onlineQfilters, (String)"createtime desc")) {
                            InvalidBillUtil.updateCurrentBill(currentBillInfo, entityName);
                        }
                    }
                    qOpFilters[index] = new QFilter("opentype", "=", (Object)"BUSSINESS");
                    DynamicObject[] openBillBussArrays = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"id,entitytypeid,billstatus,opentype", (QFilter[])qOpFilters, (String)"createtime desc");
                    if (openBillBussArrays.length > 0) {
                        DynamicObject[] onlineBillBussArrays;
                        DynamicObject openBillBuss = openBillBussArrays[0];
                        QFilter[] onlineQfilters = new QFilter[]{new QFilter("bidopenid", "=", openBillBuss.getPkValue())};
                        for (DynamicObject currentBillInfo : onlineBillBussArrays = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus", (QFilter[])onlineQfilters, (String)"createtime desc")) {
                            InvalidBillUtil.updateCurrentBill(currentBillInfo, entityName);
                        }
                    }
                } else {
                    DynamicObject[] currentBillInfoArrays5 = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"id,entitytypeid,billstatus", (QFilter[])qFilters, (String)"createtime desc");
                    if (currentBillInfoArrays5.length > 0) {
                        DynamicObject[] onlineBillArrays;
                        DynamicObject openBill = currentBillInfoArrays5[0];
                        QFilter[] onlineQfilters = new QFilter[]{new QFilter("bidopenid", "=", openBill.getPkValue())};
                        for (DynamicObject currentBillInfo : onlineBillArrays = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus", (QFilter[])onlineQfilters, (String)"createtime desc")) {
                            InvalidBillUtil.updateCurrentBill(currentBillInfo, entityName);
                        }
                    }
                }
            } else if (entityName.endsWith("decision") && (currentBillInfoArrays = BusinessDataServiceHelper.load((String)entityName, (String)"id,entitytypeid,billstatus", (QFilter[])qFilters, (String)"createtime desc")).length > 0) {
                String entityTypeId = currentBillInfoArrays[0].getString("entitytypeid");
                DynamicObject currentBill = BusinessDataServiceHelper.loadSingle((Object)currentBillInfoArrays[0].getPkValue(), (String)entityTypeId);
                if (currentBill != null) {
                    currentBill.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currentBill});
                }
            }
        }
    }

    public static void updateCurrentBill(DynamicObject currentBillInfo, String entityName) {
        if (currentBillInfo != null) {
            String entityTypeId = currentBillInfo.getString("entitytypeid");
            DynamicObject currentBill = BusinessDataServiceHelper.loadSingle((Object)currentBillInfo.getPkValue(), (String)entityTypeId);
            if (currentBill == null) {
                return;
            }
            if ("bid_bidpublish".equals(entityName)) {
                String sourceBillId = currentBill.getString("sourcepublish");
            } else {
                String sourceBillId = currentBill.getString("sourcebillid");
            }
            String sourceBillStatus = currentBill.getString("sourcebillstatus");
            currentBill.set("billstatus", (Object)sourceBillStatus);
            currentBill.set("rounds", (Object)0);
            currentBill.set("sourcebillstatus", (Object)"");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currentBill});
            if ("bid_bidevaluation".equals(entityTypeId) || "rebm_bidevaluation".equals(entityTypeId)) {
                String appId = "bid";
                if ("rebm_bidevaluation".equals(entityTypeId)) {
                    appId = "rebm";
                }
                clarifyService.autiAndunAutiInvalidByProject(Long.valueOf(Long.parseLong(currentBillInfo.getPkValue().toString())), appId, false);
            }
        }
    }

    public static void validSupplierInvitation(Object supplierInvitationId, Object sourceSupplierInvitationId) {
        if (supplierInvitationId != null && sourceSupplierInvitationId != null) {
            DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)supplierInvitationId, (String)"bid_supplierinvitation", (String)"id,entitytypeid");
            String entityTypeId = tempObj.getString("entitytypeid");
            DynamicObject newSupplierInvitation = BusinessDataServiceHelper.loadSingle((Object)supplierInvitationId, (String)entityTypeId);
            DynamicObject sourceSupplierInvitation = BusinessDataServiceHelper.loadSingle((Object)sourceSupplierInvitationId, (String)entityTypeId);
            DynamicObject bidProject = sourceSupplierInvitation.getDynamicObject("bidproject");
            if (newSupplierInvitation == null) {
                return;
            }
            sourceSupplierInvitation.set("billstatus", (Object)sourceSupplierInvitation.getString("sourcebillstatus"));
            sourceSupplierInvitation.set("rounds", (Object)0);
            sourceSupplierInvitation.set("billstatus", (Object)newSupplierInvitation.getString("sourcebillstatus"));
            if (bidProject != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(bidProject.getString("name"));
                builder.append(ResManager.loadKDString((String)"\uff08\u4fee\u8ba2\u4e2d\uff09", (String)"InvalidBillUtil_45", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                sourceSupplierInvitation.set("listprojectname", (Object)builder.toString());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceSupplierInvitation});
            newSupplierInvitation.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newSupplierInvitation});
            if (bidProject != null) {
                bidProject.set("currentstep", (Object)newSupplierInvitation.getString("bidstep"));
                SaveServiceHelper.update((DynamicObject)bidProject);
            }
            InvalidBillUtil.handleInvitedQty(newSupplierInvitation, false, entityTypeId);
        }
    }

    public static void handleInvitedQty(DynamicObject supplierInvitationData, boolean isAudit, String entityName) {
        if (supplierInvitationData == null) {
            return;
        }
        Long bidProjectID = (Long)supplierInvitationData.getDynamicObject("bidproject").getPkValue();
        DynamicObject[] myTenderArr = null;
        String selectFields = "bidproject,supplier,entry,entry.sectionname,entry.projectsection,entry.sectionstatus,ispublicbid,tenderstatus,isrecommend";
        myTenderArr = entityName.startsWith("bid") ? BusinessDataServiceHelper.load((String)"ten_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "in", (Object)bidProjectID)}) : BusinessDataServiceHelper.load((String)"resp_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "in", (Object)bidProjectID)});
        DynamicObjectCollection bidSections = supplierInvitationData.getDynamicObjectCollection("bidsection");
        ArrayList<DynamicObject> targetMyTenderArr = new ArrayList<DynamicObject>();
        for (DynamicObject aMyTender : myTenderArr) {
            if (bidProjectID.compareTo((Long)aMyTender.getDynamicObject("bidproject").getPkValue()) != 0) continue;
            targetMyTenderArr.add(aMyTender);
        }
        HashMap<String, DynamicObject> myTenderEntryMap = new HashMap<String, DynamicObject>();
        for (DynamicObject aMyTender : targetMyTenderArr) {
            for (DynamicObject aMyTenderEntry : aMyTender.getDynamicObjectCollection("entry")) {
                myTenderEntryMap.put(aMyTenderEntry.getString("sectionname") + aMyTender.getDynamicObject("supplier").getPkValue(), aMyTender);
            }
        }
        HashMap<Long, Integer> invitedQtyMap = new HashMap<Long, Integer>();
        HashMap sectionNameAndSupplierId = new HashMap();
        ArrayList<String> sectionNameAndSupplierIdList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)bidSections)) {
            ArrayList<DynamicObject> dealMyTenderArr = new ArrayList<DynamicObject>();
            for (Object bidSection : bidSections) {
                DynamicObjectCollection supplierEntryList = bidSection.getDynamicObjectCollection("supplierentry");
                String sectionName = bidSection.getString("sectionname");
                ArrayList<Long> arrayList = new ArrayList<Long>();
                for (DynamicObject supplierEntry : supplierEntryList) {
                    DynamicObject aMyTender;
                    DynamicObject supplierName = supplierEntry.getDynamicObject("supplier");
                    if (supplierName == null) continue;
                    Boolean isNew = supplierEntry.getBoolean("isnew");
                    Boolean isFromPublish = supplierEntry.getBoolean("isfrompublish");
                    Boolean invalidFlag = supplierEntry.getBoolean("invalidflag");
                    boolean flag = isNew != false || isFromPublish != false && invalidFlag == false;
                    Long bdSupplierID = (Long)supplierName.get("id");
                    if (flag) {
                        Object object;
                        Integer n;
                        Integer invitedQty = (Integer)invitedQtyMap.get(bdSupplierID);
                        if (invitedQty == null) {
                            invitedQty = 0;
                        }
                        if (isAudit) {
                            n = invitedQty;
                            invitedQty = invitedQty + 1;
                            object = invitedQty;
                        } else {
                            n = invitedQty;
                            invitedQty = invitedQty - 1;
                            object = invitedQty;
                        }
                        invitedQtyMap.put(bdSupplierID, invitedQty);
                        aMyTender = (DynamicObject)myTenderEntryMap.get(sectionName + bdSupplierID);
                        arrayList.add(bdSupplierID);
                        sectionNameAndSupplierIdList.add(sectionName + bdSupplierID);
                        if (aMyTender == null) continue;
                        dealMyTenderArr.add(aMyTender);
                        continue;
                    }
                    Boolean isRecommend = supplierEntry.getBoolean("isrecommend");
                    aMyTender = (DynamicObject)myTenderEntryMap.get(sectionName + bdSupplierID);
                    if (aMyTender == null) continue;
                    String tenderStatus = aMyTender.getString("tenderstatus");
                    if (!isRecommend.booleanValue() || !MyTenderStatus.ACCEPT_INVITED.getValue().equals(tenderStatus)) continue;
                    arrayList.add(bdSupplierID);
                    sectionNameAndSupplierIdList.add(sectionName + bdSupplierID);
                    dealMyTenderArr.add(aMyTender);
                }
                if (arrayList.isEmpty()) continue;
                sectionNameAndSupplierId.put(sectionName, arrayList);
            }
            HashMap<Long, Boolean> supplierIsHas = new HashMap<Long, Boolean>();
            if (!sectionNameAndSupplierId.isEmpty()) {
                for (Map.Entry entry : sectionNameAndSupplierId.entrySet()) {
                    List supplierIdList = (List)entry.getValue();
                    String sectionNameTemp = (String)entry.getKey();
                    block6: for (int i = 0; i < supplierIdList.size(); ++i) {
                        Long supplierIdTemp = (Long)supplierIdList.get(i);
                        boolean isBreak = false;
                        block7: for (DynamicObject bidSection : bidSections) {
                            DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                            String name = bidSection.getString("sectionname");
                            if (isBreak) continue block6;
                            if (sectionNameTemp.equals(name)) continue;
                            for (DynamicObject supplierEntry : supplierEntryColl) {
                                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                                long supplierId = supplier.getLong("id");
                                Boolean isNew = supplierEntry.getBoolean("isnew");
                                if (supplierIdTemp.compareTo(supplierId) != 0 || isNew.booleanValue()) continue;
                                supplierIsHas.put(supplierIdTemp, Boolean.TRUE);
                                isBreak = true;
                                continue block7;
                            }
                        }
                    }
                }
            }
            Set sectionNameSet = sectionNameAndSupplierId.keySet();
            for (DynamicObject myTender : dealMyTenderArr) {
                String sectionNameAndSupId;
                String name;
                int i;
                DynamicObjectCollection myTenderEntryColl = myTender.getDynamicObjectCollection("entry");
                DynamicObject supplier = myTender.getDynamicObject("supplier");
                if (isAudit) {
                    i = 0;
                    for (DynamicObject myTenderEntry : myTenderEntryColl) {
                        name = myTenderEntry.getString("sectionname");
                        sectionNameAndSupId = name + supplier.getString("id");
                        if (!MyTenderStatus.APPLIED.getValue().equals(myTenderEntry.getString("sectionstatus")) && !MyTenderStatus.UNINVITED.getValue().equals(myTenderEntry.getString("sectionstatus")) || sectionNameAndSupplierIdList.isEmpty() || !sectionNameAndSupplierIdList.contains(sectionNameAndSupId)) continue;
                        myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.INVITED.getValue());
                        ++i;
                    }
                    if (i != myTenderEntryColl.size() && supplierIsHas.containsKey(supplier.getPkValue())) continue;
                    myTender.set("tenderstatus", (Object)MyTenderStatus.INVITED.getValue());
                    continue;
                }
                if (!myTender.getBoolean("ispublicbid")) continue;
                i = 0;
                for (DynamicObject myTenderEntry : myTenderEntryColl) {
                    name = myTenderEntry.getString("sectionname");
                    sectionNameAndSupId = name + supplier.getString("id");
                    if (!MyTenderStatus.INVITED.getValue().equals(myTenderEntry.getString("sectionstatus")) || sectionNameAndSupplierIdList.isEmpty() || !sectionNameAndSupplierIdList.contains(sectionNameAndSupId)) continue;
                    myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.APPLIED.getValue());
                    ++i;
                }
                if (i != myTenderEntryColl.size() && supplierIsHas.containsKey(supplier.getPkValue())) continue;
                myTender.set("tenderstatus", (Object)MyTenderStatus.APPLIED.getValue());
            }
            if (!CollectionUtils.isEmpty(dealMyTenderArr)) {
                SaveServiceHelper.save((DynamicObject[])dealMyTenderArr.toArray(new DynamicObject[0]));
            }
            if (entityName.startsWith("bid")) {
                new SupplierStatisticServiceImpl().insertSupplierInvitedQty(invitedQtyMap, "bid_supplierstatistic");
            } else if (entityName.startsWith("rebm")) {
                new SupplierStatisticServiceImpl().insertSupplierInvitedQty(invitedQtyMap, "rebm_supplierstatistic");
            }
        }
    }

    public static void invalidSupplierInvitation(Object projectId, Object supplierInvitationId, Object sourceSupplierInvitationId) {
        if (supplierInvitationId != null) {
            DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)supplierInvitationId, (String)"bid_supplierinvitation", (String)"id,entitytypeid");
            String entityTypeId = tempObj.getString("entitytypeid");
            DynamicObject supplierInvitationData = BusinessDataServiceHelper.loadSingle((Object)supplierInvitationId, (String)entityTypeId);
            if (supplierInvitationData == null) {
                return;
            }
            if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)supplierInvitationData.getString("billstatus"))) {
                return;
            }
            InvalidBillUtil.handleInvitedQty(supplierInvitationData, true, entityTypeId);
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceSupplierInvitationId, (String)entityTypeId);
            DynamicObject bidProject = sourceBill.getDynamicObject("bidproject");
            if (bidProject != null) {
                DynamicObject[] invalidData = BusinessDataServiceHelper.load((String)entityTypeId, (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal())});
                sourceBill.set("rounds", (Object)(invalidData.length + 1));
                String currentStep = bidProject.getString("currentstep");
                if (!StringUtils.isEmpty((CharSequence)currentStep) && !(currentStep = currentStep.replaceAll(",", "")).equals(BidStepEnum.BidDocument.getAlias())) {
                    bidProject.set("currentstep", (Object)BidStepEnum.BidPublish.getAlias());
                }
                SaveServiceHelper.update((DynamicObject)bidProject);
                sourceBill.set("listprojectname", (Object)bidProject.getString("name"));
            }
            sourceBill.set("billstatus", (Object)BillStatusEnum.INVALIDXX.getVal());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceBill});
            BidProjectServiceImpl projectService = new BidProjectServiceImpl();
            projectService.saveCurrentBidStep(projectId, new BidStepEnum[]{BidStepEnum.SupplierInvitation});
        }
    }

    public static void invalidBidAssinviteBill(String appId, Long bidOpenId) {
        DynamicObject[] proficientExtractArray = BusinessDataServiceHelper.load((String)(appId + "_proficient_extract"), (String)"id,billstatus,sourcebillstatus", (QFilter[])new QFilter[]{new QFilter("bidopenname", "=", (Object)bidOpenId), new QFilter("billstatus", "!=", (Object)"XX")});
        if (proficientExtractArray != null && proficientExtractArray.length > 0) {
            for (DynamicObject dynamicObject : proficientExtractArray) {
                dynamicObject.set("sourcebillstatus", (Object)dynamicObject.getString("billstatus"));
                dynamicObject.set("billstatus", (Object)BillStatusEnum.INVALIDXX.getVal());
            }
            SaveServiceHelper.save((DynamicObject[])proficientExtractArray);
            List proficientIdList = Arrays.stream(proficientExtractArray).map(item -> item.getLong("id")).collect(Collectors.toList());
            List<Object> bidAssinviteIdList = new ArrayList();
            DynamicObject[] bidAssinviteSumArray = BusinessDataServiceHelper.load((String)(appId + "_bidassinvitesum"), (String)"id,sourcebillstatus,billstatus", (QFilter[])new QFilter[]{new QFilter("linkexpertextract", "in", proficientIdList), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
            if (bidAssinviteSumArray != null && bidAssinviteSumArray.length > 0) {
                bidAssinviteIdList = Arrays.stream(bidAssinviteSumArray).map(item -> item.getLong("id")).collect(Collectors.toList());
                for (DynamicObject bidAssinviteSum : bidAssinviteSumArray) {
                    bidAssinviteSum.set("sourcebillstatus", (Object)bidAssinviteSum.getString("billstatus"));
                    bidAssinviteSum.set("billstatus", (Object)BillStatusEnum.INVALIDXX.getVal());
                }
                SaveServiceHelper.save((DynamicObject[])bidAssinviteSumArray);
            }
            if (bidAssinviteIdList != null && bidAssinviteIdList.size() > 0) {
                DynamicObject[] dynamicObjectArray;
                for (DynamicObject bidAssinvite : dynamicObjectArray = BusinessDataServiceHelper.load((String)(appId + "_bidassinvite"), (String)"id,sourcebillstatus,billstatus", (QFilter[])new QFilter[]{new QFilter("bidassinvitesum", "in", bidAssinviteIdList), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())})) {
                    bidAssinvite.set("sourcebillstatus", (Object)bidAssinvite.getString("billstatus"));
                    bidAssinvite.set("billstatus", (Object)BillStatusEnum.INVALIDXX.getVal());
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
            }
        }
    }

    public static void validBidAssinviteBill(String appId, Long bidOpenId) {
        DynamicObject[] proficientExtractArray = BusinessDataServiceHelper.load((String)(appId + "_proficient_extract"), (String)"id,billstatus,sourcebillstatus", (QFilter[])new QFilter[]{new QFilter("bidopenname", "=", (Object)bidOpenId), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal())});
        if (proficientExtractArray != null && proficientExtractArray.length > 0) {
            for (DynamicObject dynamicObject : proficientExtractArray) {
                dynamicObject.set("billstatus", (Object)dynamicObject.getString("sourcebillstatus"));
                dynamicObject.set("sourcebillstatus", null);
            }
            SaveServiceHelper.save((DynamicObject[])proficientExtractArray);
            List proficientIdList = Arrays.stream(proficientExtractArray).map(item -> item.getLong("id")).collect(Collectors.toList());
            List<Object> bidAssinviteIdList = new ArrayList();
            DynamicObject[] bidAssinviteSumArray = BusinessDataServiceHelper.load((String)(appId + "_bidassinvitesum"), (String)"id,sourcebillstatus,billstatus", (QFilter[])new QFilter[]{new QFilter("linkexpertextract", "in", proficientIdList), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal())});
            if (bidAssinviteSumArray != null && bidAssinviteSumArray.length > 0) {
                bidAssinviteIdList = Arrays.stream(bidAssinviteSumArray).map(item -> item.getLong("id")).collect(Collectors.toList());
                for (DynamicObject bidAssinviteSum : bidAssinviteSumArray) {
                    bidAssinviteSum.set("billstatus", (Object)bidAssinviteSum.getString("sourcebillstatus"));
                    bidAssinviteSum.set("sourcebillstatus", null);
                }
                SaveServiceHelper.save((DynamicObject[])bidAssinviteSumArray);
            }
            if (bidAssinviteIdList != null && bidAssinviteIdList.size() > 0) {
                DynamicObject[] dynamicObjectArray;
                for (DynamicObject bidAssinvite : dynamicObjectArray = BusinessDataServiceHelper.load((String)(appId + "_bidassinvite"), (String)"id,sourcebillstatus,billstatus", (QFilter[])new QFilter[]{new QFilter("bidassinvitesum", "in", bidAssinviteIdList), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal())})) {
                    bidAssinvite.set("billstatus", (Object)bidAssinvite.getString("sourcebillstatus"));
                    bidAssinvite.set("sourcebillstatus", null);
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
            }
        }
    }

    public static String toChinese(String str) {
        String[] s1 = new String[]{ResManager.loadKDString((String)"\u96f6", (String)"InvalidBillUtil_46", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"InvalidBillUtil_47", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"InvalidBillUtil_48", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"InvalidBillUtil_49", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"InvalidBillUtil_50", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"InvalidBillUtil_51", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"InvalidBillUtil_52", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"InvalidBillUtil_53", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"InvalidBillUtil_54", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"InvalidBillUtil_55", (String)"scm-bid-formplugin", (Object[])new Object[0])};
        String[] s2 = new String[]{ResManager.loadKDString((String)"\u5341", (String)"InvalidBillUtil_56", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"InvalidBillUtil_57", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"InvalidBillUtil_58", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"InvalidBillUtil_59", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"InvalidBillUtil_56", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"InvalidBillUtil_57", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"InvalidBillUtil_58", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"InvalidBillUtil_60", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"InvalidBillUtil_56", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"InvalidBillUtil_57", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"InvalidBillUtil_58", (String)"scm-bid-formplugin", (Object[])new Object[0])};
        StringBuilder result = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                result.append(s1[num]);
                result.append(s2[n - 2 - i]);
                continue;
            }
            result.append(s1[num]);
        }
        return result.toString();
    }
}

