/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class NumberUtil {
    public static final DecimalFormat DF_TOSTRING_WITH2DD = new DecimalFormat("#,##0.00");
    public static final DecimalFormat DF_TOSTRING_2DD = new DecimalFormat("#.00");
    private static final DecimalFormat DF_TOSTRING_INT = new DecimalFormat("#,##0");
    public static final DecimalFormat DF_TOSTRING_PERCENT = new DecimalFormat("##0.00%");
    public static final BigDecimal ZERO = new BigDecimal("0");
    public static final BigDecimal ONE = new BigDecimal("1");
    public static final BigDecimal _ONE = new BigDecimal("-1");
    public static final BigDecimal TEN = new BigDecimal("10");
    public static final BigDecimal _TEN = new BigDecimal("-10");
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100");
    public static final BigDecimal _ONE_HUNDRED = new BigDecimal("-100");
    public static final BigDecimal ONE_THOUSAND = new BigDecimal("1000");
    public static final BigDecimal ONE_MILLION = new BigDecimal("1000000");
    public static final BigDecimal _ONE_THOUSAND = new BigDecimal("-1000");
    public static final BigDecimal TEN_THOUSAND = new BigDecimal("10000");
    public static final BigDecimal _TEN_THOUSAND = new BigDecimal("-10000");
    public static final BigDecimal _ONE_MILLION = new BigDecimal("-1000000");
    public static final BigDecimal ONE_HUNDRED_MILLION = new BigDecimal("100000000");
    public static final BigDecimal _ONE_HUNDRED_MILLION = new BigDecimal("-100000000");

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return new BigDecimal(((Integer)obj).toString());
        }
        if (obj instanceof Long) {
            return new BigDecimal(((Long)obj).toString());
        }
        if (obj instanceof Double) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (obj.toString() == null) {
            return BigDecimal.ZERO;
        }
        String str = obj.toString().trim();
        if (str.toLowerCase().indexOf(101) > -1) {
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                return BigDecimal.ZERO;
            }
        }
        if (str.matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            return new BigDecimal(str);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal toBigDecimal(Object obj, int scale) {
        return NumberUtil.toBigDecimal(obj).setScale(scale, 4);
    }

    public static BigDecimal setScale(Object obj, int scale) {
        return NumberUtil.toBigDecimal(obj, scale);
    }

    public static BigDecimal add(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return NumberUtil.toBigDecimal(dec1).add(NumberUtil.toBigDecimal(dec2));
    }

    public static BigDecimal add(Object[] objArr) {
        BigDecimal rs = null;
        int len = objArr.length;
        for (int i = 0; i < len; ++i) {
            rs = NumberUtil.add(rs, objArr[i]);
        }
        return rs;
    }

    public static BigDecimal subtract(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return NumberUtil.toBigDecimal(dec1).subtract(NumberUtil.toBigDecimal(dec2));
    }

    public static BigDecimal subtract(Object[] objArr) {
        if (null == objArr || objArr.length == 0) {
            return null;
        }
        BigDecimal rs = NumberUtil.toBigDecimal(objArr[0]);
        int len = objArr.length;
        for (int i = 1; i < len; ++i) {
            rs = NumberUtil.subtract(rs, objArr[i]);
        }
        return rs;
    }

    public static BigDecimal multiply(Object dec1, Object dec2) {
        return NumberUtil.multiply(dec1, dec2, 2);
    }

    public static BigDecimal multiply(Object dec1, Object dec2, int scale) {
        if (dec1 == null || dec2 == null) {
            return null;
        }
        BigDecimal obj = NumberUtil.toBigDecimal(dec1).multiply(NumberUtil.toBigDecimal(dec2));
        return obj.setScale(scale, 4);
    }

    public static BigDecimal multiply(Object[] objArr) {
        if (null == objArr || objArr.length == 0) {
            return null;
        }
        BigDecimal rs = null;
        int len = objArr.length;
        for (int i = 0; i < len; ++i) {
            rs = i == 0 ? NumberUtil.toBigDecimal(objArr[i]) : NumberUtil.multiply(rs, objArr[i], 10);
        }
        return null == rs ? null : rs.setScale(2, 4);
    }

    public static BigDecimal divide(Object dec1, Object dec2) {
        return NumberUtil.divide(dec1, dec2, 2, 4);
    }

    public static BigDecimal divide(Object dec1, Object dec2, int scale) {
        return NumberUtil.divide(dec1, dec2, scale, 4);
    }

    public static BigDecimal divide(Object dec1, Object dec2, int scale, int roundingMode) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        if (NumberUtil.toBigDecimal(dec2).signum() == 0) {
            return null;
        }
        return NumberUtil.toBigDecimal(dec1).divide(NumberUtil.toBigDecimal(dec2), scale, roundingMode);
    }

    public static boolean isPositiveNum(Object obj) {
        boolean isValid = false;
        if (NumberUtil.compareTo(obj, BigDecimal.ZERO) > 0) {
            isValid = true;
        }
        return isValid;
    }

    public static boolean isNegativeNum(Object obj) {
        boolean isValid = false;
        if (NumberUtil.compareTo(obj, BigDecimal.ZERO) < 0) {
            isValid = true;
        }
        return isValid;
    }

    public static boolean isZero(Object obj) {
        return NumberUtil.compareTo(obj, BigDecimal.ZERO) == 0;
    }

    public static int compareTo(Object obj1, Object obj2) {
        return NumberUtil.toBigDecimal(obj1).compareTo(NumberUtil.toBigDecimal(obj2));
    }

    public static BigDecimal max(Object obj1, Object obj2) {
        return NumberUtil.compareTo(obj1, obj2) > 0 ? NumberUtil.toBigDecimal(obj1) : NumberUtil.toBigDecimal(obj2);
    }

    public static String formatTo2ddString(Object obj) {
        if (null == obj) {
            return "0.00";
        }
        return DF_TOSTRING_WITH2DD.format(NumberUtil.toBigDecimal(obj));
    }

    public static String formatNumberToString(Object obj) {
        if (null == obj) {
            return "0.00";
        }
        BigDecimal value = NumberUtil.toBigDecimal(obj);
        if (NumberUtil.compareTo(value, ZERO) == 0) {
            return "0.00";
        }
        return DF_TOSTRING_2DD.format(value);
    }

    public static String formatToWCurrency(Object obj) {
        if (null == obj) {
            return "0.00";
        }
        return DF_TOSTRING_WITH2DD.format(NumberUtil.divide(NumberUtil.toBigDecimal(obj), TEN_THOUSAND));
    }

    public static String formatToIntString(Object obj) {
        if (null == obj) {
            return "0";
        }
        return DF_TOSTRING_INT.format(NumberUtil.toBigDecimal(obj));
    }

    public static String formatToPercentString(Object obj) {
        if (null == obj) {
            return "0.00%";
        }
        return DF_TOSTRING_PERCENT.format(NumberUtil.toBigDecimal(obj));
    }
}

