/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.common.constant.entity.BidOnlineBidEvalConstant;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.EvalItemType;
import kd.scm.bid.common.enums.ScoreMode;
import kd.scm.bid.common.util.BidDarkUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class OnlineBidEvalScoreUtil {
    protected IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();
    protected BidOnlineBidEvalConstant bidOnlineBidEvalConstant = new BidOnlineBidEvalConstant();
    public static final String KEY_OLD = "old";
    public static final String KEY_NEW = "new";

    public EntryAp createDynamicOnlineBidEvalScoreAp(Long onlinebidevalId, Long sectionId, String scoreMode, String appId) {
        EntryAp onlineBidEvalScoreAp = new EntryAp();
        onlineBidEvalScoreAp.setKey("onlineBidEvalScoreAp");
        onlineBidEvalScoreAp.setOrderAndFilter(1);
        onlineBidEvalScoreAp.setShowSeq(true);
        this.createEvalItemIdFieldAp(onlineBidEvalScoreAp);
        this.createTypeFieldAp(onlineBidEvalScoreAp);
        this.createItemFieldAp(onlineBidEvalScoreAp);
        this.createStandardFieldAp(onlineBidEvalScoreAp);
        this.createItemScoreFieldAp(onlineBidEvalScoreAp, scoreMode);
        this.createSupplierFieldAp(onlineBidEvalScoreAp, onlinebidevalId, sectionId, appId);
        return onlineBidEvalScoreAp;
    }

    public void createEvalItemIdFieldAp(EntryAp onlineBidEvalScoreAp) {
        EntryFieldAp evalItemIdFieldAp = new EntryFieldAp();
        evalItemIdFieldAp.setId("evalitemid");
        evalItemIdFieldAp.setKey("evalitemid");
        evalItemIdFieldAp.setName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameEvalitemId()));
        evalItemIdFieldAp.setLock("new,edit,view,submit,audit");
        evalItemIdFieldAp.setVisible("");
        BigIntField evalItemIdField = new BigIntField();
        evalItemIdField.setId("evalitemid");
        evalItemIdField.setKey("evalitemid");
        evalItemIdFieldAp.setField((Field)evalItemIdField);
        onlineBidEvalScoreAp.getItems().add(evalItemIdFieldAp);
    }

    public void createTypeFieldAp(EntryAp onlineBidEvalScoreAp) {
        EntryFieldAp typeFieldAp = new EntryFieldAp();
        typeFieldAp.setId("type");
        typeFieldAp.setKey("type");
        typeFieldAp.setName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameType()));
        typeFieldAp.setWidth(new LocaleString("160px"));
        typeFieldAp.setLock("new,edit,view,submit,audit");
        TextField typeField = new TextField();
        typeField.setId("type");
        typeField.setKey("type");
        typeFieldAp.setField((Field)typeField);
        onlineBidEvalScoreAp.getItems().add(typeFieldAp);
    }

    public void createItemFieldAp(EntryAp onlineBidEvalScoreAp) {
        EntryFieldAp itemFieldAp = new EntryFieldAp();
        itemFieldAp.setId("item");
        itemFieldAp.setKey("item");
        itemFieldAp.setName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameItem()));
        itemFieldAp.setWidth(new LocaleString("150px"));
        itemFieldAp.setLock("new,edit,view,submit,audit");
        TextField itemField = new TextField();
        itemField.setId("item");
        itemField.setKey("item");
        itemFieldAp.setField((Field)itemField);
        onlineBidEvalScoreAp.getItems().add(itemFieldAp);
    }

    public void createStandardFieldAp(EntryAp onlineBidEvalScoreAp) {
        EntryFieldAp standardFieldAp = new EntryFieldAp();
        standardFieldAp.setId("standard");
        standardFieldAp.setKey("standard");
        standardFieldAp.setName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameStandard()));
        standardFieldAp.setWidth(new LocaleString("430px"));
        standardFieldAp.setLock("new,edit,view,submit,audit");
        standardFieldAp.setAutoTextWrap(true);
        TextField standardField = new TextField();
        standardField.setId("standard");
        standardField.setKey("standard");
        standardFieldAp.setField((Field)standardField);
        onlineBidEvalScoreAp.getItems().add(standardFieldAp);
    }

    public void createItemScoreFieldAp(EntryAp onlineBidEvalScoreAp, String scoreMode) {
        if (ScoreMode.STANDARD.getVal().equals(scoreMode)) {
            EntryFieldAp scoreFieldAp = new EntryFieldAp();
            scoreFieldAp.setId("score");
            scoreFieldAp.setKey("score");
            scoreFieldAp.setName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameScore()));
            scoreFieldAp.setWidth(new LocaleString("110px"));
            scoreFieldAp.setLock("new,edit,view,submit,audit");
            DecimalField scoreField = new DecimalField();
            scoreField.setId("score");
            scoreField.setKey("score");
            scoreField.setScale(2);
            scoreFieldAp.setField((Field)scoreField);
            onlineBidEvalScoreAp.getItems().add(scoreFieldAp);
        } else {
            EntryFieldAp weightFieldAp = new EntryFieldAp();
            weightFieldAp.setId("weight");
            weightFieldAp.setKey("weight");
            weightFieldAp.setName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameWeight()));
            weightFieldAp.setWidth(new LocaleString("100px"));
            weightFieldAp.setLock("new,edit,view,submit,audit");
            weightFieldAp.setMask("%");
            DecimalField weightField = new DecimalField();
            weightField.setId("weight");
            weightField.setKey("weight");
            weightField.setScale(2);
            weightFieldAp.setField((Field)weightField);
            onlineBidEvalScoreAp.getItems().add(weightFieldAp);
        }
    }

    public void createSupplierFieldAp(EntryAp onlineBidEvalScoreAp, Long onlinebidevalId, Long sectionId, String appId) {
        String sectionName = "";
        String selectFields = "id,entryseq,supplier.id,supplier.number,supplier.name";
        String entryEntity = null;
        String onlinebidevalEntity = null;
        String bidOpenEntity = null;
        String darkEntityTag = null;
        if ("bid".equals(appId)) {
            entryEntity = "bid_onlinebideval";
            onlinebidevalEntity = "bid_onlinebideval";
            bidOpenEntity = "bid_bidopen";
            darkEntityTag = "bid_biddark";
        } else {
            entryEntity = "rebm_onlinebideval";
            onlinebidevalEntity = "rebm_onlinebideval";
            bidOpenEntity = "rebm_bidopen";
            darkEntityTag = "rebm_biddark";
        }
        DynamicObjectCollection onlineSupplierDetailColl = this.onlineBidEvalService.listOnlineSupplierDetailBySections(sectionId, selectFields, entryEntity);
        DynamicObject onlineBidEval = BusinessDataServiceHelper.loadSingle((Object)onlinebidevalId, (String)onlinebidevalEntity);
        DynamicObject bid_bidDark = BusinessDataServiceHelper.loadSingle((String)darkEntityTag, (QFilter[])new QFilter[]{new QFilter("bidopen", "=", onlineBidEval.get("bidopenid"))});
        boolean onlineEvalDark = onlineBidEval.getBoolean("isdark");
        HashMap supplierDarkNameMap = new HashMap();
        if (bid_bidDark != null) {
            supplierDarkNameMap = BidDarkUtil.getSupplierDarkName((DynamicObject)bid_bidDark, (boolean)onlineEvalDark);
        }
        DynamicObjectCollection onlineBidEvalSectionColl = onlineBidEval.getDynamicObjectCollection("bidsection");
        for (DynamicObject onlineBidEvalSectionRow : onlineBidEvalSectionColl) {
            if (onlineBidEvalSectionRow.getLong("id") != sectionId.longValue()) continue;
            sectionName = onlineBidEvalSectionRow.getString("sectionname");
        }
        Object bidProjectId = onlineBidEval.getDynamicObject("bidproject").getPkValue();
        if (onlineSupplierDetailColl != null && onlineSupplierDetailColl.size() > 0) {
            for (int i = 0; i < onlineSupplierDetailColl.size(); ++i) {
                DynamicObject onlineSupplierDetail = (DynamicObject)onlineSupplierDetailColl.get(i);
                EntryFieldGroupAp supplierGroupAp = new EntryFieldGroupAp();
                supplierGroupAp.setId("tenderUnitGroup");
                supplierGroupAp.setKey("tenderUnitGroup");
                long supplierLongId = onlineSupplierDetail.getLong("supplier.id");
                String supName = onlineSupplierDetail.getString("supplier.name");
                if (onlineEvalDark) {
                    List supplierList = (List)supplierDarkNameMap.get(sectionName);
                    for (HashMap supplierMap : supplierList) {
                        if (!supplierMap.containsKey(supplierLongId)) continue;
                        supplierGroupAp.setName(new LocaleString((String)supplierMap.get(supplierLongId)));
                    }
                } else {
                    supplierGroupAp.setName(new LocaleString(supName));
                }
                supplierGroupAp.setWidth(new LocaleString(supName.length() * 25 + "px"));
                onlineBidEvalScoreAp.getItems().add(supplierGroupAp);
                String tenderstrategy = OnlineBidEvalScoreUtil.isTenderstrategy(supplierLongId, onlineBidEval, sectionName);
                int rounds = OnlineBidEvalScoreUtil.getBiddingRounds(onlineBidEval, onlineSupplierDetail, appId, bidProjectId, sectionName);
                String supplierNumber = onlineSupplierDetail.getString("supplier.number").toLowerCase();
                supplierNumber = supplierNumber.replace('.', '_');
                String newSupplierIdKey = "supplierid_" + supplierNumber + KEY_NEW;
                String newSuppScoreKey = "suppscore_" + supplierNumber + KEY_NEW;
                EntryFieldAp supplierNewFieldAp = new EntryFieldAp();
                supplierNewFieldAp.setId(newSupplierIdKey);
                supplierNewFieldAp.setKey(newSupplierIdKey);
                supplierNewFieldAp.setName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameSupplierId()));
                supplierNewFieldAp.setLock("new,edit,view,submit,audit");
                supplierNewFieldAp.setVisible("");
                BigIntField newSupplierIdField = new BigIntField();
                newSupplierIdField.setId(newSupplierIdKey);
                newSupplierIdField.setKey(newSupplierIdKey);
                supplierNewFieldAp.setField((Field)newSupplierIdField);
                EntryFieldAp newSuppScoreFieldAp = new EntryFieldAp();
                newSuppScoreFieldAp.setId(newSuppScoreKey);
                newSuppScoreFieldAp.setKey(newSuppScoreKey);
                newSuppScoreFieldAp.setTextAlign("center");
                newSuppScoreFieldAp.setFireUpdEvt(true);
                newSuppScoreFieldAp.setBackColor("#ffffff");
                boolean isLock = false;
                boolean isLastOnlineEvalIsC = false;
                boolean isBidOpenOnlineNotChange = false;
                boolean needBid = false;
                long sourceBillId = onlineBidEval.getLong("sourcebillid");
                boolean thisOnlineEvalIsXX = onlineBidEval.getString("billstatus").equals(BillStatusEnum.INVALIDXX.getVal());
                if (!thisOnlineEvalIsXX && sourceBillId != 0L) {
                    DynamicObject oldOnlineBidEval = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)onlinebidevalEntity);
                    isLastOnlineEvalIsC = this.getSourceBillStatus(oldOnlineBidEval);
                    isBidOpenOnlineNotChange = this.comBidOpenEvalInfo(onlineBidEval, oldOnlineBidEval);
                    if (!StringUtils.isEmpty((CharSequence)tenderstrategy) && "NEEDBID".equals(tenderstrategy)) {
                        needBid = true;
                    }
                    boolean bl = isLock = isLastOnlineEvalIsC && isBidOpenOnlineNotChange && !needBid;
                    if (isLock) {
                        isLock = this.suppierOpenIncludeFlag(sectionName, bidOpenEntity, supplierLongId, oldOnlineBidEval);
                    }
                }
                newSuppScoreFieldAp.setLock("new,view,submit,audit");
                if (isLock && onlineBidEval.getString("sourcebillid").equals("0")) {
                    newSuppScoreFieldAp.setLock("new,view,submit,audit,edit");
                }
                if (StringUtils.isEmpty((CharSequence)tenderstrategy) || "UNNEEDBID".equals(tenderstrategy)) {
                    if (rounds > 1) {
                        newSuppScoreFieldAp.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s", (String)"OnlineBidEvalScoreUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), OnlineBidEvalScoreUtil.toChinese(String.valueOf(--rounds + 1)), ResManager.loadKDString((String)"\u6b21\u6295\u6807", (String)"OnlineBidEvalScoreUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]))));
                    } else {
                        newSuppScoreFieldAp.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s", (String)"OnlineBidEvalScoreUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), OnlineBidEvalScoreUtil.toChinese(String.valueOf(rounds)), ResManager.loadKDString((String)"\u6b21\u6295\u6807", (String)"OnlineBidEvalScoreUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]))));
                    }
                } else {
                    newSuppScoreFieldAp.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s", (String)"OnlineBidEvalScoreUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), OnlineBidEvalScoreUtil.toChinese(String.valueOf(rounds + 1)), ResManager.loadKDString((String)"\u6b21\u6295\u6807", (String)"OnlineBidEvalScoreUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]))));
                }
                DecimalField newSuppScoreField = new DecimalField();
                newSuppScoreField.setId(newSuppScoreKey);
                newSuppScoreField.setKey(newSuppScoreKey);
                newSuppScoreField.setScale(2);
                newSuppScoreField.setDataScope("[0,100]");
                newSuppScoreField.setZeroShow(true);
                newSuppScoreFieldAp.setField((Field)newSuppScoreField);
                supplierGroupAp.getItems().add(supplierNewFieldAp);
                supplierGroupAp.getItems().add(newSuppScoreFieldAp);
                String oldSupplierIdKey = "supplierid_" + supplierNumber + KEY_OLD;
                String oldSuppScoreKey = "suppscore_" + supplierNumber + KEY_OLD;
                EntryFieldAp supplierOldFieldAp = new EntryFieldAp();
                supplierOldFieldAp.setId(oldSupplierIdKey);
                supplierOldFieldAp.setKey(oldSupplierIdKey);
                supplierOldFieldAp.setName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameSupplierId()));
                supplierOldFieldAp.setLock("new,edit,view,submit,audit");
                supplierOldFieldAp.setVisible("");
                BigIntField oldSupplierIdField = new BigIntField();
                oldSupplierIdField.setId(oldSupplierIdKey);
                oldSupplierIdField.setKey(oldSupplierIdKey);
                supplierOldFieldAp.setField((Field)oldSupplierIdField);
                EntryFieldAp oldSuppScoreFieldAp = new EntryFieldAp();
                oldSuppScoreFieldAp.setId(oldSuppScoreKey);
                oldSuppScoreFieldAp.setKey(oldSuppScoreKey);
                oldSuppScoreFieldAp.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u7b2c%1$s%2$s", (String)"OnlineBidEvalScoreUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), OnlineBidEvalScoreUtil.toChinese(String.valueOf(rounds)), ResManager.loadKDString((String)"\u6b21\u6295\u6807", (String)"OnlineBidEvalScoreUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]))));
                oldSuppScoreFieldAp.setTextAlign("center");
                oldSuppScoreFieldAp.setFireUpdEvt(true);
                oldSuppScoreFieldAp.setLock("new,edit,view,submit,audit");
                oldSuppScoreFieldAp.setBackColor("#ffffff");
                DecimalField oldSuppScoreField = new DecimalField();
                oldSuppScoreField.setId(oldSuppScoreKey);
                oldSuppScoreField.setKey(oldSuppScoreKey);
                oldSuppScoreField.setScale(2);
                oldSuppScoreField.setDataScope("[0,100]");
                oldSuppScoreField.setZeroShow(true);
                oldSuppScoreFieldAp.setField((Field)oldSuppScoreField);
                supplierGroupAp.getItems().add(supplierOldFieldAp);
                supplierGroupAp.getItems().add(oldSuppScoreFieldAp);
            }
        }
    }

    protected boolean suppierOpenIncludeFlag(String sectionName, String bidOpenEntity, long supplierLongId, DynamicObject oldOnlineBidEval) {
        boolean index = false;
        long oldBidOpenId = oldOnlineBidEval.getLong("bidopenid");
        if (QueryServiceHelper.exists((String)bidOpenEntity, (Object)oldBidOpenId)) {
            DynamicObject oldBidOpen = BusinessDataServiceHelper.loadSingle((Object)oldBidOpenId, (String)bidOpenEntity, (String)"bidsection,sectionname,supplierentry,supplier,supplier_istender");
            DynamicObjectCollection oldOpenSectionColl = oldBidOpen.getDynamicObjectCollection("bidsection");
            for (DynamicObject oldOpenSectionRow : oldOpenSectionColl) {
                if (!sectionName.equals(oldOpenSectionRow.getString("sectionname"))) continue;
                DynamicObjectCollection supplierEntryColl = oldOpenSectionRow.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntryRow : supplierEntryColl) {
                    DynamicObject supplier = supplierEntryRow.getDynamicObject("supplier");
                    if (supplierLongId != supplier.getLong("id")) continue;
                    boolean supplier_istender = supplierEntryRow.getBoolean("supplier_istender");
                    if (!supplier_istender) break;
                    index = true;
                    break;
                }
                if (!index) {
                    return false;
                }
                if (!index) continue;
                return true;
            }
        }
        return true;
    }

    public static int getBiddingRounds(DynamicObject onlineBidEval, DynamicObject onlineSupplierDetail, String appId, Object bidProjectId, String sectionName) {
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (onlineBidEval == null || !enable) {
            return 1;
        }
        String publishEntity = null;
        String openEntity = null;
        if ("bid".equals(appId)) {
            publishEntity = "bid_bidpublish";
            openEntity = "bid_bidopen";
        } else {
            publishEntity = "rebm_bidpublish";
            openEntity = "rebm_bidopen";
        }
        long bidPublishId = onlineBidEval.getLong("bidpublishid");
        Long supplierId = (Long)onlineSupplierDetail.get("supplier.id");
        DynamicObject[] publishArray = BusinessDataServiceHelper.load((String)publishEntity, (String)"id,realbidpublishdate,bidsection,sectionname,supplierentry,supplier,tenderstrategy", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("sourcebillstatus", "=", (Object)"P").or(new QFilter("billstatus", "=", (Object)"P"))});
        Date publishDateThis = new Date();
        for (DynamicObject publishArrayOne : publishArray) {
            if (publishArrayOne.getLong("id") != bidPublishId) continue;
            publishDateThis = publishArrayOne.getDate("realbidpublishdate");
            break;
        }
        DynamicObject[] openArray = BusinessDataServiceHelper.load((String)openEntity, (String)"id,realbidopendate,bidpublishid,bidsection,sectionname,supplierentry,supplier,supplier_istender,supplier_isinvalid", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("sourcebillstatus", "=", (Object)"O").or(new QFilter("billstatus", "=", (Object)"O"))});
        int rounds = 1;
        for (DynamicObject publishArrayOne : publishArray) {
            boolean publishNeedAdd = false;
            boolean openNeedAdd = false;
            if (publishArrayOne.getDate("realbidpublishdate").compareTo(publishDateThis) < 0) {
                for (DynamicObject publishSectionOne : publishArrayOne.getDynamicObjectCollection("bidsection")) {
                    if (sectionName.equals(publishSectionOne.getString("sectionname"))) {
                        for (DynamicObject supplierEntryOne : publishSectionOne.getDynamicObjectCollection("supplierentry")) {
                            if (supplierEntryOne.getDynamicObject("supplier").getLong("id") != supplierId.longValue() || !supplierEntryOne.getString("tenderstrategy").equals("NEEDBID")) continue;
                            publishNeedAdd = true;
                            break;
                        }
                    }
                    if (!publishNeedAdd) continue;
                    break;
                }
            }
            if (!publishNeedAdd) continue;
            block4: for (DynamicObject openArrayOne : openArray) {
                if (publishArrayOne.getLong("id") != openArrayOne.getLong("bidpublishid")) continue;
                for (DynamicObject openSectionOne : openArrayOne.getDynamicObjectCollection("bidsection")) {
                    if (sectionName.equals(openSectionOne.getString("sectionname"))) {
                        for (DynamicObject supplierEntryOne : openSectionOne.getDynamicObjectCollection("supplierentry")) {
                            if (supplierEntryOne.getDynamicObject("supplier").getLong("id") != supplierId.longValue() || !supplierEntryOne.getBoolean("supplier_istender")) continue;
                            openNeedAdd = true;
                            break;
                        }
                    }
                    if (!openNeedAdd) continue;
                    continue block4;
                }
            }
            if (!publishNeedAdd || !openNeedAdd) continue;
            ++rounds;
        }
        return rounds;
    }

    public static String toChinese(String str) {
        String[] s1 = new String[]{ResManager.loadKDString((String)"\u96f6", (String)"OnlineBidEvalScoreUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"OnlineBidEvalScoreUtil_3", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"OnlineBidEvalScoreUtil_14", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"OnlineBidEvalScoreUtil_15", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"OnlineBidEvalScoreUtil_16", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"OnlineBidEvalScoreUtil_17", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"OnlineBidEvalScoreUtil_18", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"OnlineBidEvalScoreUtil_19", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"OnlineBidEvalScoreUtil_20", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"OnlineBidEvalScoreUtil_21", (String)"scm-bid-formplugin", (Object[])new Object[0])};
        String[] s2 = new String[]{ResManager.loadKDString((String)"\u5341", (String)"OnlineBidEvalScoreUtil_12", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"OnlineBidEvalScoreUtil_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"OnlineBidEvalScoreUtil_22", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"OnlineBidEvalScoreUtil_23", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"OnlineBidEvalScoreUtil_12", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"OnlineBidEvalScoreUtil_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"OnlineBidEvalScoreUtil_22", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"OnlineBidEvalScoreUtil_24", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"OnlineBidEvalScoreUtil_12", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"OnlineBidEvalScoreUtil_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"OnlineBidEvalScoreUtil_22", (String)"scm-bid-formplugin", (Object[])new Object[0])};
        StringBuilder result = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                result.append(s1[num]);
                result.append(s2[n - 2 - i]);
                continue;
            }
            result.append(s1[num]);
        }
        return result.toString();
    }

    public void registDynamicProps(MainEntityType newMainType, Long onlinebidevalId, Long sectionId, String scoreMode) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("onlinebidevalscore");
        this.registEvalItemIdProp(entryType);
        this.registTypeFieldAp(entryType);
        this.registItemFieldAp(entryType);
        this.registStandardFieldAp(entryType);
        this.registItemScoreFieldAp(entryType, scoreMode);
        this.registSupplierFieldAp(entryType, onlinebidevalId, sectionId);
    }

    public void registEvalItemIdProp(EntryType entryType) {
        BigIntProp evalItemIdBigIntProp = new BigIntProp();
        evalItemIdBigIntProp.setName("evalitemid");
        evalItemIdBigIntProp.setDisplayName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameEvalitemId()));
        evalItemIdBigIntProp.setDbIgnore(true);
        evalItemIdBigIntProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)evalItemIdBigIntProp);
    }

    public void registTypeFieldAp(EntryType entryType) {
        TextProp typeTextProp = new TextProp();
        typeTextProp.setName("type");
        typeTextProp.setDisplayName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameType()));
        typeTextProp.setDbIgnore(true);
        typeTextProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)typeTextProp);
    }

    public void registItemFieldAp(EntryType entryType) {
        TextProp itemTextProp = new TextProp();
        itemTextProp.setName("item");
        itemTextProp.setDisplayName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameItem()));
        itemTextProp.setDbIgnore(true);
        itemTextProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)itemTextProp);
    }

    public void registStandardFieldAp(EntryType entryType) {
        TextProp standardTextProp = new TextProp();
        standardTextProp.setName("standard");
        standardTextProp.setDisplayName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameStandard()));
        standardTextProp.setDbIgnore(true);
        standardTextProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)standardTextProp);
    }

    public void registItemScoreFieldAp(EntryType entryType, String scoreMode) {
        if (ScoreMode.STANDARD.getVal().equals(scoreMode)) {
            DecimalProp itemScoreDecimalProp = new DecimalProp();
            itemScoreDecimalProp.setName("score");
            itemScoreDecimalProp.setDisplayName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameScore()));
            itemScoreDecimalProp.setDbIgnore(true);
            itemScoreDecimalProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)itemScoreDecimalProp);
        } else {
            DecimalProp itemScoreDecimalProp = new DecimalProp();
            itemScoreDecimalProp.setName("weight");
            itemScoreDecimalProp.setDisplayName(new LocaleString(this.bidOnlineBidEvalConstant.getColNameWeight()));
            itemScoreDecimalProp.setDbIgnore(true);
            itemScoreDecimalProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)itemScoreDecimalProp);
        }
    }

    public void registSupplierFieldAp(EntryType entryType, Long onlinebidevalId, Long sectionId) {
        String selectFields = "id,entryseq,supplier.id,supplier.number,supplier.name";
        DynamicObject onLine = BusinessDataServiceHelper.loadSingle((Object)onlinebidevalId, (String)"bid_onlinebideval");
        String entryEntity = onLine.getString("entitytypeid");
        DynamicObjectCollection onlineSupplierDetailColl = this.onlineBidEvalService.listOnlineSupplierDetailBySections(sectionId, selectFields, entryEntity);
        for (int i = 0; i < onlineSupplierDetailColl.size(); ++i) {
            DynamicObject onlineSupplierDetail = (DynamicObject)onlineSupplierDetailColl.get(i);
            String supplierNumber = onlineSupplierDetail.getString("supplier.number").toLowerCase();
            supplierNumber = supplierNumber.replace('.', '_');
            String oldSupplierIdKey = "supplierid_" + supplierNumber + KEY_OLD;
            String oldSuppScoreKey = "suppscore_" + supplierNumber + KEY_OLD;
            String newSupplierIdKey = "supplierid_" + supplierNumber + KEY_NEW;
            String newSuppScoreKey = "suppscore_" + supplierNumber + KEY_NEW;
            BigIntProp newSupplierIdBigIntProp = new BigIntProp();
            newSupplierIdBigIntProp.setName(newSupplierIdKey);
            newSupplierIdBigIntProp.setDbIgnore(true);
            newSupplierIdBigIntProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)newSupplierIdBigIntProp);
            DecimalProp newTechnicalDecimalProp = new DecimalProp();
            newTechnicalDecimalProp.setName(newSuppScoreKey);
            newTechnicalDecimalProp.setDbIgnore(true);
            newTechnicalDecimalProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)newTechnicalDecimalProp);
            BigIntProp oldSupplierIdBigIntProp = new BigIntProp();
            oldSupplierIdBigIntProp.setName(oldSupplierIdKey);
            oldSupplierIdBigIntProp.setDbIgnore(true);
            oldSupplierIdBigIntProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)oldSupplierIdBigIntProp);
            DecimalProp oldTechnicalDecimalProp = new DecimalProp();
            oldTechnicalDecimalProp.setName(oldSuppScoreKey);
            oldTechnicalDecimalProp.setDbIgnore(true);
            oldTechnicalDecimalProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)oldTechnicalDecimalProp);
        }
    }

    public String getAppId(EntryType entryType) {
        String parent = entryType.getParent().getName();
        String appId = parent.split("_")[0];
        return appId;
    }

    public Map<Long, LinkedHashMap<String, Object>> getScoreDetailByDataBase(Long onlinebidevalId, Long sectionId, String scoreMode, String evalType, String appId) {
        String scoreDetailSelectFields = "id,entryseq,score,type,evalItem,supplier.id,supplier.number,supplier.name";
        DynamicObjectCollection onlineScoreDetailColl = this.onlineBidEvalService.listOnlineScoreDetailBySections(sectionId, scoreDetailSelectFields, appId);
        if (this.checkIsTechFirst(sectionId, appId)) {
            onlineScoreDetailColl.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    int temp = 0;
                    int compareTo = o1.getString("type").compareTo(o2.getString("type"));
                    if (compareTo > 0) {
                        temp = -1;
                    } else if (compareTo < 0) {
                        temp = 1;
                    } else if (compareTo == 0) {
                        temp = 0;
                    }
                    return temp;
                }
            });
        } else {
            onlineScoreDetailColl.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    return o1.getString("type").compareTo(o2.getString("type"));
                }
            });
        }
        LinkedHashMap<Long, LinkedHashMap<String, Object>> rowMap = new LinkedHashMap<Long, LinkedHashMap<String, Object>>();
        for (int i = 0; i < onlineScoreDetailColl.size(); ++i) {
            DynamicObject onlineScoreDetail = (DynamicObject)onlineScoreDetailColl.get(i);
            Long evalItemId = onlineScoreDetail.getLong("evalItem");
            DynamicObject evalItem = this.onlineBidEvalService.getEvalItemDetail(evalItemId);
            LinkedHashMap<String, Object> rowDataMap = (LinkedHashMap<String, Object>)rowMap.get(evalItemId);
            if (rowDataMap == null) {
                rowDataMap = new LinkedHashMap<String, Object>();
                rowMap.put(evalItemId, rowDataMap);
                String type = onlineScoreDetail.getString("type");
                if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                    type = EvalItemType.TECHNICAL.getAlias();
                } else if (EvalItemType.COMMERCIAL.getVal().equals(type)) {
                    type = EvalItemType.COMMERCIAL.getAlias();
                }
                String item = evalItem.getString("item");
                String standard = evalItem.getString("standard");
                BigDecimal score = evalItem.getBigDecimal("score");
                BigDecimal weight = evalItem.getBigDecimal("weight");
                rowDataMap.put("evalitemid", evalItemId);
                rowDataMap.put("type", type);
                rowDataMap.put("item", item);
                rowDataMap.put("standard", standard);
                if (ScoreMode.STANDARD.getVal().equals(scoreMode)) {
                    rowDataMap.put("score", score);
                } else {
                    rowDataMap.put("weight", weight);
                }
            }
            String supplierNumber = onlineScoreDetail.getString("supplier.number").toLowerCase();
            supplierNumber = supplierNumber.replace('.', '_');
            String newSupplierIdKey = "supplierid_" + supplierNumber + KEY_NEW;
            String newSuppScoreKey = "suppscore_" + supplierNumber + KEY_NEW;
            String oldSuppScoreKey = "suppscore_" + supplierNumber + KEY_OLD;
            Long supplierId = onlineScoreDetail.getLong("supplier.id");
            rowDataMap.put(newSupplierIdKey, supplierId);
            BigDecimal technicalscore = onlineScoreDetail.getBigDecimal("score");
            rowDataMap.put(newSuppScoreKey, technicalscore);
            this.comparisonData(onlinebidevalId, appId, sectionId, scoreDetailSelectFields, rowDataMap, newSuppScoreKey, newSupplierIdKey, oldSuppScoreKey, supplierId, evalItem);
        }
        return rowMap;
    }

    public void comparisonData(Long onlinebidevalId, String appId, Long sectionId, String scoreDetailSelectFields, LinkedHashMap<String, Object> rowDataMap, String newSuppScoreKey, String newSupplierIdKey, String oldSuppScoreKey, Long supplierId, DynamicObject evalItem) {
        String onlinebidevalName = null;
        onlinebidevalName = "bid".equals(appId) ? "bid_onlinebideval" : ("rebm".equals(appId) ? "rebm_onlinebideval" : "rebm_onlinebideval");
        DynamicObject onlineBidEval = BusinessDataServiceHelper.loadSingle((Object)onlinebidevalId, (String)onlinebidevalName);
        DynamicObjectCollection bidSectionColl = onlineBidEval.getDynamicObjectCollection("bidsection");
        String sectionName = "";
        for (DynamicObject bidSectionRow : bidSectionColl) {
            if (bidSectionRow.getLong("id") != sectionId.longValue()) continue;
            sectionName = bidSectionRow.getString("sectionname");
            break;
        }
        Long sourcebillid = onlineBidEval.getLong("sourcebillid");
        boolean isHideOldRounds = false;
        boolean isHideNewRounds = true;
        boolean isUNNEEDBID = false;
        boolean isLoadScore = false;
        String tenderstrategy = OnlineBidEvalScoreUtil.isTenderstrategy(supplierId, onlineBidEval, sectionName);
        if (sourcebillid != 0L && !StringUtils.equals((CharSequence)onlineBidEval.getString("billstatus"), (CharSequence)"D")) {
            sourcebillid = onlinebidevalId;
        }
        if (sourcebillid != 0L) {
            DynamicObject oldOnlinebideval = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)onlinebidevalName);
            isHideOldRounds = this.getSourceBillStatus(oldOnlinebideval);
            if (!StringUtils.isEmpty((CharSequence)tenderstrategy) && "UNNEEDBID".equals(tenderstrategy)) {
                isUNNEEDBID = true;
            }
            if (isHideOldRounds) {
                isHideOldRounds = this.comBidOpenEvalInfo(onlineBidEval, oldOnlinebideval);
            }
            if (isHideOldRounds) {
                isLoadScore = true;
            }
            if (isLoadScore) {
                long oldBidSection = 0L;
                DynamicObjectCollection oldBidSectionColl = oldOnlinebideval.getDynamicObjectCollection("bidsection");
                for (DynamicObject oldBidSectionRow : oldBidSectionColl) {
                    if (!StringUtils.equals((CharSequence)sectionName, (CharSequence)oldBidSectionRow.getString("sectionname"))) continue;
                    oldBidSection = oldBidSectionRow.getLong("id");
                    break;
                }
                DynamicObjectCollection onlinescoredetailColl = this.oneOnlineScoreDetailBySection(oldBidSection, supplierId, scoreDetailSelectFields, evalItem.getString("item"), appId);
                BigDecimal oldtechnicalscore = BigDecimal.ZERO;
                if (!onlinescoredetailColl.isEmpty()) {
                    oldtechnicalscore = ((DynamicObject)onlinescoredetailColl.get(0)).getBigDecimal("score");
                }
                rowDataMap.put(newSupplierIdKey, supplierId);
                if (isUNNEEDBID) {
                    rowDataMap.put(newSuppScoreKey, oldtechnicalscore);
                } else {
                    rowDataMap.put(oldSuppScoreKey, oldtechnicalscore);
                }
            }
        }
        if (isUNNEEDBID || StringUtils.isEmpty((CharSequence)tenderstrategy)) {
            isHideOldRounds = false;
            isHideNewRounds = true;
        }
        rowDataMap.put(oldSuppScoreKey + "_hide", isHideOldRounds);
        rowDataMap.put(newSuppScoreKey + "_hide", isHideNewRounds);
    }

    public DynamicObjectCollection oneOnlineScoreDetailBySection(Long sectionId, Long supplier, String selectFields, String evalItem, String appId) {
        QFilter qFilter = new QFilter("section", "=", (Object)sectionId).and("evalItem.item", "=", (Object)evalItem).and("supplier.id", "=", (Object)supplier);
        DynamicObjectCollection onlineScoreDetailColl = null;
        onlineScoreDetailColl = "bid".equals(appId) ? QueryServiceHelper.query((String)"bid_onlinescoredetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq") : QueryServiceHelper.query((String)"rebm_onlinescoredetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq");
        return onlineScoreDetailColl;
    }

    public static String isTenderstrategy(Long supplierId, DynamicObject onlineBidEval, String sectionName) {
        String publishName = null;
        publishName = onlineBidEval.getDataEntityType().getName().startsWith("bid") ? "bid_bidpublish" : "rebm_bidpublish";
        String tenderstrategy = null;
        long bidPublishId = onlineBidEval.getLong("bidpublishid");
        if (!QueryServiceHelper.exists((String)publishName, (Object)bidPublishId)) {
            return tenderstrategy;
        }
        DynamicObject bidpublish = BusinessDataServiceHelper.loadSingle((Object)bidPublishId, (String)publishName);
        DynamicObjectCollection bidsectionColl = bidpublish.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection : bidsectionColl) {
            if (!sectionName.equals(bidsection.getString("sectionname"))) continue;
            DynamicObjectCollection supplierentryColl = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplier : supplierentryColl) {
                if (!supplier.getDynamicObject("supplier").getPkValue().equals(supplierId)) continue;
                tenderstrategy = supplier.getString("tenderstrategy");
                return tenderstrategy;
            }
        }
        return tenderstrategy;
    }

    public boolean comBidOpenEvalInfo(DynamicObject onlineBidEval, DynamicObject oldOnlinebideval) {
        Object oldBidevaltemplatePk;
        Object bidevaltemplatePk;
        DynamicObject oldBidopen;
        boolean isHideRounds = true;
        String entryType = null;
        entryType = onlineBidEval.getDataEntityType().getName().startsWith("bid") ? "bid_bidopen" : "rebm_bidopen";
        Object bidopenid = onlineBidEval.get("bidopenid");
        Object oldBidopenid = oldOnlinebideval.get("bidopenid");
        DynamicObject bidopen = BusinessDataServiceHelper.loadSingle((Object)bidopenid, (String)entryType);
        isHideRounds = this.getIsonlineeval(bidopen, oldBidopen = BusinessDataServiceHelper.loadSingle((Object)oldBidopenid, (String)entryType), isHideRounds);
        if (!isHideRounds) {
            return false;
        }
        DynamicObjectCollection entryEntityColl = bidopen.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection oldEntryEntityColl = oldBidopen.getDynamicObjectCollection("entryentity");
        if (entryEntityColl.size() != oldEntryEntityColl.size()) {
            return false;
        }
        DynamicObject bidEvalTemplate = bidopen.getDynamicObject("bidevaltemplate");
        DynamicObject oldBidEvalTemplate = oldBidopen.getDynamicObject("bidevaltemplate");
        if (bidEvalTemplate == null && oldBidEvalTemplate != null) {
            return false;
        }
        if (bidEvalTemplate != null && oldBidEvalTemplate == null) {
            return false;
        }
        if (bidEvalTemplate != null && oldBidEvalTemplate != null && !(bidevaltemplatePk = bidEvalTemplate.getPkValue()).equals(oldBidevaltemplatePk = oldBidEvalTemplate.getPkValue())) {
            return false;
        }
        String type1 = null;
        String oldType1 = null;
        DynamicObjectCollection evalItemEntry = null;
        DynamicObjectCollection oldEvalItemEntry = null;
        int evalItemEntrySize = 0;
        int oldEvalItemEntrySize = 0;
        DynamicObject evalItemEntryIndex = null;
        DynamicObject oldEvalItemEntryIndex = null;
        String type = null;
        String item = null;
        String standard = null;
        BigDecimal score = null;
        BigDecimal weight = null;
        String oldType = null;
        String oldItem = null;
        String oldStandard = null;
        BigDecimal oldScore = null;
        BigDecimal oldWeight = null;
        for (DynamicObject entryEntityRow : entryEntityColl) {
            type1 = entryEntityRow.getString("type1");
            for (DynamicObject oldEntryEntityRow : oldEntryEntityColl) {
                oldType1 = oldEntryEntityRow.getString("type1");
                if (!StringUtils.equals((CharSequence)type1, (CharSequence)oldType1)) continue;
                evalItemEntry = entryEntityRow.getDynamicObjectCollection("bidopen_evalitementry");
                oldEvalItemEntry = oldEntryEntityRow.getDynamicObjectCollection("bidopen_evalitementry");
                evalItemEntrySize = evalItemEntry.size();
                if (evalItemEntrySize != (oldEvalItemEntrySize = oldEvalItemEntry.size())) {
                    return false;
                }
                for (int i = 0; i < evalItemEntry.size(); ++i) {
                    evalItemEntryIndex = (DynamicObject)evalItemEntry.get(i);
                    oldEvalItemEntryIndex = (DynamicObject)oldEvalItemEntry.get(i);
                    type = evalItemEntryIndex.getString("type");
                    if (!StringUtils.equals((CharSequence)type, (CharSequence)(oldType = oldEvalItemEntryIndex.getString("type")))) {
                        return false;
                    }
                    item = evalItemEntryIndex.getString("item");
                    if (!StringUtils.equals((CharSequence)item, (CharSequence)(oldItem = oldEvalItemEntryIndex.getString("item")))) {
                        return false;
                    }
                    standard = evalItemEntryIndex.getString("standard");
                    if (!StringUtils.equals((CharSequence)standard, (CharSequence)(oldStandard = oldEvalItemEntryIndex.getString("standard")))) {
                        return false;
                    }
                    score = evalItemEntryIndex.getBigDecimal("score");
                    if (score.compareTo(oldScore = oldEvalItemEntryIndex.getBigDecimal("score")) != 0) {
                        return false;
                    }
                    weight = evalItemEntryIndex.getBigDecimal("weight");
                    if (weight.compareTo(oldWeight = oldEvalItemEntryIndex.getBigDecimal("weight")) == 0) continue;
                    return false;
                }
            }
        }
        return isHideRounds;
    }

    public boolean getTenderstrategy(boolean isHideRounds, Long supplierId, DynamicObject bidopen, String appId) {
        String entryType = null;
        entryType = appId.equals("bid") ? "bid_bidpublish" : "rebm_bidpublish";
        long bidpublishid = bidopen.getLong("bidpublishid");
        DynamicObject bidpublish = BusinessDataServiceHelper.loadSingle((Object)bidpublishid, (String)entryType);
        DynamicObjectCollection supplierentryInfoColl = ((DynamicObject)bidpublish.getDynamicObjectCollection("bidsection").get(0)).getDynamicObjectCollection("supplierentry");
        for (DynamicObject supplierentryInfo : supplierentryInfoColl) {
            if (!supplierentryInfo.get("supplier.id").equals(supplierId) || supplierentryInfo.getString("tenderstrategy").equals("NEEDBID")) continue;
            isHideRounds = false;
        }
        return isHideRounds;
    }

    public boolean getSourceBillStatus(DynamicObject oldOnlinebideval) {
        boolean isHideOldRounds = false;
        String sourcebillstatus = oldOnlinebideval.getString("sourcebillstatus");
        if (sourcebillstatus.equals("C")) {
            isHideOldRounds = true;
        }
        return isHideOldRounds;
    }

    public boolean getIsonlineeval(DynamicObject bidopen, DynamicObject oldBidopen, boolean isHideRounds) {
        boolean isonlineeval = bidopen.getBoolean("isonlineeval");
        boolean oldisonlineeval = oldBidopen.getBoolean("isonlineeval");
        if (!isonlineeval && !oldisonlineeval) {
            isHideRounds = false;
        }
        return isHideRounds;
    }

    public Map<Long, HashMap<String, Object>> sumSupplierSorce(Long onlinebidevalId, Long sectionId, String scoreMode, DynamicObjectCollection onlineBidEvalScoreColl, String appId) {
        int scoreIndex;
        List<String> supplierColumnKeyList = this.getOnlineBidEvalSupplierColumnKeys(onlinebidevalId, sectionId, appId);
        HashMap<Long, HashMap<String, Object>> supplierMap = new HashMap<Long, HashMap<String, Object>>();
        Map<String, Integer> totalRowIndexMap = this.getTotalRowIndex(sectionId, appId);
        int technicalTotalScoreIndex = totalRowIndexMap.get("technicalscore");
        int commercialTotalScoreIndex = totalRowIndexMap.get("commercialscore");
        int evalItemCount = scoreIndex = totalRowIndexMap.get("totalscore").intValue();
        for (int i = 0; i < evalItemCount; ++i) {
            if (i == technicalTotalScoreIndex || i == commercialTotalScoreIndex) continue;
            DynamicObject onlineBidEvalScore = (DynamicObject)onlineBidEvalScoreColl.get(i);
            int score = 0;
            BigDecimal weight = BigDecimal.ZERO;
            boolean isWeight = false;
            if (ScoreMode.STANDARD.getVal().equals(scoreMode)) {
                score = onlineBidEvalScore.getInt("score");
            } else {
                weight = onlineBidEvalScore.getBigDecimal("weight");
                isWeight = true;
            }
            if (score != 0) {
                // empty if block
            }
            String type = onlineBidEvalScore.getString("type");
            boolean isTechnical = EvalItemType.TECHNICAL.getAlias().equals(type);
            HashMap<String, Object> supplierScore = new HashMap<String, Object>(16);
            for (int j = 0; j < supplierColumnKeyList.size(); ++j) {
                String columnKey = supplierColumnKeyList.get(j);
                if (columnKey.startsWith("supplierid_")) {
                    Long supplierId = onlineBidEvalScore.getLong(columnKey);
                    supplierScore = (HashMap<String, Object>)supplierMap.get(supplierId);
                    if (supplierScore != null) continue;
                    supplierScore = new HashMap<String, Object>();
                    supplierScore.put("sumCommercialSorce", BigDecimal.ZERO);
                    supplierScore.put("sumTechnicalSorce", BigDecimal.ZERO);
                    supplierMap.put(supplierId, supplierScore);
                    continue;
                }
                if (!columnKey.startsWith("suppscore_")) continue;
                BigDecimal suppSorce = onlineBidEvalScore.getBigDecimal(columnKey);
                if (supplierScore != null) {
                    if (isWeight) {
                        suppSorce = suppSorce.multiply(weight);
                    }
                    if (isTechnical) {
                        supplierScore.put("sumTechnicalSorce", ((BigDecimal)supplierScore.get("sumTechnicalSorce")).add(suppSorce));
                    } else {
                        supplierScore.put("sumCommercialSorce", ((BigDecimal)supplierScore.get("sumCommercialSorce")).add(suppSorce));
                    }
                }
                supplierScore.put("columnKey", columnKey);
            }
        }
        return supplierMap;
    }

    public List<String> getOnlineBidEvalSupplierColumnKeys(Long onlinebidevalId, Long sectionId, String appId) {
        String selectFields = "id,entryseq,supplier.id,supplier.number,supplier.name";
        String entryEntity = null;
        entryEntity = "bid".equals(appId) ? "bid_onlinebideval" : "rebm_onlinebideval";
        DynamicObjectCollection onlineSupplierDetailColl = this.onlineBidEvalService.listOnlineSupplierDetailBySections(sectionId, selectFields, entryEntity);
        ArrayList<String> supplierColumnKeyList = new ArrayList<String>(16);
        for (int i = 0; i < onlineSupplierDetailColl.size(); ++i) {
            DynamicObject onlineSupplierDetail = (DynamicObject)onlineSupplierDetailColl.get(i);
            String supplierNumber = onlineSupplierDetail.getString("supplier.number").toLowerCase();
            supplierNumber = supplierNumber.replace('.', '_');
            String newSupplierIdKey = "supplierid_" + supplierNumber + KEY_NEW;
            String newSuppScoreKey = "suppscore_" + supplierNumber + KEY_NEW;
            supplierColumnKeyList.add(newSupplierIdKey);
            supplierColumnKeyList.add(newSuppScoreKey);
        }
        return supplierColumnKeyList;
    }

    public List<String> getOnlineBidEvalSupplierColumnKeysIncludeOld(Long onlinebidevalId, Long sectionId, String appId) {
        String selectFields = "id,entryseq,supplier.id,supplier.number,supplier.name";
        String entryEntity = null;
        entryEntity = "bid".equals(appId) ? "bid_onlinebideval" : "rebm_onlinebideval";
        DynamicObjectCollection onlineSupplierDetailColl = this.onlineBidEvalService.listOnlineSupplierDetailBySections(sectionId, selectFields, entryEntity);
        ArrayList<String> supplierColumnKeyList = new ArrayList<String>(16);
        for (int i = 0; i < onlineSupplierDetailColl.size(); ++i) {
            DynamicObject onlineSupplierDetail = (DynamicObject)onlineSupplierDetailColl.get(i);
            String supplierNumber = onlineSupplierDetail.getString("supplier.number").toLowerCase();
            supplierNumber = supplierNumber.replace('.', '_');
            String newSupplierIdKey = "supplierid_" + supplierNumber + KEY_NEW;
            String newSuppScoreKey = "suppscore_" + supplierNumber + KEY_NEW;
            supplierColumnKeyList.add(newSupplierIdKey);
            supplierColumnKeyList.add(newSuppScoreKey);
            String oldSupplierScoreKey = "suppscore_" + supplierNumber + KEY_OLD;
            supplierColumnKeyList.add(oldSupplierScoreKey);
        }
        return supplierColumnKeyList;
    }

    public DynamicObjectCollection getOnlineBidEvalSupplier(Long onlinebidevalId, Long sectionId, String appId) {
        String selectFields = "id,entryseq,supplier.id,supplier.number,supplier.name";
        String entryEntity = null;
        entryEntity = "bid".equals(appId) ? "bid_onlinebideval" : "rebm_onlinebideval";
        return this.onlineBidEvalService.listOnlineSupplierDetailBySections(sectionId, selectFields, entryEntity);
    }

    public List<String> getOnlineBidEvalScoreColumnKeys(Long onlinebidevalId, Long sectionId, String scoreMode, String appId) {
        List<String> columnKeys = this.getOnlineBidEvalSupplierColumnKeys(onlinebidevalId, sectionId, appId);
        columnKeys.add("evalitemid");
        columnKeys.add("type");
        columnKeys.add("item");
        columnKeys.add("standard");
        if (ScoreMode.STANDARD.getVal().equals(scoreMode)) {
            columnKeys.add("score");
        } else {
            columnKeys.add("weight");
        }
        return columnKeys;
    }

    public List<String> getOnlineBidEvalScoreColumnKeysIncludeOld(Long onlinebidevalId, Long sectionId, String scoreMode, String appId) {
        List<String> columnKeys = this.getOnlineBidEvalSupplierColumnKeysIncludeOld(onlinebidevalId, sectionId, appId);
        columnKeys.add("evalitemid");
        columnKeys.add("type");
        columnKeys.add("item");
        columnKeys.add("standard");
        if (ScoreMode.STANDARD.getVal().equals(scoreMode)) {
            columnKeys.add("score");
        } else {
            columnKeys.add("weight");
        }
        return columnKeys;
    }

    public Map<String, LinkedHashMap<String, Object>> getSupplierTotalScoreByDataBase(Long onlinebidevalId, Long sectionId, String appId) {
        String selectFields = "id,entryseq,technicalscore,commercialscore,totalscore,supplier.id,supplier.number,supplier.name";
        String entryEntity = null;
        entryEntity = "bid".equals(appId) ? "bid_onlinebideval" : "rebm_onlinebideval";
        DynamicObjectCollection onlineSupplierDetailColl = this.onlineBidEvalService.listOnlineSupplierDetailBySections(sectionId, selectFields, entryEntity);
        LinkedHashMap<String, LinkedHashMap<String, Object>> totalRowMap = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        LinkedHashMap<String, Number> technicalScoreRow = new LinkedHashMap<String, Number>();
        totalRowMap.put("technicalscore", technicalScoreRow);
        LinkedHashMap<String, Number> commercialScoreRow = new LinkedHashMap<String, Number>();
        totalRowMap.put("commercialscore", commercialScoreRow);
        LinkedHashMap<String, Number> scoreRow = new LinkedHashMap<String, Number>();
        totalRowMap.put("totalscore", scoreRow);
        DynamicObject onlineBidEval = BusinessDataServiceHelper.loadSingle((Object)onlinebidevalId, (String)entryEntity);
        long sourceBillId = onlineBidEval.getLong("sourcebillid");
        String sectionName = "";
        for (DynamicObject bidSectionRow : onlineBidEval.getDynamicObjectCollection("bidsection")) {
            if (bidSectionRow.getLong("id") != sectionId.longValue()) continue;
            sectionName = bidSectionRow.getString("sectionname");
            break;
        }
        Object bidprojectid = onlineBidEval.getDynamicObject("bidproject").getPkValue();
        QFilter qFilter = new QFilter("bidproject", "=", bidprojectid).and("id", "!=", (Object)onlinebidevalId).and("bidevaluator.id", "=", onlineBidEval.getDynamicObject("bidevaluator").getPkValue()).and("evaltype", "=", (Object)onlineBidEval.getString("evaltype"));
        if (sourceBillId != 0L && QueryServiceHelper.exists((String)entryEntity, (Object)sourceBillId)) {
            qFilter = new QFilter("id", "=", (Object)sourceBillId);
        }
        DynamicObject[] oldOnlineBIdEvalArray = BusinessDataServiceHelper.load((String)entryEntity, (String)"id,billstatus,bidsection,bidsection.id,bidsection.sectionname,bidopenid,sourcebillstatus,createtime", (QFilter[])qFilter.toArray(), (String)"createtime desc");
        boolean isLoadScore = false;
        boolean isLastOnlineEvalIsC = false;
        boolean isBidOpenOnlineNotChange = false;
        if (oldOnlineBIdEvalArray != null && oldOnlineBIdEvalArray.length > 0) {
            DynamicObject oldOnlineBidEval = oldOnlineBIdEvalArray[0];
            isLastOnlineEvalIsC = this.getSourceBillStatus(oldOnlineBidEval);
            isBidOpenOnlineNotChange = this.comBidOpenEvalInfo(onlineBidEval, oldOnlineBidEval);
            isLoadScore = isLastOnlineEvalIsC && isBidOpenOnlineNotChange;
        }
        for (int i = 0; i < onlineSupplierDetailColl.size(); ++i) {
            DynamicObject onlineSupplierDetail = (DynamicObject)onlineSupplierDetailColl.get(i);
            Long supplierId = onlineSupplierDetail.getLong("supplier.id");
            Object supplierNumber = onlineSupplierDetail.getString("supplier.number").toLowerCase();
            supplierNumber = ((String)supplierNumber).replace('.', '_');
            String newSupplierIdKey = "supplierid_" + (String)supplierNumber + KEY_NEW;
            String newSuppScoreKey = "suppscore_" + (String)supplierNumber + KEY_NEW;
            BigDecimal technicalScore = onlineSupplierDetail.getBigDecimal("technicalscore");
            BigDecimal commercialScore = onlineSupplierDetail.getBigDecimal("commercialscore");
            BigDecimal totalScore = onlineSupplierDetail.getBigDecimal("totalscore");
            technicalScoreRow.put(newSupplierIdKey, supplierId);
            commercialScoreRow.put(newSupplierIdKey, supplierId);
            scoreRow.put(newSupplierIdKey, supplierId);
            technicalScoreRow.put(newSuppScoreKey, technicalScore);
            commercialScoreRow.put(newSuppScoreKey, commercialScore);
            scoreRow.put(newSuppScoreKey, totalScore);
        }
        if (oldOnlineBIdEvalArray != null && oldOnlineBIdEvalArray.length != 0) {
            long oldBidSectionId = 0L;
            DynamicObject oldOnlineBidEval = oldOnlineBIdEvalArray[0];
            for (DynamicObject oldBidSectionRow : oldOnlineBidEval.getDynamicObjectCollection("bidsection")) {
                if (!StringUtils.equals((CharSequence)sectionName, (CharSequence)oldBidSectionRow.getString("sectionname"))) continue;
                oldBidSectionId = oldBidSectionRow.getLong("id");
                break;
            }
            DynamicObjectCollection oldOnlineSupplierDetailColl = this.onlineBidEvalService.listOnlineSupplierDetailBySections(Long.valueOf(oldBidSectionId), selectFields, entryEntity);
            LinkedHashMap oldtechnicalScoreRow = new LinkedHashMap();
            totalRowMap.put("oldtechnicalscore", oldtechnicalScoreRow);
            LinkedHashMap oldcommercialScoreRow = new LinkedHashMap();
            totalRowMap.put("oldcommercialscore", oldcommercialScoreRow);
            LinkedHashMap oldscoreRow = new LinkedHashMap();
            totalRowMap.put("oldtotalscore", oldscoreRow);
            for (DynamicObject oldonlineSupplierDetail : oldOnlineSupplierDetailColl) {
                Long supplierId = oldonlineSupplierDetail.getLong("supplier.id");
                String supplierNumber = oldonlineSupplierDetail.getString("supplier.number").toLowerCase();
                supplierNumber = supplierNumber.replace('.', '_');
                String oldSupplierIdKey = "supplierid_" + supplierNumber + KEY_OLD;
                String oldSuppScoreKey = "suppscore_" + supplierNumber + KEY_OLD;
                BigDecimal oldtechnicalScore = oldonlineSupplierDetail.getBigDecimal("technicalscore");
                BigDecimal oldcommercialScore = oldonlineSupplierDetail.getBigDecimal("commercialscore");
                BigDecimal oldtotalScore = oldonlineSupplierDetail.getBigDecimal("totalscore");
                technicalScoreRow.put(oldSupplierIdKey, supplierId);
                commercialScoreRow.put(oldSupplierIdKey, supplierId);
                scoreRow.put(oldSupplierIdKey, supplierId);
                if (oldOnlineBIdEvalArray.length != 0) {
                    if (!oldOnlineBIdEvalArray[0].getString("sourcebillstatus").equals("C") || !isLoadScore) continue;
                    technicalScoreRow.put(oldSuppScoreKey, oldtechnicalScore);
                    commercialScoreRow.put(oldSuppScoreKey, oldcommercialScore);
                    scoreRow.put(oldSuppScoreKey, oldtotalScore);
                    String tenderstrategy = OnlineBidEvalScoreUtil.isTenderstrategy(supplierId, onlineBidEval, sectionName);
                    String newSuppScoreKey = "suppscore_" + supplierNumber + KEY_NEW;
                    if (StringUtils.isEmpty((CharSequence)tenderstrategy) || !"UNNEEDBID".equals(tenderstrategy)) continue;
                    technicalScoreRow.put(newSuppScoreKey, oldtechnicalScore);
                    commercialScoreRow.put(newSuppScoreKey, oldcommercialScore);
                    scoreRow.put(newSuppScoreKey, oldtotalScore);
                    continue;
                }
                technicalScoreRow.put(oldSuppScoreKey, BigDecimal.ZERO);
                commercialScoreRow.put(oldSuppScoreKey, BigDecimal.ZERO);
                scoreRow.put(oldSuppScoreKey, BigDecimal.ZERO);
            }
        }
        return totalRowMap;
    }

    public Map<String, Integer> getTotalRowIndex(Long sectionId, String appId) {
        HashMap<String, Integer> totalRowIndexMap = new HashMap<String, Integer>();
        int technicalItemCount = this.onlineBidEvalService.getTypeItemCount(sectionId, EvalItemType.TECHNICAL.getVal());
        int commercialItemCount = this.onlineBidEvalService.getTypeItemCount(sectionId, EvalItemType.COMMERCIAL.getVal());
        boolean isTechFirst = this.checkIsTechFirst(sectionId, appId);
        int technicalTotalScoreIndex = -1;
        int commercialTotalScoreIndex = -1;
        if (isTechFirst) {
            if (technicalItemCount > 0) {
                technicalTotalScoreIndex = technicalItemCount;
            }
            if (commercialItemCount > 0) {
                commercialTotalScoreIndex = technicalItemCount + commercialItemCount;
                if (technicalTotalScoreIndex > 0) {
                    ++commercialTotalScoreIndex;
                }
            }
        } else {
            if (commercialItemCount > 0) {
                commercialTotalScoreIndex = commercialItemCount;
            }
            if (technicalItemCount > 0) {
                technicalTotalScoreIndex = commercialItemCount + technicalItemCount;
                if (commercialTotalScoreIndex > 0) {
                    ++technicalTotalScoreIndex;
                }
            }
        }
        int scoreIndex = technicalItemCount + commercialItemCount;
        if (technicalTotalScoreIndex > 0) {
            ++scoreIndex;
        }
        if (commercialTotalScoreIndex > 0) {
            ++scoreIndex;
        }
        totalRowIndexMap.put("technicalscore", technicalTotalScoreIndex);
        totalRowIndexMap.put("commercialscore", commercialTotalScoreIndex);
        totalRowIndexMap.put("totalscore", scoreIndex);
        return totalRowIndexMap;
    }

    public boolean checkIsTechFirst(long sectionId, String appId) {
        boolean isTechFirst = true;
        String scoreDetailSelectFields = "id,entryseq,score,type,evalItem.id,supplier.id,supplier.number";
        DynamicObjectCollection onlineScoreDetailColl = this.onlineBidEvalService.listOnlineScoreDetailBySections(Long.valueOf(sectionId), scoreDetailSelectFields, appId);
        if (onlineScoreDetailColl != null && onlineScoreDetailColl.size() > 0) {
            DynamicObject onlineScoreDetail = (DynamicObject)onlineScoreDetailColl.get(0);
            String type = onlineScoreDetail.getString("type");
            if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                isTechFirst = true;
            } else if (EvalItemType.COMMERCIAL.getVal().equals(type)) {
                isTechFirst = false;
            }
        }
        return isTechFirst;
    }
}

