/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.formplugin.bill.util.OnlineBidEvalScoreUtil;

public class OnlineBidEvalUtil {
    protected IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();

    public void saveOnlineBidEvalScoreData(Map<Long, String> cacheOnlineBidEvalScoreData, String appId) {
        ArrayList<HashMap<String, Object>> onlineBidEvalScoreList = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> entryDataList = new ArrayList<HashMap<String, Object>>();
        this.setListData(onlineBidEvalScoreList, entryDataList, cacheOnlineBidEvalScoreData, appId);
        this.onlineBidEvalService.saveSupplierScoreDetail(onlineBidEvalScoreList, entryDataList);
    }

    public boolean checkScopeOnlineBidEvalScoreData(Map<Long, String> cacheOnlineBidEvalScoreData, String appId) {
        ArrayList<HashMap<String, Object>> onlineBidEvalScoreList = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> entryDataList = new ArrayList<HashMap<String, Object>>();
        this.setListData(onlineBidEvalScoreList, entryDataList, cacheOnlineBidEvalScoreData, appId);
        return this.checkData(onlineBidEvalScoreList, entryDataList);
    }

    public void setListData(List<HashMap<String, Object>> onlineBidEvalScoreList, List<HashMap<String, Object>> entryDataList, Map<Long, String> cacheOnlineBidEvalScoreData, String appId) {
        OnlineBidEvalScoreUtil onlineBidEvalScoreUtil = new OnlineBidEvalScoreUtil();
        for (Map.Entry<Long, String> cacheOnlineBidEvalScore : cacheOnlineBidEvalScoreData.entrySet()) {
            String columnKey;
            HashMap<String, Long> data;
            Long sectionId = cacheOnlineBidEvalScore.getKey();
            Map<String, Integer> totalRowIndexMap = onlineBidEvalScoreUtil.getTotalRowIndex(sectionId, appId);
            int technicalTotalScoreIndex = totalRowIndexMap.get("technicalscore");
            int commercialTotalScoreIndex = totalRowIndexMap.get("commercialscore");
            int scoreIndex = totalRowIndexMap.get("totalscore");
            List<String> supplierColumnKeyList = onlineBidEvalScoreUtil.getOnlineBidEvalSupplierColumnKeys(null, sectionId, appId);
            String cacheOnlineBidEvalScoreCollStr = cacheOnlineBidEvalScore.getValue();
            List onlineBidEvalScoreDataList = (List)SerializationUtils.fromJsonString((String)cacheOnlineBidEvalScoreCollStr, Object.class);
            if (onlineBidEvalScoreDataList == null || onlineBidEvalScoreDataList.size() <= 0) continue;
            for (int i = 0; i < scoreIndex; ++i) {
                if (i == technicalTotalScoreIndex || i == commercialTotalScoreIndex) continue;
                LinkedHashMap rowData = (LinkedHashMap)onlineBidEvalScoreDataList.get(i);
                Long evalItemId = (Long)rowData.get("evalitemid");
                data = new HashMap(16);
                for (int j = 0; j < supplierColumnKeyList.size(); ++j) {
                    columnKey = supplierColumnKeyList.get(j);
                    if (columnKey.startsWith("supplierid_")) {
                        data = new HashMap();
                        onlineBidEvalScoreList.add(data);
                        data.put("section", sectionId);
                        data.put("evalitemid", evalItemId);
                        data.put("supplierid_", (Long)rowData.get(columnKey));
                        continue;
                    }
                    if (!columnKey.startsWith("suppscore_")) continue;
                    data.put("suppscore_", (Long)rowData.get(columnKey));
                }
            }
            LinkedHashMap technicalTotalRowData = null;
            if (technicalTotalScoreIndex > 0) {
                technicalTotalRowData = (LinkedHashMap)onlineBidEvalScoreDataList.get(technicalTotalScoreIndex);
            }
            LinkedHashMap commercialTotalRowData = null;
            if (commercialTotalScoreIndex > 0) {
                commercialTotalRowData = (LinkedHashMap)onlineBidEvalScoreDataList.get(commercialTotalScoreIndex);
            }
            LinkedHashMap totalRowData = (LinkedHashMap)onlineBidEvalScoreDataList.get(scoreIndex);
            data = new HashMap<String, Long>(16);
            for (int i = 0; i < supplierColumnKeyList.size(); ++i) {
                columnKey = supplierColumnKeyList.get(i);
                if (columnKey.startsWith("supplierid_")) {
                    data = new HashMap();
                    entryDataList.add(data);
                    data.put("section", sectionId);
                    data.put("supplierid_", (Long)totalRowData.get(columnKey));
                    continue;
                }
                if (!columnKey.startsWith("suppscore_")) continue;
                if (technicalTotalRowData != null) {
                    data.put("technicalscore", (Long)technicalTotalRowData.get(columnKey));
                }
                if (commercialTotalRowData != null) {
                    data.put("commercialscore", (Long)commercialTotalRowData.get(columnKey));
                }
                data.put("totalscore", (Long)totalRowData.get(columnKey));
            }
        }
    }

    public boolean checkData(List<HashMap<String, Object>> onlineBidEvalScoreList, List<HashMap<String, Object>> entryDataList) {
        for (int i = 0; i < onlineBidEvalScoreList.size(); ++i) {
            BigDecimal sorce;
            HashMap<String, Object> dataMap = onlineBidEvalScoreList.get(i);
            Object suppScore = dataMap.get("suppscore_");
            if (suppScore == null || (sorce = (BigDecimal)suppScore).compareTo(new BigDecimal(0)) >= 0 && sorce.compareTo(new BigDecimal(100)) <= 0) continue;
            return false;
        }
        return true;
    }
}

