/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.enums.ClarifyStatusEnum;

public class QuestionClarifyUtil {
    protected IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    public static final String OP_KEY_SEND = "send";
    public static final String OP_KEY_CANCEL = "unsubmit";
    public static final String OP_KEY_SAVE = "save";
    public static final String MainOrgPageCache = "mianOrgPageCache";

    public BillShowParameter addNewQuestionClarifyBill(String appId, Object bidProjectId, String openType) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("bidproject", bidProjectId);
        showParameter.setCustomParam("opentype", (Object)openType);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(this.getFormConstant(appId));
        return showParameter;
    }

    public BillShowParameter addNewMultiQuestionClarifyBill(String appId, Object bidProjectId, String openType) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("bidproject", bidProjectId);
        showParameter.setCustomParam("opentype", (Object)openType);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(this.getMultiFormConstant(appId));
        return showParameter;
    }

    public BillShowParameter getOpenQuestionClarifyBill(String appId, Object billId) {
        DynamicObject questClarify = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bid_questionclarify", (String)"billstatus");
        String billstatus = questClarify.getString("billstatus");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(billId);
        if (ClarifyStatusEnum.UNSENT.getValue().equals(billstatus) || ClarifyStatusEnum.SAVED.getValue().equals(billstatus)) {
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(this.getFormConstant(appId));
        return showParameter;
    }

    public BillShowParameter getOpenQuestionClarifyBillUnEnable(String appId, Object billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(billId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("LookLock", (Object)Boolean.TRUE);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(this.getFormConstant(appId));
        return showParameter;
    }

    public ListShowParameter getOpenQCListInBidEval(String appId, Object bidProjectId, String openType, String evalStatus, Object bidEvalId) {
        this.questionClarifyService.refreshCurrentQCListData(bidProjectId, openType);
        ListShowParameter listShowParameter = new ListShowParameter();
        List qFilters = this.questionClarifyService.getCurrentQCListQFilterList(bidProjectId, openType);
        String orderBys = "initiationtime desc";
        ListFilterParameter listFilterParameter = new ListFilterParameter(qFilters, orderBys);
        listShowParameter.setCustomParam("bidProjectId", bidProjectId);
        listShowParameter.setCustomParam("openType", (Object)openType);
        listShowParameter.setCustomParam("bidEvalId", bidEvalId);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setListFilterParameter(listFilterParameter);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId(this.getFormConstant(appId));
        String evalStatusText = this.getEvalStatusText(evalStatus);
        if (StringUtils.isNotEmpty((CharSequence)evalStatusText)) {
            listShowParameter.setCustomParam("evalStatusText", (Object)evalStatusText);
        }
        return listShowParameter;
    }

    public ListShowParameter getOnlineBidEvalQCList(String appId, Object bidProjectId, String openType) {
        this.questionClarifyService.refreshCurrentQCListData(bidProjectId, openType);
        ListShowParameter listShowParameter = new ListShowParameter();
        List qFilters = this.questionClarifyService.getCurrentQCListQFilterList(bidProjectId, openType);
        String orderBys = "initiationtime desc";
        ListFilterParameter listFilterParameter = new ListFilterParameter(qFilters, orderBys);
        listShowParameter.setCustomParam("bidProjectId", bidProjectId);
        listShowParameter.setCustomParam("openType", (Object)openType);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setListFilterParameter(listFilterParameter);
        listShowParameter.setCustomParam("OnlineBidEval", (Object)Boolean.TRUE);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId(this.getFormConstant(appId));
        return listShowParameter;
    }

    public String getEvalStatusText(String evalstatus) {
        switch (evalstatus) {
            case "B": {
                return "\u5df2\u63d0\u4ea4";
            }
            case "I": {
                return "\u5ba1\u6838\u4e2d";
            }
            case "C": {
                return "\u5df2\u5ba1\u6838";
            }
            case "XX": {
                return "\u5df2\u4f5c\u5e9f";
            }
        }
        return null;
    }

    public void synFileInClarifyAttachPanel(String appId, Object pkValue) {
        if ("rebm".equals(appId)) {
            BidFileHelper.synFileFromAToB((String)"rebm_questionclarify", (Object)pkValue, (String)"clarifyattachpanel", (String)"resp_questionclarify", (Object)pkValue, (String)"clarifyattachpanel");
        } else {
            BidFileHelper.synFileFromAToB((String)"bid_questionclarify", (Object)pkValue, (String)"clarifyattachpanel", (String)"ten_questionclarify", (Object)pkValue, (String)"clarifyattachpanel");
        }
    }

    public String getMultiFormConstant(String appName) {
        String postfix = "multiquestclarify";
        switch (appName) {
            case "bid": {
                return "bid_" + postfix;
            }
            case "ten": {
                return "bid_" + postfix;
            }
            case "rebm": {
                return "rebm_" + postfix;
            }
            case "resp": {
                return "rebm_" + postfix;
            }
        }
        return "bid_" + postfix;
    }

    public String getFormConstant(String appName) {
        String postfix = "questionclarify";
        switch (appName) {
            case "bid": {
                return "bid_" + postfix;
            }
            case "ten": {
                return "bid_" + postfix;
            }
            case "rebm": {
                return "rebm_" + postfix;
            }
            case "resp": {
                return "rebm_" + postfix;
            }
        }
        return "bid_" + postfix;
    }

    public String getFormConstant(String appName, String postfix) {
        switch (appName) {
            case "bid": {
                return "bid_" + postfix;
            }
            case "ten": {
                return "bid_" + postfix;
            }
            case "rebm": {
                return "rebm_" + postfix;
            }
            case "resp": {
                return "rebm_" + postfix;
            }
        }
        return "bid_" + postfix;
    }

    public void setComboEditValuesByBidProjectId(String appId, ComboEdit comboEdit, DynamicObject bidProject, String openType) {
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)openType);
        QFilter enableFilter = new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX", "J"});
        String formConstant = this.getFormConstant(appId, "bidopen");
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)formConstant, (String)"id,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.supplier_istender,supplierentry.supplier_isinvalid", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), openTypeFilter, enableFilter});
        DynamicObjectCollection bidsectioncoll = bidOpen.getDynamicObjectCollection("bidsection");
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        ArrayList<ComboItem> modelItems = new ArrayList<ComboItem>();
        for (int i = 0; i < bidsectioncoll.size(); ++i) {
            DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
            String sectionname = "";
            if (enablemultisection) {
                sectionname = bidsection.getString("sectionname");
            }
            DynamicObjectCollection suppliereEntryColl = bidsection.getDynamicObjectCollection("supplierentry");
            for (int j = 0; j < suppliereEntryColl.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)suppliereEntryColl.get(j);
                Boolean istender = supplierentry.getBoolean("supplier_istender");
                Boolean isinvalid = supplierentry.getBoolean("supplier_isinvalid");
                if (!istender.booleanValue() || isinvalid.booleanValue()) continue;
                DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                String supplierName = supplier.getString("name");
                String supplierId = supplier.getPkValue().toString();
                LocaleString caption = null;
                caption = enablemultisection ? new LocaleString(supplierName + "(" + sectionname + ")") : new LocaleString(supplierName);
                String value = supplierId + "&&" + supplierName + "&&" + sectionname;
                modelItems.add(new ComboItem(caption, value));
            }
        }
        comboEdit.setComboItems(modelItems);
    }

    public String checkBidEvalStatusCanSendOrUnSubmmit(Object bidprojectId, String openType, String opKey) {
        String evalstatus = this.questionClarifyService.getBidEvalutionStatus(bidprojectId, openType);
        String evalstatusText = this.getEvalStatusText(evalstatus);
        String notification = null;
        if (evalstatusText != null) {
            if (OP_KEY_SEND.equals(opKey)) {
                notification = String.format(ResManager.loadKDString((String)"\u8bc4\u6807\u5355%s\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u3002", (String)"QuestionClarifyUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), evalstatusText);
            } else if (OP_KEY_CANCEL.equals(opKey)) {
                notification = String.format(ResManager.loadKDString((String)"\u8bc4\u6807\u5355%s\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"QuestionClarifyUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), evalstatusText);
            }
        }
        return notification;
    }
}

