/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IMyTenderService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.MyTenderServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SupplierHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.formplugin.bill.util.InvItationMessageAuxiliary;

public class SendMessageUtil {
    private static final String Long = null;
    private IMyTenderService myTenderService = new MyTenderServiceImpl();

    public void sendSeletedMsg(DynamicObject supplierInvitation, String appId) {
        DynamicObject bidProject = supplierInvitation.getDynamicObject("bidproject");
        DynamicObject bidMode = bidProject.getDynamicObject("bidmode");
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            return;
        }
        if (bidMode != null) {
            InvItationMessageAuxiliary auxiliary = new InvItationMessageAuxiliary();
            if (BidModeHelper.isPublicBidding(bidProject)) {
                auxiliary.publicIntationMessage(supplierInvitation, appId, bidProject);
            } else {
                auxiliary.privateInvitation(supplierInvitation, appId, bidProject);
            }
        }
    }

    public void sendSupplierInvitationSeletedMsg(DynamicObject[] supplierInvitationArray, String appId) {
        if (supplierInvitationArray != null && supplierInvitationArray.length > 0) {
            for (DynamicObject supplierInvitation : supplierInvitationArray) {
                DynamicObject bidProject = supplierInvitation.getDynamicObject("bidproject");
                DynamicObject bidMode = bidProject.getDynamicObject("bidmode");
                boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
                if (!enable) {
                    return;
                }
                if (bidMode == null) continue;
                InvItationMessageAuxiliary auxiliary = new InvItationMessageAuxiliary();
                if (BidModeHelper.isPublicBidding(bidProject)) {
                    auxiliary.publicIntationMessage(supplierInvitation, appId, bidProject);
                    continue;
                }
                auxiliary.privateInvitation(supplierInvitation, appId, bidProject);
            }
        }
    }

    public void sentInvitedMsg(String appId, String operateKey, Object invitationId, DynamicObject supplierInvitation) {
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        supplierInvitation = "bid".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)supplierInvitation.getPkValue(), (String)"bid_supplierinvitation") : BusinessDataServiceHelper.loadSingle((Object)supplierInvitation.getPkValue(), (String)"rebm_supplierinvitation");
        ArrayList<String> invitationSupplierIdList = new ArrayList<String>();
        DynamicObject invitation = BusinessDataServiceHelper.loadSingle((Object)invitationId, (String)(appId + "_invitation"));
        if (invitation != null) {
            DynamicObjectCollection supplierEntryCol = invitation.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryCol) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null) continue;
                invitationSupplierIdList.add(supplier.getString("id"));
            }
        }
        if (!CollectionUtils.isEmpty(invitationSupplierIdList)) {
            DynamicObject bidProject = supplierInvitation.getDynamicObject("bidproject");
            DynamicObjectCollection bidsectionCollection = (DynamicObjectCollection)supplierInvitation.get("bidsection");
            HashMap<String, Object> msgParam = new HashMap<String, Object>();
            msgParam.put("title", null);
            msgParam.put("content", null);
            msgParam.put("appId", appId);
            msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId"));
            msgParam.put("operation", operateKey);
            msgParam.put("msgentity", "bid_invitation");
            msgParam.put("pkId", invitationId);
            msgParam.put("id", invitationId);
            msgParam.put("tplScene", "bid_invitation");
            if ("rebm".equals(appId)) {
                msgParam.put("formId", "resp_invitation_detail");
            } else {
                msgParam.put("formId", "ten_invitation_detail");
            }
            String notifyTypes = MessageChannelUtil.getNotifyType((String)"bid_invitation", (String)"bid_invitation");
            HashSet<Long> allIds = new HashSet<Long>();
            for (DynamicObject bidSection : bidsectionCollection) {
                DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    Long partnerId;
                    DynamicObject supplier;
                    if (supplierEntry.getLong("id") == 0L || supplierEntry.getDynamicObject("supplier") == null || (supplier = supplierEntry.getDynamicObject("supplier")) == null || !invitationSupplierIdList.contains(supplier.getString("id"))) continue;
                    Long supplierId = (Long)supplierEntry.getDynamicObject("supplier").getPkValue();
                    msgParam.put("supplierBizUser", supplierId);
                    msgParam.put("supplierId", supplierId);
                    Set<Long> receiveUserIds = this.getReceiveUserIds(appId, supplierId, allIds);
                    allIds.addAll(new HashSet<Long>(receiveUserIds));
                    DynamicObject projectpartner = supplierEntry.getDynamicObject("projectpartner");
                    if (projectpartner != null && allIds.add(partnerId = (Long)projectpartner.getPkValue())) {
                        receiveUserIds.add(partnerId);
                    }
                    MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, new ArrayList<Long>(receiveUserIds), (String)notifyTypes);
                }
            }
        }
    }

    public void sendInvitationByBidProject(String appId, String operateKey, Object bidProjectId, Object invitationId) {
        DynamicObject bidProject = null;
        bidProject = "bid".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project") : BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"rebm_project");
        String projectName = bidProject.getString("name");
        boolean enableMultiSection = bidProject.getBoolean("enablemultisection");
        DynamicObjectCollection bidsectionCollection = bidProject.getDynamicObjectCollection("bidrollsection");
        String notifyTypes = MessageChannelUtil.getNotifyType((String)"bid_invitation", (String)"bid_invitation");
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("title", null);
        msgParam.put("content", null);
        msgParam.put("appId", appId);
        msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId"));
        msgParam.put("operation", operateKey);
        msgParam.put("msgentity", "bid_invitation");
        msgParam.put("pkId", invitationId);
        msgParam.put("id", invitationId);
        msgParam.put("tplScene", "bid_invitation");
        if ("rebm".equals(appId)) {
            msgParam.put("formId", "resp_invitation_detail");
        } else {
            msgParam.put("formId", "ten_invitation_detail");
        }
        HashSet<Long> allIds = new HashSet<Long>();
        for (DynamicObject bidSection : bidsectionCollection) {
            DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                Long partnerId;
                Object supplierId = null;
                if ("bid".equals(appId)) {
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    if (null == supplier) continue;
                    supplierId = supplier.getPkValue();
                } else {
                    DynamicObject regSupplier;
                    String supplierSource = supplierEntry.getString("suppliersource");
                    DynamicObject supplierObj = supplierEntry.getDynamicObject("suppliername");
                    supplierId = supplierObj.getPkValue();
                    if ("resm_regsupplier".equals(supplierSource) && null != (regSupplier = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"resm_regsupplier")).getDynamicObject("officesupplier")) {
                        supplierId = regSupplier.getPkValue();
                    }
                }
                Set<Long> receiveUserIds = this.getReceiveUserIds(appId, (Long)supplierId, allIds);
                allIds.addAll(receiveUserIds);
                DynamicObject projectpartner = supplierEntry.getDynamicObject("projectpartner");
                if (projectpartner != null && allIds.add(partnerId = (Long)projectpartner.getPkValue())) {
                    receiveUserIds.add(partnerId);
                }
                msgParam.put("supplierBizUser", (Long)supplierId);
                msgParam.put("supplierId", (Long)supplierId);
                MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, new ArrayList<Long>(receiveUserIds), (String)notifyTypes);
            }
        }
    }

    protected Set<Long> getReceiveUserIds(String appId, Long supplierId, Set<Long> allIds) {
        HashSet<Long> receiveUserIds = new HashSet<Long>();
        Long adminUserId = null;
        if ("rebm".equals(appId)) {
            long id = (Long)SupplierHelper.getSysSupByRESMSup((Long)supplierId).getPkValue();
            adminUserId = SupplierHelper.listAdminUserIdBySupplier((Long)id);
            if (!allIds.contains(adminUserId)) {
                receiveUserIds.add(adminUserId);
            }
            allIds.add(adminUserId);
        } else {
            adminUserId = SupplierHelper.listAdminUserIdBySupplier((Long)supplierId);
            if (!allIds.contains(adminUserId)) {
                receiveUserIds.add(adminUserId);
            }
            allIds.add(adminUserId);
        }
        return receiveUserIds;
    }

    public void sendAnswerMsg(Long projectId, String appId, Object[] objects) {
        DynamicObjectCollection supplierEntrys;
        DynamicObjectCollection sections;
        DynamicObject bidProject = new BidProjectServiceImpl().getBidProjectAllById(projectId);
        Boolean hasPublishStep = bidProject.getBoolean("bidpublish");
        Boolean hasSuppInviStep = bidProject.getBoolean("supplierinvitation");
        DynamicObject bidMode = bidProject.getDynamicObject("bidmode");
        HashSet<Long> supplierIDs = new HashSet<Long>();
        QFilter projFilter = new QFilter("bidproject", "=", (Object)projectId);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.PUBLISHED.getVal());
        if (hasPublishStep.booleanValue()) {
            DynamicObject[] bidPublishs = null;
            bidPublishs = "bid".equals(appId) ? BusinessDataServiceHelper.loadFromCache((String)"bid_bidpublish", (QFilter[])new QFilter[]{projFilter, statusFilter}).values().toArray(new DynamicObject[0]) : BusinessDataServiceHelper.loadFromCache((String)"rebm_bidpublish", (QFilter[])new QFilter[]{projFilter, statusFilter}).values().toArray(new DynamicObject[0]);
            if (bidPublishs.length > 0) {
                DynamicObject bidPublish = bidPublishs[0];
                sections = bidPublish.getDynamicObjectCollection("bidsection");
                for (DynamicObject section : sections) {
                    supplierEntrys = section.getDynamicObjectCollection("supplierentry");
                    for (Object supplierEntry : supplierEntrys) {
                        supplierIDs.add((Long)supplierEntry.getDynamicObject("supplier").getPkValue());
                    }
                }
            }
        } else if (hasSuppInviStep.booleanValue()) {
            statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal());
            DynamicObject[] suppInvis = null;
            suppInvis = "bid".equals(appId) ? BusinessDataServiceHelper.loadFromCache((String)"bid_supplierinvitation", (QFilter[])new QFilter[]{projFilter, statusFilter}).values().toArray(new DynamicObject[0]) : BusinessDataServiceHelper.loadFromCache((String)"rebm_supplierinvitation", (QFilter[])new QFilter[]{projFilter, statusFilter}).values().toArray(new DynamicObject[0]);
            if (suppInvis.length > 0) {
                DynamicObject suppInvi = suppInvis[0];
                sections = suppInvi.getDynamicObjectCollection("bidsection");
                for (DynamicObject section : sections) {
                    supplierEntrys = section.getDynamicObjectCollection("supplierentry");
                    for (Object supplierEntry : supplierEntrys) {
                        supplierIDs.add((Long)supplierEntry.getDynamicObject("supplier").getPkValue());
                    }
                }
            }
        }
        if (supplierIDs.size() == 0) {
            return;
        }
        if (objects != null && objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                HashMap<String, Object> msgParam = new HashMap<String, Object>();
                msgParam.put("title", null);
                msgParam.put("content", null);
                msgParam.put("appId", appId);
                msgParam.put("id", objects[i]);
                msgParam.put("tplScene", "reco");
                if ("bid".equals(appId)) {
                    msgParam.put("formId", "ten_mytender");
                } else {
                    msgParam.put("formId", "resp_mytender");
                }
                msgParam.put("msgentity", "bid_answerquestion_reco");
                msgParam.put("targetButtonId", "button_online_answer");
                msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "targetButtonId"));
                msgParam.put("operation", "audit");
                String notifyType = MessageChannelUtil.getNotifyType((String)"reco", (String)"bid_answerquestion_reco");
                msgParam.put("notifyType", notifyType);
                DynamicObject answerQuestionReco = null;
                answerQuestionReco = "bid".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)objects[i], (String)"bid_answerquestion_reco") : BusinessDataServiceHelper.loadSingle((Object)objects[i], (String)"rebm_answerquestion_reco");
                DynamicObjectCollection ansQuelist = answerQuestionReco.getDynamicObjectCollection("bid_answerquestions_list");
                HashSet<Long> onlySupplierIDs = new HashSet<Long>();
                boolean openFlag = false;
                for (DynamicObject ansQue : ansQuelist) {
                    DynamicObject[] isOpen = ansQue.getString("isopen");
                    if ("1".equals(isOpen)) {
                        openFlag = true;
                        break;
                    }
                    if (!"0".equals(isOpen)) continue;
                    DynamicObject proposedUnit = ansQue.getDynamicObject("proposedunit");
                    onlySupplierIDs.add((Long)proposedUnit.getPkValue());
                }
                if (!openFlag) {
                    DynamicObject[] load;
                    QFilter filter = new QFilter("id", "in", onlySupplierIDs);
                    for (DynamicObject supplier : load = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"name,bizpartner", (QFilter[])new QFilter[]{filter})) {
                        DynamicObject bizpartner = supplier.getDynamicObject("bizpartner");
                        if (bizpartner == null) continue;
                        QFilter bizPartnerFilter = new QFilter("bizpartner", "=", bizpartner.getPkValue());
                        DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"name", (QFilter[])new QFilter[]{bizPartnerFilter});
                        if (suppliers.length <= 1) continue;
                        for (DynamicObject tempSup : suppliers) {
                            onlySupplierIDs.add((Long)tempSup.getPkValue());
                        }
                    }
                    supplierIDs.clear();
                    supplierIDs.addAll(onlySupplierIDs);
                }
                for (Long supplierId : supplierIDs) {
                    DynamicObject myTender = this.myTenderService.getMyTenderByBidProjectAndSupplier(projectId, supplierId);
                    if (myTender == null) continue;
                    Long tenderPk = 0L;
                    if (myTender != null) {
                        tenderPk = myTender.getLong("id");
                    }
                    msgParam.put("supplierId", supplierId);
                    msgParam.put("supplierBizUser", myTender.getPkValue());
                    msgParam.put("pkId", tenderPk);
                    this.sendRecoMessage(msgParam, bidProject.getPkValue(), supplierId, notifyType, appId);
                }
            }
        }
    }

    private void sendRecoMessage(HashMap<String, Object> msgParam, Object bidProjectPk, Long currentSupplierId, String notifyTypes, String appId) {
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        boolean enable_close = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable_close) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)notifyTypes)) {
            return;
        }
        DynamicObject[] bidPublishArray = BusinessDataServiceHelper.load((String)(appId + "_bidpublish"), (String)"bidsection,bidsection.supplierentry,supplierentry,supplierentry.supplier,supplierentry.projectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("billstatus", "=", (Object)"P")}, (String)"createtime desc");
        if (bidPublishArray != null && bidPublishArray.length > 0) {
            DynamicObject bidPublish = bidPublishArray[0];
            DynamicObjectCollection bidSectionCol = bidPublish.getDynamicObjectCollection("bidsection");
            HashMap<Long, Long> hasMap = new HashMap<Long, Long>();
            for (DynamicObject bidSection : bidSectionCol) {
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject projectPartner;
                    Long supplierId = supplierEntry.getLong("supplier.id");
                    if (!currentSupplierId.equals(supplierId) || (projectPartner = supplierEntry.getDynamicObject("projectpartner")) == null) continue;
                    hasMap.put(supplierId, projectPartner.getLong("id"));
                }
            }
            Long supplierUserId = (Long)hasMap.get(currentSupplierId);
            msgParam.put("supplierId", currentSupplierId);
            if (supplierUserId != null) {
                msgParam.put("supplierBizUser", supplierUserId);
            }
            MessageCenterHelper.sendMessages(msgParam, (boolean)true, (String)appId, (String)notifyTypes);
        }
    }

    private void sendAnswerMsg(HashMap<String, Object> msgParam, Object id, Set<Long> supplierIds) {
        HashMap<Long, Long> supplierBizUsers = new HashMap<Long, Long>();
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()));
        DynamicObject bidMode = project.getDynamicObject("bidmode");
        String appId = project.getString("entitytypeid").split("_")[0];
        if (bidMode != null) {
            DynamicObject[] supplierInvation = null;
            supplierInvation = "bid".equals(appId) ? BusinessDataServiceHelper.load((String)"bid_supplierinvitation", (String)"id,bidsection,bidsection.supplierentry,bidenrollsection,supplierentry,supplierentry.invitationstatus,supplierentry.invitationuser,supplierentry.invitationuser.id,supplierentry.supplier,supplierentry.isrecommend,bidenrollsection.supplierenrollentry,supplierenrollentry.enrollsupplier,supplierenrollentry.applyuser", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", id)}) : BusinessDataServiceHelper.load((String)"rebm_supplierinvitation", (String)"id,bidsection,bidsection.supplierentry,bidenrollsection,supplierentry,supplierentry.invitationstatus,supplierentry.invitationuser,supplierentry.invitationuser.id,supplierentry.isrecommend,supplierentry.supplier,bidenrollsection.supplierenrollentry,supplierenrollentry.enrollsupplier,supplierenrollentry.applyuser", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", id)});
            if (supplierInvation != null && supplierInvation.length > 0) {
                DynamicObject supplierInvate = supplierInvation[0];
                if (BidModeHelper.isPublicBidding(project)) {
                    DynamicObjectCollection bidEnrollSectionColl = supplierInvate.getDynamicObjectCollection("bidenrollsection");
                    if (!bidEnrollSectionColl.isEmpty()) {
                        for (int i = 0; i < bidEnrollSectionColl.size(); ++i) {
                            DynamicObject bidSection = (DynamicObject)bidEnrollSectionColl.get(i);
                            for (DynamicObject item : bidSection.getDynamicObjectCollection("supplierenrollentry")) {
                                long supplierId = item.getLong("enrollsupplier.id");
                                long applyUserId = item.getLong("applyuser.id");
                                if (!supplierIds.contains(supplierId)) continue;
                                supplierBizUsers.put(supplierId, applyUserId);
                            }
                        }
                    }
                    MessageCenterHelper.sendMessages(msgParam, (boolean)true, supplierIds, supplierBizUsers);
                } else {
                    DynamicObjectCollection bidSectionColl = supplierInvate.getDynamicObjectCollection("bidsection");
                    if (!bidSectionColl.isEmpty()) {
                        for (int i = 0; i < bidSectionColl.size(); ++i) {
                            DynamicObjectCollection supplierEntryColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                            for (DynamicObject supplierEntry : supplierEntryColl) {
                                if (supplierEntry.getLong("id") == 0L || supplierEntry.getDynamicObject("supplier") == null) continue;
                                Long supplierId = (Long)supplierEntry.getDynamicObject("supplier").getPkValue();
                                boolean isrecommend = supplierEntry.getBoolean("isrecommend");
                                if (!supplierIds.contains(supplierId) || !isrecommend) continue;
                                ArrayList<Long> partnerUserIds = new ArrayList<Long>();
                                DynamicObject[] partnerUsers = null;
                                partnerUsers = "bid".equals(appId) ? SupplierHelper.listUserBySupplierId((Long)supplierId) : SupplierHelper.listUserByResmSupplierId((Long)supplierId);
                                for (DynamicObject partnerUser : partnerUsers) {
                                    DynamicObject user = partnerUser.getDynamicObject("user");
                                    if (user == null || !partnerUser.getBoolean("isadmin")) continue;
                                    partnerUserIds.add((Long)user.getPkValue());
                                    break;
                                }
                                supplierBizUsers.put((Long)supplierEntry.getDynamicObject("supplier").getPkValue(), (Long)partnerUserIds.get(0));
                                DynamicObject invitationuser = supplierEntry.getDynamicObject("invitationuser");
                                if (invitationuser == null) continue;
                                HashMap<Long, Long> invitationusers = new HashMap<Long, Long>();
                                invitationusers.put((Long)supplierEntry.getDynamicObject("supplier").getPkValue(), invitationuser.getLong("id"));
                                MessageCenterHelper.sendMessages(msgParam, (boolean)true, supplierIds, invitationusers);
                            }
                        }
                    }
                    MessageCenterHelper.sendMessages(msgParam, (boolean)true, supplierIds, supplierBizUsers);
                }
            } else {
                ArrayList<Long> partnerUserIds = new ArrayList<Long>();
                for (Long supplierId : supplierIds) {
                    DynamicObject[] partnerUsers = null;
                    partnerUsers = "bid".equals(appId) ? SupplierHelper.listUserBySupplierId((Long)supplierId) : SupplierHelper.listUserByResmSupplierId((Long)supplierId);
                    for (DynamicObject partnerUser : partnerUsers) {
                        DynamicObject user = partnerUser.getDynamicObject("user");
                        if (user == null) continue;
                        partnerUserIds.add((Long)user.getPkValue());
                    }
                }
                MessageCenterHelper.sendMessages(msgParam, (boolean)true, partnerUserIds);
            }
        }
    }

    private void sendMessage(HashMap<String, Object> msgParam, Object id, Set<Long> supplierIds) {
        HashMap<Long, Long> supplierBizUsers = new HashMap<Long, Long>();
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()));
        DynamicObject bidMode = project.getDynamicObject("bidmode");
        String appId = project.getString("entitytypeid").split("_")[0];
        if (bidMode != null) {
            DynamicObject[] supplierInvation = null;
            supplierInvation = "bid".equals(appId) ? BusinessDataServiceHelper.load((String)"bid_supplierinvitation", (String)"id,bidsection,bidsection.supplierentry,bidenrollsection,supplierentry,supplierentry.invitationstatus,supplierentry.invitationuser,supplierentry.invitationuser.id,supplierentry.supplier,supplierentry.projectpartner,bidenrollsection.supplierenrollentry,supplierenrollentry.enrollsupplier,supplierenrollentry.applyuser,supplierenrollentry.baoprojectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", id)}) : BusinessDataServiceHelper.load((String)"rebm_supplierinvitation", (String)"id,bidsection,bidsection.supplierentry,bidenrollsection,supplierentry,supplierentry.invitationstatus,supplierentry.invitationuser,supplierentry.invitationuser.id,supplierentry.supplier,supplierentry.projectpartner,bidenrollsection.supplierenrollentry,supplierenrollentry.enrollsupplier,supplierenrollentry.applyuser,supplierenrollentry.baoprojectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", id)});
            if (supplierInvation != null && supplierInvation.length > 0) {
                DynamicObject supplierInvate = supplierInvation[0];
                if (BidModeHelper.isPublicBidding(project)) {
                    DynamicObjectCollection bidEnrollSectionColl = supplierInvate.getDynamicObjectCollection("bidenrollsection");
                    if (!bidEnrollSectionColl.isEmpty()) {
                        for (int i = 0; i < bidEnrollSectionColl.size(); ++i) {
                            DynamicObject bidSection = (DynamicObject)bidEnrollSectionColl.get(i);
                            for (DynamicObject item : bidSection.getDynamicObjectCollection("supplierenrollentry")) {
                                long supplierId = item.getLong("enrollsupplier.id");
                                long applyUserId = item.getLong("applyuser.id");
                                supplierBizUsers.put(supplierId, applyUserId);
                            }
                        }
                    }
                    MessageCenterHelper.sendMessages(msgParam, (boolean)true, supplierIds, supplierBizUsers);
                } else {
                    DynamicObjectCollection bidSectionColl = supplierInvate.getDynamicObjectCollection("bidsection");
                    if (!bidSectionColl.isEmpty()) {
                        for (int i = 0; i < bidSectionColl.size(); ++i) {
                            DynamicObjectCollection supplierEntryColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                            for (DynamicObject supplierEntry : supplierEntryColl) {
                                if (supplierEntry.getLong("id") == 0L || supplierEntry.getDynamicObject("supplier") == null) continue;
                                supplierIds.add((Long)supplierEntry.getDynamicObject("supplier").getPkValue());
                                supplierBizUsers.put((Long)supplierEntry.getDynamicObject("supplier").getPkValue(), supplierEntry.getLong("invitationuser.id"));
                            }
                        }
                    }
                    MessageCenterHelper.sendMessages(msgParam, (boolean)true, supplierIds, supplierBizUsers);
                }
            } else {
                MessageCenterHelper.sendMessages(msgParam, (boolean)true, supplierIds, supplierBizUsers);
            }
        }
    }
}

