/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.WebOffice;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;

public class WebOfficeUtil {
    private static final Logger log = Logger.getLogger(WebOfficeUtil.class.getName());
    public static final String ID = "id";
    public static final String FNUMBER = "FNUMBER";
    public static final String FBILLTYPE = "FBillType";
    public static final String FINTERID = "FInterID";
    public static final String FMODIFYTIME = "FModifyTime";
    public static final String FATTACHMENTNAME = "FAttachmentName";
    public static final String FCREATETIME = "fcreatetime";
    public static final String FALIASFILENAME = "FaliasFileName";
    public static final String FEXTNAME = "FExtName";
    public static final String FATTACHMENTSIZE = "FATTACHMENTSIZE";
    public static final String FCREATEMEN = "FCREATEMEN";
    public static final String FATTACHMENTPANEL = "fattachmentpanel";
    public static final String FDESCRIPTION = "fdescription";
    public static final String FFILEID = "FFileId";
    public static final String BOS_ATTACHMENT = "bos_attachment";
    public static final String UTF8 = "utf-8";
    public static final String FILENAME = "fileName";
    public static final String FILEPATH = "filePath";
    public static final String URL = "url";

    public static Long uploadDoc(String appId, Long pkId, Long conDocFileId, String fileName, Long fileSize, String url, boolean isContractBill, String attachmentpanel, int a) throws IOException {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_ATTACHMENT);
        if (a == 1 && null != conDocFileId) {
            DeleteServiceHelper.delete((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new Object[]{conDocFileId});
        }
        long id = ORM.create().genLongId(BOS_ATTACHMENT);
        dynamicObject.set(ID, (Object)id);
        dynamicObject.set(FNUMBER, (Object)UUID.randomUUID().toString());
        if (isContractBill) {
            dynamicObject.set(FBILLTYPE, (Object)(appId + "_biddocument_edit"));
            dynamicObject.set(FATTACHMENTPANEL, (Object)attachmentpanel);
        } else {
            dynamicObject.set(FBILLTYPE, (Object)(appId + "_tendertemplate"));
            dynamicObject.set(FATTACHMENTPANEL, (Object)attachmentpanel);
        }
        dynamicObject.set(FINTERID, (Object)pkId);
        Date now = new Date();
        dynamicObject.set(FMODIFYTIME, (Object)now);
        dynamicObject.set(FCREATETIME, (Object)now);
        dynamicObject.set(FALIASFILENAME, (Object)fileName);
        dynamicObject.set(FATTACHMENTNAME, (Object)fileName);
        dynamicObject.set(FEXTNAME, (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
        if (fileSize != null && fileSize != 0L) {
            dynamicObject.set(FATTACHMENTSIZE, (Object)fileSize);
        } else {
            dynamicObject.set(FATTACHMENTSIZE, (Object)WebOfficeUtil.getFileSize(url));
        }
        dynamicObject.set(FCREATEMEN, (Object)RequestContext.get().getUserId());
        dynamicObject.set(FDESCRIPTION, (Object)ResManager.loadKDString((String)"\u6a21\u7248\u9644\u4ef6", (String)"WebOfficeUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        dynamicObject.set(FFILEID, (Object)url);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return id;
    }

    public static Long uploadDoc2(String appId, Long pkId, Long conDocFileId, String fileName, Long fileSize, String url, String billType, String attachmentpanel, int a) throws IOException {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_ATTACHMENT);
        if (a == 1 && null != conDocFileId) {
            DeleteServiceHelper.delete((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new Object[]{conDocFileId});
        }
        long id = ORM.create().genLongId(BOS_ATTACHMENT);
        dynamicObject.set(ID, (Object)id);
        dynamicObject.set(FNUMBER, (Object)UUID.randomUUID().toString());
        dynamicObject.set(FBILLTYPE, (Object)billType);
        dynamicObject.set(FATTACHMENTPANEL, (Object)attachmentpanel);
        dynamicObject.set(FINTERID, (Object)pkId);
        Date now = new Date();
        dynamicObject.set(FMODIFYTIME, (Object)now);
        dynamicObject.set(FCREATETIME, (Object)now);
        dynamicObject.set(FALIASFILENAME, (Object)fileName);
        dynamicObject.set(FATTACHMENTNAME, (Object)fileName);
        dynamicObject.set(FEXTNAME, (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
        if (fileSize != null && fileSize != 0L) {
            dynamicObject.set(FATTACHMENTSIZE, (Object)fileSize);
        } else {
            dynamicObject.set(FATTACHMENTSIZE, (Object)WebOfficeUtil.getFileSize(url));
        }
        dynamicObject.set(FCREATEMEN, (Object)RequestContext.get().getUserId());
        dynamicObject.set(FDESCRIPTION, (Object)ResManager.loadKDString((String)"\u6a21\u7248\u9644\u4ef6", (String)"WebOfficeUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        dynamicObject.set(FFILEID, (Object)url);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getFileSize(String fileUrl) throws IOException {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        InputStream in = fileService.getInputStream(fileUrl);
        if (null != in) {
            Integer available = null;
            try {
                available = in.available();
                Long l = available.longValue();
                return l;
            }
            catch (IOException e) {
                log.info(e.getMessage());
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    public static Map<String, String> handleFileUrl(Object[] urls, String docurl, String docname, String name) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Object urlData = urls[0];
        String filePath = "";
        String fileName = "";
        String url = "";
        if (urlData instanceof String) {
            filePath = urlData.toString();
            fileName = filePath.substring(filePath.lastIndexOf(47));
            String[] files = fileName.split("\\.");
            String tFileName = files.length == 2 ? files[0] : UUID.randomUUID().toString();
            try {
                tFileName = URLEncoder.encode(tFileName, UTF8);
            }
            catch (UnsupportedEncodingException e) {
                log.info(e.getMessage());
            }
            String tExtend = files.length == 2 ? files[1] : "doc";
            fileName = tFileName + '.' + tExtend;
            url = filePath;
        } else if (urlData instanceof Map) {
            filePath = ((Map)urlData).get(URL).toString();
            fileName = StringUtils.isBlank((CharSequence)docname) ? name : docname;
            url = filePath;
        }
        dataMap.put(FILENAME, fileName);
        dataMap.put(FILEPATH, filePath);
        dataMap.put(URL, url);
        return dataMap;
    }

    public static String getAttachmentFileName(String appId, String formId, Object pkId, String filename) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)formId, (Object)pkId, (String)filename);
    }

    public static Map<String, String> uploadTempFile(String url, String docurl, String filePath, String fileName, int a, Map fileNameData) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String appId = (String)fileNameData.get("appId");
        String formId = (String)fileNameData.get("formId");
        Object pkId = fileNameData.get("pkId");
        String turl = "";
        Integer available = 0;
        if (url.contains("tempfile")) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            FileService service = FileServiceFactory.getAttachmentFileService();
            FileItem fileItem = null;
            if (StringUtils.isNotBlank((CharSequence)docurl) && a == 0) {
                fileItem = new FileItem(fileName, docurl, in);
                fileItem.setCreateNewFileWhenExists(false);
            } else {
                String suffix = StringUtils.isNotBlank((CharSequence)filePath) && filePath.endsWith(".docx") ? ".docx" : ".doc";
                String utf8FileName = fileName = fileName + suffix;
                try {
                    utf8FileName = URLEncoder.encode(utf8FileName, UTF8);
                }
                catch (UnsupportedEncodingException e) {
                    log.info(e.getMessage());
                }
                fileItem = new FileItem(utf8FileName, WebOfficeUtil.getAttachmentFileName(appId, formId, pkId, fileName), in);
                fileItem.setCreateNewFileWhenExists(true);
            }
            try {
                available = in.available();
                in.close();
            }
            catch (IOException e) {
                log.info(e.getMessage());
            }
            turl = service.upload(fileItem);
            cache.remove(url);
            url = turl;
        }
        dataMap.put(FILENAME, fileName);
        dataMap.put(FILEPATH, filePath);
        dataMap.put(FATTACHMENTSIZE, available.toString());
        dataMap.put(URL, url);
        return dataMap;
    }

    public static void openWebOfficeFile(WebOffice webOffice, String url, String fileName) {
        String tUrl = UrlService.getAttachmentFullUrl((String)url);
        String urlName = tUrl.substring(tUrl.lastIndexOf(47));
        String[] files = urlName.split("\\.");
        String tFileName = files.length == 2 ? files[0] : UUID.randomUUID().toString();
        try {
            tFileName = URLEncoder.encode(tFileName, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            log.info(e.getMessage());
        }
        String tExtend = files.length == 2 ? files[1] : "doc";
        fileName = tFileName + '.' + tExtend;
        tUrl = tUrl.substring(0, tUrl.lastIndexOf(47));
        tUrl = tUrl + fileName;
        webOffice.openAll(tUrl, fileName);
    }
}

