/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BidDecisionToScmcPurContPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString())) {
            List value = (List)extendedDataEntity.getValue("ConvertSource");
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (value.size() == 0) {
                BizLog.log((String)"=====================logInfo: not found decision bill===================================");
                return;
            }
            DynamicObject val = (DynamicObject)value.get(0);
            DynamicObject decision = BusinessDataServiceHelper.loadSingle((String)"bid_decision", (String)"bidproject,bidsection,supfinaldetail,lpurentryproject", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)val.getLong("id"))});
            this.setContractType(dataEntity, decision);
            this.setBillEntryProject(dataEntity, decision);
            this.setContractDefaultValue(dataEntity);
        }
    }

    protected void setContractDefaultValue(DynamicObject dataEntity) {
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(16);
        DynamicObject bd_currency = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"bd_currency");
        dataEntity.set("settlecurrency", (Object)bd_currency);
        bills.add(dataEntity);
        List contBills = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"IContractBotpService", (String)"batPurContractDefValue", (Object[])new Object[]{bills});
        if (contBills == null || contBills.size() == 0) {
            return;
        }
        DynamicObject contBill = (DynamicObject)contBills.get(0);
        dataEntity.set("category", contBill.get("category"));
        dataEntity.set("operatorgroup", contBill.get("operatorgroup"));
        dataEntity.set("operator", contBill.get("operator"));
        dataEntity.set("dept", contBill.get("dept"));
        dataEntity.set("exratetable", contBill.get("exratetable"));
        dataEntity.set("exchangerate", contBill.get("exchangerate"));
        dataEntity.set("settletype", contBill.get("settletype"));
        dataEntity.set("exchangetype", contBill.get("exchangetype"));
        dataEntity.set("providersupplier", contBill.get("providersupplier"));
        dataEntity.set("providerlinkman", contBill.get("providerlinkman"));
        dataEntity.set("provideraddress", contBill.get("provideraddress"));
        dataEntity.set("invoicesupplier", contBill.get("invoicesupplier"));
        dataEntity.set("receivesupplier", contBill.get("receivesupplier"));
        dataEntity.set("party2nd", contBill.get("party2nd"));
        dataEntity.set("contactperson2nd", contBill.get("contactperson2nd"));
        dataEntity.set("phone2nd", contBill.get("phone2nd"));
        dataEntity.set("contparties", contBill.get("contparties"));
        dataEntity.set("party1st", contBill.get("party1st"));
        dataEntity.set("contactperson1st", contBill.get("contactperson1st"));
        dataEntity.set("phone1st", contBill.get("phone1st"));
        dataEntity.set("totaltaxamount", contBill.get("totaltaxamount"));
        dataEntity.set("totalamount", contBill.get("totalamount"));
        dataEntity.set("totalallamount", contBill.get("totalallamount"));
        dataEntity.set("conmprop", contBill.get("conmprop"));
        dataEntity.set("currency", contBill.get("currency"));
        dataEntity.set("reviewstatus", contBill.get("reviewstatus"));
        dataEntity.set("signstatus", contBill.get("signstatus"));
        dataEntity.set("filingstatus", contBill.get("filingstatus"));
        this.setEntryData(dataEntity, contBill);
    }

    protected void setEntryData(DynamicObject dataEntity, DynamicObject contBill) {
        DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection("billentry");
        DynamicObjectCollection fakeBillentry = contBill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < fakeBillentry.size(); ++i) {
            DynamicObject fakeEntryRow = (DynamicObject)fakeBillentry.get(i);
            DynamicObject entryRow = (DynamicObject)billentry.get(i);
            entryRow.set("price", fakeEntryRow.get("price"));
            entryRow.set("amount", fakeEntryRow.get("amount"));
            entryRow.set("taxamount", fakeEntryRow.get("taxamount"));
            entryRow.set("amountandtax", fakeEntryRow.get("amountandtax"));
            entryRow.set("curamount", fakeEntryRow.get("curamount"));
            entryRow.set("curtaxamount", fakeEntryRow.get("curtaxamount"));
            entryRow.set("curamountandtax", fakeEntryRow.get("curamountandtax"));
            entryRow.set("baseqty", fakeEntryRow.get("baseqty"));
            entryRow.set("baseunit", fakeEntryRow.get("baseunit"));
            entryRow.set("auxunit", fakeEntryRow.get("auxunit"));
            entryRow.set("auxqty", fakeEntryRow.get("auxqty"));
            entryRow.set("entrysettleorg", fakeEntryRow.get("entrysettleorg"));
        }
    }

    protected void setBillEntryProject(DynamicObject dataEntity, DynamicObject decision) {
        HashMap bdProjectMap = new HashMap(16);
        DynamicObjectCollection bidsection = decision.getDynamicObjectCollection("bidsection");
        bidsection.forEach(section -> {
            DynamicObjectCollection supfinaldetail = section.getDynamicObjectCollection("supfinaldetail");
            supfinaldetail.forEach(detail -> {
                DynamicObject lpurentryproject = detail.getDynamicObject("lpurentryproject");
                if (lpurentryproject == null) {
                    return;
                }
                DynamicObject bdproject = lpurentryproject.getDynamicObject("bdproject");
                bdProjectMap.put((Long)detail.getPkValue(), bdproject);
            });
        });
        DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection("billentry");
        billentry.forEach(entry -> {
            long srcbillentryid = entry.getLong("srcbillentryid");
            entry.set("project", bdProjectMap.get(srcbillentryid));
        });
    }

    protected void setContractType(DynamicObject dataEntity, DynamicObject decision) {
        DynamicObject queryDecision = QueryServiceHelper.queryOne((String)"bid_decision", (String)"bidproject", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)decision.getLong("id"))});
        long bidproject = queryDecision.getLong("bidproject");
        if (bidproject != 0L) {
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((String)"bid_project", (String)"scmcbiztype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidproject)});
            DynamicObject scmcBiztype = bidProject.getDynamicObject("scmcbiztype");
            if (scmcBiztype == null) {
                BizLog.log((String)"NO BIZTYPE IN BID_PROJECT!!!!!!!!!!!!!!!!!!!!!!!!");
                return;
            }
            long scmcBiztypeId = (Long)scmcBiztype.getPkValue();
            String number = scmcBiztype.getString("number");
            long conmTypeId = 0L;
            switch (number) {
                case "110": {
                    conmTypeId = 712021156571496448L;
                    break;
                }
                case "111": {
                    conmTypeId = 955088578298276864L;
                    break;
                }
                case "113": {
                    conmTypeId = 955089097318230016L;
                    break;
                }
                case "130": {
                    conmTypeId = 955089518501850112L;
                    break;
                }
                default: {
                    DynamicObjectCollection types = QueryServiceHelper.query((String)"conm_type", (String)"id,", (QFilter[])new QFilter[]{new QFilter("biztype", "=", (Object)scmcBiztypeId)});
                    if (types == null || types.size() <= 0) break;
                    conmTypeId = ((DynamicObject)types.get(0)).getLong("id");
                }
            }
            if (conmTypeId != 0L) {
                DynamicObject conm_type = BusinessDataServiceHelper.loadSingle((Object)conmTypeId, (String)"conm_type");
                dataEntity.set("type", (Object)conm_type);
            }
        }
    }
}

