/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.commonop;

import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidReportHandle
extends AbstractReportFormPlugin {
    public static String PAGE_FLAG = "billtype";
    public static String JUMP_LIST = "oplog";
    public static final Set<String> EX_OP_SET = new HashSet<String>();

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String optKey = event.getOperateKey();
        if (EX_OP_SET.contains(optKey)) {
            this.saveOpLog(optKey);
        }
        if (StringUtils.equals((CharSequence)JUMP_LIST, (CharSequence)optKey)) {
            this.showOpLog();
        }
    }

    public void saveOpLog(String opkey) {
        long currUserId = RequestContext.get().getCurrUserId();
        String billType = this.getPageCache().get(PAGE_FLAG);
        if (StringUtils.isBlank((CharSequence)billType)) {
            billType = this.getView().getEntityId();
        }
        long id = ID.genLongId();
        StringBuilder formId = new StringBuilder();
        formId.append(this.getAppId()).append("_report_oplog");
        MainEntityType logMainType = EntityMetadataCache.getDataEntityType((String)formId.toString());
        DynamicObject opLog = new DynamicObject((DynamicObjectType)logMainType);
        opLog.set("id", (Object)id);
        opLog.set("billNo", (Object)(id + ""));
        opLog.set("creator", (Object)currUserId);
        opLog.set("opname", (Object)opkey);
        opLog.set("billtype", (Object)billType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{opLog});
    }

    public void showOpLog() {
        String billType = this.getPageCache().get(PAGE_FLAG);
        if (StringUtils.isBlank((CharSequence)billType)) {
            billType = this.getView().getEntityId();
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCustomParam("billType", (Object)billType);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId(this.getAppId() + "_report_oplog");
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public String getAppId() {
        return "bid";
    }

    static {
        EX_OP_SET.add("exportexcel");
        EX_OP_SET.add("print");
    }
}

