/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.commonop;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.bidcenter.IBidCenterService;
import kd.scm.bid.business.bidcenter.impl.BidCenterServiceImpl;
import kd.scm.bid.common.constant.entity.bidcenter.BidCenterConstant;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;

public class JumpCenterDeal
extends AbstractBillPlugIn {
    private IBidCenterService bidCenterService = new BidCenterServiceImpl();
    public static final String PROJECT_FLAG = "bidproject";

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(PROJECT_FLAG);
        basedataEdit.addBeforeF7ViewDetailListener(this::showCentBill);
    }

    protected void showCentBill(BeforeF7ViewDetailEvent evt) {
        evt.setCancel(true);
        Object bidProjectId = this.getView().getModel().getDataEntity(true).getDynamicObject(PROJECT_FLAG).getPkValue();
        RequestContext context = RequestContext.get();
        Long userId = context.getCurrUserId();
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((String)this.getFormId(), (String)"id,org,entrustmentorgunit,memberentity,memberentity.respbusiness,memberentity.user,memberentity.isdirector,billstatus,bidproject,supplierinvitation,biddocument,bidpublish,bidopen,bidanswerquestion,bidevaluation,bidbustalk,biddecision,bidopentype", (QFilter[])new QFilter[]{new QFilter("id", "=", bidProjectId)});
        DynamicObject orgData = bidProject.getDynamicObject("org");
        long org = (Long)orgData.getPkValue();
        boolean hasBidCenterPermission = this.checkPermission("QXX0001", org, this.getAppId(), "bid_bidcenter");
        if (!hasBidCenterPermission) {
            String tip = this.stepTipInfo("bid_bidcenter");
            this.getView().showErrorNotification(tip);
            return;
        }
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            String formId;
            DynamicObject entity;
            DynamicObject permissionMember = this.bidCenterService.getPermissionMember((Object)userId, bidProjectId, "01");
            if (permissionMember == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u62db\u6807\u7acb\u9879\u7684\u4e1a\u52a1\u7ecf\u529e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"JumpCenterDeal_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            String permisionCode = (String)BidCenterConstant.OPKEY_PERMISIONCODE_MAP.get(PROJECT_FLAG);
            boolean hasPermission = this.checkOpPermission(permisionCode, entity = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)(formId = this.getFormId()), (String)"id,org,entrustmentorgunit"), formId);
            if (!hasPermission) {
                String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get(PROJECT_FLAG);
                this.getView().showErrorNotification(tip);
                return;
            }
        }
        this.showNewBid();
    }

    public void showNewBid() {
        BillShowParameter showParameter = new BillShowParameter();
        String formId = this.getAppId() + "_" + "bidcenter";
        Object primaryKeyValue = this.getView().getModel().getDataEntity(true).getDynamicObject(PROJECT_FLAG).getPkValue();
        showParameter.setFormId(formId);
        showParameter.setPkId(primaryKeyValue);
        showParameter.setCustomParam("opKeyFromList", (Object)PROJECT_FLAG);
        showParameter.setCustomParam("bidProjectId", primaryKeyValue);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean checkOpPermission(String permisionCode, DynamicObject entity, String formId) {
        String appId = this.getAppId();
        long orgId = (Long)entity.getDynamicObject("org").getPkValue();
        boolean orgHasPermission = PermissionUtils.checkPermission(permisionCode, orgId, appId, formId);
        DynamicObject entrustmentorgunit = entity.getDynamicObject("entrustmentorgunit");
        if (entrustmentorgunit == null) {
            return orgHasPermission;
        }
        Long entrustmentorgunitId = (Long)entrustmentorgunit.getPkValue();
        boolean entrustmentorgHasPermission = PermissionUtils.checkPermission(permisionCode, entrustmentorgunitId, appId, formId);
        return orgHasPermission || entrustmentorgHasPermission;
    }

    public String getBidAdminRoleID() {
        String appId = this.getAppId();
        if (appId.equals("bid")) {
            return "/FFXFSRKI73+";
        }
        return "/V6OAY0JH+8R";
    }

    public String getFormId() {
        return this.getAppId() + "_" + "project";
    }

    public String getAppId() {
        String entityId = this.getView().getEntityId();
        if (entityId.startsWith("rebm")) {
            return "rebm";
        }
        return "bid";
    }

    public boolean checkPermission(String number, Long orgId, String appId, String entityNum) {
        QFilter[] filter = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObject permissionObj = BusinessDataServiceHelper.loadSingle((String)"perm_permitem", (String)"id,number", (QFilter[])filter);
        int hasPermission = 0;
        if (permissionObj != null) {
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            String permItemId = permissionObj.get("id").toString();
            if (appId.equals("rebm")) {
                entityNum = this.replaceBeforeTip(entityNum);
            }
            hasPermission = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)appId, (String)entityNum, (String)permItemId);
        }
        return hasPermission == 1;
    }

    public String replaceBeforeTip(String step) {
        String name = null;
        if ("bid_project".equals(step)) {
            name = "rebm_project";
        } else if ("bid_supplierinvitation".equals(step)) {
            name = "rebm_supplierinvitation";
        } else if ("bid_biddocument_edit".equals(step)) {
            name = "rebm_biddocument_edit";
        } else if ("bid_bidpublish".equals(step)) {
            name = "rebm_bidpublish";
        } else if ("bid_answerquestion_reco".equals(step)) {
            name = "rebm_answerquestion_reco";
        } else if ("bid_bidopen".equals(step)) {
            name = "rebm_bidopen";
        } else if ("bid_bidevaluation".equals(step)) {
            name = "rebm_bidevaluation";
        } else if ("bid_bustalk".equals(step)) {
            name = "rebm_bustalk";
        } else if ("bid_decision".equals(step)) {
            name = "rebm_decision";
        } else if ("bid_bidcenter".equals(step)) {
            name = "rebm_bidcenter";
        }
        return name;
    }

    private String stepTipInfo(String step) {
        return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"JumpCenterDeal_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
    }

    private String stepName(String step) {
        String name = null;
        if ("bid_project".equals(step)) {
            name = ResManager.loadKDString((String)"\u62db\u6807\u7acb\u9879", (String)"JumpCenterDeal_3", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_supplierinvitation".equals(step)) {
            name = ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4", (String)"JumpCenterDeal_4", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_biddocument_edit".equals(step)) {
            name = ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236", (String)"JumpCenterDeal_5", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidpublish".equals(step)) {
            name = ResManager.loadKDString((String)"\u53d1\u6807", (String)"JumpCenterDeal_6", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_answerquestion_reco".equals(step)) {
            name = ResManager.loadKDString((String)"\u7b54\u7591", (String)"JumpCenterDeal_7", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidopen".equals(step)) {
            name = ResManager.loadKDString((String)"\u5f00\u6807", (String)"JumpCenterDeal_8", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidevaluation".equals(step)) {
            name = ResManager.loadKDString((String)"\u8bc4\u6807", (String)"JumpCenterDeal_9", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bustalk".equals(step)) {
            name = ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224", (String)"JumpCenterDeal_10", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_decision".equals(step)) {
            name = ResManager.loadKDString((String)"\u5b9a\u6807", (String)"JumpCenterDeal_11", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidcenter".equals(step)) {
            name = ResManager.loadKDString((String)"\u62db\u6807\u4e2d\u5fc3", (String)"JumpCenterDeal_12", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        return name;
    }
}

