/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.mobilebill;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.bid.common.util.MobileDynamicEntryUtils;

public class BidCalibrationAuditPlugin
extends AbstractMobBillPlugIn {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final Map<String, String> fieldsMap = new LinkedHashMap<String, String>();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, String> fieldsMap = this.loadColumns();
        this.loadEntry(fieldsMap);
    }

    private Map<String, String> loadColumns() {
        return new LinkedHashMap<String, String>(fieldsMap);
    }

    private void loadEntry(Map<String, String> fieldsMap) {
        boolean isratebidding;
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        DynamicObjectCollection bidsections = dynamicObject.getDynamicObjectCollection("bidsection");
        if (bidsections != null && bidsections.size() == 1) {
            fieldsMap.remove("sectionname");
        }
        if (isratebidding = dynamicObject.getBoolean("bidproject.isratebidding")) {
            fieldsMap.remove("finalprice");
            fieldsMap.remove("finaltaxrate");
            fieldsMap.remove("finalvat");
            fieldsMap.remove("finalexceptvat");
            fieldsMap.remove("tenderprice");
            fieldsMap.remove("tendertaxrate");
            fieldsMap.remove("tendervat");
            fieldsMap.remove("tenderexceptvat");
        } else {
            fieldsMap.remove("finalrate");
            fieldsMap.remove("rate");
        }
        List<Map<String, Object>> dataList = this.buildData(bidsections, isratebidding);
        if (!CollectionUtils.isEmpty(dataList)) {
            MobileDynamicEntryUtils.rebuildGridCols((IFormView)this.getView(), (String)KEY_ENTRYENTITY, dataList, fieldsMap);
        }
    }

    private List<Map<String, Object>> buildData(DynamicObjectCollection bidsections, boolean isratebidding) {
        DecimalFormat df = new DecimalFormat("#0.00");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (!CollectionUtils.isEmpty((Collection)bidsections)) {
            for (DynamicObject bidsectionObj : bidsections) {
                DynamicObjectCollection projectentrys = bidsectionObj.getDynamicObjectCollection("supplierentry");
                if (CollectionUtils.isEmpty((Collection)projectentrys)) continue;
                for (DynamicObject dy : projectentrys) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
                    map.put("id", dy.getPkValue());
                    map.put("sectionname", bidsectionObj.getString("sectionname"));
                    DynamicObject supplier = dy.getDynamicObject("supplier");
                    map.put("supplier", supplier == null ? "" : supplier.getString("name"));
                    map.put("score", df.format(dy.getBigDecimal("score")));
                    map.put("range", dy.getInt("range"));
                    map.put("isrecommended", dy.getBoolean("isrecommended") ? ResManager.loadKDString((String)"\u662f", (String)"BidCalibrationAuditPlugin_19", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"BidCalibrationAuditPlugin_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    if (isratebidding) {
                        map.put("finalrate", dy.getBigDecimal("finalrate").multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString());
                        map.put("rate", dy.getBigDecimal("rate").multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString());
                    } else {
                        map.put("finalprice", "\u00a5" + df.format(dy.getBigDecimal("finalprice")));
                        map.put("finaltaxrate", dy.getBigDecimal("finaltaxrate").multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString());
                        map.put("finalvat", "\u00a5" + df.format(dy.getBigDecimal("finalvat")));
                        map.put("finalexceptvat", "\u00a5" + df.format(dy.getBigDecimal("finalexceptvat")));
                        map.put("tenderprice", "\u00a5" + df.format(dy.getBigDecimal("tenderprice")));
                        map.put("tendertaxrate", dy.getBigDecimal("tendertaxrate").multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString());
                        map.put("tendervat", "\u00a5" + df.format(dy.getBigDecimal("tendervat")));
                        map.put("tenderexceptvat", "\u00a5" + df.format(dy.getBigDecimal("tenderexceptvat")));
                    }
                    map.put("techfile", dy.get("techfile"));
                    map.put("commfile", dy.get("commfile"));
                    map.put("comment", dy.getString("comment"));
                    list.add(map);
                }
            }
        }
        return list;
    }

    static {
        fieldsMap.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7:40px", (String)"BidCalibrationAuditPlugin_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("sectionname", ResManager.loadKDString((String)"\u6807\u6bb5\u540d\u79f0:120px", (String)"BidCalibrationAuditPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("supplier", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540d\u79f0:240px", (String)"BidCalibrationAuditPlugin_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("score", ResManager.loadKDString((String)"\u5f97\u5206:120px", (String)"BidCalibrationAuditPlugin_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("range", ResManager.loadKDString((String)"\u6392\u884c:120px", (String)"BidCalibrationAuditPlugin_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("isrecommended", ResManager.loadKDString((String)"\u4e2d\u6807\u5355\u4f4d:120px", (String)"BidCalibrationAuditPlugin_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("finalprice", ResManager.loadKDString((String)"\u6700\u7ec8\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09:120px", (String)"BidCalibrationAuditPlugin_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("finaltaxrate", ResManager.loadKDString((String)"\u6700\u7ec8\u7a0e\u7387\uff08%\uff09:120px", (String)"BidCalibrationAuditPlugin_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("finalvat", ResManager.loadKDString((String)"\u6700\u7ec8\u4ef7\u7a0e\u989d:120px", (String)"BidCalibrationAuditPlugin_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("finalexceptvat", ResManager.loadKDString((String)"\u6700\u7ec8\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09:120px", (String)"BidCalibrationAuditPlugin_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("tenderprice", ResManager.loadKDString((String)"\u6295\u6807\u62a5\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09:150px", (String)"BidCalibrationAuditPlugin_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("tendertaxrate", ResManager.loadKDString((String)"\u6295\u6807\u7a0e\u7387\uff08%\uff09:120px", (String)"BidCalibrationAuditPlugin_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("tendervat", ResManager.loadKDString((String)"\u6295\u6807\u62a5\u4ef7\u7a0e\u989d:120px", (String)"BidCalibrationAuditPlugin_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("tenderexceptvat", ResManager.loadKDString((String)"\u6295\u6807\u62a5\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09:150px", (String)"BidCalibrationAuditPlugin_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("finalrate", ResManager.loadKDString((String)"\u6700\u7ec8\u8d39\u7387(%):120px", (String)"BidCalibrationAuditPlugin_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("rate", ResManager.loadKDString((String)"\u6295\u6807\u8d39\u7387(%):120px", (String)"BidCalibrationAuditPlugin_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("techfile", ResManager.loadKDString((String)"\u6280\u672f\u6587\u4ef6:120px", (String)"BidCalibrationAuditPlugin_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("commfile", ResManager.loadKDString((String)"\u5546\u52a1\u6587\u4ef6:120px", (String)"BidCalibrationAuditPlugin_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        fieldsMap.put("comment", ResManager.loadKDString((String)"\u62a5\u4ef7\u8bf4\u660e:200px", (String)"BidCalibrationAuditPlugin_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
    }
}

