/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.mobilebill;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.scm.bid.common.util.MobileDynamicEntryUtils;

public class BidProjectAuditPlugin
extends AbstractMobBillPlugIn {
    private static final String KEY_BIDENTRY = "bidentry";
    private static final String KEY_SUPPLIER = "supplierentry";
    private static final String KEY_EXPERTENTRY = "expertentry";
    private static final String KEY_TEAMENTRY = "teamentry";
    private static final String RECOSUPPLIERTABPAGE = "tabpageap3";
    private static final Map<String, String> bidFieldsMap = new LinkedHashMap<String, String>();
    private static final Map<String, String> materialFieldsMap = new LinkedHashMap<String, String>();
    private static final Map<String, String> supplierFieldsMap = new LinkedHashMap<String, String>();
    private static final Map<String, String> expertFieldsMap = new LinkedHashMap<String, String>();
    private static final Map<String, String> teamFieldsMap = new LinkedHashMap<String, String>();
    protected static final Map<String, String> stageNameMap = new HashMap<String, String>();

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        this.visibleComponent(data);
    }

    private void visibleComponent(DynamicObject data) {
        if (this.isPublicBidding(data)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RECOSUPPLIERTABPAGE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{RECOSUPPLIERTABPAGE});
        }
        if (data.getBoolean("isonlineeval")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bidevaltemplate"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"scoremode"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"scoretype"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidevaltemplate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"scoremode"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"scoretype"});
        }
        String doctype = data.getString("doctype");
        if ("BUSSINESS".equals(doctype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidopentype"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bidopentype"});
        }
        if (data.getBoolean("enablemultisection")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isdeposit"});
            if (data.getBoolean("isdeposit")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"deposit"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"deposit"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isdeposit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"deposit"});
        }
    }

    private boolean isPublicBidding(DynamicObject bidProject) {
        DynamicObject bidMode = bidProject.getDynamicObject("bidmode");
        return bidMode != null && bidMode.getString("name").contains(ResManager.loadKDString((String)"\u516c\u5f00\u62db\u6807", (String)"BidProjectAuditPlugin_53", (String)"scm-bid-formplugin", (Object[])new Object[0]));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, Map<String, String>> fieldsMap = this.loadColumns();
        this.loadEntry(fieldsMap);
    }

    private Map<String, Map<String, String>> loadColumns() {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(16);
        map.put("bidFieldsMap", new LinkedHashMap<String, String>(bidFieldsMap));
        map.put("materialFieldsMap", new LinkedHashMap<String, String>(materialFieldsMap));
        map.put("supplierFieldsMap", new LinkedHashMap<String, String>(supplierFieldsMap));
        map.put("expertFieldsMap", new LinkedHashMap<String, String>(expertFieldsMap));
        map.put("teamFieldsMap", new LinkedHashMap<String, String>(teamFieldsMap));
        return map;
    }

    private void loadEntry(Map<String, Map<String, String>> fieldsMap) {
        DynamicObjectCollection members;
        List<Map<String, Object>> teamList;
        DynamicObjectCollection proficients;
        List<Map<String, Object>> expertList;
        DynamicObjectCollection bidrollsections;
        List<Map<String, Object>> supplierList;
        DynamicObject object = this.getModel().getDataEntity();
        Map<String, String> bidFieldsMap = fieldsMap.get("bidFieldsMap");
        Map<String, String> materialFieldsMap = fieldsMap.get("materialFieldsMap");
        Map<String, String> supplierFieldsMap = fieldsMap.get("supplierFieldsMap");
        Map<String, String> expertFieldsMap = fieldsMap.get("expertFieldsMap");
        Map<String, String> teamFieldsMap = fieldsMap.get("teamFieldsMap");
        DynamicObjectCollection bidsections = object.getDynamicObjectCollection("bidsection");
        List<Map<String, Object>> bidList = null;
        boolean isMoreBid = object.getBoolean("enablemultisection");
        boolean isDeposit = object.getBoolean("isdeposit");
        boolean ismaterialpur = object.getBoolean("ismaterialpur");
        if (ismaterialpur) {
            if (!isMoreBid) {
                materialFieldsMap.remove("sectionname");
                materialFieldsMap.remove("secdeposit");
                supplierFieldsMap.remove("sectionname");
            }
            if (!isDeposit) {
                materialFieldsMap.remove("secdeposit");
            }
            if (!CollectionUtils.isEmpty(bidList = this.builMaterialBidData(bidsections, isMoreBid, isDeposit))) {
                MobileDynamicEntryUtils.rebuildGridCols((IFormView)this.getView(), (String)KEY_BIDENTRY, bidList, materialFieldsMap);
            }
        } else {
            if (!isMoreBid) {
                bidFieldsMap.remove("sectionname");
                bidFieldsMap.remove("workload");
                bidFieldsMap.remove("secdeposit");
                bidFieldsMap.remove("purentrycomment");
                bidFieldsMap.put("purentryworkload", ResManager.loadKDString((String)"\u603b\u5de5\u671f\uff08\u5929\uff09:120px", (String)"BidProjectAuditPlugin_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                bidFieldsMap.put("purentrycomment", ResManager.loadKDString((String)"\u8bf4\u660e:200px", (String)"BidProjectAuditPlugin_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                supplierFieldsMap.remove("sectionname");
            }
            if (!isDeposit) {
                bidFieldsMap.remove("secdeposit");
            }
            if (!CollectionUtils.isEmpty(bidList = this.buildBidData(bidsections, isMoreBid, isDeposit))) {
                MobileDynamicEntryUtils.rebuildGridCols((IFormView)this.getView(), (String)KEY_BIDENTRY, bidList, bidFieldsMap);
            }
        }
        if (!CollectionUtils.isEmpty(supplierList = this.buildSupplierData(bidrollsections = object.getDynamicObjectCollection("bidrollsection"), object.getBoolean("enablemultisection")))) {
            MobileDynamicEntryUtils.rebuildGridCols((IFormView)this.getView(), (String)KEY_SUPPLIER, supplierList, supplierFieldsMap);
        }
        if (!CollectionUtils.isEmpty(expertList = this.buildExpertData(proficients = object.getDynamicObjectCollection("bid_proficiententry")))) {
            MobileDynamicEntryUtils.rebuildGridCols((IFormView)this.getView(), (String)KEY_EXPERTENTRY, expertList, expertFieldsMap);
        }
        if (!CollectionUtils.isEmpty(teamList = this.buildTeamData(object, members = object.getDynamicObjectCollection("memberentity")))) {
            MobileDynamicEntryUtils.rebuildGridCols((IFormView)this.getView(), (String)KEY_TEAMENTRY, teamList, teamFieldsMap);
        }
    }

    private List<Map<String, Object>> builMaterialBidData(DynamicObjectCollection bidsections, boolean isMoreBid, boolean isDeposit) {
        if (CollectionUtils.isEmpty((Collection)bidsections)) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject bidsectionObj : bidsections) {
            DynamicObjectCollection projectentrys = bidsectionObj.getDynamicObjectCollection("projectentry");
            if (CollectionUtils.isEmpty((Collection)projectentrys)) continue;
            for (DynamicObject dy : projectentrys) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
                map.put("id", dy.getPkValue());
                if (isMoreBid) {
                    map.put("sectionname", bidsectionObj.getString("sectionname"));
                    if (isDeposit) {
                        map.put("secdeposit", "\u00a5" + df.format(bidsectionObj.getBigDecimal("secdeposit")));
                    }
                }
                map.put("purentrycontent", dy.getString("purentrycontent"));
                DynamicObject material = dy.getDynamicObject("materialid");
                if (null != material) {
                    map.put("materialno", material.getString("number"));
                    map.put("materialname", material.getString("name"));
                    map.put("model", material.getString("modelnum"));
                    map.put("unit", material.getString("baseunit.name"));
                } else {
                    map.put("materialno", "");
                    map.put("materialname", "");
                    map.put("model", "");
                    map.put("unit", "");
                }
                map.put("materialdes", dy.getString("materialdes"));
                map.put("qty", df.format(dy.getBigDecimal("qty")));
                map.put("controlamount", "\u00a5" + df.format(dy.getBigDecimal("controlamount")));
                map.put("controlvat", "\u00a5" + df.format(dy.getBigDecimal("controlvat")));
                map.put("ctrlamtexceptvat", "\u00a5" + df.format(dy.getBigDecimal("ctrlamtexceptvat")));
                map.put("purentrycomment", dy.getString("purentrycomment"));
                list.add(map);
            }
        }
        return list;
    }

    private List<Map<String, Object>> buildBidData(DynamicObjectCollection bidsections, boolean isMoreBid, boolean isDeposit) {
        if (CollectionUtils.isEmpty((Collection)bidsections)) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject bidsectionObj : bidsections) {
            DynamicObjectCollection projectentrys = bidsectionObj.getDynamicObjectCollection("projectentry");
            if (CollectionUtils.isEmpty((Collection)projectentrys)) continue;
            for (DynamicObject dy : projectentrys) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("id", dy.getPkValue());
                if (isMoreBid) {
                    map.put("sectionname", bidsectionObj.getString("sectionname"));
                    map.put("workload", bidsectionObj.getString("workload"));
                    if (isDeposit) {
                        map.put("secdeposit", "\u00a5" + df.format(bidsectionObj.getBigDecimal("secdeposit")));
                    }
                }
                map.put("purentrycontent", dy.getString("purentrycontent"));
                DynamicObject purprojectObj = dy.getDynamicObject("purentryproject");
                map.put("purentryproject", purprojectObj == null ? "" : purprojectObj.getString("name"));
                map.put("controlamount", "\u00a5" + df.format(dy.getBigDecimal("controlamount")));
                map.put("controlvat", "\u00a5" + df.format(dy.getBigDecimal("controlvat")));
                map.put("ctrlamtexceptvat", "\u00a5" + df.format(dy.getBigDecimal("ctrlamtexceptvat")));
                if (!isMoreBid) {
                    map.put("purentryworkload", dy.getString("purentryworkload"));
                }
                map.put("purentrycomment", dy.getString("purentrycomment"));
                list.add(map);
            }
        }
        return list;
    }

    private List<Map<String, Object>> buildSupplierData(DynamicObjectCollection bidrollsections, boolean moreBid) {
        if (CollectionUtils.isEmpty((Collection)bidrollsections)) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject bidsectionObj : bidrollsections) {
            DynamicObjectCollection supplierentrys = bidsectionObj.getDynamicObjectCollection(KEY_SUPPLIER);
            if (CollectionUtils.isEmpty((Collection)supplierentrys)) continue;
            for (DynamicObject dy : supplierentrys) {
                DynamicObject supplier;
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("id", dy.getPkValue());
                if (moreBid) {
                    map.put("sectionname", bidsectionObj.getString("rollsectionname"));
                }
                map.put("suppliername", (supplier = dy.getDynamicObject("supplier")) == null ? "" : supplier.getString("name"));
                map.put("suppliercontact", dy.getString("suppliercontact"));
                map.put("contactphone", dy.getString("contactphone"));
                map.put("email", dy.getString("email"));
                map.put("address", dy.getString("address"));
                map.put("fax", dy.getString("fax"));
                DynamicObject statistic = dy.getDynamicObject("supplierstatistic");
                map.put("invitedqty", statistic == null ? "" : statistic.getString("invitedqty"));
                map.put("wonqty", statistic == null ? "" : statistic.getString("wonqty"));
                map.put("suppliercomment", dy.getString("suppliercomment"));
                list.add(map);
            }
        }
        return list;
    }

    private List<Map<String, Object>> buildExpertData(DynamicObjectCollection proficients) {
        if (CollectionUtils.isEmpty((Collection)proficients)) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(proficients.size());
        for (DynamicObject dy : proficients) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("id", dy.getPkValue());
            String proficientType = "";
            DynamicObject proficient = dy.getDynamicObject("proficient");
            if (proficient != null) {
                map.put("proficient", proficient.getString("name"));
                if ("internalExperts".equals(proficient.get("type"))) {
                    proficientType = ResManager.loadKDString((String)"\u5185\u90e8\u4e13\u5bb6", (String)"BidProjectAuditPlugin_54", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                } else if ("externalExperts".equals(proficient.get("type"))) {
                    proficientType = ResManager.loadKDString((String)"\u5916\u90e8\u4e13\u5bb6", (String)"BidProjectAuditPlugin_55", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                }
                map.put("proficient_major", proficient.getString("majortypenames"));
                map.put("proficient_telephone", proficient.getString("telephone"));
            } else {
                map.put("proficient", "");
                map.put("proficient_major", "");
                map.put("proficient_telephone", "");
            }
            map.put("proficient_type", proficientType);
            map.put("proficient_technical", dy.getBoolean("proficient_technical") ? ResManager.loadKDString((String)"\u662f", (String)"BidProjectAuditPlugin_56", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"BidProjectAuditPlugin_57", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            map.put("proficient_commercial", dy.getBoolean("proficient_commercial") ? ResManager.loadKDString((String)"\u662f", (String)"BidProjectAuditPlugin_56", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"BidProjectAuditPlugin_57", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            map.put("proficient_comment", dy.getString("proficient_comment"));
            list.add(map);
        }
        return list;
    }

    private List<Map<String, Object>> buildTeamData(DynamicObject object, DynamicObjectCollection members) {
        if (CollectionUtils.isEmpty((Collection)members)) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(members.size());
        for (DynamicObject dy : members) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("id", dy.getPkValue());
            DynamicObject user = dy.getDynamicObject("user");
            map.put("user", user == null ? "" : user.getString("name"));
            map.put("membertel", user == null ? "" : user.getString("phone"));
            DynamicObject position = dy.getDynamicObject("position");
            map.put("positionname", position == null ? "" : position.getString("position"));
            DynamicObject org = object.getDynamicObject("org");
            map.put("memberorg", org == null ? "" : org.getString("name"));
            String respbusiness = dy.getString("respbusiness");
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)respbusiness)) {
                String[] split;
                for (String str : split = respbusiness.split(",")) {
                    if (!StringUtils.isNotEmpty((String)str)) continue;
                    sb.append(stageNameMap.get(str));
                    sb.append(',');
                }
                respbusiness = sb.toString().substring(0, sb.toString().length() - 1);
                map.put("respbusiness", respbusiness);
            }
            map.put("isdirector", dy.getBoolean("isdirector") ? ResManager.loadKDString((String)"\u662f", (String)"BidProjectAuditPlugin_56", (String)"scm-bid-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"BidProjectAuditPlugin_57", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            map.put("membercomment", dy.getString("membercomment"));
            list.add(map);
        }
        return list;
    }

    static {
        stageNameMap.put("01", ResManager.loadKDString((String)"\u62db\u6807\u7acb\u9879", (String)"BidProjectAuditPlugin_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("02", ResManager.loadKDString((String)"\u5165\u56f4\u9080\u8bf7", (String)"BidProjectAuditPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("03", ResManager.loadKDString((String)"\u6280\u672f\u6807\u7f16\u5236", (String)"BidProjectAuditPlugin_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("04", ResManager.loadKDString((String)"\u5546\u52a1\u6807\u7f16\u5236", (String)"BidProjectAuditPlugin_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("05", ResManager.loadKDString((String)"\u53d1\u6807", (String)"BidProjectAuditPlugin_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("06", ResManager.loadKDString((String)"\u5f00\u6807", (String)"BidProjectAuditPlugin_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("07", ResManager.loadKDString((String)"\u8bc4\u6807", (String)"BidProjectAuditPlugin_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("08", ResManager.loadKDString((String)"\u5b9a\u6807", (String)"BidProjectAuditPlugin_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("09", ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236", (String)"BidProjectAuditPlugin_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("10", ResManager.loadKDString((String)"\u7b54\u7591", (String)"BidProjectAuditPlugin_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("11", ResManager.loadKDString((String)"\u6280\u672f\u6807\u5f00\u6807", (String)"BidProjectAuditPlugin_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("12", ResManager.loadKDString((String)"\u5546\u52a1\u6807\u5f00\u6807", (String)"BidProjectAuditPlugin_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("13", ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807", (String)"BidProjectAuditPlugin_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("14", ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807", (String)"BidProjectAuditPlugin_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("15", ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224", (String)"BidProjectAuditPlugin_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("16", ResManager.loadKDString((String)"\u7f34\u8d39", (String)"BidProjectAuditPlugin_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        stageNameMap.put("17", ResManager.loadKDString((String)"\u667a\u80fd\u6e05\u6807", (String)"BidProjectAuditPlugin_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        bidFieldsMap.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7:40px", (String)"BidProjectAuditPlugin_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        bidFieldsMap.put("sectionname", ResManager.loadKDString((String)"\u6807\u6bb5\u540d\u79f0:120px", (String)"BidProjectAuditPlugin_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        bidFieldsMap.put("workload", ResManager.loadKDString((String)"\u603b\u5de5\u671f\uff08\u5929\uff09:120px", (String)"BidProjectAuditPlugin_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        bidFieldsMap.put("secdeposit", ResManager.loadKDString((String)"\u6295\u6807\u4fdd\u8bc1\u91d1:120px", (String)"BidProjectAuditPlugin_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        bidFieldsMap.put("purentrycontent", ResManager.loadKDString((String)"\u62db\u6807\u5185\u5bb9:120px", (String)"BidProjectAuditPlugin_21", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        bidFieldsMap.put("purentryproject", ResManager.loadKDString((String)"\u91c7\u8d2d\u9879\u76ee:240px", (String)"BidProjectAuditPlugin_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        bidFieldsMap.put("controlamount", ResManager.loadKDString((String)"\u91c7\u8d2d\u63a7\u5236\u91d1\u989d:120px", (String)"BidProjectAuditPlugin_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        bidFieldsMap.put("controlvat", ResManager.loadKDString((String)"\u91c7\u8d2d\u63a7\u5236\u7a0e\u989d:120px", (String)"BidProjectAuditPlugin_24", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        bidFieldsMap.put("ctrlamtexceptvat", ResManager.loadKDString((String)"\u91c7\u8d2d\u63a7\u5236\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09:160px", (String)"BidProjectAuditPlugin_25", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        bidFieldsMap.put("purentrycomment", ResManager.loadKDString((String)"\u8bf4\u660e:200px", (String)"BidProjectAuditPlugin_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7:40px", (String)"BidProjectAuditPlugin_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("sectionname", ResManager.loadKDString((String)"\u6807\u6bb5\u540d\u79f0:120px", (String)"BidProjectAuditPlugin_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("secdeposit", ResManager.loadKDString((String)"\u6295\u6807\u4fdd\u8bc1\u91d1:120px", (String)"BidProjectAuditPlugin_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("purentryproject", ResManager.loadKDString((String)"\u91c7\u8d2d\u9879\u76ee:240px", (String)"BidProjectAuditPlugin_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("materialno", ResManager.loadKDString((String)"\u4ea7\u54c1\u7f16\u7801:120px", (String)"BidProjectAuditPlugin_27", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("materialname", ResManager.loadKDString((String)"\u4ea7\u54c1\u540d\u79f0:200px", (String)"BidProjectAuditPlugin_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("model", ResManager.loadKDString((String)"\u89c4\u5219\u578b\u53f7:120px", (String)"BidProjectAuditPlugin_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("unit", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d:120px", (String)"BidProjectAuditPlugin_30", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("materialdes", ResManager.loadKDString((String)"\u4ea7\u54c1\u63cf\u8ff0:200px", (String)"BidProjectAuditPlugin_31", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("qty", ResManager.loadKDString((String)"\u6570\u91cf:120px", (String)"BidProjectAuditPlugin_32", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("controlamount", ResManager.loadKDString((String)"\u91c7\u8d2d\u63a7\u5236\u91d1\u989d:120px", (String)"BidProjectAuditPlugin_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("controlvat", ResManager.loadKDString((String)"\u91c7\u8d2d\u63a7\u5236\u7a0e\u989d:120px", (String)"BidProjectAuditPlugin_24", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("ctrlamtexceptvat", ResManager.loadKDString((String)"\u91c7\u8d2d\u63a7\u5236\u91d1\u989d\uff08\u4e0d\u542b\u7a0e\uff09:160px", (String)"BidProjectAuditPlugin_25", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        materialFieldsMap.put("purentrycomment", ResManager.loadKDString((String)"\u8bf4\u660e:200px", (String)"BidProjectAuditPlugin_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7:40px", (String)"BidProjectAuditPlugin_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("sectionname", ResManager.loadKDString((String)"\u6807\u6bb5\u540d\u79f0:120px", (String)"BidProjectAuditPlugin_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("suppliername", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u540d\u79f0:240px", (String)"BidProjectAuditPlugin_33", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("suppliercontact", ResManager.loadKDString((String)"\u8054\u7cfb\u4eba:120px", (String)"BidProjectAuditPlugin_34", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("contactphone", ResManager.loadKDString((String)"\u8054\u7cfb\u7535\u8bdd:120px", (String)"BidProjectAuditPlugin_35", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("email", ResManager.loadKDString((String)"\u7535\u5b50\u90ae\u4ef6:180px", (String)"BidProjectAuditPlugin_36", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("address", ResManager.loadKDString((String)"\u8054\u7cfb\u5730\u5740:300px", (String)"BidProjectAuditPlugin_37", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("fax", ResManager.loadKDString((String)"\u4f20\u771f:120px", (String)"BidProjectAuditPlugin_38", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("invitedqty", ResManager.loadKDString((String)"\u5165\u56f4\u6b21\u6570:120px", (String)"BidProjectAuditPlugin_39", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("wonqty", ResManager.loadKDString((String)"\u4e2d\u6807\u6b21\u6570:120px", (String)"BidProjectAuditPlugin_40", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        supplierFieldsMap.put("suppliercomment", ResManager.loadKDString((String)"\u63a8\u8350\u7406\u7531:200px", (String)"BidProjectAuditPlugin_41", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        expertFieldsMap.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7:40px", (String)"BidProjectAuditPlugin_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        expertFieldsMap.put("proficient", ResManager.loadKDString((String)"\u4e13\u5bb6\u59d3\u540d:120px", (String)"BidProjectAuditPlugin_42", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        expertFieldsMap.put("proficient_type", ResManager.loadKDString((String)"\u4e13\u5bb6\u6765\u6e90:120px", (String)"BidProjectAuditPlugin_43", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        expertFieldsMap.put("proficient_major", ResManager.loadKDString((String)"\u4e13\u4e1a\u5206\u7c7b:120px", (String)"BidProjectAuditPlugin_44", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        expertFieldsMap.put("proficient_telephone", ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801:120px", (String)"BidProjectAuditPlugin_45", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        expertFieldsMap.put("proficient_technical", ResManager.loadKDString((String)"\u6280\u672f\u6807:120px", (String)"BidProjectAuditPlugin_46", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        expertFieldsMap.put("proficient_commercial", ResManager.loadKDString((String)"\u5546\u52a1\u6807:120px", (String)"BidProjectAuditPlugin_47", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        expertFieldsMap.put("proficient_comment", ResManager.loadKDString((String)"\u8bf4\u660e:200px", (String)"BidProjectAuditPlugin_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        teamFieldsMap.put("seq", ResManager.loadKDString((String)"\u5e8f\u53f7:40px", (String)"BidProjectAuditPlugin_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        teamFieldsMap.put("user", ResManager.loadKDString((String)"\u59d3\u540d:120px", (String)"BidProjectAuditPlugin_48", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        teamFieldsMap.put("membertel", ResManager.loadKDString((String)"\u8054\u7cfb\u7535\u8bdd:120px", (String)"BidProjectAuditPlugin_35", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        teamFieldsMap.put("positionname", ResManager.loadKDString((String)"\u804c\u4f4d:120px", (String)"BidProjectAuditPlugin_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        teamFieldsMap.put("memberorg", ResManager.loadKDString((String)"\u6240\u5c5e\u7ec4\u7ec7:120px", (String)"BidProjectAuditPlugin_50", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        teamFieldsMap.put("respbusiness", ResManager.loadKDString((String)"\u7ecf\u529e\u4e1a\u52a1:300px", (String)"BidProjectAuditPlugin_51", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        teamFieldsMap.put("isdirector", ResManager.loadKDString((String)"\u662f\u5426\u8d1f\u8d23\u4eba:120px", (String)"BidProjectAuditPlugin_52", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        teamFieldsMap.put("membercomment", ResManager.loadKDString((String)"\u8bf4\u660e:200px", (String)"BidProjectAuditPlugin_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
    }
}

