/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair;

import java.util.ArrayList;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.util.bidabordrepair.BidAbortiveUtil;

public class BidAbortiveRepair
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (newValue == (oldValue = changeData.getOldValue())) {
            return;
        }
        String name = e.getProperty().getName();
        if ("bidproject".equals(name)) {
            this.bidProjectChanged(newValue);
        }
    }

    protected void bidProjectChanged(Object newValue) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection downbillentry = dataEntity.getDynamicObjectCollection("downbillentry");
        downbillentry.clear();
        if (newValue == null) {
            this.getView().updateView("downbillentry");
            return;
        }
        BidAbortiveUtil.fillEntryDownLoadBillsData((Object)((DynamicObject)newValue).getPkValue(), (String)this.getAppId(), (DynamicObject)dataEntity);
        this.getView().updateView("downbillentry");
        this.getView().updateView("entryentity");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public String getAppId() {
        return this.getModel().getDataEntityType().getName().split("_")[0];
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult().isSuccess() && "submit".equals(args.getOperateKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            this.recoverDownLoadBillsStatus(dataEntity);
            this.recoverSupplierInvitationStatus(dataEntity);
            DeleteServiceHelper.delete((String)(this.getAppId() + "_projectcancel"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", dataEntity.getDynamicObject("bidproject").getPkValue())});
        }
    }

    protected void recoverSupplierInvitationStatus(DynamicObject dataEntity) {
        DynamicObjectCollection entityEntry = dataEntity.getDynamicObjectCollection("entryentity");
        if (entityEntry.isEmpty()) {
            return;
        }
        String sql = "update t_bid_invitationentry set finvitationstatus = ? where fentryid = ?";
        ArrayList paramList = new ArrayList(16);
        entityEntry.forEach(entry -> {
            Object[] param = new Object[]{entry.get("invitationstatus"), entry.get("srcentryid")};
            paramList.add(param);
        });
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, paramList);
    }

    protected void recoverDownLoadBillsStatus(DynamicObject dataEntity) {
        DynamicObjectCollection downbillentry = dataEntity.getDynamicObjectCollection("downbillentry");
        if (downbillentry.isEmpty()) {
            return;
        }
        boolean displayflag = dataEntity.getBoolean("displayflag");
        boolean deletedataflag = dataEntity.getBoolean("deletedataflag");
        boolean recoverflag = dataEntity.getBoolean("recoverflag");
        for (DynamicObject entry : downbillentry) {
            if (deletedataflag) {
                this.deletedata(entry);
                continue;
            }
            if (recoverflag) {
                this.recoverData(entry);
                continue;
            }
            if (!displayflag) continue;
            this.displayData(entry);
        }
    }

    protected void displayData(DynamicObject entry) {
        String entryId = entry.getString("entityid");
        DynamicObject data = BidAbortiveUtil.getDatas((Object)entry.get("billid"), (String)entryId, (String)this.getAppId());
        String billStatusName = BidAbortiveUtil.getBillStatusName((String)entryId, (String)this.getAppId());
        data.set(billStatusName, (Object)"NOT_SHOW");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
    }

    protected void recoverData(DynamicObject entry) {
        String entryId = entry.getString("entityid");
        DynamicObject data = BidAbortiveUtil.getDatas((Object)entry.get("billid"), (String)entryId, (String)this.getAppId());
        String billStatusName = BidAbortiveUtil.getBillStatusName((String)entryId, (String)this.getAppId());
        data.set(billStatusName, entry.get("entrybillstatus"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
    }

    protected void deletedata(DynamicObject entry) {
        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)entry.getString("entityid")), (Object[])new Object[]{entry.get("billid")});
    }
}

