/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.helper.BidFileHelper;

public class BidDecisionFileRepair
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit decisionF7 = (BasedataEdit)this.getView().getControl("decision");
        decisionF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bidOpenF7 = (BasedataEdit)this.getView().getControl("bidopen");
        bidOpenF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit busTalkF7 = (BasedataEdit)this.getView().getControl("bustalk");
        busTalkF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit questionClarifyF7 = (BasedataEdit)this.getView().getControl("questionclarify");
        questionClarifyF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"decision")) {
            this.getModel().setValue("bidopen", null);
            this.getModel().setValue("bustalk", null);
            this.getModel().setValue("questionclarify", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject decision = dataEntity.getDynamicObject("decision");
        DynamicObject busTalk = dataEntity.getDynamicObject("bustalk");
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bidopen") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"questionclarify") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bustalk")) {
            if (decision == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b9a\u6807", (String)"BidDecisionFileRepair_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            DynamicObject bidProject = decision.getDynamicObject("bidproject");
            QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("audit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String fileSource = dataEntity.getString("filesource");
            DynamicObject decision = dataEntity.getDynamicObject("decision");
            DynamicObject busTalk = dataEntity.getDynamicObject("bustalk");
            DynamicObject bidOpen = dataEntity.getDynamicObject("bidopen");
            DynamicObject questionClarify = dataEntity.getDynamicObject("questionclarify");
            String entityTypeId = decision.getString("entitytypeid");
            String appId = entityTypeId.split("_")[0];
            DynamicObject realDecision = BusinessDataServiceHelper.loadSingle((Object)decision.getPkValue(), (String)(appId + "_decision"));
            if ("bidopen".equals(fileSource)) {
                String key;
                DynamicObject supplier;
                DynamicObjectCollection supplierEntryCol;
                String sectionName;
                DynamicObjectCollection bidSectionCol;
                if (bidOpen == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u6807", (String)"BidDecisionFileRepair_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                HashMap<String, DynamicObject> supplierFileMap = new HashMap<String, DynamicObject>();
                DynamicObject realBidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpen.getPkValue(), (String)(appId + "_bidopen"));
                if (realBidOpen != null) {
                    bidSectionCol = realBidOpen.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidSection : bidSectionCol) {
                        sectionName = bidSection.getString("sectionname");
                        supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : supplierEntryCol) {
                            supplier = supplierEntry.getDynamicObject("supplier");
                            if (supplier == null) continue;
                            key = String.format("%s_%s", sectionName, supplier.getPkValue());
                            supplierFileMap.put(key, supplierEntry);
                        }
                    }
                }
                if (realDecision != null) {
                    bidSectionCol = realDecision.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidSection : bidSectionCol) {
                        sectionName = bidSection.getString("sectionname");
                        supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : supplierEntryCol) {
                            supplier = supplierEntry.getDynamicObject("supplier");
                            if (supplier == null) continue;
                            key = String.format("%s_%s", sectionName, supplier.getPkValue());
                            DynamicObject supplierFile = supplierFileMap.getOrDefault(key, null);
                            this.copyToEntryAttach(supplierFile, "supplier_techattach", supplierEntry, "techfile_new");
                            this.copyToEntryAttach(supplierFile, "supplier_comattach", supplierEntry, "commfile_new");
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{realDecision});
                }
            } else if ("bidquestionclarify".equals(fileSource)) {
                String clarifyFormIde = appId + "_questionclarify";
                DynamicObject clarifyQuestion = BusinessDataServiceHelper.loadSingle((Object)questionClarify.getPkValue(), (String)clarifyFormIde);
                if (clarifyQuestion == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d28\u7591\u6f84\u6e05\u3002", (String)"BidDecisionFileRepair_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection sectionColl = clarifyQuestion.getDynamicObjectCollection("bidsection");
                String clarifySectionName = ((DynamicObject)sectionColl.get(0)).getString("sectionname");
                String clarifySupplier = clarifyQuestion.getString("clarifysupplier");
                String[] values = clarifySupplier.split("&&");
                String clarifySupplierId = values[0];
                List techList = AttachmentServiceHelper.getAttachments((String)clarifyFormIde, (Object)clarifyQuestion.getPkValue(), (String)"techattachment");
                List comList = AttachmentServiceHelper.getAttachments((String)clarifyFormIde, (Object)clarifyQuestion.getPkValue(), (String)"commercattachment");
                if (realDecision != null) {
                    DynamicObjectCollection bidSectionCol = realDecision.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidSection : bidSectionCol) {
                        String sectionName = bidSection.getString("sectionname");
                        if (!clarifySectionName.equals(sectionName)) continue;
                        DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : supplierEntryCol) {
                            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                            if (supplier == null || !clarifySupplierId.equals(supplier.getString("id"))) continue;
                            this.copyToEntryAttachByAttachList(techList, supplierEntry, "techfile_new");
                            this.copyToEntryAttachByAttachList(comList, supplierEntry, "commfile_new");
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{realDecision});
                }
            } else if ("bustalk".equals(fileSource)) {
                String key;
                DynamicObject supplier;
                DynamicObjectCollection supplierEntryCol;
                String sectionName;
                DynamicObjectCollection bidSectionCol;
                if (busTalk == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u52a1\u8c08\u5224\u3002", (String)"BidDecisionFileRepair_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                HashMap<String, DynamicObject> supplierFileMap = new HashMap<String, DynamicObject>();
                DynamicObject realBusTalk = BusinessDataServiceHelper.loadSingle((Object)busTalk.getPkValue(), (String)(appId + "_bustalk"));
                if (realBusTalk != null) {
                    bidSectionCol = realBusTalk.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidSection : bidSectionCol) {
                        sectionName = bidSection.getString("sectionname");
                        supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : supplierEntryCol) {
                            supplier = supplierEntry.getDynamicObject("supplier");
                            if (supplier == null) continue;
                            key = String.format("%s_%s", sectionName, supplier.getPkValue());
                            supplierFileMap.put(key, supplierEntry);
                        }
                    }
                }
                if (realDecision != null) {
                    bidSectionCol = realDecision.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidSection : bidSectionCol) {
                        sectionName = bidSection.getString("sectionname");
                        supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : supplierEntryCol) {
                            supplier = supplierEntry.getDynamicObject("supplier");
                            if (supplier == null) continue;
                            key = String.format("%s_%s", sectionName, supplier.getPkValue());
                            DynamicObject supplierFile = supplierFileMap.getOrDefault(key, null);
                            this.copyToEntryAttach(supplierFile, "technology_new", supplierEntry, "techfile_new");
                            this.copyToEntryAttach(supplierFile, "business_new", supplierEntry, "commfile_new");
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{realDecision});
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("audit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            if (operationResult.isSuccess()) {
                dataEntity.set("bizstatus", (Object)"success");
            } else {
                dataEntity.set("bizstatus", (Object)"fail");
            }
            this.getView().updateView("bizstatus");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        }
    }

    protected void copyToEntryAttach(DynamicObject bidOpenSupplierEntry, String bidOpenEntryProperty, DynamicObject supplierEntry, String entryProperty) {
        DynamicObjectCollection bidOpenFileCol = bidOpenSupplierEntry.getDynamicObjectCollection(bidOpenEntryProperty);
        DynamicObjectCollection inviteAttachFiles = supplierEntry.getDynamicObjectCollection(entryProperty);
        inviteAttachFiles.clear();
        bidOpenFileCol.stream().forEach(item -> {
            DynamicObject oldAttachment = item.getDynamicObject("fbasedataid");
            DynamicObject inviteAttach = inviteAttachFiles.addNew();
            DynamicObject newAttachment = BidFileHelper.copyBdAttachment((DynamicObject)oldAttachment);
            if (newAttachment != null) {
                inviteAttach.set("fbasedataid", (Object)newAttachment);
            } else {
                inviteAttach.set("fbasedataid", (Object)oldAttachment);
            }
        });
        supplierEntry.set(entryProperty, (Object)inviteAttachFiles);
    }

    protected void copyToEntryAttachByAttachList(List<Map<String, Object>> attachList, DynamicObject supplierEntry, String entryProperty) {
        if (attachList != null && attachList.size() > 0) {
            List attachments = BidFileHelper.copyToEntryAttachment(attachList);
            DynamicObjectCollection inviteAttachFiles = supplierEntry.getDynamicObjectCollection(entryProperty);
            inviteAttachFiles.clear();
            attachments.stream().forEach(item -> {
                DynamicObject inviteAttach = inviteAttachFiles.addNew();
                inviteAttach.set("fbasedataid", item);
            });
            supplierEntry.set(entryProperty, (Object)inviteAttachFiles);
        }
    }
}

