/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidInviteRollBackRepair
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BIDPROJECT = "bidproject";
    private static final String SECTION = "section";
    private static final String SUPPLIER = "supplier";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bidproject = (BasedataEdit)this.getControl(BIDPROJECT);
        bidproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplier = (BasedataEdit)this.getControl(SUPPLIER);
        supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (newValue == (oldValue = changeData.getOldValue())) {
            return;
        }
        String name = e.getProperty().getName();
        if (BIDPROJECT.equals(name)) {
            this.projectChanged(newValue);
        }
    }

    protected void projectChanged(Object newValue) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.getModel().setValue(SECTION, null);
        dataEntity.getDynamicObjectCollection(SUPPLIER).clear();
        DynamicObject invitation = this.getSupplierInvitation(((DynamicObject)newValue).getPkValue());
        if (invitation == null) {
            return;
        }
        DynamicObjectCollection bidsection = invitation.getDynamicObjectCollection("bidsection");
        ComboEdit comboEdit = (ComboEdit)this.getControl(SECTION);
        ArrayList comboItemList = new ArrayList();
        bidsection.forEach(section -> {
            String sectionname = section.getString("sectionname");
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(sectionname));
            comboItem.setValue(sectionname);
            comboItemList.add(comboItem);
        });
        comboEdit.setComboItems(comboItemList);
        this.getView().updateView(SECTION);
        this.getView().updateView(SUPPLIER);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        switch (name) {
            case "bidproject": {
                this.bidprojectF7Selected(customQFilters);
                break;
            }
            case "supplier": {
                this.supplierF7Selected(customQFilters);
            }
        }
    }

    protected void supplierF7Selected(List<QFilter> customQFilters) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String section = dataEntity.getString(SECTION);
        DynamicObject bidProject = dataEntity.getDynamicObject(BIDPROJECT);
        if (section == null || bidProject == null) {
            customQFilters.add(new QFilter("id", "=", (Object)-1L));
            return;
        }
        DynamicObject invitation = this.getSupplierInvitation(bidProject.getPkValue());
        if (invitation == null) {
            return;
        }
        DynamicObjectCollection bidsection = invitation.getDynamicObjectCollection("bidsection");
        HashSet supplierIdSet = new HashSet();
        bidsection.stream().filter(item -> StringUtils.equals((CharSequence)section, (CharSequence)item.getString("sectionname"))).forEach(entry -> {
            DynamicObjectCollection supplierentry = entry.getDynamicObjectCollection("supplierentry");
            supplierentry.forEach(sentry -> supplierIdSet.add(sentry.getDynamicObject(SUPPLIER).getPkValue()));
        });
        DynamicObjectCollection bidenrollsection = invitation.getDynamicObjectCollection("bidenrollsection");
        bidenrollsection.stream().filter(item -> StringUtils.equals((CharSequence)section, (CharSequence)item.getString("entrysectionname"))).forEach(entry -> {
            DynamicObjectCollection supplierentry = entry.getDynamicObjectCollection("supplierenrollentry");
            supplierentry.forEach(sentry -> supplierIdSet.add(sentry.getDynamicObject("enrollsupplier").getPkValue()));
        });
        customQFilters.add(new QFilter("id", "in", supplierIdSet));
    }

    protected void bidprojectF7Selected(List<QFilter> customQFilters) {
        DynamicObjectCollection invitations = QueryServiceHelper.query((String)(this.getAppId() + "_" + "supplierinvitation"), (String)BIDPROJECT, (QFilter[])new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"A", "D"})});
        Set bidprojectIdSet = invitations.stream().map(item -> item.getLong(BIDPROJECT)).collect(Collectors.toSet());
        customQFilters.add(new QFilter("id", "in", bidprojectIdSet));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            this.rollBackSupplierInvitation();
        }
    }

    protected void rollBackSupplierInvitation() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject bidproject = dataEntity.getDynamicObject(BIDPROJECT);
        DynamicObject supplierInvitation = this.getSupplierInvitation(bidproject.getPkValue());
        if (supplierInvitation == null) {
            return;
        }
        DynamicObject queryBidProject = QueryServiceHelper.queryOne((String)(this.getAppId() + "_project"), (String)"bidmode", (QFilter[])new QFilter[]{new QFilter("id", "=", bidproject.getPkValue())});
        Long bidModeId = queryBidProject.getLong("bidmode");
        DynamicObject bidModeData = QueryServiceHelper.queryOne((String)(this.getAppId() + "_" + "bidmode"), (String)"opentenderflag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidModeId)});
        List<Object> supplierIdList = dataEntity.getDynamicObjectCollection(SUPPLIER).stream().map(item -> item.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        if (bidModeData.getBoolean("opentenderflag")) {
            this.deleteSupplierData(dataEntity, supplierInvitation, supplierIdList);
        } else {
            this.changeSupplierInvitationStatus(dataEntity, supplierInvitation, supplierIdList);
            this.changeInvitationStatus(supplierIdList, bidproject.getPkValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierInvitation});
    }

    private void changeInvitationStatus(List<Object> supplierIdList, Object bidProjectId) {
        DynamicObject invitation = BusinessDataServiceHelper.loadSingle((String)(this.getAppId() + "_invitation"), (String)"supplierentry,supplier,invitationstatus,confirmman,confirmdate,invitationuser", (QFilter[])new QFilter[]{new QFilter(BIDPROJECT, "=", bidProjectId), new QFilter("releasestatus", "=", (Object)"P")});
        if (invitation == null) {
            return;
        }
        invitation.getDynamicObjectCollection("supplierentry").stream().filter(item -> supplierIdList.contains(item.getDynamicObject(SUPPLIER).getPkValue())).forEach(item -> {
            item.set("invitationstatus", (Object)"UNCONFIRM");
            item.set("confirmman", null);
            item.set("confirmdate", null);
            item.set("invitationuser", null);
        });
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invitation});
    }

    protected void changeSupplierInvitationStatus(DynamicObject dataEntity, DynamicObject supplierInvitation, List<Object> supplierIdList) {
        String sectionname = dataEntity.getString(SECTION);
        DynamicObjectCollection bidsection = supplierInvitation.getDynamicObjectCollection("bidsection");
        Optional<DynamicObject> bidSection = bidsection.stream().filter(section -> sectionname.equals(section.getString("sectionname"))).findFirst();
        if (bidSection.isPresent()) {
            DynamicObject bidSectionData = bidSection.get();
            bidSectionData.getDynamicObjectCollection("supplierentry").stream().filter(item -> supplierIdList.contains(item.getDynamicObject(SUPPLIER).getPkValue())).forEach(item -> {
                item.set("invitationstatus", (Object)"UNCONFIRM");
                item.set("isrecommend", (Object)Boolean.FALSE);
            });
        }
    }

    protected void deleteSupplierData(DynamicObject dataEntity, DynamicObject supplierInvitation, List<Object> supplierIdList) {
        Optional<DynamicObject> bidEnrollSection;
        String sectionname = dataEntity.getString(SECTION);
        DynamicObjectCollection bidsection = supplierInvitation.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection bidenrollsection = supplierInvitation.getDynamicObjectCollection("bidenrollsection");
        Optional<DynamicObject> bidSection = bidsection.stream().filter(section -> sectionname.equals(section.getString("sectionname"))).findFirst();
        if (bidSection.isPresent()) {
            DynamicObject bidSectionData = bidSection.get();
            bidSectionData.getDynamicObjectCollection("supplierentry").removeIf(entry -> supplierIdList.contains(entry.getDynamicObject(SUPPLIER).getPkValue()));
        }
        if ((bidEnrollSection = bidenrollsection.stream().filter(section -> sectionname.equals(section.getString("entrysectionname"))).findFirst()).isPresent()) {
            DynamicObject bidSectionData = bidEnrollSection.get();
            bidSectionData.getDynamicObjectCollection("supplierenrollentry").removeIf(entry -> supplierIdList.contains(entry.getDynamicObject("enrollsupplier").getPkValue()));
        }
    }

    protected DynamicObject getSupplierInvitation(Object id) {
        return BusinessDataServiceHelper.loadSingle((String)(this.getAppId() + "_" + "supplierinvitation"), (String)"bidproject,bidsection,sectionname,supplierentry,supplier,invitationstatus,bidenrollsection,entrysectionname,supplierenrollentry,enrollsupplier,isrecommend", (QFilter[])new QFilter[]{new QFilter(BIDPROJECT, "=", id), new QFilter("billstatus", "in", (Object)new String[]{"A", "D"})});
    }

    protected String getAppId() {
        String name = this.getModel().getDataEntityType().getName();
        return name.split("_")[0];
    }
}

