/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidThlAndWinRollBackRepair
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BIDPROJECT = "bidproject";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (newValue == (oldValue = changeData.getOldValue())) {
            return;
        }
        String name = e.getProperty().getName();
        if (BIDPROJECT.equals(name)) {
            this.bidProjectChanged(newValue);
        }
    }

    protected void bidProjectChanged(Object newValue) {
        this.getModel().setValue("bidsection", null);
        if (newValue == null) {
            return;
        }
        DynamicObject decision = this.getDecisionData(((DynamicObject)newValue).getPkValue());
        if (decision == null) {
            return;
        }
        DynamicObjectCollection bidsection = decision.getDynamicObjectCollection("bidsection");
        ComboEdit comboEdit = (ComboEdit)this.getControl("bidsection");
        ArrayList comboItemList = new ArrayList();
        bidsection.forEach(section -> {
            String sectionname = section.getString("sectionname");
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(sectionname));
            comboItem.setValue(String.valueOf(section.getPkValue()));
            comboItemList.add(comboItem);
        });
        comboEdit.setComboItems(comboItemList);
        this.getView().updateView("bidsection");
    }

    protected DynamicObject getDecisionData(Object bidProjectId) {
        return BusinessDataServiceHelper.loadSingle((String)(this.getAppId() + "_decision"), (String)"bidsection,sectionname,issendwinnotice,issendthanksletter,supplierentry,sendnoticeflag,sendthanksletterflag", (QFilter[])new QFilter[]{new QFilter(BIDPROJECT, "=", bidProjectId), new QFilter("billstatus", "=", (Object)"C")});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        if (BIDPROJECT.equals(name)) {
            this.bidprojectF7Select(customQFilters);
        }
    }

    protected void bidprojectF7Select(List<QFilter> customQFilters) {
        DynamicObjectCollection decisionDatas = QueryServiceHelper.query((String)(this.getAppId() + "_decision"), (String)BIDPROJECT, (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"C")});
        Set bidprojectIdSet = decisionDatas.stream().map(item -> item.getLong(BIDPROJECT)).collect(Collectors.toSet());
        customQFilters.add(new QFilter("id", "in", bidprojectIdSet));
    }

    protected String getAppId() {
        return this.getModel().getDataEntityType().getName().split("_")[0];
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (operationResult.isSuccess() && "save".equals(operateKey)) {
            this.afterDoSaveOperation();
        }
    }

    protected void afterDoSaveOperation() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object bidProjectId = dataEntity.getDynamicObject(BIDPROJECT).getPkValue();
        DynamicObject decisionData = this.getDecisionData(bidProjectId);
        if (decisionData == null) {
            return;
        }
        String sectionId = dataEntity.getString("bidsection");
        DynamicObjectCollection bidsection = decisionData.getDynamicObjectCollection("bidsection");
        Optional<DynamicObject> first = bidsection.stream().filter(item -> (Long)item.getPkValue() == Long.parseLong(sectionId)).findFirst();
        if (first.isPresent()) {
            DynamicObject present = first.get();
            String type = dataEntity.getString("type");
            present.set("winnotice".equalsIgnoreCase(type) ? "issendwinnotice" : "issendthanksletter", (Object)Boolean.FALSE);
            present.getDynamicObjectCollection("supplierentry").forEach(item -> item.set("winnotice".equalsIgnoreCase(type) ? "sendnoticeflag" : "sendthanksletterflag", (Object)Boolean.FALSE));
            String entityName = this.getAppId() + ("winnotice".equalsIgnoreCase(type) ? "_winnotice" : "_thanksletter");
            this.rollBackBillStatus(entityName, Long.parseLong(sectionId), bidProjectId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{decisionData});
        }
    }

    protected void rollBackBillStatus(String entityName, long sectionId, Object bidProjectId) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"issuestatus", (QFilter[])new QFilter[]{new QFilter("decisionsectionid", "=", (Object)sectionId), new QFilter(BIDPROJECT, "=", bidProjectId), new QFilter("issuestatus", "=", (Object)"ISSUED")});
        if (bill == null) {
            return;
        }
        bill.set("issuestatus", (Object)"UNISSUE");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }
}

