/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.repair.bidqty;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidQtyChangeRepairOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (e.getOperationKey().equals("del_unit")) {
            Arrays.stream(dataEntities).forEach(dataEntity -> this.delUnit((DynamicObject)dataEntity));
        } else if (e.getOperationKey().equals("update_unit")) {
            Arrays.stream(dataEntities).forEach(dataEntity -> this.updateUnit((DynamicObject)dataEntity));
        } else if (e.getOperationKey().equals("set_his")) {
            Arrays.stream(dataEntities).forEach(dataEntity -> this.updateHis((DynamicObject)dataEntity, true));
        } else if (e.getOperationKey().equals("cancel_his")) {
            Arrays.stream(dataEntities).forEach(dataEntity -> this.updateHis((DynamicObject)dataEntity, false));
        }
    }

    public void updateHis(DynamicObject dataEntity, boolean isHis) {
        DynamicObjectCollection bidEntry = dataEntity.getDynamicObjectCollection("bid_entry");
        List bidProjectIdList = bidEntry.stream().map(item -> item.getDynamicObject("bidproject").getPkValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("is_qty_change");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"bid_project", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> obj.set("is_qty_change", (Object)isHis));
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }

    public void updateUnit(DynamicObject dataEntity) {
        DynamicObjectCollection bidEntry = dataEntity.getDynamicObjectCollection("bid_entry");
        List bidProjectIdList = bidEntry.stream().map(item -> item.getDynamicObject("bidproject").getPkValue()).collect(Collectors.toList());
        if (bidProjectIdList.isEmpty()) {
            return;
        }
        DynamicObject unit = dataEntity.getDynamicObject("unit");
        Lists.partition(bidProjectIdList, (int)200).forEach(idList -> this.updateData((List<Object>)idList, unit));
    }

    public void delUnit(DynamicObject dataEntity) {
        DynamicObjectCollection bidEntry = dataEntity.getDynamicObjectCollection("bid_entry");
        List bidProjectIdList = bidEntry.stream().map(item -> item.getDynamicObject("bidproject").getPkValue()).collect(Collectors.toList());
        if (bidProjectIdList.isEmpty()) {
            return;
        }
        Lists.partition(bidProjectIdList, (int)200).forEach(idList -> this.updateData((List<Object>)idList, null));
    }

    public void updateData(List<Object> bidProjectIdList, Object unit) {
        this.updateBidProject(bidProjectIdList, unit);
        this.updateBidDoc(bidProjectIdList, unit);
        this.updateBidBottom(bidProjectIdList, unit);
        this.updateBidPublish(bidProjectIdList, unit);
        this.updateBidOpen(bidProjectIdList, unit);
        this.updateTenMytender(bidProjectIdList, unit);
        this.updateTenOnlineDetail(bidProjectIdList, unit);
        this.updateBidQuestionclarify(bidProjectIdList, unit);
        this.updateBidBustalk(bidProjectIdList, unit);
        this.updateBidDecision(bidProjectIdList, unit);
    }

    public void updateBidDecision(List<Object> bidProjectIdList, Object unit) {
        QFilter qFilter = new QFilter("bidproject", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("bidsection");
        joiner.add("supfinaldetail");
        joiner.add("lbaseunit");
        joiner.add("supbackdetail");
        joiner.add("baseunit");
        joiner.add("bottomsection");
        joiner.add("bottomentry");
        joiner.add("botbaseunit");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"bid_decision", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> {
            DynamicObjectCollection sections = obj.getDynamicObjectCollection("bidsection");
            sections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("supfinaldetail");
                details.forEach(row -> row.set("lbaseunit", unit));
                DynamicObjectCollection backDetails = section.getDynamicObjectCollection("supbackdetail");
                backDetails.forEach(row -> row.set("baseunit", unit));
            });
            DynamicObjectCollection bottomSections = obj.getDynamicObjectCollection("bottomsection");
            bottomSections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("bottomentry");
                details.forEach(row -> row.set("botbaseunit", unit));
            });
        });
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }

    public void updateBidBustalk(List<Object> bidProjectIdList, Object unit) {
        QFilter qFilter = new QFilter("bidproject", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("bidsection");
        joiner.add("supplierdetail");
        joiner.add("baseunit");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"bid_bustalk", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> {
            DynamicObjectCollection sections = obj.getDynamicObjectCollection("bidsection");
            sections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("supplierdetail");
                details.forEach(row -> row.set("baseunit", unit));
            });
        });
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }

    public void updateBidQuestionclarify(List<Object> bidProjectIdList, Object unit) {
        QFilter qFilter = new QFilter("bidproject", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("bidsection");
        joiner.add("supplierdetail");
        joiner.add("baseunit");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> {
            DynamicObjectCollection sections = obj.getDynamicObjectCollection("bidsection");
            sections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("supplierdetail");
                details.forEach(row -> row.set("baseunit", unit));
            });
        });
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }

    public void updateTenOnlineDetail(List<Object> bidProjectIdList, Object unit) {
        QFilter qFilter = new QFilter("bidproject", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("supplierdetail");
        joiner.add("baseunit");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"ten_online_bid_detail", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> {
            DynamicObjectCollection details = obj.getDynamicObjectCollection("supplierdetail");
            details.forEach(row -> row.set("baseunit", unit));
        });
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }

    public void updateTenMytender(List<Object> bidProjectIdList, Object unit) {
        QFilter qFilter = new QFilter("bidproject", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("entry");
        joiner.add("supplierdetail");
        joiner.add("baseunit");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"ten_mytender", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> {
            DynamicObjectCollection sections = obj.getDynamicObjectCollection("entry");
            sections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("supplierdetail");
                details.forEach(row -> row.set("baseunit", unit));
            });
        });
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }

    public void updateBidOpen(List<Object> bidProjectIdList, Object unit) {
        QFilter qFilter = new QFilter("bidproject", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("bidsection");
        joiner.add("supplierdetail");
        joiner.add("baseunit");
        joiner.add("bottomsection");
        joiner.add("bottomentry");
        joiner.add("botbaseunit");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> {
            DynamicObjectCollection sections = obj.getDynamicObjectCollection("bidsection");
            sections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("supplierdetail");
                details.forEach(row -> row.set("baseunit", unit));
            });
            DynamicObjectCollection bottomSections = obj.getDynamicObjectCollection("bottomsection");
            bottomSections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("bottomentry");
                details.forEach(row -> row.set("botbaseunit", unit));
            });
        });
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }

    public void updateBidPublish(List<Object> bidProjectIdList, Object unit) {
        QFilter qFilter = new QFilter("bidproject", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("fakebidsection");
        joiner.add("projectdetail");
        joiner.add("baseunit");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> {
            DynamicObjectCollection sections = obj.getDynamicObjectCollection("fakebidsection");
            sections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("projectdetail");
                details.forEach(row -> row.set("baseunit", unit));
            });
        });
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }

    public void updateBidBottom(List<Object> bidProjectIdList, Object unit) {
        QFilter qFilter = new QFilter("bidproject", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("bidsection");
        joiner.add("projectentry");
        joiner.add("baseunit");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"bid_bottom_make", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> {
            DynamicObjectCollection sections = obj.getDynamicObjectCollection("bidsection");
            sections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("projectentry");
                details.forEach(row -> row.set("baseunit", unit));
            });
        });
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }

    public void updateBidDoc(List<Object> bidProjectIdList, Object unit) {
        QFilter qFilter = new QFilter("bidproject", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("biddocumententry");
        joiner.add("biddocdetail");
        joiner.add("baseunit");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"bid_biddocument_edit", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> {
            DynamicObjectCollection sections = obj.getDynamicObjectCollection("biddocumententry");
            sections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("biddocdetail");
                details.forEach(row -> row.set("baseunit", unit));
            });
        });
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }

    public void updateBidProject(List<Object> bidProjectIdList, Object unit) {
        QFilter qFilter = new QFilter("id", "in", bidProjectIdList);
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("bidsection");
        joiner.add("projectentry");
        joiner.add("baseunit");
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((String)"bid_project", (String)joiner.toString(), (QFilter[])qFilter.toArray());
        Arrays.stream(objectArr).forEach(obj -> {
            DynamicObjectCollection sections = obj.getDynamicObjectCollection("bidsection");
            sections.forEach(section -> {
                DynamicObjectCollection details = section.getDynamicObjectCollection("projectentry");
                details.forEach(row -> row.set("baseunit", unit));
            });
        });
        SaveServiceHelper.save((DynamicObject[])objectArr);
    }
}

