/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.report.biddetailquery;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.report.BaseListRptOrgFilterEdit;
import kd.scm.bid.common.report.RptFilterUtil;

public class BidDetailQueryEdit
extends BaseListRptOrgFilterEdit {
    protected static final String[] CURRENTKEYS = new String[]{"bidProjectNum", "supplierInvitationNum", "bidDocumentNum", "bidPublishNum", "bidAnswerQuestionNum", "bidOpenNum", "bidEvaluationNum", "bidBustalkNum", "bidDecisionNum"};
    protected static final String[] CURRENTNAMES = new String[]{"BidProject", "SupplierInvitation", "BidDocument", "BidPublish", "BidAnswerQuestion", "BidOpen", "BidEvaluation", "BidBustalk", "BidDecision"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        DynamicObject[] result;
        super.processRowData(gridPK, rowData, queryParam);
        HashMap<Long, String> decisionIdWinsupplierMap = new HashMap<Long, String>();
        String selectsupplierInDecision = "id,bidsection,supplierentry,supplierentry.supplier,supplierentry.isrecommended";
        String formId = FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass());
        QFilter entitytypefilter = new QFilter("entitytypeid", "=", (Object)formId);
        QFilter statusQFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter[] disionSupplierQFilters = new QFilter[]{statusQFilter, entitytypefilter};
        for (DynamicObject dy : result = BusinessDataServiceHelper.load((String)formId, (String)selectsupplierInDecision, (QFilter[])disionSupplierQFilters)) {
            Long id = dy.getLong("id");
            DynamicObjectCollection bidsections = dy.getDynamicObjectCollection("bidsection");
            for (Object section : bidsections) {
                DynamicObjectCollection supplierentrys = section.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierentry : supplierentrys) {
                    DynamicObject supplier;
                    Boolean isrecommended = supplierentry.getBoolean("isrecommended");
                    if (!isrecommended.booleanValue() || (supplier = supplierentry.getDynamicObject("supplier")) == null) continue;
                    String winsupplier = supplier.getString("name");
                    String value = (String)decisionIdWinsupplierMap.get(id);
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        decisionIdWinsupplierMap.put(id, (String)decisionIdWinsupplierMap.get(id) + winsupplier + ";");
                        continue;
                    }
                    decisionIdWinsupplierMap.put(id, winsupplier + ";");
                }
            }
        }
        if (decisionIdWinsupplierMap.isEmpty()) {
            return;
        }
        HashSet<String> set = new HashSet<String>(16);
        for (DynamicObject row : rowData) {
            Long decisionid = row.getLong("decisionid");
            String value = (String)decisionIdWinsupplierMap.get(decisionid);
            if (decisionid == null || StringUtils.isEmpty((CharSequence)value)) continue;
            StringBuilder winsupplier = new StringBuilder();
            String[] winsuppliers = ((String)decisionIdWinsupplierMap.get(decisionid)).split(";");
            set.clear();
            for (String supplier : winsuppliers) {
                set.add(supplier);
            }
            for (String str : set) {
                winsupplier.append(str);
                winsupplier.append(';');
            }
            String winsupplierStr = winsupplier.toString();
            row.set("winsupplier", (Object)winsupplierStr.substring(0, winsupplierStr.length() - 1));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        if ("currentstep".equals(evt.getFieldName())) {
            Object id = rowData.get("bidid");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FormTypeConstants.getFormConstant((String)"projectprocess", ((Object)((Object)this)).getClass()));
            showParameter.setCustomParam("bidProjectId", (Object)Long.parseLong(id.toString()));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.initDetailQuantityNum(queryParam);
        this.getView().setVisible(Boolean.TRUE, new String[]{"detailquantityflex"});
    }

    public void initDetailQuantityNum(ReportQueryParam queryParam) {
        ArrayList<QFilter> bidFilter = new ArrayList<QFilter>();
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection orgmultiplefilter = filterInfo.getDynamicObjectCollection(RptFilterUtil.ROW_ORG + RptFilterUtil.FLAG_MULTIPLE + RptFilterUtil.FLAG_FILTER);
        DynamicObjectCollection bidmodeMultiplefilter = filterInfo.getDynamicObjectCollection("bidmode" + RptFilterUtil.FLAG_FILTER);
        if (orgmultiplefilter != null && orgmultiplefilter.size() > 0) {
            Object[] orgIds = RptFilterUtil.getBaseDataPkIds((DynamicObjectCollection)orgmultiplefilter);
            bidFilter.add(new QFilter(RptFilterUtil.ROW_ORG, "in", (Object)orgIds).or(this.getEntrustmentorgunitQFilter(orgIds)));
        } else {
            List orgList = RptFilterUtil.getHasPermOrgs();
            bidFilter.add(new QFilter(RptFilterUtil.ROW_ORG, "in", (Object)orgList).or(this.getEntrustmentorgunitQFilter(orgList)));
        }
        if (bidmodeMultiplefilter != null && bidmodeMultiplefilter.size() > 0) {
            HashSet<Long> bidModeIds = new HashSet<Long>(25);
            for (DynamicObject bidmode : bidmodeMultiplefilter) {
                bidModeIds.add(bidmode.getLong("id"));
            }
            bidFilter.add(new QFilter("bidmode", "in", bidModeIds));
        }
        String formId = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass());
        QFilter entitytypefilter = new QFilter("EntityTypeId", "=", (Object)formId);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)"X");
        QFilter cancelFilter = new QFilter("billstatus", "!=", (Object)"XX");
        bidFilter.add(entitytypefilter);
        bidFilter.add(statusFilter);
        bidFilter.add(cancelFilter);
        QFilter[] bidQFilters = bidFilter.toArray(new QFilter[bidFilter.size()]);
        DynamicObject[] bidProjects = BusinessDataServiceHelper.load((String)formId, (String)"id,currentstep", (QFilter[])bidQFilters);
        int[] nums = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (DynamicObject bidProject : bidProjects) {
            String currentStep = bidProject.getString("currentstep");
            for (int i = 0; i < CURRENTNAMES.length; ++i) {
                if (!currentStep.contains(CURRENTNAMES[i])) continue;
                nums[i] = nums[i] + 1;
            }
        }
        for (int i = 0; i < CURRENTKEYS.length; ++i) {
            this.getModel().setValue(CURRENTKEYS[i], (Object)nums[i]);
        }
    }

    public QFilter getEntrustmentorgunitQFilter(Object value) {
        return new QFilter("entrustmentorgunit", "in", value);
    }

    public List<Long> getHasPermOrgs() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appId = this.getModel().getDataEntityType().getAppId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)(appId + "_detailqueryrpt"), (String)"47150e89000000ac");
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List hasPermOrgs = new ArrayList();
        hasPermOrgs = hasAllOrgPerm ? OrgUnitServiceHelper.getAllOrgByViewNumber((String)"01", (boolean)false) : hasPermOrgResult.getHasPermOrgs();
        return hasPermOrgs;
    }
}

