/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.report.biddetailquery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FastFilter;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.formplugin.bill.util.BidHistoryUtil;

public class BidDetailQueryHeadFilter {
    public static IBidProjectService projectService = new BidProjectServiceImpl();
    public static String ROW_ORG = "org";
    public static String FLAG_MULTIPLE = "multiple";
    public static String FLAG_FILTER = "filter";
    public static String FLAG_STARTDATE = "_startdate";
    public static String FLAG_ENDDATE = "_enddate";
    private static final String[] arr = new String[]{"A", "B", "C", "D", "I", "X"};

    public List<QFilter> getBidFilter(FilterInfo filterInfo, String appId, Set<Long> searchQFilter) {
        QFilter orgQFilter;
        ArrayList<QFilter> bidFilter = new ArrayList<QFilter>();
        String formId = appId + "_project";
        QFilter bidIdFilter = null;
        bidIdFilter = searchQFilter != null && searchQFilter.size() > 0 ? new QFilter("id", "in", searchQFilter) : new QFilter("id", "!=", (Object)-1);
        boolean orgFlag = false;
        for (FilterItemInfo filterItemInfo : filterInfo.getFilterItems()) {
            QFilter resultFilter;
            QFilter orgFilter;
            if (filterItemInfo.getPropName().contains("orgfilter.id")) {
                orgFilter = new QFilter("org.id", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                bidIdFilter.and(orgFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("orgfilter.name")) {
                String s;
                orgFilter = new QFilter("org.name", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                Object value = orgFilter.getValue();
                if (value == null || StringUtils.equals((CharSequence)(s = orgFilter.getValue().toString()), (CharSequence)"EMPTY")) continue;
                bidIdFilter.and(orgFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("purprojectset.id")) {
                orgFilter = new QFilter("bidsection.projectentry.purentryproject.id", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                bidIdFilter.and(orgFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("purprojectset.name")) {
                orgFilter = new QFilter("bidsection.projectentry.purentryproject.name", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                bidIdFilter.and(orgFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("bidpurtype.id")) {
                orgFilter = new QFilter("purtype.id", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                bidIdFilter.and(orgFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("bidpurtype.name")) {
                orgFilter = new QFilter("purtype.name", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                bidIdFilter.and(orgFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("bidmode.id")) {
                orgFilter = new QFilter("bidmode.id", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                bidIdFilter.and(orgFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("bidmode.name")) {
                orgFilter = new QFilter("bidmode.name", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                bidIdFilter.and(orgFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("purmodel")) {
                orgFilter = new QFilter("purmodel", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                bidIdFilter.and(orgFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("billstatus")) {
                resultFilter = null;
                if (StringUtils.equals((CharSequence)"not_x", (CharSequence)filterItemInfo.getValue().toString())) {
                    resultFilter = new QFilter("billstatus", "!=", (Object)"X");
                } else if (StringUtils.equals((CharSequence)"x", (CharSequence)filterItemInfo.getValue().toString())) {
                    resultFilter = new QFilter("billstatus", "=", (Object)"X");
                }
                if (resultFilter == null) continue;
                bidIdFilter.and(resultFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("setupdate")) {
                orgFilter = new QFilter("setupdate", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                bidIdFilter.and(orgFilter);
                continue;
            }
            if (filterItemInfo.getPropName().contains("bidcurrentstep")) {
                if ("ALL".equals(filterItemInfo.getValue()) || "_project".equals(filterItemInfo.getValue())) continue;
                String entitytype = appId + filterItemInfo.getValue();
                DynamicObject[] dynamicObjects = new DynamicObject[]{};
                QFilter qFilter = new QFilter("entitytypeid", "=", (Object)entitytype);
                QFilter status = new QFilter("billstatus", "!=", (Object)"XX");
                if ("_bidpublish".equals(filterItemInfo.getValue())) {
                    QFilter publishListQFilter = BidHistoryUtil.getPublishListQFilter();
                    dynamicObjects = BusinessDataServiceHelper.load((String)entitytype, (String)"bidproject.id", (QFilter[])new QFilter[]{qFilter, status, publishListQFilter});
                } else {
                    dynamicObjects = BusinessDataServiceHelper.load((String)entitytype, (String)"bidproject.id", (QFilter[])new QFilter[]{qFilter, status});
                }
                HashSet<Long> Ids = new HashSet<Long>(16);
                for (DynamicObject id : dynamicObjects) {
                    if (id.getDynamicObject("bidproject") == null) continue;
                    long aLong = id.getDynamicObject("bidproject").getLong("id");
                    Ids.add(aLong);
                }
                QFilter idFilter = new QFilter("id", "in", Ids);
                bidIdFilter.and(idFilter);
                continue;
            }
            if (!filterItemInfo.getPropName().contains("signstatus")) continue;
            resultFilter = this.getSignDecisionFilter(filterInfo, appId);
            bidIdFilter.and(resultFilter);
        }
        filterInfo.getFilterItems().removeIf(row -> row.getPropName().contains("bidcurrentstep"));
        if (!orgFlag && (orgQFilter = this.handleOrgFilter(appId)) != null) {
            bidIdFilter.and(orgQFilter);
        }
        QFilter entitytypeid = new QFilter("entitytypeid", "=", (Object)formId);
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)formId, (String)"id", (QFilter[])new QFilter[]{bidIdFilter, entitytypeid});
        HashSet<Long> projectIds = new HashSet<Long>(16);
        if (ids != null) {
            for (DynamicObject id : ids) {
                projectIds.add(id.getLong("id"));
            }
            QFilter def = this.getDecisionFilter(filterInfo, appId);
            if (def != null && ids != null) {
                formId = appId + "_project";
                DynamicObject[] loads = BusinessDataServiceHelper.load((String)formId, (String)"id", (QFilter[])new QFilter[]{def, new QFilter("id", "in", projectIds)});
                projectIds.clear();
                if (loads == null || loads.length == 0) {
                    projectIds.add(-1L);
                    bidFilter.add(new QFilter("bidproject.id", "in", projectIds));
                    return bidFilter;
                }
                for (DynamicObject id : loads) {
                    projectIds.add(id.getLong("id"));
                }
            }
            bidFilter.add(new QFilter("bidproject.id", "in", projectIds));
        }
        return bidFilter;
    }

    private QFilter getSignDecisionFilter(FilterInfo filterInfo, String appId) {
        List descSignStatus = filterInfo.getFilterItems("signstatus");
        if (null != descSignStatus && !descSignStatus.isEmpty()) {
            QFilter qFilter = null;
            for (FilterItemInfo signStatus : descSignStatus) {
                qFilter = "unsign".equals(signStatus.getValue()) ? new QFilter("billstatus", "in", (Object)arr) : ("partsigned".equals(signStatus.getValue()) ? new QFilter("billstatus", "=", (Object)"R") : new QFilter("billstatus", "=", (Object)"S"));
                if (qFilter == null) continue;
                DynamicObject[] bidprojects = BusinessDataServiceHelper.load((String)(appId + "_decision"), (String)"bidproject", (QFilter[])qFilter.toArray());
                if (bidprojects == null || bidprojects.length == 0) {
                    return new QFilter("id", "=", (Object)-1);
                }
                HashSet<Long> projectIds = new HashSet<Long>(16);
                for (DynamicObject bidproject : bidprojects) {
                    DynamicObject bidproject1 = bidproject.getDynamicObject("bidproject");
                    projectIds.add((Long)bidproject1.getPkValue());
                }
                return new QFilter("id", "in", projectIds);
            }
        }
        return null;
    }

    public String getBidAdminRoleID(String appId) {
        if (StringUtils.equals((CharSequence)"bid", (CharSequence)appId)) {
            return "/FFXFSRKI73+";
        }
        return "/V6OAY0JH+8R";
    }

    public List<QFilter> getQFilterBySearch(FilterInfo filterInfo, String appId) {
        FastFilter fastFilter = filterInfo.getFastFilter();
        if (fastFilter == null || fastFilter.getQFilters() == null || fastFilter.getQFilters().size() == 0) {
            return null;
        }
        return fastFilter.getQFilters();
    }

    public QFilter handleOrgFilter(String appId) {
        String formId;
        Long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)(formId = appId + "_project"), (String)"47150e89000000ac");
        if (allPermOrgs.hasAllOrgPerm()) {
            return new QFilter("org", "!=", (Object)-1).or(new QFilter("entrustmentorgunit", "!=", (Object)-1));
        }
        return new QFilter("org", "in", (Object)allPermOrgs.getHasPermOrgs()).or(this.getEntrustmentorgunitQFilter(allPermOrgs.getHasPermOrgs()));
    }

    public QFilter getDecisionFilter(FilterInfo filterInfo, String appid) {
        List planprojectdatefilter = filterInfo.getFilterItems("biddecisiondate");
        if (planprojectdatefilter != null && !planprojectdatefilter.isEmpty()) {
            QFilter qFilter = null;
            for (FilterItemInfo ilterItemInfo : planprojectdatefilter) {
                QFilter qFilter2;
                if (qFilter == null) {
                    qFilter = qFilter2 = new QFilter("decisiondate", ilterItemInfo.getCompareType(), (Object)ilterItemInfo.getDate());
                    continue;
                }
                qFilter2 = new QFilter("decisiondate", ilterItemInfo.getCompareType(), (Object)ilterItemInfo.getDate());
                qFilter.and(qFilter2);
            }
            if (qFilter != null) {
                DynamicObject[] bidprojects = BusinessDataServiceHelper.load((String)(appid + "_report_data"), (String)"bidproject", (QFilter[])qFilter.toArray());
                if (bidprojects == null || bidprojects.length == 0) {
                    return new QFilter("id", "=", (Object)-1);
                }
                HashSet<Long> projectIds = new HashSet<Long>(16);
                for (DynamicObject bidproject : bidprojects) {
                    DynamicObject bidproject1 = bidproject.getDynamicObject("bidproject");
                    projectIds.add((Long)bidproject1.getPkValue());
                }
                return new QFilter("id", "in", projectIds);
            }
        }
        return null;
    }

    public QFilter getEntrustmentorgunitQFilter(Object value) {
        return new QFilter("entrustmentorgunit", "in", value);
    }
}

