/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.report.efficiencydetail;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;

public class BidEfficiencyPurModeEdit
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void beforeBindData(EventObject e) {
        this.getPageCache().put("billType", this.getView().getEntityId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        super.preProcessExportData(exportColumns, data, numberFormatProvider);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        if ("reportlistap".equals(gridPK) && !CollectionUtils.isEmpty((Collection)rowData)) {
            this.buildPurModeData(rowData);
        }
        super.processRowData(gridPK, rowData, queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void buildPurModeData(DynamicObjectCollection rowDataList) {
        Long sumTotalNumber = 0L;
        Long sumTotalRealProjectPeriod = 0L;
        Long sumProjectTime = 0L;
        Long sumSupplierInvTime = 0L;
        Long sumDocumentTime = 0L;
        Long sumBottomMakeTime = 0L;
        Long sumPublishTime = 0L;
        Long sumClarificaitonTime = 0L;
        Long sumDyTime = 0L;
        Long sumOpenTime = 0L;
        Long sumEvaluationTime = 0L;
        Long sumSwtpTime = 0L;
        Long sumDecisionTime = 0L;
        for (DynamicObject rowData : rowDataList) {
            DynamicObject org = rowData.getDynamicObject("org");
            if (org != null) {
                Long totalNumber = rowData.getLong("totalnumber");
                sumTotalNumber = sumTotalNumber + totalNumber;
                Long realProjectPeriod = rowData.getLong("realprojectperiod");
                sumTotalRealProjectPeriod = sumTotalRealProjectPeriod + realProjectPeriod;
                Long projectTime = rowData.getLong("projecttime");
                sumProjectTime = sumProjectTime + projectTime;
                Long supplierInvTime = rowData.getLong("supplierinvtime");
                sumSupplierInvTime = sumSupplierInvTime + supplierInvTime;
                Long documentTime = rowData.getLong("documenttime");
                sumDocumentTime = sumDocumentTime + documentTime;
                Long bottomMakeTime = rowData.getLong("bottommaketime");
                sumBottomMakeTime = sumBottomMakeTime + bottomMakeTime;
                Long publishTime = rowData.getLong("publishtime");
                sumPublishTime = sumPublishTime + publishTime;
                Long clarificaitonTime = rowData.getLong("clarificaitontime");
                sumClarificaitonTime = sumClarificaitonTime + clarificaitonTime;
                Long dyTime = rowData.getLong("dytime");
                sumDyTime = sumDyTime + dyTime;
                Long openTime = rowData.getLong("opentime");
                sumOpenTime = sumOpenTime + openTime;
                Long evaluationTime = rowData.getLong("evaluationtime");
                sumEvaluationTime = sumEvaluationTime + evaluationTime;
                Long swtpTime = rowData.getLong("swtptime");
                sumSwtpTime = sumSwtpTime + swtpTime;
                Long decisionTime = rowData.getLong("decisiontime");
                sumDecisionTime = sumDecisionTime + decisionTime;
                BigDecimal totalNumberBig = BigDecimal.valueOf(totalNumber);
                if (totalNumberBig.intValue() <= 0) continue;
                BigDecimal avgPeriod = BigDecimal.valueOf(realProjectPeriod).divide(totalNumberBig, 2, 4);
                BigDecimal projectAvgPeriod = BigDecimal.valueOf(this.timeToDay(projectTime)).divide(totalNumberBig, 2, 4);
                BigDecimal supInvAvgPeriod = BigDecimal.valueOf(this.timeToDay(supplierInvTime)).divide(totalNumberBig, 2, 4);
                BigDecimal docAvgPeriod = BigDecimal.valueOf(this.timeToDay(documentTime)).divide(totalNumberBig, 2, 4);
                BigDecimal bottomMakeAvgPeriod = BigDecimal.valueOf(this.timeToDay(bottomMakeTime)).divide(totalNumberBig, 2, 4);
                BigDecimal publishAvgPeriod = BigDecimal.valueOf(this.timeToDay(publishTime)).divide(totalNumberBig, 2, 4);
                BigDecimal zbjdAvgPeriod = BigDecimal.valueOf(this.timeToDay(clarificaitonTime)).divide(totalNumberBig, 2, 4);
                BigDecimal dyAvgPeriod = BigDecimal.valueOf(this.timeToDay(dyTime)).divide(totalNumberBig, 2, 4);
                BigDecimal openAvgPeriod = BigDecimal.valueOf(this.timeToDay(openTime)).divide(totalNumberBig, 2, 4);
                BigDecimal evalAvgPeriod = BigDecimal.valueOf(this.timeToDay(evaluationTime)).divide(totalNumberBig, 2, 4);
                BigDecimal swtpAvgPeriod = BigDecimal.valueOf(this.timeToDay(swtpTime)).divide(totalNumberBig, 2, 4);
                BigDecimal decisionAvgPeriod = BigDecimal.valueOf(this.timeToDay(decisionTime)).divide(totalNumberBig, 2, 4);
                rowData.set("orgname", (Object)org.getString("name"));
                rowData.set("totalnumber", (Object)totalNumber);
                rowData.set("avgperiod", (Object)avgPeriod);
                rowData.set("projecttime", (Object)projectAvgPeriod);
                rowData.set("supplierinvtime", (Object)supInvAvgPeriod);
                rowData.set("documenttime", (Object)docAvgPeriod);
                rowData.set("bottommaketime", (Object)bottomMakeAvgPeriod);
                rowData.set("publishtime", (Object)publishAvgPeriod);
                rowData.set("clarificaitontime", (Object)zbjdAvgPeriod);
                rowData.set("dytime", (Object)dyAvgPeriod);
                rowData.set("opentime", (Object)openAvgPeriod);
                rowData.set("evaluationtime", (Object)evalAvgPeriod);
                rowData.set("swtptime", (Object)swtpAvgPeriod);
                rowData.set("decisiontime", (Object)decisionAvgPeriod);
                continue;
            }
            BigDecimal sumAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumprojectAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumSupInvAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumDocAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumBottomMakeAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumPublishAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumZbjdAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumDyAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumOpenAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumEvalAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumSwtpAvgPeriod = BigDecimal.ZERO;
            BigDecimal sumDecisionAvgPeriod = BigDecimal.ZERO;
            if (sumTotalNumber > 0L) {
                BigDecimal sumTotalNumberBig = BigDecimal.valueOf(sumTotalNumber);
                sumAvgPeriod = BigDecimal.valueOf(sumTotalRealProjectPeriod).divide(sumTotalNumberBig, 2, 4);
                sumprojectAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumProjectTime)).divide(sumTotalNumberBig, 2, 4);
                sumSupInvAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumSupplierInvTime)).divide(sumTotalNumberBig, 2, 4);
                sumDocAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumDocumentTime)).divide(sumTotalNumberBig, 2, 4);
                sumBottomMakeAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumBottomMakeTime)).divide(sumTotalNumberBig, 2, 4);
                sumPublishAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumPublishTime)).divide(sumTotalNumberBig, 2, 4);
                sumZbjdAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumClarificaitonTime)).divide(sumTotalNumberBig, 2, 4);
                sumDyAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumDyTime)).divide(sumTotalNumberBig, 2, 4);
                sumOpenAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumOpenTime)).divide(sumTotalNumberBig, 2, 4);
                sumEvalAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumEvaluationTime)).divide(sumTotalNumberBig, 2, 4);
                sumSwtpAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumSwtpTime)).divide(sumTotalNumberBig, 2, 4);
                sumDecisionAvgPeriod = BigDecimal.valueOf(this.timeToDay(sumDecisionTime)).divide(sumTotalNumberBig, 2, 4);
            }
            rowData.set("org", null);
            rowData.set("orgname", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"BidEfficiencyPurModeEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            rowData.set("purmode", null);
            rowData.set("totalnumber", (Object)sumTotalNumber);
            rowData.set("avgperiod", (Object)sumAvgPeriod);
            rowData.set("projecttime", (Object)sumprojectAvgPeriod);
            rowData.set("supplierinvtime", (Object)sumSupInvAvgPeriod);
            rowData.set("documenttime", (Object)sumDocAvgPeriod);
            rowData.set("bottommaketime", (Object)sumBottomMakeAvgPeriod);
            rowData.set("publishtime", (Object)sumPublishAvgPeriod);
            rowData.set("clarificaitontime", (Object)sumZbjdAvgPeriod);
            rowData.set("dytime", (Object)sumDyAvgPeriod);
            rowData.set("opentime", (Object)sumOpenAvgPeriod);
            rowData.set("evaluationtime", (Object)sumEvalAvgPeriod);
            rowData.set("swtptime", (Object)sumSwtpAvgPeriod);
            rowData.set("decisiontime", (Object)sumDecisionAvgPeriod);
        }
        Collections.sort(rowDataList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Long org1 = o1.getDynamicObject("org") != null ? o1.getDynamicObject("org").getLong("id") : 0L;
                Long org2 = o2.getDynamicObject("org") != null ? o2.getDynamicObject("org").getLong("id") : 0L;
                if (org1 == 0L) {
                    return 1;
                }
                if (org2 == 0L) {
                    return -1;
                }
                if (org1 > org2) {
                    return 1;
                }
                return 0;
            }
        });
        this.getPageCache().put("rowData", SerializationUtils.toJsonString((Object)rowDataList));
    }

    public double timeToDay(Long time) {
        if (time == null) {
            return 0.0;
        }
        Long day = 86400000L;
        return (double)time.longValue() / (double)day.longValue();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("qingview".equals(operateKey)) {
            String rowData = this.getPageCache().get("rowData");
            String appId = this.getAppId();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(appId + "_efficiency_modeqing");
            formShowParameter.setCustomParam("rowData", (Object)rowData);
            formShowParameter.setCustomParam("appId", (Object)appId);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(formShowParameter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("totalnumber".equals(evt.getFieldName())) {
            ReportQueryParam reportQueryParam = this.getView().getQueryParam();
            ReportShowParameter showParameter = new ReportShowParameter();
            showParameter.setFormId(this.getAppId() + "_newdetailquery");
            if (reportQueryParam != null) {
                int rowIndex = evt.getRowIndex();
                ReportList billList = (ReportList)this.getView().getControl("reportlistap");
                DynamicObject rowData = billList.getReportModel().getRowData(rowIndex);
                DynamicObject org = rowData.getDynamicObject("org");
                DynamicObject purMode = rowData.getDynamicObject("purmode");
                if (org != null) {
                    List filterItemList = reportQueryParam.getFilter().getFilterItems();
                    if (CollectionUtils.isEmpty((Collection)filterItemList)) {
                        FilterItemInfo filterItemInfo = new FilterItemInfo();
                        filterItemInfo.setPropName("orgfilter.id");
                        filterItemInfo.setCompareType("in");
                        filterItemInfo.setValue(org.getPkValue());
                        filterItemList.add(filterItemInfo);
                        if (purMode != null) {
                            FilterItemInfo purModeFilterItemInfo = new FilterItemInfo();
                            purModeFilterItemInfo.setPropName("bidmode.id");
                            purModeFilterItemInfo.setCompareType("in");
                            purModeFilterItemInfo.setValue(purMode.getPkValue());
                            filterItemList.add(purModeFilterItemInfo);
                        }
                    } else {
                        boolean existBidModeFlag = false;
                        boolean existBidOrgFlag = false;
                        for (FilterItemInfo filterItemInfo : filterItemList) {
                            if ("orgfilter.id".equals(filterItemInfo.getPropName())) {
                                filterItemInfo.setValue(org.getPkValue());
                                existBidOrgFlag = true;
                                continue;
                            }
                            if ("orgfilter.name".equals(filterItemInfo.getPropName())) {
                                if (filterItemInfo.getCompareType().equals("is not null")) {
                                    filterItemInfo.setCompareType("like");
                                    filterItemInfo.setValue((Object)org.getString("name"));
                                } else if (!filterItemInfo.getCompareType().equals("!=") || !StringUtils.isBlank((String)filterItemInfo.getValue().toString())) {
                                    filterItemInfo.setValue((Object)org.getString("name"));
                                }
                                existBidOrgFlag = true;
                                continue;
                            }
                            if ("bidmode.id".equals(filterItemInfo.getPropName())) {
                                filterItemInfo.setValue(purMode.getPkValue());
                                existBidModeFlag = true;
                                continue;
                            }
                            if (!"bidmode.name".equals(filterItemInfo.getPropName())) continue;
                            filterItemInfo.setValue((Object)purMode.getString("name"));
                            existBidModeFlag = true;
                        }
                        if (!existBidModeFlag && purMode != null) {
                            FilterItemInfo purModeFilterItemInfo = new FilterItemInfo();
                            purModeFilterItemInfo.setPropName("bidmode.id");
                            purModeFilterItemInfo.setCompareType("in");
                            purModeFilterItemInfo.setValue(purMode.getPkValue());
                            filterItemList.add(purModeFilterItemInfo);
                        }
                        if (!existBidOrgFlag) {
                            FilterItemInfo filterItemInfo = new FilterItemInfo();
                            filterItemInfo.setPropName("orgfilter.id");
                            filterItemInfo.setCompareType("in");
                            filterItemInfo.setValue(org.getPkValue());
                            filterItemList.add(filterItemInfo);
                        }
                    }
                }
                Map customParam = reportQueryParam.getCustomParam();
                customParam.put("decitiontype", "crs");
            }
            showParameter.setQueryParam(reportQueryParam);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public String getAppId() {
        String formId = this.getView().getFormShowParameter().getFormId();
        String appId = formId.split("_")[0];
        return appId;
    }
}

