/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.report.efficiencydetail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.bid.formplugin.report.efficiencydetail.BidEfficiencyConst;

public class BidEfficiencyPurTypeEdit
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void beforeBindData(EventObject e) {
        this.getPageCache().put("billType", this.getView().getEntityId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        super.preProcessExportData(exportColumns, data, numberFormatProvider);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        if ("reportlistap".equals(gridPK)) {
            QFilter qFilter = this.getQFilter();
            if (!CollectionUtils.isEmpty((Collection)rowData)) {
                this.buildPurTypeData(rowData, qFilter);
            }
        }
        super.processRowData(gridPK, rowData, queryParam);
    }

    public QFilter getQFilter() {
        List filterItemList = this.getView().getQueryParam().getFilter().getFilterItems();
        QFilter qFilter = new QFilter("entitytypeid", "=", (Object)(this.getAppId() + "_report_data"));
        qFilter.and(new QFilter("decisionstatus", "=", (Object)"crs"));
        for (FilterItemInfo filterItemInfo : filterItemList) {
            if ("bidpurtype.id".equals(filterItemInfo.getPropName())) {
                qFilter.and(new QFilter("purtype.id", filterItemInfo.getCompareType(), filterItemInfo.getValue()));
                continue;
            }
            if ("bidpurtype.name".equals(filterItemInfo.getPropName())) {
                qFilter.and(new QFilter("purtype.name", filterItemInfo.getCompareType(), filterItemInfo.getValue()));
                continue;
            }
            if ("purmodel".equals(filterItemInfo.getPropName())) {
                qFilter.and(new QFilter("purmodel", filterItemInfo.getCompareType(), filterItemInfo.getValue()));
                continue;
            }
            if ("setupdate".equals(filterItemInfo.getPropName())) {
                QFilter setupDateQFilter = new QFilter("setupdate", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                setupDateQFilter.and(new QFilter("setupdate", filterItemInfo.getCompareType(), filterItemInfo.getValue()));
                qFilter.and(setupDateQFilter);
                continue;
            }
            if (!"decisiondate".equals(filterItemInfo.getPropName())) continue;
            QFilter decisionDateFilter = new QFilter("decisiondate", filterItemInfo.getCompareType(), filterItemInfo.getValue());
            decisionDateFilter.and(new QFilter("decisiondate", filterItemInfo.getCompareType(), filterItemInfo.getValue()));
            qFilter.and(decisionDateFilter);
        }
        return qFilter;
    }

    public void buildPurTypeData(DynamicObjectCollection rowDataList, QFilter qFilter) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (DynamicObject rowData : rowDataList) {
            DynamicObject org = rowData.getDynamicObject("org");
            if (org == null) continue;
            orgIdList.add(org.getLong("id"));
        }
        qFilter.and(new QFilter("org.id", "in", orgIdList));
        String selectFields = "org, null as orgname, realprojectperiod, 0 as totalnumber, 0 as avgperiod, 0 as consignavgperiod, purtype";
        DynamicObject[] reportDataCol = BusinessDataServiceHelper.load((String)(this.getAppId() + "_report_data"), (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, ArrayList<DynamicObject>> orgPurTypeMap = new HashMap<Long, ArrayList<DynamicObject>>(16);
        for (DynamicObject reportData : reportDataCol) {
            Long orgId = reportData.getDynamicObject("org").getLong("id");
            ArrayList<DynamicObject> orgPurTypeList = (ArrayList<DynamicObject>)orgPurTypeMap.get(orgId);
            if (!CollectionUtils.isEmpty((Collection)orgPurTypeList)) {
                orgPurTypeList.add(reportData);
            } else {
                orgPurTypeList = new ArrayList<DynamicObject>();
                orgPurTypeList.add(reportData);
            }
            orgPurTypeMap.put(orgId, orgPurTypeList);
        }
        Long sumTotalNumber = 0L;
        Long sumRealProjectPeriod = 0L;
        HashMap sumPurTypeMap = new HashMap();
        for (DynamicObject rowData : rowDataList) {
            DynamicObject org = rowData.getDynamicObject("org");
            Long currentOrgTotalNumber = 0L;
            Long currentOrgTotalRealProjectPeriod = 0L;
            if (org != null) {
                Long orgId = org.getLong("id");
                List orgPurTypeList = (List)orgPurTypeMap.get(orgId);
                if (!CollectionUtils.isEmpty((Collection)orgPurTypeList)) {
                    currentOrgTotalNumber = orgPurTypeList.size();
                    sumTotalNumber = sumTotalNumber + (long)orgPurTypeList.size();
                    Map<String, List<DynamicObject>> orgPurTypeGroupMap = orgPurTypeList.stream().filter(item -> null != item.getDynamicObject("purtype")).collect(Collectors.groupingBy(item -> item.getDynamicObject("purtype").getString("id")));
                    for (Map.Entry<String, List<DynamicObject>> orgPurTypeGroupMapData : orgPurTypeGroupMap.entrySet()) {
                        List<DynamicObject> orgPurTypeGroupList = orgPurTypeGroupMapData.getValue();
                        String purTypeId = orgPurTypeGroupMapData.getKey();
                        String tenderNumberKey = BidEfficiencyConst.TENDER_NUMBER_PREFIX + purTypeId;
                        String tenderPeriodKey = BidEfficiencyConst.TENDER_AVG_PERIOD_PREFIX + purTypeId;
                        String tenderProportionKey = BidEfficiencyConst.TENDER_NUMBER_PROPORTION_PREFIX + purTypeId;
                        HashMap<String, Long> sumPurTypeDetailMap = (HashMap<String, Long>)sumPurTypeMap.get(purTypeId);
                        if (sumPurTypeDetailMap == null) {
                            sumPurTypeDetailMap = new HashMap<String, Long>();
                        }
                        long currentPurTypeNumber = 0L;
                        BigDecimal currentPurTypeAvgPeriod = BigDecimal.ZERO;
                        Long currentPurTypeTotalProjectPeriod = 0L;
                        if (!CollectionUtils.isEmpty(orgPurTypeGroupList)) {
                            currentPurTypeNumber = orgPurTypeGroupList.size();
                            Long sumPurTypeNumber = (Long)sumPurTypeDetailMap.get(tenderNumberKey);
                            sumPurTypeNumber = sumPurTypeNumber != null ? Long.valueOf(sumPurTypeNumber + currentPurTypeNumber) : Long.valueOf(currentPurTypeNumber);
                            sumPurTypeDetailMap.put(tenderNumberKey, sumPurTypeNumber);
                            for (DynamicObject orgPurTypeGroup : orgPurTypeGroupList) {
                                Long realProjectPeriod = orgPurTypeGroup.getLong("realprojectperiod");
                                if (realProjectPeriod == null) continue;
                                currentPurTypeTotalProjectPeriod = currentPurTypeTotalProjectPeriod + realProjectPeriod;
                                currentOrgTotalRealProjectPeriod = currentOrgTotalRealProjectPeriod + realProjectPeriod;
                                sumRealProjectPeriod = sumRealProjectPeriod + realProjectPeriod;
                            }
                            Long purTypeTotalTenderPeriod = (Long)sumPurTypeDetailMap.get(tenderPeriodKey);
                            purTypeTotalTenderPeriod = purTypeTotalTenderPeriod != null ? Long.valueOf(purTypeTotalTenderPeriod + currentPurTypeTotalProjectPeriod) : currentPurTypeTotalProjectPeriod;
                            sumPurTypeDetailMap.put(tenderPeriodKey, purTypeTotalTenderPeriod);
                            currentPurTypeAvgPeriod = BigDecimal.valueOf(currentPurTypeTotalProjectPeriod).divide(BigDecimal.valueOf(currentPurTypeNumber), 2, 4);
                        }
                        double value = (double)currentPurTypeNumber / (double)currentOrgTotalNumber.longValue() * 100.0;
                        BigDecimal tenderProPortion = BigDecimal.valueOf(value).setScale(2, 4);
                        rowData.set(tenderNumberKey, (Object)currentPurTypeNumber);
                        rowData.set(tenderProportionKey, (Object)(tenderProPortion + "%"));
                        rowData.set(tenderPeriodKey, (Object)currentPurTypeAvgPeriod);
                        sumPurTypeMap.put(purTypeId, sumPurTypeDetailMap);
                    }
                }
                rowData.set("orgname", (Object)org.getString("name"));
                if (currentOrgTotalNumber > 0L) {
                    BigDecimal currentOrgBidAvgPeriod = BigDecimal.valueOf(currentOrgTotalRealProjectPeriod).divide(BigDecimal.valueOf(currentOrgTotalNumber), 2, 4);
                    rowData.set("avgperiod", (Object)currentOrgBidAvgPeriod);
                }
                rowData.set("totalnumber", (Object)currentOrgTotalNumber);
                continue;
            }
            rowData.set("orgname", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"BidEfficiencyPurTypeEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            rowData.set("totalnumber", (Object)sumTotalNumber);
            if (sumTotalNumber.intValue() > 0) {
                double value = (double)sumRealProjectPeriod.longValue() / (double)sumTotalNumber.longValue();
                BigDecimal sumBidAvgPeriod = BigDecimal.valueOf(value).setScale(2, 4);
                rowData.set("avgperiod", (Object)sumBidAvgPeriod);
            }
            for (Map.Entry sumPurTypeMapData : sumPurTypeMap.entrySet()) {
                double value;
                String key = (String)sumPurTypeMapData.getKey();
                Map sumPurTypeDetailMap = (Map)sumPurTypeMapData.getValue();
                if (CollectionUtils.isEmpty((Map)sumPurTypeDetailMap)) continue;
                String tenderNumberKey = BidEfficiencyConst.TENDER_NUMBER_PREFIX + key;
                String tenderAvgPeriodKey = BidEfficiencyConst.TENDER_AVG_PERIOD_PREFIX + key;
                String tenderProportionKey = BidEfficiencyConst.TENDER_NUMBER_PROPORTION_PREFIX + key;
                Long sumPurTypeNumber = (Long)sumPurTypeDetailMap.get(tenderNumberKey);
                Long sumPurTypePeriod = (Long)sumPurTypeDetailMap.get(tenderAvgPeriodKey);
                if (sumPurTypePeriod.intValue() > 0) {
                    value = (double)sumPurTypePeriod.longValue() / (double)sumPurTypeNumber.longValue();
                    BigDecimal sumPurTypeBidAvgPeriod = BigDecimal.valueOf(value).setScale(2, 4);
                    rowData.set(tenderAvgPeriodKey, (Object)sumPurTypeBidAvgPeriod);
                }
                if (sumTotalNumber.intValue() > 0) {
                    value = (double)sumPurTypeNumber.longValue() / (double)sumTotalNumber.longValue() * 100.0;
                    BigDecimal tenderProPortion = BigDecimal.valueOf(value).setScale(2, 4);
                    rowData.set(tenderProportionKey, (Object)(tenderProPortion + "%"));
                }
                rowData.set(tenderNumberKey, (Object)sumPurTypeNumber);
            }
        }
        Collections.sort(rowDataList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Long org1 = o1.getDynamicObject("org") != null ? o1.getDynamicObject("org").getLong("id") : 0L;
                Long org2 = o2.getDynamicObject("org") != null ? o2.getDynamicObject("org").getLong("id") : 0L;
                if (org1 == 0L) {
                    return 1;
                }
                if (org2 == 0L) {
                    return -1;
                }
                if (org1 > org2) {
                    return 1;
                }
                return 0;
            }
        });
        this.getPageCache().put("rowData", SerializationUtils.toJsonString((Object)rowDataList));
    }

    public double timeToDay(Long time) {
        if (time == null) {
            return 0.0;
        }
        Long day = 86400000L;
        return (double)time.longValue() / (double)day.longValue();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("totalnumber".equals(evt.getFieldName())) {
            ReportQueryParam reportQueryParam = this.getView().getQueryParam();
            ReportShowParameter showParameter = new ReportShowParameter();
            showParameter.setFormId(this.getAppId() + "_newdetailquery");
            if (reportQueryParam != null) {
                int rowIndex = evt.getRowIndex();
                ReportList billList = (ReportList)this.getView().getControl("reportlistap");
                DynamicObject rowData = billList.getReportModel().getRowData(rowIndex);
                DynamicObject org = rowData.getDynamicObject("org");
                if (org != null) {
                    List filterItemList = reportQueryParam.getFilter().getFilterItems();
                    if (CollectionUtils.isEmpty((Collection)filterItemList)) {
                        FilterItemInfo filterItemInfo = new FilterItemInfo();
                        filterItemInfo.setPropName("orgfilter.id");
                        filterItemInfo.setCompareType("in");
                        filterItemInfo.setValue(org.getPkValue());
                        filterItemList.add(filterItemInfo);
                    } else {
                        boolean existBidOrgFlag = false;
                        for (FilterItemInfo filterItemInfo : filterItemList) {
                            if ("orgfilter.id".equals(filterItemInfo.getPropName())) {
                                filterItemInfo.setValue(org.getPkValue());
                                existBidOrgFlag = true;
                                continue;
                            }
                            if (!"orgfilter.name".equals(filterItemInfo.getPropName())) continue;
                            if (filterItemInfo.getCompareType().equals("is not null")) {
                                filterItemInfo.setCompareType("like");
                                filterItemInfo.setValue((Object)org.getString("name"));
                            } else if (!filterItemInfo.getCompareType().equals("!=") || !StringUtils.isBlank((String)filterItemInfo.getValue().toString())) {
                                filterItemInfo.setValue((Object)org.getString("name"));
                            }
                            existBidOrgFlag = true;
                        }
                        if (!existBidOrgFlag) {
                            FilterItemInfo filterItemInfo = new FilterItemInfo();
                            filterItemInfo.setPropName("orgfilter.id");
                            filterItemInfo.setCompareType("in");
                            filterItemInfo.setValue(org.getPkValue());
                            filterItemList.add(filterItemInfo);
                        }
                    }
                }
                Map customParam = reportQueryParam.getCustomParam();
                customParam.put("decitiontype", "crs");
            }
            showParameter.setQueryParam(reportQueryParam);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (evt.getFieldName().contains(BidEfficiencyConst.TENDER_NUMBER_PREFIX)) {
            ReportQueryParam reportQueryParam = this.getView().getQueryParam();
            ReportShowParameter showParameter = new ReportShowParameter();
            showParameter.setFormId(this.getAppId() + "_newdetailquery");
            String[] typeIDs = evt.getFieldName().split("_");
            String typeid = null;
            if (typeIDs.length > 1) {
                typeid = typeIDs[1];
            }
            if (reportQueryParam != null) {
                List filterItemList;
                int rowIndex = evt.getRowIndex();
                ReportList billList = (ReportList)this.getView().getControl("reportlistap");
                DynamicObject rowData = billList.getReportModel().getRowData(rowIndex);
                DynamicObject org = rowData.getDynamicObject("org");
                if (org != null) {
                    filterItemList = reportQueryParam.getFilter().getFilterItems();
                    if (CollectionUtils.isEmpty((Collection)filterItemList)) {
                        FilterItemInfo filterItemInfo = new FilterItemInfo();
                        filterItemInfo.setPropName("orgfilter.id");
                        filterItemInfo.setCompareType("in");
                        filterItemInfo.setValue(org.getPkValue());
                        filterItemList.add(filterItemInfo);
                        if (typeid != null) {
                            FilterItemInfo filterItemInfotypr = new FilterItemInfo();
                            filterItemInfotypr.setPropName("bidpurtype.id");
                            filterItemInfotypr.setCompareType("in");
                            filterItemInfotypr.setValue((Object)Long.parseLong(typeid));
                            filterItemList.add(filterItemInfotypr);
                        }
                    } else {
                        boolean existBidOrgFlag = false;
                        for (FilterItemInfo filterItemInfo : filterItemList) {
                            if ("orgfilter.id".equals(filterItemInfo.getPropName())) {
                                filterItemInfo.setValue(org.getPkValue());
                                existBidOrgFlag = true;
                                continue;
                            }
                            if (!"orgfilter.name".equals(filterItemInfo.getPropName())) continue;
                            if (filterItemInfo.getCompareType().equals("is not null")) {
                                filterItemInfo.setCompareType("like");
                                filterItemInfo.setValue((Object)org.getString("name"));
                            } else if (!filterItemInfo.getCompareType().equals("!=") || !StringUtils.isBlank((String)filterItemInfo.getValue().toString())) {
                                filterItemInfo.setValue((Object)org.getString("name"));
                            }
                            existBidOrgFlag = true;
                        }
                        if (!existBidOrgFlag) {
                            FilterItemInfo filterItemInfo = new FilterItemInfo();
                            filterItemInfo.setPropName("orgfilter.id");
                            filterItemInfo.setCompareType("in");
                            filterItemInfo.setValue(org.getPkValue());
                            filterItemList.add(filterItemInfo);
                            if (typeid != null) {
                                FilterItemInfo filterItemInfotypr = new FilterItemInfo();
                                filterItemInfotypr.setPropName("bidpurtype.id");
                                filterItemInfotypr.setCompareType("in");
                                filterItemInfotypr.setValue((Object)Long.parseLong(typeid));
                                filterItemList.add(filterItemInfotypr);
                            }
                        }
                    }
                } else {
                    filterItemList = reportQueryParam.getFilter().getFilterItems();
                    if (typeid != null) {
                        FilterItemInfo filterItemInfotypr = new FilterItemInfo();
                        filterItemInfotypr.setPropName("bidpurtype.id");
                        filterItemInfotypr.setCompareType("in");
                        filterItemInfotypr.setValue((Object)Long.parseLong(typeid));
                        filterItemList.add(filterItemInfotypr);
                    }
                }
                Map customParam = reportQueryParam.getCustomParam();
                customParam.put("decitiontype", "crs");
            }
            showParameter.setQueryParam(reportQueryParam);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("qingview".equals(operateKey)) {
            String rowData = this.getPageCache().get("rowData");
            String appId = this.getAppId();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(appId + "_efficiency_typeqing");
            formShowParameter.setCustomParam("rowData", (Object)rowData);
            formShowParameter.setCustomParam("appId", (Object)appId);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(formShowParameter);
        }
    }

    public String getAppId() {
        String formId = this.getView().getFormShowParameter().getFormId();
        String appId = formId.split("_")[0];
        return appId;
    }
}

