/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.report.purmenoy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.bid.formplugin.report.purmenoy.BidPurprojectConst;

public class BidPurprojectTypeEdit
extends AbstractReportFormPlugin
implements FilterContainerInitListener,
HyperLinkClickListener,
ListRowClickListener {
    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            switch (filterColumn.getFieldName()) {
                case "currencycolum": {
                    filterColumn.setDefaultValue("1871091810676620288");
                }
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.getPageCache().put("billType", this.getView().getEntityId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("qingview".equals(operateKey)) {
            String appId = this.getAppId();
            String rowData = this.getPageCache().get("rowData");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(appId + "_purttypeqing");
            formShowParameter.setCustomParam("rowData", (Object)rowData);
            formShowParameter.setCustomParam("appId", (Object)appId);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm(formShowParameter);
        }
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        super.preProcessExportData(exportColumns, data, numberFormatProvider);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        if ("reportlistap".equals(gridPK)) {
            QFilter qFilter = this.getQFilter();
            if (!CollectionUtils.isEmpty((Collection)rowData)) {
                this.buildPurTypeData(rowData, qFilter);
            }
        }
        super.processRowData(gridPK, rowData, queryParam);
    }

    public QFilter getQFilter() {
        List filterItemList = this.getView().getQueryParam().getFilter().getFilterItems();
        QFilter qFilter = new QFilter("entitytypeid", "=", (Object)(this.getAppId() + "_report_data"));
        qFilter.and(new QFilter("decisionstatus", "=", (Object)"crs"));
        for (FilterItemInfo filterItemInfo : filterItemList) {
            if ("bidpurtype.id".equals(filterItemInfo.getPropName())) {
                qFilter.and(new QFilter("purtype.id", filterItemInfo.getCompareType(), filterItemInfo.getValue()));
                continue;
            }
            if ("bidpurtype.name".equals(filterItemInfo.getPropName())) {
                qFilter.and(new QFilter("purtype.name", filterItemInfo.getCompareType(), filterItemInfo.getValue()));
                continue;
            }
            if ("purmodel".equals(filterItemInfo.getPropName())) {
                qFilter.and(new QFilter("purmodel", filterItemInfo.getCompareType(), filterItemInfo.getValue()));
                continue;
            }
            if ("setupdate".equals(filterItemInfo.getPropName())) {
                QFilter setupDateQFilter = new QFilter("setupdate", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                setupDateQFilter.and(new QFilter("setupdate", filterItemInfo.getCompareType(), filterItemInfo.getValue()));
                qFilter.and(setupDateQFilter);
                continue;
            }
            if ("decisiondate".equals(filterItemInfo.getPropName())) {
                QFilter decisionDateFilter = new QFilter("decisiondate", filterItemInfo.getCompareType(), filterItemInfo.getValue());
                decisionDateFilter.and(new QFilter("decisiondate", filterItemInfo.getCompareType(), filterItemInfo.getValue()));
                qFilter.and(decisionDateFilter);
                continue;
            }
            if (!"currencycolum.id".equals(filterItemInfo.getPropName())) continue;
            QFilter currencyQFilter = new QFilter("currency", filterItemInfo.getCompareType(), filterItemInfo.getValue());
            qFilter.and(currencyQFilter);
        }
        return qFilter;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void buildPurTypeData(DynamicObjectCollection rowDataList, QFilter qFilter) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (DynamicObject rowData : rowDataList) {
            DynamicObject org = rowData.getDynamicObject("org");
            if (org == null) continue;
            orgIdList.add(org.getLong("id"));
        }
        qFilter.and(new QFilter("org.id", "in", orgIdList));
        String selectFields = "org, currency, org.orgname,  totalnumber, toltalfinalprice, totalprice,purtype";
        DynamicObject[] reportDataCol = BusinessDataServiceHelper.load((String)(this.getAppId() + "_report_data"), (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, ArrayList<DynamicObject>> orgPurTypeMap = new HashMap<Long, ArrayList<DynamicObject>>(16);
        for (DynamicObject reportData : reportDataCol) {
            Long orgId = reportData.getDynamicObject("org").getLong("id");
            ArrayList<DynamicObject> orgPurTypeList = (ArrayList<DynamicObject>)orgPurTypeMap.get(orgId);
            if (!CollectionUtils.isEmpty((Collection)orgPurTypeList)) {
                orgPurTypeList.add(reportData);
            } else {
                orgPurTypeList = new ArrayList<DynamicObject>();
                orgPurTypeList.add(reportData);
            }
            orgPurTypeMap.put(orgId, orgPurTypeList);
        }
        DynamicObject currency = null;
        if (reportDataCol != null && reportDataCol.length > 0) {
            currency = reportDataCol[0].getDynamicObject("currency");
        }
        Long sumTotalNumber = 0L;
        BigDecimal sumRealProjectPeriod = BigDecimal.ZERO;
        HashMap sumPurTypeMap = new HashMap();
        for (DynamicObject rowData : rowDataList) {
            DynamicObject org = rowData.getDynamicObject("org");
            Long currentOrgTotalNumber = 0L;
            BigDecimal currentOrgTotalTotalPrice = BigDecimal.ZERO;
            if (org != null) {
                Long orgId = org.getLong("id");
                List orgPurTypeList = (List)orgPurTypeMap.get(orgId);
                if (!CollectionUtils.isEmpty((Collection)orgPurTypeList)) {
                    currentOrgTotalNumber = orgPurTypeList.size();
                    currentOrgTotalTotalPrice = rowData.getBigDecimal("toltalfinalprice");
                    sumTotalNumber = sumTotalNumber + (long)orgPurTypeList.size();
                    rowData.set("totalprice", (Object)currentOrgTotalTotalPrice);
                    if (currentOrgTotalTotalPrice != null) {
                        sumRealProjectPeriod = sumRealProjectPeriod.add(currentOrgTotalTotalPrice).setScale(10, 5);
                    }
                    Map<String, List<DynamicObject>> orgPurTypeGroupMap = orgPurTypeList.stream().filter(item -> null != item.getDynamicObject("purtype")).collect(Collectors.groupingBy(item -> item.getDynamicObject("purtype").getString("id")));
                    for (Map.Entry<String, List<DynamicObject>> orgPurTypeGroupMapData : orgPurTypeGroupMap.entrySet()) {
                        List<DynamicObject> orgPurTypeGroupList = orgPurTypeGroupMapData.getValue();
                        String purTypeId = orgPurTypeGroupMapData.getKey();
                        String typeTotal = BidPurprojectConst.TENDER_PRO_NUMBER_PREFIX + purTypeId;
                        String typeproPreiod = BidPurprojectConst.TENDER_PRO_PERIOD_PREFIX + purTypeId;
                        String typeZhong = BidPurprojectConst.SUM_ZHONG_Money_PREFIX + purTypeId;
                        String typesumPro = BidPurprojectConst.SUM_PRO_PERIOD_PREFIX + purTypeId;
                        HashMap<String, Number> sumPurTypeDetailMap = (HashMap<String, Number>)sumPurTypeMap.get(purTypeId);
                        if (sumPurTypeDetailMap == null) {
                            sumPurTypeDetailMap = new HashMap<String, Number>();
                        }
                        long currentPurTypeNumber = 0L;
                        BigDecimal currentTotalPrice = BigDecimal.ZERO;
                        if (!CollectionUtils.isEmpty(orgPurTypeGroupList)) {
                            BigDecimal sumPurTypePrice;
                            Object bigDecimal;
                            currentPurTypeNumber = orgPurTypeGroupList.size();
                            Long sumPurTypeNumber = (Long)sumPurTypeDetailMap.get(typeTotal);
                            sumPurTypeNumber = sumPurTypeNumber != null ? Long.valueOf(sumPurTypeNumber + currentPurTypeNumber) : Long.valueOf(currentPurTypeNumber);
                            rowData.set(typeTotal, (Object)currentPurTypeNumber);
                            sumPurTypeDetailMap.put(typeTotal, sumPurTypeNumber);
                            if (currentOrgTotalNumber > 0L) {
                                bigDecimal = new BigDecimal(currentPurTypeNumber).divide(new BigDecimal(currentOrgTotalNumber), 4, 5);
                                bigDecimal = ((BigDecimal)bigDecimal).multiply(new BigDecimal(100)).setScale(2);
                                rowData.set(typeproPreiod, (Object)(((BigDecimal)bigDecimal).toString() + "%"));
                            }
                            for (DynamicObject orgPurTypeGroup : orgPurTypeGroupList) {
                                BigDecimal realToltalfinalprice = orgPurTypeGroup.getBigDecimal("toltalfinalprice");
                                if (realToltalfinalprice == null) continue;
                                currentTotalPrice = currentTotalPrice.add(realToltalfinalprice);
                            }
                            rowData.set(typeZhong, (Object)currentTotalPrice);
                            if (currentOrgTotalTotalPrice != null && currentOrgTotalTotalPrice.compareTo(BigDecimal.ZERO) != 0) {
                                bigDecimal = currentTotalPrice.divide(currentOrgTotalTotalPrice, 4, 5);
                                bigDecimal = ((BigDecimal)bigDecimal).multiply(new BigDecimal(100)).setScale(2);
                                rowData.set(typesumPro, (Object)(((BigDecimal)bigDecimal).toString() + "%"));
                            }
                            sumPurTypePrice = (sumPurTypePrice = (BigDecimal)sumPurTypeDetailMap.get(typeZhong)) != null ? sumPurTypePrice.add(currentTotalPrice).setScale(10, 5) : currentTotalPrice;
                            sumPurTypeDetailMap.put(typeZhong, sumPurTypePrice);
                        }
                        sumPurTypeMap.put(purTypeId, sumPurTypeDetailMap);
                    }
                }
                rowData.set("currency", (Object)currency);
                rowData.set("orgname", (Object)org.getString("name"));
                rowData.set("totalnumber", (Object)currentOrgTotalNumber);
                continue;
            }
            rowData.set("currency", (Object)currency);
            rowData.set("orgname", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"BidPurprojectTypeEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            rowData.set("totalnumber", (Object)sumTotalNumber);
            rowData.set("totalprice", (Object)sumRealProjectPeriod);
            for (Map.Entry sumPurTypeMapData : sumPurTypeMap.entrySet()) {
                BigDecimal bigDecimal;
                String key = (String)sumPurTypeMapData.getKey();
                Map sumPurTypeDetailMap = (Map)sumPurTypeMapData.getValue();
                if (CollectionUtils.isEmpty((Map)sumPurTypeDetailMap)) continue;
                String typeTotal = BidPurprojectConst.TENDER_PRO_NUMBER_PREFIX + key;
                String typeproPreiod = BidPurprojectConst.TENDER_PRO_PERIOD_PREFIX + key;
                String typeZhong = BidPurprojectConst.SUM_ZHONG_Money_PREFIX + key;
                String typesumPro = BidPurprojectConst.SUM_PRO_PERIOD_PREFIX + key;
                Long typeTotalLong = (Long)sumPurTypeDetailMap.get(typeTotal);
                BigDecimal typeZhongBig = (BigDecimal)sumPurTypeDetailMap.get(typeZhong);
                if (sumTotalNumber != null && sumTotalNumber > 0L && typeTotalLong != null) {
                    bigDecimal = new BigDecimal(typeTotalLong).divide(new BigDecimal(sumTotalNumber), 4, 5);
                    bigDecimal = bigDecimal.multiply(new BigDecimal(100)).setScale(2);
                    rowData.set(typeproPreiod, (Object)(bigDecimal.toString() + "%"));
                    rowData.set(typeTotal, (Object)typeTotalLong);
                }
                if (sumRealProjectPeriod == null || sumRealProjectPeriod.compareTo(BigDecimal.ZERO) == 0 || typeZhongBig == null) continue;
                bigDecimal = typeZhongBig.divide(sumRealProjectPeriod, 4, 5);
                bigDecimal = bigDecimal.multiply(new BigDecimal(100)).setScale(2);
                rowData.set(typesumPro, (Object)(bigDecimal.toString() + "%"));
                rowData.set(typeZhong, (Object)typeZhongBig);
            }
        }
        Collections.sort(rowDataList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Long org1 = o1.getDynamicObject("org") != null ? o1.getDynamicObject("org").getLong("id") : 0L;
                Long org2 = o2.getDynamicObject("org") != null ? o2.getDynamicObject("org").getLong("id") : 0L;
                if (org1 == 0L) {
                    return 1;
                }
                if (org2 == 0L) {
                    return -1;
                }
                if (org1 > org2) {
                    return 1;
                }
                return 0;
            }
        });
        this.getPageCache().put("rowData", SerializationUtils.toJsonString((Object)rowDataList));
    }

    public void makeToatalInfo() {
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        if ("totalnumber".equals(evt.getFieldName())) {
            if ("totalnumber".equals(evt.getFieldName())) {
                ReportQueryParam reportQueryParam = this.getView().getQueryParam();
                ReportShowParameter showParameter = new ReportShowParameter();
                showParameter.setFormId(this.getAppId() + "_newdetailquery");
                if (reportQueryParam != null) {
                    int rowIndex = evt.getRowIndex();
                    ReportList billList = (ReportList)this.getView().getControl("reportlistap");
                    DynamicObject rowData = billList.getReportModel().getRowData(rowIndex);
                    DynamicObject org = rowData.getDynamicObject("org");
                    if (org != null) {
                        List filterItemList = reportQueryParam.getFilter().getFilterItems();
                        if (CollectionUtils.isEmpty((Collection)filterItemList)) {
                            FilterItemInfo filterItemInfo = new FilterItemInfo();
                            filterItemInfo.setPropName("orgfilter.id");
                            filterItemInfo.setCompareType("in");
                            filterItemInfo.setValue(org.getPkValue());
                            filterItemList.add(filterItemInfo);
                        } else {
                            boolean existBidOrgFlag = false;
                            for (FilterItemInfo filterItemInfo : filterItemList) {
                                if ("orgfilter.id".equals(filterItemInfo.getPropName())) {
                                    filterItemInfo.setValue(org.getPkValue());
                                    existBidOrgFlag = true;
                                    continue;
                                }
                                if (!"orgfilter.name".equals(filterItemInfo.getPropName())) continue;
                                if (filterItemInfo.getCompareType().equals("is not null")) {
                                    filterItemInfo.setCompareType("like");
                                    filterItemInfo.setValue((Object)org.getString("name"));
                                } else if (!filterItemInfo.getCompareType().equals("!=") || !StringUtils.isBlank((String)filterItemInfo.getValue().toString())) {
                                    filterItemInfo.setValue((Object)org.getString("name"));
                                }
                                existBidOrgFlag = true;
                            }
                            if (!existBidOrgFlag) {
                                FilterItemInfo filterItemInfo = new FilterItemInfo();
                                filterItemInfo.setPropName("orgfilter.id");
                                filterItemInfo.setCompareType("in");
                                filterItemInfo.setValue(org.getPkValue());
                                filterItemList.add(filterItemInfo);
                            }
                        }
                    }
                    Map customParam = reportQueryParam.getCustomParam();
                    customParam.put("decitiontype", "crs");
                }
                showParameter.setQueryParam(reportQueryParam);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.ADDNEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if (evt.getFieldName().contains(BidPurprojectConst.TENDER_PRO_NUMBER_PREFIX)) {
            ReportQueryParam reportQueryParam = this.getView().getQueryParam();
            ReportShowParameter showParameter = new ReportShowParameter();
            showParameter.setFormId(this.getAppId() + "_newdetailquery");
            String[] typeIDs = evt.getFieldName().split("_");
            String typeid = null;
            if (typeIDs.length > 1) {
                typeid = typeIDs[1];
            }
            if (reportQueryParam != null) {
                List filterItemList;
                int rowIndex = evt.getRowIndex();
                ReportList billList = (ReportList)this.getView().getControl("reportlistap");
                DynamicObject rowData = billList.getReportModel().getRowData(rowIndex);
                DynamicObject org = rowData.getDynamicObject("org");
                if (org != null) {
                    filterItemList = reportQueryParam.getFilter().getFilterItems();
                    if (CollectionUtils.isEmpty((Collection)filterItemList)) {
                        FilterItemInfo filterItemInfo = new FilterItemInfo();
                        filterItemInfo.setPropName("orgfilter.id");
                        filterItemInfo.setCompareType("in");
                        filterItemInfo.setValue(org.getPkValue());
                        filterItemList.add(filterItemInfo);
                        if (typeid != null) {
                            FilterItemInfo filterItemInfotypr = new FilterItemInfo();
                            filterItemInfotypr.setPropName("bidpurtype.id");
                            filterItemInfotypr.setCompareType("in");
                            filterItemInfotypr.setValue((Object)Long.parseLong(typeid));
                            filterItemList.add(filterItemInfotypr);
                        }
                    } else {
                        boolean existBidOrgFlag = false;
                        for (FilterItemInfo filterItemInfo : filterItemList) {
                            if ("orgfilter.id".equals(filterItemInfo.getPropName())) {
                                filterItemInfo.setValue(org.getPkValue());
                                existBidOrgFlag = true;
                                continue;
                            }
                            if (!"orgfilter.name".equals(filterItemInfo.getPropName())) continue;
                            if (filterItemInfo.getCompareType().equals("is not null")) {
                                filterItemInfo.setCompareType("like");
                                filterItemInfo.setValue((Object)org.getString("name"));
                            } else if (!filterItemInfo.getCompareType().equals("!=") || !StringUtils.isBlank((String)filterItemInfo.getValue().toString())) {
                                filterItemInfo.setValue((Object)org.getString("name"));
                            }
                            existBidOrgFlag = true;
                        }
                        if (!existBidOrgFlag) {
                            FilterItemInfo filterItemInfo = new FilterItemInfo();
                            filterItemInfo.setPropName("orgfilter.id");
                            filterItemInfo.setCompareType("in");
                            filterItemInfo.setValue(org.getPkValue());
                            filterItemList.add(filterItemInfo);
                            if (typeid != null) {
                                FilterItemInfo filterItemInfotypr = new FilterItemInfo();
                                filterItemInfotypr.setPropName("bidpurtype.id");
                                filterItemInfotypr.setCompareType("in");
                                filterItemInfotypr.setValue((Object)Long.parseLong(typeid));
                                filterItemList.add(filterItemInfotypr);
                            }
                        }
                    }
                } else {
                    filterItemList = reportQueryParam.getFilter().getFilterItems();
                    if (typeid != null) {
                        FilterItemInfo filterItemInfotypr = new FilterItemInfo();
                        filterItemInfotypr.setPropName("bidpurtype.id");
                        filterItemInfotypr.setCompareType("in");
                        filterItemInfotypr.setValue((Object)Long.parseLong(typeid));
                        filterItemList.add(filterItemInfotypr);
                    }
                }
                Map customParam = reportQueryParam.getCustomParam();
                customParam.put("decitiontype", "crs");
            }
            showParameter.setQueryParam(reportQueryParam);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public String getAppId() {
        return "bid";
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
    }
}

