/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.util;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.bidcenter.IBidCenterService;
import kd.scm.bid.business.bidcenter.impl.BidCenterServiceImpl;
import kd.scm.bid.common.constant.entity.bidcenter.BidCenterConstant;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;

public class BidCenterCommonUtil {
    private IBidCenterService bidCenterService = new BidCenterServiceImpl();

    public String checkProjectPermission(Object id, String appId, Long userId) {
        String openFormId = appId + "_project";
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)id, (String)openFormId);
        if (bidProject == null) {
            return ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5728\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u6570\u636e\u3002", (String)"BidCenterCommonUtil_13", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        DynamicObject orgData = bidProject.getDynamicObject("org");
        long org = (Long)orgData.getPkValue();
        boolean hasBidCenterPermission = this.checkPermission("QXX0001", org, appId, "bid_bidcenter");
        if (!hasBidCenterPermission) {
            String tip = this.stepTipInfo("bid_bidcenter");
            return tip;
        }
        boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
        if (!isAdmin) {
            DynamicObject permissionMember = this.bidCenterService.getPermissionMember((Object)userId, id, "01");
            if (permissionMember == null) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u62db\u6807\u7acb\u9879\u7684\u4e1a\u52a1\u7ecf\u529e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            }
            String permisionCode = (String)BidCenterConstant.OPKEY_PERMISIONCODE_MAP.get("bidproject");
            boolean hasPermission = this.checkOpPermission(permisionCode, bidProject, openFormId, appId);
            if (!hasPermission) {
                String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get("bidproject");
                return tip;
            }
        }
        return "true";
    }

    public boolean checkOpPermission(String permisionCode, DynamicObject entity, String formId, String appId) {
        long orgId = (Long)entity.getDynamicObject("org").getPkValue();
        boolean orgHasPermission = PermissionUtils.checkPermission(permisionCode, orgId, appId, formId);
        DynamicObject entrustmentorgunit = entity.getDynamicObject("entrustmentorgunit");
        if (entrustmentorgunit == null) {
            return orgHasPermission;
        }
        Long entrustmentorgunitId = (Long)entrustmentorgunit.getPkValue();
        boolean entrustmentorgHasPermission = PermissionUtils.checkPermission(permisionCode, entrustmentorgunitId, appId, formId);
        return orgHasPermission || entrustmentorgHasPermission;
    }

    public boolean checkPermission(String number, Long orgId, String appId, String entityNum) {
        QFilter[] filter = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObject permissionObj = BusinessDataServiceHelper.loadSingle((String)"perm_permitem", (String)"id,number", (QFilter[])filter);
        int hasPermission = 0;
        if (permissionObj != null) {
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            String permItemId = permissionObj.get("id").toString();
            if (appId.equals("rebm")) {
                entityNum = this.replaceBeforeTip(entityNum);
            }
            hasPermission = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)appId, (String)entityNum, (String)permItemId);
        }
        return hasPermission == 1;
    }

    public String replaceBeforeTip(String step) {
        String name = null;
        if ("bid_project".equals(step)) {
            name = "rebm_project";
        } else if ("bid_supplierinvitation".equals(step)) {
            name = "rebm_supplierinvitation";
        } else if ("bid_biddocument_edit".equals(step)) {
            name = "rebm_biddocument_edit";
        } else if ("bid_bidpublish".equals(step)) {
            name = "rebm_bidpublish";
        } else if ("bid_answerquestion_reco".equals(step)) {
            name = "rebm_answerquestion_reco";
        } else if ("bid_bidopen".equals(step)) {
            name = "rebm_bidopen";
        } else if ("bid_bidevaluation".equals(step)) {
            name = "rebm_bidevaluation";
        } else if ("bid_bustalk".equals(step)) {
            name = "rebm_bustalk";
        } else if ("bid_decision".equals(step)) {
            name = "rebm_decision";
        } else if ("bid_bidcenter".equals(step)) {
            name = "rebm_bidcenter";
        }
        return name;
    }

    public String stepTipInfo(String step) {
        String tip = null;
        if ("bid_project".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_supplierinvitation".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_biddocument_edit".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_bidpublish".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_answerquestion_reco".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_bidopen".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_bidevaluation".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_bustalk".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_decision".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        } else if ("bid_bidcenter".equals(step)) {
            tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterCommonUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.stepName(step));
        }
        return tip;
    }

    public String stepName(String step) {
        String name = null;
        if ("bid_project".equals(step)) {
            name = ResManager.loadKDString((String)"\u62db\u6807\u7acb\u9879", (String)"BidCenterCommonUtil_3", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_supplierinvitation".equals(step)) {
            name = ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4", (String)"BidCenterCommonUtil_4", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_biddocument_edit".equals(step)) {
            name = ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236", (String)"BidCenterCommonUtil_5", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidpublish".equals(step)) {
            name = ResManager.loadKDString((String)"\u53d1\u6807", (String)"BidCenterCommonUtil_6", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_answerquestion_reco".equals(step)) {
            name = ResManager.loadKDString((String)"\u7b54\u7591", (String)"BidCenterCommonUtil_7", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidopen".equals(step)) {
            name = ResManager.loadKDString((String)"\u5f00\u6807", (String)"BidCenterCommonUtil_8", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidevaluation".equals(step)) {
            name = ResManager.loadKDString((String)"\u8bc4\u6807", (String)"BidCenterCommonUtil_9", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bustalk".equals(step)) {
            name = ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224", (String)"BidCenterCommonUtil_10", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_decision".equals(step)) {
            name = ResManager.loadKDString((String)"\u5b9a\u6807", (String)"BidCenterCommonUtil_11", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else if ("bid_bidcenter".equals(step)) {
            name = ResManager.loadKDString((String)"\u62db\u6807\u4e2d\u5fc3", (String)"BidCenterCommonUtil_12", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        }
        return name;
    }
}

