/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidTransferUtil {
    private String appid;

    public BidTransferUtil() {
    }

    public BidTransferUtil(String appid) {
        this.appid = appid;
    }

    public boolean checkIsBidAdmin(Object userId) {
        return QueryServiceHelper.exists((String)"perm_userrole", (QFilter[])new QFilter[]{new QFilter("user", "=", userId), new QFilter("role", "=", (Object)this.getBidAdminRoleIdByAppId())});
    }

    public String getBidAdminRoleIdByAppId() {
        return "bid".equalsIgnoreCase(this.appid) ? "/FFXFSRKI73+" : "/V6OAY0JH+8R";
    }

    public static List<QFilter> getQfilterList(DynamicObject dataEntity) {
        Date endDate;
        Date startDate;
        DynamicObjectCollection mulBidMode;
        DynamicObjectCollection mulPurType;
        DynamicObjectCollection mulPurOrg;
        DynamicObjectCollection mulProject;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(16);
        DynamicObject oldMenber = dataEntity.getDynamicObject("oldmenber");
        if (oldMenber != null) {
            filterList.add(new QFilter("memberentity.user", "=", oldMenber.getPkValue()).or(new QFilter("memberleaderentity.userleader", "=", oldMenber.getPkValue())));
        }
        if ((mulProject = dataEntity.getDynamicObjectCollection("mulpurproject")) != null && mulProject.size() > 0) {
            filterList.add(new QFilter("bidsection.projectentry.purentryproject", "in", BidTransferUtil.getMulBaseDataIds(mulProject)));
        }
        if ((mulPurOrg = dataEntity.getDynamicObjectCollection("mulpurorg")) != null && mulPurOrg.size() > 0) {
            filterList.add(new QFilter("org", "in", BidTransferUtil.getMulBaseDataIds(mulPurOrg)));
        }
        if ((mulPurType = dataEntity.getDynamicObjectCollection("mulpurtype")) != null && mulPurType.size() > 0) {
            filterList.add(new QFilter("purtype", "in", BidTransferUtil.getMulBaseDataIds(mulPurType)));
        }
        if ((mulBidMode = dataEntity.getDynamicObjectCollection("mulbidmode")) != null && mulBidMode.size() > 0) {
            filterList.add(new QFilter("bidmode", "in", BidTransferUtil.getMulBaseDataIds(mulBidMode)));
        }
        if ((startDate = dataEntity.getDate("startdate")) != null) {
            filterList.add(new QFilter("setupdate", ">=", (Object)startDate));
        }
        if ((endDate = dataEntity.getDate("enddate")) != null) {
            filterList.add(new QFilter("setupdate", "<=", (Object)endDate));
        }
        return filterList;
    }

    public static List<Object> getMulBaseDataIds(DynamicObjectCollection mulBaseData) {
        return mulBaseData.stream().filter(basedata -> basedata.getDynamicObject("fbasedataid") != null).map(basedata -> basedata.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
    }

    public static List<Object> getTransferAllUsers(DynamicObject dataEntity) {
        long transferee = dataEntity.getLong("transferee");
        long newMember = dataEntity.getLong("newmenber");
        return Arrays.asList(transferee, newMember);
    }

    public void openTransferEdit(IFormView view, Object bidProjectId) {
        boolean existsAdjust;
        if (bidProjectId != null && (existsAdjust = QueryServiceHelper.exists((String)(this.appid + "_adjustmentrecord"), (QFilter[])new QFilter[]{new QFilter("projectid", "=", bidProjectId), new QFilter("billstatus", "!=", (Object)"C")}))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u5b58\u5728\u672a\u5904\u7406\u7684\u7acb\u9879\u8c03\u6574\u5355\uff0c\u8bf7\u5904\u7406\u540e\u518d\u8f6c\u529e\u3002", (String)"BidTransferUtil_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(this.appid + "_bidtransfer");
        formShowParameter.setCustomParam("bidProjectId", bidProjectId);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        view.showForm((FormShowParameter)formShowParameter);
    }

    public void openTransferList(IFormView view, Object bidProjectId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(this.appid + "_bidtransfer");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCustomParam("bidProjectId", bidProjectId);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static Map<String, String> getFormIdByCurrentStep(String appId) {
        HashMap<String, String> formIdMap = new HashMap<String, String>(16);
        formIdMap.put("BidProject", appId + "_project");
        formIdMap.put("SupplierInvitation", appId + "_supplierinvitation");
        formIdMap.put("BidDocument", appId + "_biddocument_edit");
        formIdMap.put("Clarificaiton", appId + "_clarificaiton");
        formIdMap.put("BidPublish", appId + "_bidpublish");
        formIdMap.put("BidAnswerQuestion", appId + "_answerquestion");
        formIdMap.put("BidOpen", appId + "_bidopen");
        formIdMap.put("BidEvaluation", appId + "_bidevaluation");
        formIdMap.put("BidBustalk", appId + "_bustalk");
        formIdMap.put("BidDecision", appId + "_decision");
        return formIdMap;
    }

    public static String getCurrentStepStatus(DynamicObject bidProject, String appId) {
        String currentStep = bidProject.getString("currentstep");
        if (currentStep == null) {
            return null;
        }
        String[] steps = currentStep.split(",");
        StringBuilder sb = new StringBuilder();
        for (String step : steps) {
            String formId = BidTransferUtil.getFormIdByCurrentStep(appId).get(step);
            if (formId == null) continue;
            DynamicObjectCollection bills = QueryServiceHelper.query((String)formId, (String)"billstatus", (QFilter[])new QFilter[]{new QFilter(formId.endsWith("_project") ? "id" : "bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "!=", (Object)"XX")}, (String)"id");
            if (bills == null || bills.size() == 0) continue;
            if (formId.endsWith("_bustalk")) {
                DynamicObject bill2 = (DynamicObject)bills.get(bills.size() - 1);
                String billstatus = bill2.getString("billstatus");
                String s = BidTransferUtil.getChinneseStatus().get(billstatus);
                if (s == null) continue;
                sb.append(s);
                sb.append(',');
                continue;
            }
            bills.forEach(bill -> {
                String billstatus = bill.getString("billstatus");
                String s = BidTransferUtil.getChinneseStatus().get(billstatus);
                if (s == null) {
                    return;
                }
                sb.append(s);
                sb.append(',');
            });
        }
        String result = sb.toString();
        return StringUtils.isBlank((CharSequence)result) ? null : result.substring(0, result.lastIndexOf(44));
    }

    public static Map<String, String> getChinneseStatus() {
        HashMap<String, String> chineseStatusMap = new HashMap<String, String>(16);
        chineseStatusMap.put(BillStatusEnum.SAVE.getVal(), BillStatusEnum.SAVE.getAlias());
        chineseStatusMap.put(BillStatusEnum.DISBEGIN.getVal(), BillStatusEnum.DISBEGIN.getAlias());
        chineseStatusMap.put(BillStatusEnum.SUBMIT.getVal(), BillStatusEnum.SUBMIT.getAlias());
        chineseStatusMap.put(BillStatusEnum.AUDITING.getVal(), BillStatusEnum.AUDITING.getAlias());
        chineseStatusMap.put(BillStatusEnum.AUDITED.getVal(), BillStatusEnum.AUDITED.getAlias());
        chineseStatusMap.put(BillStatusEnum.PUBLISHED.getVal(), BillStatusEnum.PUBLISHED.getAlias());
        chineseStatusMap.put(BillStatusEnum.OPEN.getVal(), BillStatusEnum.OPEN.getAlias());
        chineseStatusMap.put(BillStatusEnum.SIGNED.getVal(), BillStatusEnum.SIGNED.getAlias());
        chineseStatusMap.put(BillStatusEnum.PARTSIGNED.getVal(), BillStatusEnum.PARTSIGNED.getAlias());
        chineseStatusMap.put(BillStatusEnum.INVALID.getVal(), BillStatusEnum.INVALID.getAlias());
        chineseStatusMap.put(BillStatusEnum.ADJUSTING.getVal(), BillStatusEnum.ADJUSTING.getAlias());
        chineseStatusMap.put(BillStatusEnum.ENDED.getVal(), BillStatusEnum.ENDED.getAlias());
        chineseStatusMap.put(BillStatusEnum.QUESTIONING.getVal(), BillStatusEnum.QUESTIONING.getAlias());
        chineseStatusMap.put(BillStatusEnum.RELEASED.getVal(), BillStatusEnum.RELEASED.getAlias());
        chineseStatusMap.put(BillStatusEnum.UNRELEASED.getVal(), BillStatusEnum.UNRELEASED.getAlias());
        chineseStatusMap.put(BillStatusEnum.COMPLETE.getVal(), BillStatusEnum.COMPLETE.getAlias());
        chineseStatusMap.put(BillStatusEnum.INVALIDXX.getVal(), BillStatusEnum.INVALIDXX.getAlias());
        chineseStatusMap.put(BillStatusEnum.INOPEN.getVal(), BillStatusEnum.INOPEN.getAlias());
        return chineseStatusMap;
    }

    public static boolean isHasUnfinishedbidTransfer(Object bidProjectId, String appId) {
        return QueryServiceHelper.exists((String)(appId + "_bidtransfer"), (QFilter[])new QFilter[]{new QFilter("bidprojectid", "=", bidProjectId).or(new QFilter("transferentry.entry_bidproject.id", "=", bidProjectId)), new QFilter("billstatus", "!=", (Object)"C")});
    }
}

