/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.verification;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.scm.bid.formplugin.verification.VerificationSupplierEntity;

public class SupplierUserVerificationList
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("submit".equals(operateKey)) {
            String submitCacheFlag = this.getPageCache().get("submitCache");
            if (StringUtils.isNotEmpty((String)submitCacheFlag) && "1".equals(submitCacheFlag)) {
                return;
            }
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0 || selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u63d0\u4ea4\u3002", (String)"SupplierUserVerificationList_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String entityId = ((IListView)this.getView()).getBillFormId();
            String appId = entityId.split("_")[0];
            Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)entityId);
            if (entityId.endsWith("supplierinvitation")) {
                String yqhCheck = this.getPageCache().get("yqhCheck");
                String yqhCheckResult = this.getPageCache().get("yqhCheckResult");
                if (StringUtils.isNotEmpty((String)yqhCheck) && !"1".equals(yqhCheckResult)) {
                    args.setCancel(true);
                    return;
                }
            }
            HashMap<Object, DynamicObject> supplierBizPartnerMap = null;
            supplierBizPartnerMap = entityId.endsWith("project") ? this.getSupplierBizPartner(appId, "bidrollsection", dataEntity) : this.getSupplierBizPartner(appId, "bidsection", dataEntity);
            if (!supplierBizPartnerMap.isEmpty()) {
                this.checkData(appId, entityId, dataEntity, supplierBizPartnerMap, args);
            }
        }
    }

    public void checkData(String appId, String entityId, DynamicObject dataEntity, HashMap<Object, DynamicObject> supplierBizPartnerMap, BeforeDoOperationEventArgs args) {
        DynamicObject[] bizPartnerUserArray;
        ArrayList<VerificationSupplierEntity> vSupplierEntityList = new ArrayList<VerificationSupplierEntity>();
        for (DynamicObject bizPartnerUser : bizPartnerUserArray = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"user,bizpartner", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", supplierBizPartnerMap.keySet()), new QFilter("enable", "=", (Object)"1")})) {
            DynamicObject user = bizPartnerUser.getDynamicObject("user");
            DynamicObject bizPartner = bizPartnerUser.getDynamicObject("bizpartner");
            if (bizPartner == null || user == null) continue;
            DynamicObject supplier = supplierBizPartnerMap.get(bizPartner.getPkValue());
            VerificationSupplierEntity verSupEntity = new VerificationSupplierEntity();
            verSupEntity.setSupplierId(supplier.getLong("id"));
            verSupEntity.setSupplierName(supplier.getString("name"));
            verSupEntity.setUserId(user.getLong("id"));
            verSupEntity.setBizPartnerId(bizPartner.getLong("id"));
            verSupEntity.setName(user.getString("name"));
            verSupEntity.setUserName(user.getString("username"));
            verSupEntity.setPhone(user.getString("phone"));
            verSupEntity.setEmail(user.getString("email"));
            verSupEntity.setEnable(user.getString("enable"));
            vSupplierEntityList.add(verSupEntity);
        }
        Map<Long, List<VerificationSupplierEntity>> verSupGroupMap = vSupplierEntityList.stream().collect(Collectors.groupingBy(VerificationSupplierEntity::getUserId));
        ArrayList<VerificationSupplierEntity> resultList = new ArrayList<VerificationSupplierEntity>();
        for (Map.Entry<Long, List<VerificationSupplierEntity>> verSupGroupData : verSupGroupMap.entrySet()) {
            List<VerificationSupplierEntity> verSupList = verSupGroupData.getValue();
            if (verSupList.size() <= 1) continue;
            resultList.addAll(verSupList);
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            args.setCancel(true);
            FormShowParameter formShowParameter = new FormShowParameter();
            if ("bid".equals(appId)) {
                formShowParameter.setFormId("bid_monument");
            } else {
                formShowParameter.setFormId("rebm_monument");
            }
            formShowParameter.setHasRight(true);
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            formShowParameter.setOpenStyle(openStyle);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setCustomParam("dataList", (Object)JSON.toJSONString(resultList));
            formShowParameter.setCustomParam("appId", (Object)appId);
            formShowParameter.setCustomParam("bizSource", (Object)entityId);
            formShowParameter.setCustomParam("dataId", dataEntity.getPkValue());
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "submitCloseCallBack"));
            this.getView().showForm(formShowParameter);
            return;
        }
    }

    public HashMap<Object, DynamicObject> getSupplierBizPartner(String appId, String sectionFiled, DynamicObject dataEntity) {
        HashMap<Object, DynamicObject> supplierBizPartnerMap;
        block4: {
            DynamicObject[] bdSupplierArray;
            DynamicObject bizPartner;
            TreeSet<Object> supplierIdSet;
            block5: {
                DynamicObject[] resmSupplierArray;
                supplierBizPartnerMap = new HashMap<Object, DynamicObject>();
                supplierIdSet = new TreeSet<Object>();
                DynamicObjectCollection bidRollSectionCol = dataEntity.getDynamicObjectCollection(sectionFiled);
                for (DynamicObject bidRollSection : bidRollSectionCol) {
                    DynamicObjectCollection supplierEntryCol = bidRollSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null) continue;
                        supplierIdSet.add(supplier.getPkValue());
                    }
                }
                if (supplierIdSet.isEmpty() || supplierIdSet.size() <= 1) break block4;
                if (!"rebm".equals(appId)) break block5;
                for (DynamicObject resmSupplier : resmSupplierArray = BusinessDataServiceHelper.load((String)"resm_official_supplier", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIdSet)})) {
                    bizPartner = resmSupplier.getDynamicObject("bizpartner");
                    if (bizPartner == null) continue;
                    supplierBizPartnerMap.put(bizPartner.getPkValue(), resmSupplier);
                }
                break block4;
            }
            if (!"bid".equals(appId)) break block4;
            for (DynamicObject bdSupplier : bdSupplierArray = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"name,bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIdSet)})) {
                bizPartner = bdSupplier.getDynamicObject("bizpartner");
                if (bizPartner == null) continue;
                supplierBizPartnerMap.put(bizPartner.getPkValue(), bdSupplier);
            }
        }
        return supplierBizPartnerMap;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String returnData = (String)event.getReturnData();
        if ("submitCloseCallBack".equals(event.getActionId())) {
            if ("confirm".equals(returnData)) {
                this.getPageCache().put("submitCache", "1");
                this.getView().invokeOperation("submit");
            } else {
                this.getPageCache().put("yqhCheckResult", "0");
            }
        }
    }

    public String getAppId() {
        return ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
    }
}

