/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.bid.business.bill.IBidBustalkService;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidBustalkServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.bid.common.util.MyTenderStatusUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.BidBustalkUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class BidDecisionOperationServicePlugin
extends AbstractOperationServicePlugIn {
    private IBidDecisionService service = new BidDecisionServiceImpl();
    private IBidProjectService bidProjectService = new BidProjectServiceImpl();
    private IBidBustalkService bidBustalkService = new BidBustalkServiceImpl();
    private BidBustalkUtil bidBustalkUtil = new BidBustalkUtil();
    private IBidProjectService projectService = new BidProjectServiceImpl();

    public void onAddValidators(AddValidatorsEventArgs e) {
        Validator4BidDecision validator = new Validator4BidDecision();
        e.addValidator((AbstractValidator)validator);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("sectionname");
        e.getFieldKeys().add("supplierentry");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("finalprice");
        e.getFieldKeys().add("isrecommended");
        e.getFieldKeys().add("finalvat");
        e.getFieldKeys().add("finalexceptvat");
        e.getFieldKeys().add("tenderprice");
        e.getFieldKeys().add("tendervat");
        e.getFieldKeys().add("tenderexceptvat");
        e.getFieldKeys().add("supplierentry.finalrate");
        e.getFieldKeys().add("supplierentry.finaltaxrate");
        e.getFieldKeys().add("supplierentry.tendertaxrate");
        e.getFieldKeys().add("supfinaldetail.lcostrate");
        e.getFieldKeys().add("supfinaldetail.ltaxrate");
        e.getFieldKeys().add("supplierentry.rate");
        e.getFieldKeys().add("supbackdetail.costrate");
        e.getFieldKeys().add("supbackdetail.taxrate");
        e.getFieldKeys().add("bidproject.bidbottommake");
        e.getFieldKeys().add("entitytypeid");
        e.getFieldKeys().add("bidsection");
        e.getFieldKeys().add("supplierentry");
        e.getFieldKeys().add("supfinaldetail.lpursupplier");
        e.getFieldKeys().add("supfinaldetail.lmaterialid");
        e.getFieldKeys().add("supfinaldetail.lqty");
        e.getFieldKeys().add("supfinaldetail.lmaterialdes");
        e.getFieldKeys().add("xkpurorderbillno");
        e.getFieldKeys().add("datasource");
        e.getFieldKeys().add("synxkflag");
        e.getFieldKeys().add("supfinaldetail.lresourceitem");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        List dataEntities = e.getValidExtDataEntities();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                String billstatus = dataEntity.getDataEntity().getString("billstatus");
                if (!"D".equals(billstatus) && !"A".equals(billstatus)) continue;
                dataEntity.setValue("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
            HashMap<Long, Integer> dataMap = new HashMap<Long, Integer>();
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities == null) {
                return;
            }
            DynamicObject[] dynamicObjectArray = dataEntities;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject dataEntity = dynamicObjectArray[i];
                dataEntity = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getLong("id"), (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()));
                DynamicObjectCollection sections = dataEntity.getDynamicObjectCollection("bidsection");
                for (DynamicObject section : sections) {
                    DynamicObjectCollection supplierEntrys = section.getDynamicObjectCollection("supplierentry");
                    for (int i2 = 0; i2 < supplierEntrys.size(); ++i2) {
                        DynamicObject supplierEntry = (DynamicObject)supplierEntrys.get(i2);
                        Boolean isRecommended = supplierEntry.getBoolean("isrecommended");
                        if (!isRecommended.booleanValue()) continue;
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        Long supplierId = supplier.getLong("id");
                        Integer num = -1;
                        if (dataMap.containsKey(supplierId)) {
                            num = num + dataMap.getOrDefault(supplierId, 0);
                        }
                        dataMap.put(supplierId, num);
                    }
                }
            }
            String appId = this.billEntityType.getAppId();
            if (!CollectionUtils.isEmpty(dataMap)) {
                this.service.insertRecommendStatisticSubOne(dataMap, appId + "_supplierstatistic");
            }
        }
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key) || StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities == null) {
                return;
            }
            for (DynamicObject dataEntity : dataEntities) {
                String isFromEdit;
                Map variables;
                boolean inProcess;
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                    for (DynamicObject data : dataEntities) {
                        DynamicObject answer;
                        DynamicObject project = data.getDynamicObject("bidproject");
                        long projectId = project.getLong("id");
                        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                        Date date = new Date();
                        BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)project, (BidStepEnum)BidStepEnum.BidAnswerQuestion);
                        DynamicObject bustalk = this.bidBustalkService.findMaxJudgenumBustalk(Long.valueOf(projectId));
                        if (null != bustalk) {
                            bustalk = this.bidBustalkService.getBustalkById(Long.valueOf(bustalk.getLong("id")));
                        }
                        if (null == nextStep || (BidStepEnum.BidBustalk != nextStep[0] || null == bustalk || bustalk.getInt("judge_num") != 0 || bustalk.get("auditor") != null) && BidStepEnum.BidDecision != nextStep[0] || (answer = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"answerquestion", ((Object)((Object)this)).getClass()), (String)"billstatus,realanswertime,modifytime,modifier,auditor,auditdate", (QFilter[])new QFilter[]{qFilter})) == null) continue;
                        answer.set("realanswertime", (Object)date);
                        answer.set("billstatus", (Object)BillStatusEnum.COMPLETE.getVal());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{answer});
                        this.projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.BidDecision});
                    }
                }
                if (!(inProcess = WorkflowServiceHelper.inProcess((String)dataEntity.getPkValue().toString()))) {
                    String isFromList;
                    variables = this.getOption().getVariables();
                    if (variables.get("form") == null || "List".equals(isFromList = this.getOption().getVariableValue("form"))) continue;
                    this.updateAllRateEntityData(dataEntity);
                    continue;
                }
                variables = this.getOption().getVariables();
                if (variables.get("form") == null || !"edit".equals(isFromEdit = this.getOption().getVariableValue("form"))) continue;
                this.updateAllRateEntityData(dataEntity);
            }
        }
    }

    protected void updateAllRateEntityData(DynamicObject dataEntity) {
        DynamicObjectCollection bidSectionColl1 = dataEntity.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidSectionColl1.size(); ++i) {
            DynamicObjectCollection supplierBackentry1;
            DynamicObjectCollection supplierFinalentry1;
            DynamicObjectCollection supplierentry1 = ((DynamicObject)bidSectionColl1.get(i)).getDynamicObjectCollection("supplierentry");
            if (supplierentry1 != null && supplierentry1.size() > 0) {
                for (int j = 0; j < supplierentry1.size(); ++j) {
                    ((DynamicObject)supplierentry1.get(j)).set("finaltaxrate", (Object)((DynamicObject)supplierentry1.get(j)).getBigDecimal("finaltaxrate").divide(new BigDecimal("100")));
                    ((DynamicObject)supplierentry1.get(j)).set("tendertaxrate", (Object)((DynamicObject)supplierentry1.get(j)).getBigDecimal("tendertaxrate").divide(new BigDecimal("100")));
                    ((DynamicObject)supplierentry1.get(j)).set("finalrate", (Object)((DynamicObject)supplierentry1.get(j)).getBigDecimal("finalrate").divide(new BigDecimal("100")));
                    ((DynamicObject)supplierentry1.get(j)).set("rate", (Object)((DynamicObject)supplierentry1.get(j)).getBigDecimal("rate").divide(new BigDecimal("100")));
                }
            }
            if ((supplierFinalentry1 = ((DynamicObject)bidSectionColl1.get(i)).getDynamicObjectCollection("supfinaldetail")) != null && supplierFinalentry1.size() > 0) {
                for (int j = 0; j < supplierFinalentry1.size(); ++j) {
                    ((DynamicObject)supplierFinalentry1.get(j)).set("lcostrate", (Object)((DynamicObject)supplierFinalentry1.get(j)).getBigDecimal("lcostrate").divide(new BigDecimal("100")));
                    ((DynamicObject)supplierFinalentry1.get(j)).set("ltaxrate", (Object)((DynamicObject)supplierFinalentry1.get(j)).getBigDecimal("ltaxrate").divide(new BigDecimal("100")));
                }
            }
            if ((supplierBackentry1 = ((DynamicObject)bidSectionColl1.get(i)).getDynamicObjectCollection("supbackdetail")) == null || supplierBackentry1.size() <= 0) continue;
            for (int j = 0; j < supplierBackentry1.size(); ++j) {
                ((DynamicObject)supplierBackentry1.get(j)).set("taxrate", (Object)((DynamicObject)supplierBackentry1.get(j)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                ((DynamicObject)supplierBackentry1.get(j)).set("costrate", (Object)((DynamicObject)supplierBackentry1.get(j)).getBigDecimal("costrate").divide(new BigDecimal("100")));
            }
        }
    }

    private void changeAnswerQuesData(DynamicObject data) {
        BidProjectServiceImpl projectService = new BidProjectServiceImpl();
        DynamicObject project = data.getDynamicObject("bidproject");
        Long projectId = project.getLong("id");
        DynamicObject tempProject = projectService.getBidProjectById(projectId, "answerquestiontime");
        Date date = new Date();
        Date answerQuestionTime = tempProject.getDate("answerquestiontime");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
        DynamicObject answer = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"answerquestion", ((Object)((Object)this)).getClass()), (String)"billstatus,realanswertime,modifytime,modifier,auditor,auditdate", (QFilter[])new QFilter[]{qFilter});
        if (answer != null) {
            if (answerQuestionTime == null || formatter.format(date).compareTo(formatter.format(answerQuestionTime)) < 0) {
                answer.set("billstatus", (Object)BillStatusEnum.QUESTIONING.getVal());
            } else if (answerQuestionTime != null && formatter.format(date).compareTo(formatter.format(answerQuestionTime)) >= 0) {
                answer.set("billstatus", (Object)BillStatusEnum.ENDED.getVal());
            }
            answer.set("realanswertime", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{answer});
            projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.BidAnswerQuestion});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        HashSet<Object> supplierSet;
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)key)) {
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject dynamicObject = dataEntities[i];
                DynamicObject bidProject = dynamicObject.getDynamicObject("bidproject");
                String appId = this.billEntityType.getAppId();
                this.bidBustalkUtil.deleteDecision(bidProject, appId);
            }
        } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
            HashMap<Long, Object> dataMap = new HashMap<Long, Object>();
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObject[] sections = dataEntity.getDynamicObjectCollection("bidsection");
                for (DynamicObject section : sections) {
                    DynamicObjectCollection supplierEntrys = section.getDynamicObjectCollection("supplierentry");
                    for (int i = 0; i < supplierEntrys.size(); ++i) {
                        void var18_77;
                        DynamicObject supplierEntry = (DynamicObject)supplierEntrys.get(i);
                        DynamicObject[] isRecommended = Boolean.valueOf(supplierEntry.getBoolean("isrecommended"));
                        if (!isRecommended.booleanValue()) continue;
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        Long supplierId = supplier.getLong("id");
                        Integer n = 1;
                        if (dataMap.containsKey(supplierId)) {
                            Integer n2 = n + dataMap.getOrDefault(supplierId, 0);
                        }
                        dataMap.put(supplierId, var18_77);
                    }
                }
            }
            String string = this.billEntityType.getAppId();
            this.service.insertRecommendStatisticaddOne(dataMap, string + "_supplierstatistic");
        }
        if ("audit".equals(key) || "unaudit".equals(key)) {
            DynamicObject[] myTenderArr;
            HashSet<Long> bidProjectIDSet = new HashSet<Long>();
            for (DynamicObject bidDecision : dataEntities) {
                bidProjectIDSet.add((Long)bidDecision.getDynamicObject("bidproject").getPkValue());
            }
            String string = this.billEntityType.getAppId();
            boolean enable = SystemParamHelper.getSystemParameter((String)string, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
            if (!enable && "audit".equals(key)) {
                String selectFields = "bidproject,supplier,entry,entry.sectionname,entry.projectsection,entry.sectionstatus,ispublicbid,tenderstatus";
                myTenderArr = BusinessDataServiceHelper.load((String)("bid".equals(string) ? "ten_mytender" : "resp_mytender"), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet), new QFilter("tenderstatus", "in", (Object)MyTenderStatusUtil.getPreviousValidStatus((MyTenderStatus)MyTenderStatus.DECIDED))});
                if (myTenderArr.length > 0) {
                    for (DynamicObject bidDecision : dataEntities) {
                        Long bidProjectID = (Long)bidDecision.getDynamicObject("bidproject").getPkValue();
                        ArrayList<DynamicObject> targetMyTenderArr = new ArrayList<DynamicObject>();
                        for (DynamicObject dynamicObject : myTenderArr) {
                            if (bidProjectID.compareTo((Long)dynamicObject.getDynamicObject("bidproject").getPkValue()) != 0) continue;
                            targetMyTenderArr.add(dynamicObject);
                        }
                        HashMap myTenderEntryMap = new HashMap();
                        for (DynamicObject aMyTender : targetMyTenderArr) {
                            for (DynamicObject aMyTenderEntry : aMyTender.getDynamicObjectCollection("entry")) {
                                myTenderEntryMap.put(aMyTender.getDynamicObject("supplier").getPkValue() + aMyTenderEntry.getString("sectionname"), aMyTenderEntry);
                            }
                        }
                        for (DynamicObject bidSectionEntry : bidDecision.getDynamicObjectCollection("bidsection")) {
                            DynamicObjectCollection dynamicObjectCollection = bidSectionEntry.getDynamicObjectCollection("supplierentry");
                            for (DynamicObject supplierEntry : dynamicObjectCollection) {
                                DynamicObject myTenderEntry = (DynamicObject)myTenderEntryMap.get(supplierEntry.getDynamicObject("supplier").getPkValue() + bidSectionEntry.getString("sectionname"));
                                if (myTenderEntry == null || !supplierEntry.getBoolean("isrecommended")) continue;
                                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.DECIDED);
                            }
                        }
                    }
                    for (DynamicObject myTender : myTenderArr) {
                        DynamicObjectCollection myTenderEntryColl = myTender.getDynamicObjectCollection("entry");
                        int decidedCount = 0;
                        for (DynamicObject myTenderEntry : myTenderEntryColl) {
                            MyTenderStatus myTenderEntryStatus = MyTenderStatus.valueOf((String)myTenderEntry.getString("sectionstatus"));
                            if (!MyTenderStatusUtil.getAllUnValidStatus().contains(myTenderEntryStatus) && MyTenderStatus.DECIDED != myTenderEntryStatus) {
                                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.UNDECIDED);
                                continue;
                            }
                            if (MyTenderStatus.DECIDED != myTenderEntryStatus) continue;
                            ++decidedCount;
                        }
                        if (decidedCount == 0) {
                            myTender.set("tenderstatus", (Object)MyTenderStatus.UNDECIDED);
                            continue;
                        }
                        if (decidedCount == myTenderEntryColl.size()) {
                            myTender.set("tenderstatus", (Object)MyTenderStatus.DECIDED);
                            continue;
                        }
                        myTender.set("tenderstatus", (Object)MyTenderStatus.SECTIONAL_DECIDED);
                    }
                    SaveServiceHelper.update((DynamicObject[])myTenderArr);
                }
            } else if ("unaudit".equals(key)) {
                String selectFields = "bidproject,supplier,entry,entry.sectionname,entry.projectsection,entry.sectionstatus,ispublicbid,tenderstatus";
                myTenderArr = BusinessDataServiceHelper.load((String)"ten_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet), new QFilter("tenderstatus", "in", new HashSet<MyTenderStatus>(Arrays.asList(MyTenderStatus.UNDECIDED, MyTenderStatus.DECIDED, MyTenderStatus.SECTIONAL_DECIDED)))});
                if (myTenderArr.length > 0) {
                    for (DynamicObject myTender : myTenderArr) {
                        DynamicObject bidProject = myTender.getDynamicObject("bidproject");
                        MyTenderStatus previousStatus = null;
                        previousStatus = bidProject.getBoolean("bidpublish") ? MyTenderStatus.TENDERED : MyTenderStatus.INVITED;
                        myTender.set("tenderstatus", (Object)previousStatus);
                        for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                            MyTenderStatus myTenderEntryStatus = MyTenderStatus.valueOf((String)myTenderEntry.getString("sectionstatus"));
                            if (MyTenderStatus.DECIDED != myTenderEntryStatus && MyTenderStatus.UNDECIDED != myTenderEntryStatus) continue;
                            myTenderEntry.set("sectionstatus", (Object)previousStatus);
                        }
                    }
                    SaveServiceHelper.update((DynamicObject[])myTenderArr);
                }
                for (DynamicObject bidDecision : dataEntities) {
                    DynamicObjectCollection bustalks;
                    BidStepEnum[] nextStep;
                    DynamicObject project = bidDecision.getDynamicObject("bidproject");
                    Long bidProjectId = (Long)project.getPkValue();
                    DynamicObject bustalk = this.bidBustalkService.findMaxJudgenumBustalk(bidProjectId);
                    if (null != bustalk) {
                        bustalk = this.bidBustalkService.getBustalkById(Long.valueOf(bustalk.getLong("id")));
                    }
                    if (null != (nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)project, (BidStepEnum)BidStepEnum.BidAnswerQuestion)) && BidStepEnum.BidDecision == nextStep[0]) {
                        this.changeAnswerQuesData(bidDecision);
                        continue;
                    }
                    if (null != nextStep && BidStepEnum.BidBustalk == nextStep[0]) {
                        if (null != bustalk && bustalk.getInt("judge_num") == 0) {
                            if (bustalk.get("auditor") != null) {
                                BidStepEnum[] steps2 = new BidStepEnum[]{BidStepEnum.BidBustalk, BidStepEnum.BidDecision};
                                this.bidProjectService.saveCurrentBidStep((Object)bidProjectId, steps2);
                            } else {
                                this.changeAnswerQuesData(bidDecision);
                            }
                            bustalks = this.bidBustalkService.findBustalkByBidprojectId(bidProjectId);
                            this.bidBustalkService.updateBustalkComplete(bustalks, BillStatusEnum.AUDITED.getVal(), null);
                            continue;
                        }
                        bustalks = this.bidBustalkService.findBustalkByBidprojectId(bidProjectId);
                        if (null == bustalks || bustalks.size() <= 0) continue;
                        this.bidBustalkService.updateBustalkComplete(bustalks, BillStatusEnum.AUDITED.getVal(), null);
                        BidStepEnum[] bidStepEnumArray = new BidStepEnum[]{BidStepEnum.BidBustalk, BidStepEnum.BidDecision};
                        this.bidProjectService.saveCurrentBidStep((Object)bidProjectId, bidStepEnumArray);
                        continue;
                    }
                    bustalks = this.bidBustalkService.findBustalkByBidprojectId(bidProjectId);
                    if (null == bustalks || bustalks.size() <= 0) continue;
                    this.bidBustalkService.updateBustalkComplete(bustalks, BillStatusEnum.AUDITED.getVal(), null);
                    BidStepEnum[] bidStepEnumArray = new BidStepEnum[]{BidStepEnum.BidBustalk, BidStepEnum.BidDecision};
                    this.bidProjectService.saveCurrentBidStep((Object)bidProjectId, bidStepEnumArray);
                }
            }
        }
        if ("audit".equals(key)) {
            String appId = this.billEntityType.getAppId();
            for (DynamicObject bidDecision : dataEntities) {
                DynamicObject supplierstatistic;
                supplierSet = this.querySupplierSet(bidDecision, appId);
                if (CollectionUtils.isEmpty(supplierSet)) continue;
                QFilter supplierFilter = new QFilter("supplier.id", "in", supplierSet);
                for (DynamicObject supstatis : supplierstatistic = BusinessDataServiceHelper.load((String)(appId + "_supplierstatistic"), (String)"abandonnums", (QFilter[])new QFilter[]{supplierFilter})) {
                    supstatis.set("abandonnums", (Object)(supstatis.getInt("abandonnums") + 1));
                }
                SaveServiceHelper.save((DynamicObject[])supplierstatistic);
            }
        } else if ("unaudit".equals(key)) {
            String appId = this.billEntityType.getAppId();
            for (DynamicObject bidDecision : dataEntities) {
                supplierSet = this.querySupplierSet(bidDecision, appId);
                if (CollectionUtils.isEmpty(supplierSet)) continue;
                QFilter supplierFilter = new QFilter("supplier.id", "in", supplierSet);
                DynamicObject[] supplierstatistic = BusinessDataServiceHelper.load((String)(appId + "_supplierstatistic"), (String)"abandonnums", (QFilter[])new QFilter[]{supplierFilter});
                for (DynamicObject supstatis : supplierstatistic) {
                    supstatis.set("abandonnums", (Object)(supstatis.getInt("abandonnums") - 1));
                }
                SaveServiceHelper.save((DynamicObject[])supplierstatistic);
            }
        }
        if ("submit".equals(key)) {
            for (DynamicObject bidDecision : dataEntities) {
                Long bidProjectId = (Long)bidDecision.getDynamicObject("bidproject").getPkValue();
                DynamicObjectCollection bustalks = this.bidBustalkService.findBustalkByBidprojectId(bidProjectId);
                if (null == bustalks || bustalks.size() <= 0) continue;
                this.bidBustalkService.updateBustalkComplete(bustalks, BillStatusEnum.COMPLETE.getVal(), new Date());
                this.bidProjectService.saveCurrentBidStep((Object)bidProjectId, new BidStepEnum[]{BidStepEnum.BidDecision});
            }
        }
        if ("unsubmit".equals(key)) {
            for (DynamicObject bidDecision : dataEntities) {
                BidStepEnum[] steps;
                DynamicObjectCollection bustalks;
                BidStepEnum[] nextStep;
                DynamicObject project = bidDecision.getDynamicObject("bidproject");
                Long bidProjectId = (Long)project.getPkValue();
                DynamicObject bustalk = this.bidBustalkService.findMaxJudgenumBustalk(bidProjectId);
                if (null != bustalk) {
                    bustalk = this.bidBustalkService.getBustalkById(Long.valueOf(bustalk.getLong("id")));
                }
                if (null != (nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)project, (BidStepEnum)BidStepEnum.BidAnswerQuestion)) && BidStepEnum.BidDecision == nextStep[0]) {
                    this.changeAnswerQuesData(bidDecision);
                    continue;
                }
                if (null != nextStep && BidStepEnum.BidBustalk == nextStep[0]) {
                    if (null != bustalk && bustalk.getInt("judge_num") == 0) {
                        if (null != bustalk.get("auditor")) {
                            BidStepEnum[] steps3 = new BidStepEnum[]{BidStepEnum.BidBustalk, BidStepEnum.BidDecision};
                            this.bidProjectService.saveCurrentBidStep((Object)bidProjectId, steps3);
                        } else {
                            this.changeAnswerQuesData(bidDecision);
                        }
                        bustalks = this.bidBustalkService.findBustalkByBidprojectId(bidProjectId);
                        this.bidBustalkService.updateBustalkComplete(bustalks, BillStatusEnum.AUDITED.getVal(), null);
                        continue;
                    }
                    if (null == bustalk) {
                        this.changeAnswerQuesData(bidDecision);
                        continue;
                    }
                    bustalks = this.bidBustalkService.findBustalkByBidprojectId(bidProjectId);
                    if (null == bustalks || bustalks.size() <= 0) continue;
                    this.bidBustalkService.updateBustalkComplete(bustalks, BillStatusEnum.AUDITED.getVal(), null);
                    steps = new BidStepEnum[]{BidStepEnum.BidBustalk, BidStepEnum.BidDecision};
                    this.bidProjectService.saveCurrentBidStep((Object)bidProjectId, steps);
                    continue;
                }
                bustalks = this.bidBustalkService.findBustalkByBidprojectId(bidProjectId);
                if (null == bustalks || bustalks.size() <= 0) continue;
                this.bidBustalkService.updateBustalkComplete(bustalks, BillStatusEnum.AUDITED.getVal(), null);
                steps = new BidStepEnum[]{BidStepEnum.BidBustalk, BidStepEnum.BidDecision};
                this.bidProjectService.saveCurrentBidStep((Object)bidProjectId, steps);
            }
        }
    }

    private HashSet<Object> querySupplierSet(DynamicObject bidDecision, String appId) {
        Object bidProjectId = bidDecision.getDynamicObject("bidproject").getPkValue();
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)(appId + "_project")));
        String projectType = bidProject.getString("bidopentype");
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("billstatus", "=", (Object)"O"));
        qfilters.add(new QFilter("bidproject", "=", bidProject.getPkValue()));
        HashSet<Object> supplierSet = new HashSet<Object>(16);
        if ("UNIONOPEN".equals(projectType)) {
            qfilters.add(new QFilter("opentype", "=", (Object)"MULTI"));
        } else if ("TECHBUSINESS".equals(projectType)) {
            qfilters.add(new QFilter("opentype", "=", (Object)"TECHNICAL"));
        } else {
            qfilters.add(new QFilter("opentype", "=", (Object)"BUSSINESS"));
        }
        this.queryOpenBid(appId, qfilters, supplierSet);
        return supplierSet;
    }

    protected void queryOpenBid(String appId, List<QFilter> qfilters, HashSet<Object> supplierSet) {
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidopen"), (String)"billno", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]));
        if (bidOpen != null) {
            DynamicObject openBid = BusinessDataServiceHelper.loadSingle((Object)bidOpen.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)(appId + "_bidopen")));
            DynamicObjectCollection openSectionEntry = openBid.getDynamicObjectCollection("bidsection");
            for (DynamicObject openSection : openSectionEntry) {
                DynamicObjectCollection supplierEntry = openSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject openSupplier : supplierEntry) {
                    DynamicObject supplier = openSupplier.getDynamicObject("supplier");
                    Boolean isTender = openSupplier.getBoolean("supplier_istender");
                    if (isTender.booleanValue() || supplier == null) continue;
                    supplierSet.add(supplier.getPkValue());
                }
            }
        }
    }

    private class Validator4BidDecision
    extends AbstractValidator {
        private Validator4BidDecision() {
        }

        public void validate() {
            DynamicObject bidDecision;
            DynamicObject tempProject;
            DynamicObject pro;
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            BidProjectServiceImpl projectService = new BidProjectServiceImpl();
            if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"audit", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key) || StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key) || StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    pro = (DynamicObject)dataEntity.getValue("bidproject");
                    Long projectId = pro.getLong("id");
                    DynamicObject tempProject2 = projectService.getBidProjectAllById(projectId);
                    String appId = tempProject2.getString("entitytypeid").split("_")[0];
                    QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                    DynamicObject[] supplierInvitation = BusinessDataServiceHelper.load((String)(appId + "_supplierinvitation"), (String)"billstatus", (QFilter[])qFilter.toArray());
                    for (int i = 0; i < supplierInvitation.length; ++i) {
                        String billStatus = supplierInvitation[i].getString("billstatus");
                        if (!"A".equals(billStatus) && !"B".equals(billStatus)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4fee\u8ba2\u4e2d\u72b6\u6001\u7684\u589e\u8865\u5165\u56f4\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"BidDecisionOperationServicePlugin_21", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject[] bidPublish = BusinessDataServiceHelper.load((String)(appId + "_bidpublish"), (String)"billstatus", (QFilter[])qFilter.toArray());
                    for (int i = 0; i < bidPublish.length; ++i) {
                        String billStatus = bidPublish[i].getString("billstatus");
                        if (!"A".equals(billStatus) && !"B".equals(billStatus)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4fee\u8ba2\u4e2d\u72b6\u6001\u7684\u53d1\u6807\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"BidDecisionOperationServicePlugin_22", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
            if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    pro = (DynamicObject)dataEntity.getValue("bidproject");
                    Object bidproject = pro.getPkValue();
                    boolean exsitunFinishback = new ReBackBidUtil(((Object)((Object)this)).getClass().getName().split("\\.")[2]).checkBackBidFinished(bidproject);
                    if (exsitunFinishback) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u5728\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidDecisionOperationServicePlugin_41", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    boolean existBusTalk = pro.getBoolean("bidbustalk");
                    if (existBusTalk) {
                        tempProject = projectService.getBidProjectAllById(Long.valueOf(pro.getLong("id")));
                        String appId = tempProject.getString("entitytypeid").split("_")[0];
                        boolean existFlag = QueryServiceHelper.exists((String)(appId + "_bustalk"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", pro.getPkValue()), new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "I"})});
                        if (existFlag) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidDecisionOperationServicePlugin_23", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        DynamicObject[] bustalkC = BusinessDataServiceHelper.load((String)(appId + "_bustalk"), (String)"id,offerstoptime,createtime", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", pro.getPkValue()), new QFilter("openonlinesynergy", "=", (Object)Boolean.TRUE), new QFilter("billstatus", "in", (Object)new String[]{"C"})}, (String)"createtime desc");
                        Date date = new Date();
                        for (DynamicObject dynamicObject : bustalkC) {
                            Date offerstoptime = dynamicObject.getDate("offerstoptime");
                            if (offerstoptime.getTime() <= date.getTime()) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidDecisionOperationServicePlugin_23", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                    bidDecision = dataEntity.getDataEntity();
                    DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)pro.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidtype,ismaterialpur,enablemultisection, bidsection,bidsection.sectionname,projectentry,projectentry.materialid,projectentry.qty,projectentry.materialdes,entitytypeid");
                    boolean isMaterialPur = bidProject.getBoolean("ismaterialpur");
                    String appId = bidProject.getString("entitytypeid").split("_")[0];
                    if ("rebm".equals(appId)) {
                        bidProject = BusinessDataServiceHelper.loadSingle((Object)pro.getPkValue(), (String)(appId + "_project"), (String)"bidtype,ismaterialpur,enablemultisection, bidsection,bidsection.sectionname,projectentry,projectentry.materialid,projectentry.qty,projectentry.materialdes,entitytypeid,projectentry.resourceitem");
                    }
                    int bidtype = bidProject.getInt("bidtype");
                    boolean enableMultiSection = bidProject.getBoolean("enablemultisection");
                    if (bidtype != 1 && bidtype != 2) continue;
                    HashMap<String, BigDecimal> materialNumberMap = new HashMap<String, BigDecimal>(16);
                    DynamicObjectCollection bidProjectSection = bidProject.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidSection : bidProjectSection) {
                        Object resourceitemId = null;
                        String materialNumber = null;
                        String materialId = null;
                        String resourceitemNumber = null;
                        String sectionName = bidSection.getString("sectionname");
                        DynamicObjectCollection projectEntryList = bidSection.getDynamicObjectCollection("projectentry");
                        Iterator iterator = projectEntryList.iterator();
                        while (iterator.hasNext()) {
                            DynamicObject projectEntry = (DynamicObject)iterator.next();
                            BigDecimal purQty = projectEntry.getBigDecimal("qty");
                            if (bidtype == 2 && "rebm".equals(appId)) {
                                DynamicObject resourceitem = projectEntry.getDynamicObject("resourceitem");
                                if (resourceitem != null) {
                                    resourceitemId = resourceitem.getString("id");
                                    resourceitemNumber = resourceitem.getString("number");
                                }
                            } else {
                                DynamicObject material = projectEntry.getDynamicObject("materialid");
                                materialId = material.getString("id");
                                materialNumber = material.getString("number");
                            }
                            String materialDesc = projectEntry.getString("materialdes");
                            String materialKey = sectionName + "_" + materialId + "_" + materialNumber + "_" + materialDesc + "_" + (String)resourceitemId + "_" + resourceitemNumber;
                            materialNumberMap.put(materialKey, purQty);
                        }
                    }
                    HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(16);
                    DynamicObjectCollection bidSectionList = bidDecision.getDynamicObjectCollection("bidsection");
                    for (DynamicObject bidSection : bidSectionList) {
                        String sectionName = bidSection.getString("sectionname");
                        DynamicObjectCollection supplierEntryList = bidSection.getDynamicObjectCollection("supplierentry");
                        TreeSet<String> supplierIdSet = new TreeSet<String>();
                        for (DynamicObject supplierEntry : supplierEntryList) {
                            boolean isRecommended = supplierEntry.getBoolean("isrecommended");
                            if (!isRecommended) continue;
                            supplierIdSet.add(supplierEntry.getDynamicObject("supplier").getString("id"));
                        }
                        String resourceitemId = null;
                        String resourceitemNumber = null;
                        String materialNumber = null;
                        String materialId = null;
                        DynamicObjectCollection supFinalDetailList = bidSection.getDynamicObjectCollection("supfinaldetail");
                        for (DynamicObject supFinalDetail : supFinalDetailList) {
                            String lPurSupplierId = supFinalDetail.getDynamicObject("lpursupplier").getString("id");
                            if (CollectionUtils.isEmpty(supplierIdSet) || !supplierIdSet.contains(lPurSupplierId)) continue;
                            BigDecimal lQty = supFinalDetail.getBigDecimal("lqty");
                            if (bidtype == 2 && "rebm".equals(appId)) {
                                DynamicObject resourceitem = supFinalDetail.getDynamicObject("lresourceitem");
                                if (resourceitem != null) {
                                    resourceitemId = resourceitem.getString("id");
                                    resourceitemNumber = resourceitem.getString("number");
                                }
                            } else {
                                DynamicObject material = supFinalDetail.getDynamicObject("lmaterialid");
                                materialNumber = material.getString("number");
                                materialId = material.getString("id");
                            }
                            String materialDec = supFinalDetail.getString("lmaterialdes");
                            String materialKey = sectionName + "_" + materialId + "_" + materialNumber + "_" + materialDec + "_" + resourceitemId + "_" + resourceitemNumber;
                            if (hashMap != null && hashMap.containsKey(materialKey)) {
                                BigDecimal qty = (BigDecimal)hashMap.get(materialKey);
                                hashMap.put(materialKey, lQty.add(qty));
                                continue;
                            }
                            hashMap.put(materialKey, lQty);
                        }
                    }
                    if (CollectionUtils.isEmpty(hashMap) || CollectionUtils.isEmpty(materialNumberMap)) continue;
                    for (Map.Entry mapEntry : materialNumberMap.entrySet()) {
                        int k;
                        String materialKey = (String)mapEntry.getKey();
                        BigDecimal projectMaterialNumber = (BigDecimal)mapEntry.getValue();
                        BigDecimal decisionMaterialNumber = (BigDecimal)hashMap.get(materialKey);
                        if (projectMaterialNumber == null || decisionMaterialNumber == null || (k = decisionMaterialNumber.subtract(projectMaterialNumber).compareTo(BigDecimal.ZERO)) <= 0) continue;
                        String[] materialKeySplit = materialKey.split("_");
                        if (enableMultiSection) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u7684\u4e2d\u6807\u5355\u4f4d\u7684\u4ea7\u54c1\u6570\u91cf\u4e4b\u548c\u4e0d\u5141\u8bb8\u5927\u4e8e%3$s\u3002", (String)"BidDecisionOperationServicePlugin_24", (String)"scm-bid-opplugin", (Object[])new Object[0]), bidtype == 1 ? materialKeySplit[2] : materialKeySplit[materialKeySplit.length - 1], materialKeySplit[0], projectMaterialNumber));
                            continue;
                        }
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7684\u4e2d\u6807\u5355\u4f4d\u7684\u4ea7\u54c1\u6570\u91cf\u4e4b\u548c\u4e0d\u5141\u8bb8\u5927\u4e8e%2$s\u3002", (String)"BidDecisionOperationServicePlugin_25", (String)"scm-bid-opplugin", (Object[])new Object[0]), bidtype == 1 ? materialKeySplit[2] : materialKeySplit[materialKeySplit.length - 1], projectMaterialNumber));
                    }
                }
            }
            if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    boolean b2;
                    if (!BidDecisionOperationServicePlugin.this.service.checkBidDocFinished(dataEntity.getBillPkId())) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u672a\u5ba1\u6279\u7684\u6807\u4e66\u7f16\u5236\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"BidDecisionOperationServicePlugin_26", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    pro = (DynamicObject)dataEntity.getValue("bidproject");
                    boolean isRateBidding = pro.getBoolean("isratebidding");
                    boolean isBustalk = pro.getBoolean("bidbustalk");
                    if (!isBustalk) continue;
                    Date oldModifytime = (Date)dataEntity.getValue("modifytime");
                    bidDecision = BidDecisionOperationServicePlugin.this.service.getBidDecisionById((Long)dataEntity.getBillPkId());
                    Date newModifytime = bidDecision.getDate("modifytime");
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    boolean b1 = null == oldModifytime && null != newModifytime;
                    boolean bl = b2 = null != oldModifytime && null != newModifytime && !format.format(oldModifytime).equals(format.format(newModifytime));
                    if (!b1 && !b2) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u518d\u64cd\u4f5c\u3002", (String)"BidDecisionOperationServicePlugin_27", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
                return;
            }
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject pro2;
                    boolean isAudit;
                    if (!BidDecisionOperationServicePlugin.this.service.checkBidDocFinished(dataEntity.getBillPkId())) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u672a\u5ba1\u6279\u7684\u6807\u4e66\u7f16\u5236\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidDecisionOperationServicePlugin_30", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject bidProjectTemp = dataEntity.getDataEntity().getDynamicObject("bidproject");
                    boolean bidBottomMake = bidProjectTemp.getBoolean("bidbottommake");
                    if (bidBottomMake && !(isAudit = this.checkIsAuditBottomMake(bidProjectTemp))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u72b6\u6001\u7684\u6807\u5e95\u7f16\u5236\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c", (String)"BidDecisionOperationServicePlugin_31", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    Long projectId = (pro2 = (DynamicObject)dataEntity.getValue("bidproject")) != null ? pro2.getLong("id") : 0L;
                    tempProject = projectService.getBidProjectAllById(projectId);
                    BidStepEnum[] nextStep = null;
                    if (pro2 != null) {
                        nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)pro2, (BidStepEnum)BidStepEnum.BidAnswerQuestion);
                    }
                    if (null != nextStep && (BidStepEnum.BidDecision == nextStep[0] || BidStepEnum.BidBustalk == nextStep[0])) {
                        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                        DynamicObject[] AnswerQuestionReco = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter});
                        boolean flag = true;
                        for (DynamicObject dynamicObject : AnswerQuestionReco) {
                            if ("C".equals(dynamicObject.get("billstatus"))) continue;
                            flag = false;
                            break;
                        }
                        Date date = new Date();
                        Date answerQuestionTime = tempProject.getDate("answerquestiontime");
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        if (answerQuestionTime != null && formatter.format(date).compareTo(formatter.format(answerQuestionTime)) < 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7b54\u7591\u622a\u6b62\u65f6\u95f4\u201d\u5c1a\u672a\u622a\u6b62\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidDecisionOperationServicePlugin_32", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                        if (!flag) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6279\u7684\u7b54\u7591\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidDecisionOperationServicePlugin_33", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                    }
                    boolean enableMultiSection = false;
                    if (pro2 != null) {
                        enableMultiSection = pro2.getBoolean("enablemultisection");
                    }
                    DynamicObjectCollection sections = (DynamicObjectCollection)dataEntity.getValue("bidsection");
                    boolean isExist = BidDecisionOperationServicePlugin.this.bidBustalkService.findBustalkByUnauditExpFirst(Long.valueOf(pro2 != null ? pro2.getLong("id") : 0L));
                    if (isExist) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u672a\u5b8c\u6210\u5ba1\u6279\u7684\u5546\u52a1\u8c08\u5224\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidDecisionOperationServicePlugin_34", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    boolean isBustalk = pro2.getBoolean("bidbustalk");
                    Date createtime = (Date)dataEntity.getValue("createtime");
                    if (isBustalk && null != createtime) {
                        boolean b2;
                        Date oldModifytime = (Date)dataEntity.getValue("modifytime");
                        DynamicObject dynamicObject = BidDecisionOperationServicePlugin.this.service.getBidDecisionById((Long)dataEntity.getBillPkId());
                        Date newModifytime = dynamicObject.getDate("modifytime");
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        boolean b1 = null == oldModifytime && null != newModifytime;
                        boolean bl = b2 = null != oldModifytime && null != newModifytime && !format.format(oldModifytime).equals(format.format(newModifytime));
                        if (b1 || b2) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f60\u9009\u62e9\u7684\u6570\u636e\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u518d\u64cd\u4f5c\u3002", (String)"BidDecisionOperationServicePlugin_27", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                    }
                    for (int i = 0; i < sections.size(); ++i) {
                        DynamicObject dynamicObject = (DynamicObject)sections.get(i);
                        String name = dynamicObject.getLocaleString("sectionname").getLocaleValue();
                        DynamicObjectCollection supEntries = dynamicObject.getDynamicObjectCollection("supplierentry");
                        String msgHeadStr = "";
                        if (enableMultiSection) {
                            msgHeadStr = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u201c%s\u201d\u5bf9\u5e94\u7684", (String)"BidDecisionOperationServicePlugin_1", (String)"scm-bid-opplugin", (Object[])new Object[0]), name);
                        }
                        if (supEntries == null || supEntries.size() == 0) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidDecisionOperationServicePlugin_35", (String)"scm-bid-opplugin", (Object[])new Object[0]), msgHeadStr));
                            continue;
                        }
                        boolean flag = false;
                        for (int j = 0; j < supEntries.size(); ++j) {
                            boolean isrecommended;
                            DynamicObject supEntry = (DynamicObject)supEntries.get(j);
                            if (supEntry == null) continue;
                            String msgLineStr = String.format(ResManager.loadKDString((String)"%1$s\u4f9b\u5e94\u5546\u4fe1\u606f\u4e2d\u7b2c%2$s\u884c\u3002", (String)"BidDecisionOperationServicePlugin_36", (String)"scm-bid-opplugin", (Object[])new Object[0]), msgHeadStr, String.valueOf(j + 1));
                            DynamicObject supplier = supEntry.getDynamicObject("supplier");
                            if (supplier == null) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u201c\u4f9b\u5e94\u5546\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidDecisionOperationServicePlugin_37", (String)"scm-bid-opplugin", (Object[])new Object[0]), msgLineStr));
                            }
                            if (!(isrecommended = supEntry.getBoolean("isrecommended"))) continue;
                            flag = true;
                        }
                        if (flag) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4f9b\u5e94\u5546\u4fe1\u606f\u4e2d\u201c\u4e2d\u6807\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidDecisionOperationServicePlugin_38", (String)"scm-bid-opplugin", (Object[])new Object[0]), msgHeadStr));
                    }
                    DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("billstatus", "not in", (Object)new String[]{BillStatusEnum.ADJUSTING.getVal(), BillStatusEnum.INVALID.getVal()}), new QFilter("bidproject", "=", pro2.getPkValue())});
                    if (bidPublish == null) continue;
                    String string = bidPublish.getString("billstatus");
                    if (BillStatusEnum.PUBLISHED.getVal().equals(string)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5904\u7406\u53d1\u6807\u4e1a\u52a1\u518d\u63d0\u4ea4\u3002", (String)"BidDecisionOperationServicePlugin_39", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
            if ("unaudit".equals(key)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject decision = dataEntity.getDataEntity();
                    boolean synxkflag = decision.getBoolean("synxkflag");
                    String dataSource = decision.getString("datasource");
                    if (!synxkflag || !"1".equals(dataSource) && !"2".equals(dataSource)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDecisionOperationServicePlugin_40", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }

        public boolean checkIsAuditBottomMake(DynamicObject bidProjectData) {
            DynamicObject[] bidBottomMakes = BusinessDataServiceHelper.load((String)"bid_bottom_make", (String)"bidbottomamount,bidsection.totalfinalauditamount", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectData.getPkValue()), new QFilter("billstatus", "=", (Object)"C")});
            return bidBottomMakes.length > 0;
        }
    }
}

