/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidAnswerQuestionService;
import kd.scm.bid.business.bill.IBidDocumentService;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionRecoServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.opplugin.bill.util.BidProjectQueryUtil;
import kd.scm.bid.opplugin.bill.util.NextStepSendMessage;

public class BidDocumentOperationServicePlugin
extends AbstractOperationServicePlugIn {
    protected IBidDocumentService documentService = new BidDocumentServiceImpl();
    protected IBidProjectService projectService = new BidProjectServiceImpl();
    protected IBidOpenService openService = new BidOpenServiceImpl();
    protected IBidAnswerQuestionService answerQuestionService = new BidAnswerQuestionServiceImpl();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ValidatorForBidDocument());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("tech_docnum");
        keys.add("com_docnum");
        keys.add("biddoc_num");
        keys.add("isseparatedoc");
        keys.add("auditdate");
        keys.add("auditor");
        keys.add("parent");
        keys.add("bidproject");
        keys.add("billstatus");
        keys.add("parent");
        keys.add("evaluatedecideway");
        keys.add("bidproject");
        keys.add("bidproject.doctype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block20: {
            DynamicObject docNow;
            Long id;
            MainEntityType type;
            Long parent;
            Long projectId;
            DynamicObject[] datas;
            String key;
            block22: {
                LinkedList<BidStepEnum> stepEnumList;
                block21: {
                    block19: {
                        super.beginOperationTransaction(e);
                        key = e.getOperationKey();
                        datas = e.getDataEntities();
                        projectId = null;
                        parent = null;
                        type = null;
                        id = null;
                        docNow = null;
                        stepEnumList = null;
                        if (!StringUtils.equals((CharSequence)"save", (CharSequence)key)) break block19;
                        type = EntityMetadataCache.getDataEntityType((String)"bid_biddocument_edit");
                        for (DynamicObject data : datas) {
                            id = (Long)data.getPkValue();
                            projectId = data.getLong("bidproject.id");
                            String billstatus = data.getString("billstatus");
                            if ("D".equals(billstatus) || "A".equals(billstatus)) {
                                data.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                            }
                            parent = data.getLong("parent");
                            DynamicObject temp = this.documentService.getBidDocumentByProjectId(projectId, "id,billstatus");
                            if (parent != null && parent != 0L && !"C".equals(temp.getString("billstatus"))) continue;
                        }
                        break block20;
                    }
                    if (!StringUtils.equals((CharSequence)"submit", (CharSequence)key)) break block21;
                    type = EntityMetadataCache.getDataEntityType((String)"bid_biddocument_edit");
                    for (DynamicObject data : datas) {
                        id = (Long)data.getPkValue();
                        projectId = data.getLong("bidproject.id");
                        DynamicObject temp = this.documentService.getBidDocumentByProjectId(projectId, "id,billstatus");
                        parent = data.getLong("parent");
                        if (parent != null && parent != 0L && !"C".equals(temp.getString("billstatus"))) continue;
                    }
                    break block20;
                }
                if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) break block22;
                type = EntityMetadataCache.getDataEntityType((String)"bid_biddocument_edit");
                for (DynamicObject data : datas) {
                    id = (Long)data.getPkValue();
                    docNow = this.documentService.getBidDocumentById(id);
                    projectId = docNow.getLong("bidproject.id");
                    parent = docNow.getLong("parent");
                    HashMap<String, String> stepMap = BidProjectQueryUtil.queryStep(projectId);
                    DynamicObject bidProject = this.projectService.getBidProjectAllById(projectId);
                    if (BidStepInteractiveHelper.checkStepComplete((Long)projectId, (BidStepEnum)BidStepEnum.SupplierInvitation)) {
                        this.documentService.deleteNextStepUnStarted(bidProject, BidStepEnum.BidDocument);
                        BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProject, (BidStepEnum)BidStepEnum.BidDocument);
                        if (nextStep != null && BidStepEnum.BidAnswerQuestion == nextStep[0] && bidProject.getBoolean("bidopen")) {
                            this.openService.deleteUnStarted(bidProject.getPkValue());
                        }
                        if (nextStep != null && BidStepEnum.BidAnswerQuestion == nextStep[0] && !bidProject.getBoolean("bidopen")) {
                            this.answerQuestionService.deleteNextStepUnStarted(bidProject, BidStepEnum.BidAnswerQuestion);
                        }
                        if (parent == null) {
                            if (stepMap.get(BidStepEnum.Clarificaiton.name()) != null) {
                                this.projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.BidDocument, BidStepEnum.Clarificaiton});
                            } else {
                                this.projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.BidDocument});
                            }
                        }
                    } else if (parent == null || parent != null && parent != 0L) {
                        if (stepMap.get(BidStepEnum.Clarificaiton.name()) != null) {
                            this.projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.SupplierInvitation, BidStepEnum.BidDocument, BidStepEnum.Clarificaiton});
                        } else {
                            this.projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.SupplierInvitation, BidStepEnum.BidDocument});
                        }
                    }
                    if (parent != null && parent != 0L) {
                        DynamicObject parentDoc = this.documentService.getBidDocumentById(parent);
                        parentDoc.set("billstatus", (Object)BillStatusEnum.AUDITED.getVal());
                        docNow.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                        BusinessDataServiceHelper.save((IDataEntityType)type, (Object[])new Object[]{parentDoc, docNow});
                    }
                    data.set("auditor", null);
                    data.set("auditdate", null);
                    if (stepMap.get(BidStepEnum.Clarificaiton.name()) == null) continue;
                    HashMap<String, BidStepEnum> bidStepEnumHashMap = BidProjectQueryUtil.queryStepEnum(projectId);
                    bidStepEnumHashMap.put("Clarificaiton", BidStepEnum.Clarificaiton);
                    stepEnumList = new LinkedList<BidStepEnum>();
                    if (!bidStepEnumHashMap.values().isEmpty()) {
                        stepEnumList.addAll(bidStepEnumHashMap.values());
                    }
                    this.projectService.saveCurrentBidStep((Object)projectId, stepEnumList.toArray(new BidStepEnum[stepEnumList.size()]));
                }
                break block20;
            }
            if (!StringUtils.equals((CharSequence)"delete", (CharSequence)key)) break block20;
            type = EntityMetadataCache.getDataEntityType((String)"bid_biddocument_edit");
            for (DynamicObject data : datas) {
                id = (Long)data.getPkValue();
                parent = (Long)data.get("parent");
                if (parent != null && parent != 0L) {
                    DynamicObject obj = this.documentService.getBidDocumentById(parent, "billstatus");
                    String status = obj.getString("billstatus");
                    if (BillStatusEnum.AUDITED.getVal().equals(status) || BillStatusEnum.ADJUSTING.getVal().equals(status)) {
                        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])new Long[]{id});
                        continue;
                    }
                }
                docNow = this.documentService.getBidDocumentById(id);
                projectId = docNow.getLong("bidproject.id");
                DynamicObject projectObj = this.projectService.getBidProjectAllById(projectId);
                this.documentService.createByLastStep(projectObj, BidStepEnum.BidProject);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if ("audit".equals(key)) {
            NextStepSendMessage nextStepSendMessage = null;
            for (DynamicObject proObj : datas) {
                long parentId = proObj.getLong("parent");
                if (parentId != 0L) continue;
                DynamicObject bidProject = proObj.getDynamicObject("bidproject");
                bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
                nextStepSendMessage = new NextStepSendMessage();
                nextStepSendMessage.nextStepSendMessage(bidProject, BidStepEnum.BidDocument);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block19: {
            DynamicObject docNow;
            Long id;
            MainEntityType type;
            DynamicObject[] datas;
            String key;
            block18: {
                super.endOperationTransaction(e);
                key = e.getOperationKey();
                datas = e.getDataEntities();
                type = null;
                Long projectId = null;
                id = null;
                Long parent = null;
                docNow = null;
                if (!StringUtils.equals((CharSequence)"audit", (CharSequence)key)) break block18;
                type = EntityMetadataCache.getDataEntityType((String)"bid_biddocument_edit");
                for (DynamicObject data : datas) {
                    id = (Long)data.getPkValue();
                    docNow = this.documentService.getBidDocumentById(id);
                    parent = docNow.getLong("parent");
                    projectId = docNow.getLong("bidproject.id");
                    DynamicObject bidProject = this.projectService.getBidProjectAllById(projectId);
                    HashMap<String, String> stepMap = BidProjectQueryUtil.queryStep(projectId);
                    if (parent != null && parent != 0L) {
                        DynamicObject parentObject = this.documentService.getBidDocumentById(parent);
                        parentObject.set("billstatus", (Object)BillStatusEnum.INVALIDXX.getVal());
                        BusinessDataServiceHelper.save((IDataEntityType)type, (Object[])new Object[]{parentObject});
                        BidStepEnum[] steps = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProject, (BidStepEnum)BidStepEnum.BidDocument);
                        BidStepEnum next = steps[0];
                        if (next.getIndex() == BidStepEnum.BidAnswerQuestion.getIndex() && steps.length > 1) {
                            next = steps[1];
                        }
                        BidStepEnum[] nextService = BidStepInteractiveHelper.getBidStepService((BidStepEnum)next);
                        QFilter qFilter = new QFilter("billstatus", "!=", (Object)"X");
                        qFilter.and(new QFilter("billstatus", "!=", (Object)"J"));
                        qFilter.and(new QFilter("bidproject.id", "=", (Object)projectId));
                        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)nextService.getFormId(), (String)"billstatus,evaluatedecideway", (QFilter[])new QFilter[]{qFilter});
                        if (obj == null) {
                            if (BidStepInteractiveHelper.checkStepComplete((Long)projectId, (BidStepEnum)BidStepEnum.SupplierInvitation)) {
                                this.documentService.createNextStep(bidProject, BidStepEnum.BidDocument);
                                if (stepMap.get(BidStepEnum.Clarificaiton.name()) != null) {
                                    this.projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.Clarificaiton, BidStepEnum.BidPublish});
                                }
                            }
                        } else if (obj.getDataEntityType().getProperties().containsKey((Object)"evaluatedecideway")) {
                            obj.set("evaluatedecideway", data.get("evaluatedecideway"));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                        }
                    } else if (BidStepInteractiveHelper.checkStepComplete((Long)projectId, (BidStepEnum)BidStepEnum.SupplierInvitation)) {
                        this.documentService.createNextStep(bidProject, BidStepEnum.BidDocument);
                        BidStepEnum[] steps = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProject, (BidStepEnum)BidStepEnum.BidDocument);
                        if (steps != null && BidStepEnum.BidAnswerQuestion == steps[0]) {
                            BidAnswerQuestionServiceImpl service = new BidAnswerQuestionServiceImpl();
                            service.createNextStep(bidProject, BidStepEnum.BidAnswerQuestion);
                        }
                        BidStepEnum[] stepNew = null;
                        if (stepMap.get(BidStepEnum.Clarificaiton.name()) != null) {
                            LinkedList<BidStepEnum> list = new LinkedList<BidStepEnum>();
                            for (BidStepEnum temp : steps) {
                                list.add(temp);
                            }
                            list.add(BidStepEnum.Clarificaiton);
                            stepNew = list.toArray(new BidStepEnum[list.size()]);
                        } else {
                            stepNew = steps;
                        }
                        this.projectService.saveCurrentBidStep((Object)projectId, stepNew);
                    } else if (stepMap.get(BidStepEnum.Clarificaiton.name()) != null) {
                        this.projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.SupplierInvitation, BidStepEnum.Clarificaiton});
                    } else {
                        this.projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.SupplierInvitation});
                    }
                    DynamicObject now = this.documentService.getBidDocumentById(id);
                    Integer docIsChange = (Integer)now.get("docchange");
                    if (docIsChange == null || docIsChange != 1) continue;
                    QFilter qFilter = new QFilter("billstatus", "!=", (Object)"X");
                    qFilter.and(new QFilter("bidproject.id", "=", (Object)projectId));
                    DynamicObject[] bidopen = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)"id,isdocchange", (QFilter[])new QFilter[]{qFilter}, (String)"createtime desc");
                    if (bidopen.length <= 0 || Long.compare(parent, 0L) == 0) continue;
                    DynamicObject obj = bidopen[0];
                    obj.set("isdocchange", (Object)Boolean.TRUE);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                }
                break block19;
            }
            if (!StringUtils.equals((CharSequence)key, (CharSequence)"doaudit")) break block19;
            type = EntityMetadataCache.getDataEntityType((String)"bid_biddocument_edit");
            for (DynamicObject data : datas) {
                id = (Long)data.getPkValue();
                docNow = this.documentService.getBidDocumentById(id);
                docNow.set("billstatus", (Object)BillStatusEnum.AUDITING.getVal());
                BusinessDataServiceHelper.save((IDataEntityType)type, (Object[])new Object[]{docNow});
            }
        }
    }

    private class ValidatorForBidDocument
    extends AbstractValidator {
        private ValidatorForBidDocument() {
        }

        public void validate() {
            block26: {
                Long parent;
                ExtendedDataEntity[] dateEntities;
                String key;
                block28: {
                    Long id;
                    block27: {
                        DynamicObject now;
                        Long projectId;
                        block25: {
                            key = this.getOperateKey();
                            dateEntities = this.getDataEntities();
                            projectId = null;
                            parent = null;
                            id = null;
                            now = null;
                            if (!StringUtils.equals((CharSequence)"save", (CharSequence)key)) break block25;
                            for (ExtendedDataEntity dataEntity : dateEntities) {
                                id = (Long)dataEntity.getBillPkId();
                                parent = (Long)dataEntity.getValue("parent");
                                if (parent == null || parent == 0L) continue;
                                String mess = BidDocumentOperationServicePlugin.this.documentService.checkReviseDocument(parent);
                                if (mess != null) {
                                    this.addErrorMessage(dataEntity, mess);
                                    continue;
                                }
                                QFilter qFilter = new QFilter("parent", "=", (Object)parent);
                                DynamicObjectCollection searchDatas = QueryServiceHelper.query((String)"bid_biddocument_edit", (String)"id", (QFilter[])new QFilter[]{qFilter});
                                if (searchDatas.size() == 1) {
                                    DynamicObject temp = (DynamicObject)searchDatas.get(0);
                                    Long toId = temp.getLong("id");
                                    Long nowId = (Long)dataEntity.getValue("id");
                                    if (toId.longValue() != nowId.longValue()) {
                                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u5df2\u5b58\u5728\u6807\u4e66\u4fee\u8ba2\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"BidDocumentOperationServicePlugin_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                    }
                                }
                                if (searchDatas.size() <= 1) continue;
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u5df2\u5b58\u5728\u6807\u4e66\u4fee\u8ba2\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"BidDocumentOperationServicePlugin_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            break block26;
                        }
                        if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) break block27;
                        for (ExtendedDataEntity dataEntity : dateEntities) {
                            boolean isrepublish;
                            DynamicObject[] bidDocColl;
                            id = (Long)dataEntity.getBillPkId();
                            now = BidDocumentOperationServicePlugin.this.documentService.getBidDocumentById(id);
                            parent = now.getLong("parent");
                            boolean checkRecodeBill = true;
                            if (parent != null && parent != 0L) {
                                checkRecodeBill = false;
                            }
                            if ((bidDocColl = BusinessDataServiceHelper.load((String)"bid_biddocument_edit", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidProject", "=", (Object)(projectId = Long.valueOf(now.getLong("bidproject.id"))))}, (String)"createtime desc")).length > 0 && !bidDocColl[0].getString("id").equals(id.toString())) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u65b0\u7684\u6807\u4e66\u4fee\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u539f\u5355\u636e\u3002", (String)"BidDocumentOperationServicePlugin_12", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            DynamicObject bidProject = BidDocumentOperationServicePlugin.this.projectService.getBidProjectAllById(projectId);
                            boolean isPublish = bidProject.getBoolean("bidpublish");
                            boolean isAnswer = bidProject.getBoolean("bidanswerquestion");
                            if (!isPublish && isAnswer && checkRecodeBill) {
                                BidAnswerQuestionServiceImpl answerService = new BidAnswerQuestionServiceImpl();
                                BidAnswerQuestionRecoServiceImpl recoService = new BidAnswerQuestionRecoServiceImpl();
                                boolean isComplete = BidDocumentOperationServicePlugin.this.documentService.checkBillIsStatus((Object)projectId, ((MainEntityType)dataEntity.getDataEntity().getDataEntityType()).getAppId() + "_answerquestion", BillStatusEnum.COMPLETE);
                                DynamicObjectCollection records = recoService.getRecordByProjectId(projectId);
                                if (isComplete) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDocumentOperationServicePlugin_13", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                    continue;
                                }
                                if (records.size() > 0) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u7b54\u7591\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDocumentOperationServicePlugin_14", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                    continue;
                                }
                            }
                            if (!BidDocumentOperationServicePlugin.this.documentService.checkNextStepUnStarted(bidProject, BidStepEnum.BidDocument) && checkRecodeBill) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidDocumentOperationServicePlugin_13", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProject, (BidStepEnum)BidStepEnum.BidDocument);
                            BidAnswerQuestionServiceImpl service = new BidAnswerQuestionServiceImpl();
                            if (nextStep != null && BidStepEnum.BidAnswerQuestion == nextStep[0] && checkRecodeBill && !service.checkNextStepUnStarted(bidProject, BidStepEnum.BidAnswerQuestion)) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"BidDocumentOperationServicePlugin_15", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            if (!(isrepublish = QueryServiceHelper.exists((String)"bid_bidpublish", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "not in", (Object)new String[]{"X", "J"}), new QFilter("biddocument", "=", (Object)id)}))) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u518d\u6b21\u53d1\u6807\u540e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\u3002", (String)"BidDocumentOperationServicePlugin_16", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                        break block26;
                    }
                    if (!StringUtils.equals((CharSequence)"submit", (CharSequence)key)) break block28;
                    for (ExtendedDataEntity dataEntity : dateEntities) {
                        id = (Long)dataEntity.getBillPkId();
                        int techFileNum = (Integer)dataEntity.getValue("tech_docnum");
                        int comFileNum = (Integer)dataEntity.getValue("com_docnum");
                        int bidDocNum = (Integer)dataEntity.getValue("biddoc_num");
                        parent = (Long)dataEntity.getValue("parent");
                        DynamicObject bidProject = (DynamicObject)dataEntity.getValue("bidproject");
                        String docTypeStr = bidProject.getString("doctype");
                        if (((Boolean)dataEntity.getValue("isseparatedoc")).booleanValue()) {
                            if (techFileNum == 0 && comFileNum == 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u5bf9\u5e94\u7684\u201c\u6280\u672f\u6807\u6587\u4ef6\u201d\u3001\u201c\u5546\u52a1\u6807\u6587\u4ef6\u201d\u5c1a\u672a\u7f16\u5236\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidDocumentOperationServicePlugin_17", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            } else if (techFileNum == 0 && (BidOpenTypeEnum.TECHNICAL.getValue().equals(docTypeStr) || BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr))) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u5bf9\u5e94\u7684\u201d\u6280\u672f\u6807\u6587\u4ef6\u201c\u5c1a\u672a\u7f16\u5236\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidDocumentOperationServicePlugin_18", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            } else if (comFileNum == 0 && (BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr) || BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr))) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u5bf9\u5e94\u7684\u201c\u5546\u52a1\u6807\u6587\u4ef6\u201d\u5c1a\u672a\u7f16\u5236\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidDocumentOperationServicePlugin_19", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                        } else if (bidDocNum == 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u8be5\u7acb\u9879\u7684\u6807\u4e66\u6587\u4ef6\u3002", (String)"BidDocumentOperationServicePlugin_20", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                        if (parent == null || parent == 0L) continue;
                        String mess = BidDocumentOperationServicePlugin.this.documentService.checkReviseDocument(parent);
                        if (mess != null) {
                            this.addErrorMessage(dataEntity, mess);
                            continue;
                        }
                        QFilter qFilter = new QFilter("parent", "=", (Object)parent);
                        DynamicObjectCollection searchDatas = QueryServiceHelper.query((String)"bid_biddocument_edit", (String)"id", (QFilter[])new QFilter[]{qFilter});
                        if (searchDatas.size() == 1) {
                            DynamicObject temp = (DynamicObject)searchDatas.get(0);
                            Long toId = temp.getLong("id");
                            Long nowId = (Long)dataEntity.getValue("id");
                            if (toId.longValue() != nowId.longValue()) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u5df2\u5b58\u5728\u6807\u4e66\u4fee\u8ba2\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidDocumentOperationServicePlugin_21", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                        }
                        if (searchDatas.size() <= 1) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u5df2\u5b58\u5728\u6807\u4e66\u4fee\u8ba2\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidDocumentOperationServicePlugin_21", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    break block26;
                }
                if (!StringUtils.equals((CharSequence)key, (CharSequence)"delete")) break block26;
                for (ExtendedDataEntity dataEntity : dateEntities) {
                    DynamicObject obj;
                    String status;
                    parent = (Long)dataEntity.getValue("parent");
                    if (parent == null || parent == 0L || !StringUtils.equals((CharSequence)(status = (obj = BidDocumentOperationServicePlugin.this.documentService.getBidDocumentById(parent, "billstatus")).getString("billstatus")), (CharSequence)BillStatusEnum.ADJUSTING.getVal())) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u6b63\u5728\u4fee\u8ba2\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"BidDocumentOperationServicePlugin_22", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

