/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.ReWfUtil;
import kd.scm.bid.common.util.SupplierHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.SendMessageUtil;

public class BidInvitationOperateServicePlugIn
extends AbstractOperationServicePlugIn {
    private static final String SEND = "send";
    private static final String UN_SEND = "unsend";
    private static final String SUBMIT_AUDIT = "submitaudit";
    protected IBidProjectService projectService = new BidProjectServiceImpl();
    protected ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("supplierentry");
        e.getFieldKeys().add("supplierentry.supplier");
        e.getFieldKeys().add("supplierentry.invitationstatus");
        e.getFieldKeys().add("supplierentry.projectpartner");
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("supplierinvitation");
        e.getFieldKeys().add("deadlinedate");
        e.getFieldKeys().add("releaseuser");
        e.getFieldKeys().add("releasestatus");
        e.getFieldKeys().add("publishdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        String key = e.getOperationKey();
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            if ("save".equals(key)) {
                data.set("enable", (Object)1L);
                continue;
            }
            if ("unaudit".equals(key)) {
                data.set("status", (Object)"A");
                data.set("releasestatus", null);
                continue;
            }
            if ("audit".equals(key)) {
                data.set("releasestatus", (Object)"U");
                continue;
            }
            if (SUBMIT_AUDIT.equals(key)) {
                data.set("releasestatus", (Object)"U");
                continue;
            }
            if (SEND.equals(key)) {
                this.send(data);
                continue;
            }
            if (!UN_SEND.equals(key)) continue;
            this.unSend(data);
        }
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        for (DynamicObject object : dataEntities = e.getDataEntities()) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u8c03\u8bd5@%1$s@%2$s@%3$s", (String)"BidInvitationOperateServicePlugIn_20", (String)"scm-bid-opplugin", (Object[])new Object[0]), key, object.getString("number"), object.getDynamicObjectCollection("supplierentry").size()));
        }
    }

    public void send(DynamicObject invitationData) {
        DynamicObject supplierInvitation;
        invitationData.set("releasestatus", (Object)"P");
        invitationData.set("releaseuser", (Object)RequestContext.get().getUserId());
        invitationData.set("publishdate", (Object)new Date());
        DynamicObjectCollection supplierEntryCol = invitationData.getDynamicObjectCollection("supplierentry");
        for (DynamicObject supplierEntry : supplierEntryCol) {
            supplierEntry.set("invitationstatus", (Object)"UNCONFIRM");
        }
        DynamicObject invitationSupplierInvitation = invitationData.getDynamicObject("supplierInvitation");
        Object supplierInvitationId = null;
        if (invitationSupplierInvitation != null) {
            supplierInvitationId = invitationSupplierInvitation.getPkValue();
        }
        Object bidProjectId = invitationData.getDynamicObject("bidproject").getPkValue();
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"entitytypeid");
        String appId = bidProject.getString("entitytypeid").split("_")[0];
        boolean isFromSupInv = true;
        if (null == supplierInvitationId) {
            supplierInvitation = BusinessDataServiceHelper.loadSingle((String)(appId + "_supplierinvitation"), (String)"id,bidsection,supplierentry,supplierentry.supplier,supplierentry.invitationstatus,supplierentry.invitation,supplierentry.isrecommend,supplierentry.projectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)});
            isFromSupInv = false;
        } else {
            supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)supplierInvitationId, (String)(appId + "_supplierinvitation"), (String)"id,bidsection,supplierentry,supplierentry.supplier,supplierentry.invitationstatus,supplierentry.invitation,supplierentry.isrecommend,supplierentry.projectpartner");
        }
        this.updatePartUser(supplierInvitation, invitationData);
        this.updateSupplierInvitation(appId, SEND, supplierInvitation, invitationData, isFromSupInv);
        this.updateBidProject(appId, SEND, invitationData, bidProjectId, isFromSupInv);
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invitationData});
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    public void updatePartUser(DynamicObject supplierInvitation, DynamicObject invitationData) {
        HashMap<String, DynamicObject> partUser = new HashMap<String, DynamicObject>();
        DynamicObjectCollection bidrollsection = supplierInvitation.getDynamicObjectCollection("bidsection");
        for (DynamicObject section : bidrollsection) {
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                DynamicObject parter = row.getDynamicObject("projectpartner");
                DynamicObject supplier = row.getDynamicObject("supplier");
                if (supplier == null || parter == null) continue;
                partUser.put(supplier.getPkValue().toString(), parter);
            }
        }
        if (partUser.size() > 0) {
            DynamicObjectCollection supplierentry = invitationData.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                String supplerPk = row.getDynamicObject("supplier").getPkValue().toString();
                DynamicObject dynamicObject = (DynamicObject)partUser.get(supplerPk);
                row.set("projectpartner", (Object)dynamicObject);
            }
        }
    }

    public void unSend(DynamicObject invitationData) {
        invitationData.set("releasestatus", (Object)"U");
        invitationData.set("releaseuser", (Object)0);
        invitationData.set("publishdate", null);
        ArrayList<String> unSendSupplierIdList = new ArrayList<String>();
        DynamicObjectCollection supplierEntryCol = invitationData.getDynamicObjectCollection("supplierentry");
        for (DynamicObject supplierEntry : supplierEntryCol) {
            unSendSupplierIdList.add(supplierEntry.getDynamicObject("supplier").getString("id"));
        }
        DynamicObject invitationSupplierInvitation = invitationData.getDynamicObject("supplierInvitation");
        Object supplierInvitationId = null;
        if (invitationSupplierInvitation != null) {
            supplierInvitationId = invitationSupplierInvitation.getPkValue();
        }
        Object bidProjectId = invitationData.getDynamicObject("bidproject").getPkValue();
        DynamicObject tempBidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"entitytypeid");
        String appId = tempBidProject.getString("entitytypeid").split("_")[0];
        DynamicObject supplierInvitation = null == supplierInvitationId ? BusinessDataServiceHelper.loadSingle((String)(appId + "_supplierinvitation"), (String)"id,bidsection,bidsection.supplierentry,supplierentry.supplier,supplierentry.invitationstatus,supplierentry.invitation,supplierentry.isrecommend", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)}) : BusinessDataServiceHelper.loadSingle((Object)supplierInvitationId, (String)(appId + "_supplierinvitation"));
        DynamicObjectCollection bidSectionCollection = supplierInvitation.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidSection : bidSectionCollection) {
            DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                if (!unSendSupplierIdList.contains(supplierId)) continue;
                supplierEntry.set("invitationstatus", (Object)"UNSEND");
                supplierEntry.set("invitation", (Object)0);
                supplierEntry.set("isrecommend", (Object)Boolean.TRUE);
            }
        }
        SaveServiceHelper.update((DynamicObject)supplierInvitation);
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)(appId + "_project"));
        DynamicObjectCollection bidSectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        for (DynamicObject sectionEntry : bidSectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null || !unSendSupplierIdList.contains(supplier.getString("id"))) continue;
                supplierEntry.set("invitationstatus", (Object)"UNSEND");
            }
        }
        SaveServiceHelper.update((DynamicObject)bidProject);
        SaveServiceHelper.update((DynamicObject)invitationData);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4BidEvaluation());
    }

    protected void updateSupplierInvitation(String appId, String operateKey, DynamicObject supplierInvitation, DynamicObject invitationData, boolean isFromSupInv) {
        ArrayList<String> unSendSupplierIdList = new ArrayList<String>();
        DynamicObjectCollection supplierEntryCol = invitationData.getDynamicObjectCollection("supplierentry");
        for (Object supplierEntry : supplierEntryCol) {
            unSendSupplierIdList.add(supplierEntry.getDynamicObject("supplier").getString("id"));
        }
        DynamicObjectCollection bidSectionCol = supplierInvitation.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidSection : bidSectionCol) {
            DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                if (!unSendSupplierIdList.contains(supplierId)) continue;
                supplierEntry.set("invitationstatus", (Object)"UNCONFIRM");
                supplierEntry.set("invitation", invitationData.getPkValue());
                supplierEntry.set("isrecommend", (Object)Boolean.FALSE);
            }
        }
        SaveServiceHelper.update((DynamicObject)supplierInvitation);
        if (isFromSupInv) {
            boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
            if (!enable) {
                return;
            }
            new SendMessageUtil().sentInvitedMsg(appId, operateKey, invitationData.getPkValue(), supplierInvitation);
        }
    }

    protected void updateBidProject(String appId, String operateKey, DynamicObject invitationData, Object bidProjectId, boolean isFromSupInv) {
        ArrayList<String> unSendSupplierEntryList = new ArrayList<String>();
        DynamicObjectCollection supplierEntryCol = invitationData.getDynamicObjectCollection("supplierentry");
        for (DynamicObject supplierEntry : supplierEntryCol) {
            unSendSupplierEntryList.add(supplierEntry.getDynamicObject("supplier").getString("id"));
        }
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)(appId + "_project"));
        DynamicObjectCollection bidSectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        for (DynamicObject sectionEntry : bidSectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null || !unSendSupplierEntryList.contains(supplier.getString("id"))) continue;
                supplierEntry.set("invitationstatus", (Object)"UNCONFIRM");
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidProject});
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
        if (!isFromSupInv) {
            new SendMessageUtil().sendInvitationByBidProject(appId, operateKey, bidProjectId, invitationData.getPkValue());
        }
    }

    private static class Validator4BidEvaluation
    extends AbstractValidator {
        private Validator4BidEvaluation() {
        }

        public void validate() {
            String key = this.getOperateKey();
            if (BidInvitationOperateServicePlugIn.SUBMIT_AUDIT.equals(key)) {
                ExtendedDataEntity[] dataEntities;
                this.varifyPartner();
                for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
                    String id = dataEntity.getBillPkId().toString();
                    if (StringUtils.isEmpty((CharSequence)id) || "0".equals(id)) {
                        this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u8fdb\u884c\u63d0\u4ea4\u5e76\u5ba1\u6838\u64cd\u4f5c", (String)"BidInvitationOperateServicePlugIn_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                    this.varify(BidInvitationOperateServicePlugIn.SUBMIT_AUDIT, ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u5ba1\u6838", (String)"BidInvitationOperateServicePlugIn_12", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
                DynamicObject bidProject = dataEntities[0].getDataEntity().getDynamicObject("bidproject");
                DynamicObject tempBidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project", (String)"entitytypeid");
                String formId = tempBidProject.getString("entitytypeid").split("_")[0] + "_invitation";
                if (ReWfUtil.hasEableProcess((String)formId)) {
                    this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u5df2\u542f\u7528\u5de5\u4f5c\u6d41\u65f6\u4e0d\u5141\u8bb8\u64cd\u4f5c\u63d0\u4ea4\u5e76\u5ba1\u6838\u6309\u94ae", (String)"BidInvitationOperateServicePlugIn_13", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                }
            } else {
                if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
                    this.varifyPartner();
                    this.varify(key, ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BidInvitationOperateServicePlugIn_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.equals((CharSequence)BidInvitationOperateServicePlugIn.SEND, (CharSequence)key)) {
                    this.varify(key, ResManager.loadKDString((String)"\u53d1\u5e03", (String)"BidInvitationOperateServicePlugIn_14", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    this.varifyPartner();
                    return;
                }
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                    this.varifyPartner();
                    this.varify(key, ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"BidInvitationOperateServicePlugIn_15", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (BidInvitationOperateServicePlugIn.UN_SEND.equals(key)) {
                    ArrayList<String> unSendSupplierIdList = new ArrayList<String>();
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        unSendSupplierIdList.clear();
                        DynamicObject data = dataEntity.getDataEntity();
                        DynamicObjectCollection invSupplierEntryCol = data.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierEntry : invSupplierEntryCol) {
                            unSendSupplierIdList.add(supplierEntry.getDynamicObject("supplier").getString("id"));
                        }
                        DynamicObject supplierInvitationData = data.getDynamicObject("supplierInvitation");
                        DynamicObject bidProject = data.getDynamicObject("bidproject");
                        Object bidProjectId = 0L;
                        if (bidProject != null) {
                            bidProjectId = bidProject.getPkValue();
                        }
                        DynamicObject tempBidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"entitytypeid");
                        String appId = tempBidProject.getString("entitytypeid").split("_")[0];
                        DynamicObject supplierInvitation = supplierInvitationData == null ? BusinessDataServiceHelper.loadSingle((String)(appId + "_supplierinvitation"), (String)"billstatus,bidsection,bidsection.supplierentry,supplierentry.supplier,supplierentry.invitationstatus,supplierentry.invitation", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"})}) : BusinessDataServiceHelper.loadSingle((Object)supplierInvitationData.getPkValue(), (String)(appId + "_supplierinvitation"));
                        if (supplierInvitation != null) {
                            String billStatus = supplierInvitation.getString("billstatus");
                            DynamicObjectCollection bidSectionCol = supplierInvitation.getDynamicObjectCollection("bidsection");
                            boolean undoSendFlag = false;
                            block3: for (DynamicObject bidSection : bidSectionCol) {
                                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                                for (DynamicObject supplierEntry : supplierEntryCol) {
                                    String invitationStatus = supplierEntry.getString("invitationstatus");
                                    String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                                    if (!unSendSupplierIdList.contains(supplierId) || !"ACCEPTED".equals(invitationStatus) && !"REJECTED".equals(invitationStatus)) continue;
                                    undoSendFlag = true;
                                    continue block3;
                                }
                            }
                            if (undoSendFlag) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u4f9b\u5e94\u5546\u63a5\u53d7\u6216\u62d2\u7edd\u9080\u8bf7\u51fd\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500", (String)"BidInvitationOperateServicePlugIn_16", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                            if (BillStatusEnum.SAVE.getVal().equals(billStatus) || BillStatusEnum.DISBEGIN.getVal().equals(billStatus)) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5165\u56f4\u5355\u636e\u4e3a\u672a\u5f00\u59cb\u6216\u6682\u5b58\u72b6\u6001\uff0c\u624d\u5141\u8bb8\u64a4\u9500\u53d1\u5e03\u9080\u8bf7\u51fd", (String)"BidInvitationOperateServicePlugIn_21", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5173\u8054\u7684\u5165\u56f4\u5355\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500", (String)"BidInvitationOperateServicePlugIn_22", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        }

        protected void varifyPartner() {
            DynamicObject bidProject = this.dataEntities[0].getDataEntity().getDynamicObject("bidproject");
            DynamicObject tempBidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project", (String)"entitytypeid");
            String appId = tempBidProject.getString("entitytypeid").split("_")[0];
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject data = dataEntity.getDataEntity();
                DynamicObjectCollection invSupplierEntryCol = data.getDynamicObjectCollection("supplierentry");
                for (DynamicObject invSupplier : invSupplierEntryCol) {
                    DynamicObject projectpartner = invSupplier.getDynamicObject("projectpartner");
                    if (projectpartner != null) continue;
                    DynamicObject supplier = invSupplier.getDynamicObject("supplier");
                    Long supplierId = supplier.getLong("id");
                    Long adminUserId = null;
                    if ("rebm".equals(appId)) {
                        long id = (Long)SupplierHelper.getSysSupByRESMSup((Long)supplierId).getPkValue();
                        adminUserId = SupplierHelper.listAdminUserIdBySupplier((Long)id);
                    } else {
                        adminUserId = SupplierHelper.listAdminUserIdBySupplier((Long)supplierId);
                    }
                    if (adminUserId != null && adminUserId != 0L) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4f9b\u5e94\u5546\u6ca1\u6709\u5546\u52a1\u4f19\u4f34\u7528\u6237\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002\u3002", (String)"BidInvitationOperateServicePlugIn_23", (String)"scm-bid-opplugin", (Object[])new Object[0]), invSupplier.getDynamicObject("supplier").getString("name")));
                }
            }
        }

        protected void varify(String key, String operation) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                boolean checkDeadLineDateFlag;
                DynamicObject data = dataEntity.getDataEntity();
                Date deadlinedate = data.getDate("deadlinedate");
                if (deadlinedate == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s:\u201c\u9080\u8bf7\u51fd\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidInvitationOperateServicePlugIn_17", (String)"scm-bid-opplugin", (Object[])new Object[0]), operation));
                }
                boolean bl = checkDeadLineDateFlag = "save".equals(key) || BidInvitationOperateServicePlugIn.SEND.equals(key) || "submit".equals(key) || BidInvitationOperateServicePlugIn.SUBMIT_AUDIT.equals(key);
                if (checkDeadLineDateFlag && deadlinedate != null && deadlinedate.compareTo(new Date()) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u9080\u8bf7\u51fd\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u201d\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u4e0d\u80fd%s\u9080\u8bf7\u51fd\u3002", (String)"BidInvitationOperateServicePlugIn_18", (String)"scm-bid-opplugin", (Object[])new Object[0]), operation));
                    break;
                }
                DynamicObject supplierInvitationData = data.getDynamicObject("supplierInvitation");
                if (null == supplierInvitationData) continue;
                DynamicObject supplierInvitation = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", supplierInvitationData.getPkValue())});
                String billStatus = supplierInvitation.getString("billstatus");
                if (BillStatusEnum.SAVE.getVal().equals(billStatus)) continue;
                String status = ResManager.loadKDString((String)"\u4e0d\u662f\u6682\u5b58\u72b6\u6001", (String)"BidInvitationOperateServicePlugIn_5", (String)"scm-bid-opplugin", (Object[])new Object[0]);
                if (BillStatusEnum.INVALID.getVal().equals(billStatus)) {
                    status = ResManager.loadKDString((String)"\u5df2\u4f5c\u5e9f", (String)"BidInvitationOperateServicePlugIn_6", (String)"scm-bid-opplugin", (Object[])new Object[0]);
                }
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5165\u56f4\u5355\u636e%1$s\uff0c\u4e0d\u80fd%2$s\u9080\u8bf7\u51fd\u3002", (String)"BidInvitationOperateServicePlugIn_19", (String)"scm-bid-opplugin", (Object[])new Object[0]), status, operation));
            }
        }
    }
}

