/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.id.ID;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scm.bid.business.basedata.IProficientService;
import kd.scm.bid.business.basedata.serviceImpl.ProficientServiceImpl;
import kd.scm.bid.business.bill.IBidAnswerQuestionService;
import kd.scm.bid.business.bill.IBidDocumentService;
import kd.scm.bid.business.bill.IBidOpenService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.IBidSupplierFileService;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidSupplierFileServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.EvalItemType;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.enums.ScoreMode;
import kd.scm.bid.common.enums.ScoreType;
import kd.scm.bid.common.util.BidOpenUtil;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.SupplierInvitationUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;
import kd.scm.bid.opplugin.bill.util.BidProjectQueryUtil;
import kd.scm.bid.opplugin.bill.util.NextStepSendMessage;

public class BidOpenOperationServicePlugIn
extends AbstractOperationServicePlugIn {
    protected IBidOpenService bidOpenService = new BidOpenServiceImpl();
    protected IBidProjectService bidProjectService = new BidProjectServiceImpl();
    protected IBidDocumentService documentService = new BidDocumentServiceImpl();
    protected IBidSupplierFileService bidSupplierFileService = new BidSupplierFileServiceImpl();
    protected IBidAnswerQuestionService answerQuestion = new BidAnswerQuestionServiceImpl();
    protected IProficientService proficientService = new ProficientServiceImpl();
    protected IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();
    protected IBidProjectService projectService = new BidProjectServiceImpl();
    private static Log logger = LogFactory.getLog(BidOpenOperationServicePlugIn.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        ValidatorForBidOpen validator = new ValidatorForBidOpen();
        validator.appId = this.billEntityType.getAppId();
        e.addValidator((AbstractValidator)validator);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidsection");
        e.getFieldKeys().add("bidopen_proficient");
        e.getFieldKeys().add("supplierentry");
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("techweight");
        e.getFieldKeys().add("comweight");
        e.getFieldKeys().add("supplier_deposit");
        e.getFieldKeys().add("supplier_exceptvat");
        e.getFieldKeys().add("supplier_pricevat");
        e.getFieldKeys().add("supplier_istender");
        e.getFieldKeys().add("supplier_tenderprice");
        e.getFieldKeys().add("supplier_rate");
        e.getFieldKeys().add("supplier_isinvalid");
        e.getFieldKeys().add("supplier_deposittype");
        e.getFieldKeys().add("sectionname");
        e.getFieldKeys().add("proficient_technical");
        e.getFieldKeys().add("proficient_commercial");
        e.getFieldKeys().add("isonlineeval");
        e.getFieldKeys().add("bidopendeadline");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("type1");
        e.getFieldKeys().add("bidopen_evalitementry");
        e.getFieldKeys().add("bidopen_evalitementry.seq");
        e.getFieldKeys().add("scoremode");
        e.getFieldKeys().add("scoretype");
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("item");
        e.getFieldKeys().add("score");
        e.getFieldKeys().add("weight");
        e.getFieldKeys().add("supplier_isinvalid");
        e.getFieldKeys().add("evaluatedecideway");
        e.getFieldKeys().add("opentype");
        e.getFieldKeys().add("bidproject.bidopentype");
        e.getFieldKeys().add("supplierdetail");
        e.getFieldKeys().add("supplierdetail.taxrate");
        e.getFieldKeys().add("supplierdetail.costrate");
        e.getFieldKeys().add("supplierdetail.materialid");
        e.getFieldKeys().add("supplierdetail.materialdes");
        e.getFieldKeys().add("supplierdetail.purentryproject");
        e.getFieldKeys().add("supplierdetail.purentrycontent");
        e.getFieldKeys().add("supplierdetail.resourceitem");
        e.getFieldKeys().add("supplierentry.supplier_taxrate");
        e.getFieldKeys().add("supplierentry.supplier_rate");
        e.getFieldKeys().add("bidproject.bidsection.projectentry");
        e.getFieldKeys().add("bidproject.bidopendeadline");
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("supplierentry.supplier");
        e.getFieldKeys().add("supplierdetail.pursupplier");
        e.getFieldKeys().add("supplierinvitationid");
        e.getFieldKeys().add("evaluatedmethod");
        e.getFieldKeys().add("bidproject.bidbottommake");
        e.getFieldKeys().add("bottomsection");
        e.getFieldKeys().add("botsectionname");
        e.getFieldKeys().add("bottomentry");
        e.getFieldKeys().add("botpurentrycontent");
        e.getFieldKeys().add("botpurentryproject");
        e.getFieldKeys().add("botmaterialid");
        e.getFieldKeys().add("botcontrolamount");
        e.getFieldKeys().add("botcontrolvat");
        e.getFieldKeys().add("botctrlamtexceptvat");
        e.getFieldKeys().add("declareamount");
        e.getFieldKeys().add("finalauditamount");
        e.getFieldKeys().add("botqty");
        e.getFieldKeys().add("planamount");
        e.getFieldKeys().add("nottaxplanamount");
        e.getFieldKeys().add("baseprice");
        e.getFieldKeys().add("botlistnumber");
        e.getFieldKeys().add("botlistname");
        e.getFieldKeys().add("botresourceitem");
        e.getFieldKeys().add("botmaterialdes");
        e.getFieldKeys().add("bidopentime");
        e.getFieldKeys().add("techopenbidtime");
        e.getFieldKeys().add("busopenbidtime");
        e.getFieldKeys().add("lbidopentime");
        e.getFieldKeys().add("ltechopenbidtime");
        e.getFieldKeys().add("lbusopenbidtime");
        e.getFieldKeys().add("isfromreback");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block18: {
            String appId;
            DynamicObject now;
            Long id;
            DynamicObject[] dataEntities;
            String key;
            block17: {
                super.beginOperationTransaction(e);
                key = e.getOperationKey();
                dataEntities = e.getDataEntities();
                id = null;
                now = null;
                DynamicObject tempProject = dataEntities[0].getDynamicObject("bidproject");
                appId = this.getAppId(tempProject);
                boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
                if (!StringUtils.equals((CharSequence)key, (CharSequence)"save") && !StringUtils.equals((CharSequence)key, (CharSequence)"submit")) break block17;
                ArrayList<Long> list = new ArrayList<Long>();
                ArrayList<Long> sections = new ArrayList<Long>();
                for (DynamicObject data : dataEntities) {
                    Object saveSection2;
                    DynamicObjectCollection saveSections = data.getDynamicObjectCollection("bidsection");
                    for (Object saveSection2 : saveSections) {
                        DynamicObjectCollection saveSuppliers = saveSection2.getDynamicObjectCollection("supplierentry");
                        Long sectionId = saveSection2.getLong("id");
                        sections.add(sectionId);
                        for (DynamicObject saveSupplier : saveSuppliers) {
                            Long supplierId = null;
                            try {
                                supplierId = saveSupplier.getLong("supplier.id");
                            }
                            catch (Exception e1) {
                                return;
                            }
                            DynamicObject tech = this.bidSupplierFileService.getOneFileRecordByIds(supplierId, sectionId, "techFile", "id");
                            DynamicObject com = this.bidSupplierFileService.getOneFileRecordByIds(supplierId, sectionId, "comFile", "id");
                            DynamicObject ten = this.bidSupplierFileService.getOneFileRecordByIds(supplierId, sectionId, "tenFile", "id");
                            DynamicObject other = this.bidSupplierFileService.getOneFileRecordByIds(supplierId, sectionId, "otherFile", "id");
                            if (tech != null) {
                                list.add(tech.getLong("id"));
                            }
                            if (com != null) {
                                list.add(com.getLong("id"));
                            }
                            if (ten != null) {
                                list.add(ten.getLong("id"));
                            }
                            if (other == null) continue;
                            list.add(other.getLong("id"));
                        }
                    }
                    DynamicObjectCollection entryEntityColl = data.getDynamicObjectCollection("entryentity");
                    saveSection2 = entryEntityColl.iterator();
                    while (saveSection2.hasNext()) {
                        DynamicObject entryEntityRow = (DynamicObject)saveSection2.next();
                        DynamicObjectCollection evalItemEntryColl = entryEntityRow.getDynamicObjectCollection("bidopen_evalitementry");
                        for (int i = 0; i < evalItemEntryColl.size(); ++i) {
                            DynamicObject evalItemEntryRow = (DynamicObject)evalItemEntryColl.get(i);
                            evalItemEntryRow.set("seq", (Object)(i + 1));
                        }
                    }
                }
                QFilter qFilter1 = new QFilter("sectionid", "in", (Object)sections.toArray());
                QFilter qFilter2 = new QFilter("id", "not in", (Object)list.toArray());
                DeleteServiceHelper.delete((String)"bid_supplier_file", (QFilter[])new QFilter[]{qFilter1, qFilter2});
                for (DynamicObject obj : dataEntities) {
                    id = obj.getLong("id");
                    now = this.bidOpenService.getBidOpenByIdAndType(id, appId);
                    if (enable) {
                        this.restoreRateEntityDate(obj, now, appId);
                        continue;
                    }
                    this.updateRateEntityData(obj);
                }
                if (!StringUtils.equals((CharSequence)key, (CharSequence)"submit")) break block18;
                for (DynamicObject data : dataEntities) {
                    DynamicObject bidProject = data.getDynamicObject("bidproject");
                    data.set("billstatus", (Object)"A");
                    BidOpenUtil.setPurDetail((String)appId, (DynamicObject)bidProject, (DynamicObject)data);
                    data.set("billstatus", (Object)"B");
                }
                break block18;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"confirmopen") || StringUtils.equals((CharSequence)key, (CharSequence)"audit")) {
                for (DynamicObject obj : dataEntities) {
                    DynamicObject bidOpen;
                    DynamicObject bidProject;
                    DynamicObject bidMode;
                    DynamicObject answer;
                    id = obj.getLong("id");
                    DynamicObject bidProjectData = obj.getDynamicObject("bidproject");
                    now = this.bidOpenService.getBidOpenByIdAndType(id, appId);
                    this.restoreRateEntityDate(obj, now, appId);
                    if (!StringUtils.equals((CharSequence)key, (CharSequence)"confirmopen")) continue;
                    Date basedatapropfield = obj.getDate("bidproject.bidopendeadline");
                    Object pkValue = obj.getPkValue();
                    DynamicObject bidopen = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)(appId + "_bidopen"));
                    obj.set("bidopendeadline", (Object)basedatapropfield);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidopen});
                    long projectId = bidProjectData.getLong("id");
                    QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                    BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)bidProjectData, (BidStepEnum)BidStepEnum.BidAnswerQuestion);
                    if (nextStep != null && BidStepEnum.BidOpen == nextStep[0] && null != (answer = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"answerquestion", ((Object)((Object)this)).getClass()), (String)"billstatus,realanswertime,modifytime,modifier,auditor,auditdate", (QFilter[])new QFilter[]{qFilter})) && !answer.get("billstatus").equals("F")) {
                        answer.set("realanswertime", (Object)new Date());
                        answer.set("billstatus", (Object)BillStatusEnum.COMPLETE.getVal());
                        answer.set("modifytime", (Object)new Date());
                        answer.set("modifier", (Object)RequestContext.get().getUserId());
                        answer.set("auditor", (Object)RequestContext.get().getUserId());
                        answer.set("auditdate", (Object)new Date());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{answer});
                        this.projectService.saveCurrentBidStep((Object)projectId, nextStep);
                    }
                    if ((bidMode = (bidProject = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()))).getDynamicObject("bidmode")).getBoolean("bidevaluation")) continue;
                    String bidOpenSelectType = bidProject.getString("bidopentype");
                    String openType = obj.getString("opentype");
                    if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenSelectType)) {
                        if (!StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)openType) || "O".equals((bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())})).getString("billstatus"))) continue;
                        this.sendMessage(bidProject, openType);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenSelectType) || !StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)openType) || "O".equals((bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue())})).getString("billstatus"))) continue;
                    this.sendMessage(bidProject, openType);
                }
            }
        }
    }

    protected void updateSupplierDetailUntenStatus(DynamicObject obj) {
        DynamicObject bidProject = obj.getDynamicObject("bidproject");
        Object bidProjectId = bidProject.getPkValue();
        ArrayList supplierIdList = new ArrayList(16);
        DynamicObjectCollection bidsection = obj.getDynamicObjectCollection("bidsection");
        bidsection.forEach(section -> {
            DynamicObjectCollection supplierDetail = section.getDynamicObjectCollection("supplierentry");
            supplierDetail.forEach(detail -> {
                DynamicObject supplier = detail.getDynamicObject("supplier");
                if (supplier == null) {
                    return;
                }
                Object supplierId = supplier.getPkValue();
                if (!supplierIdList.contains(supplierId)) {
                    supplierIdList.add(supplierId);
                }
            });
        });
        String tenAppId = this.getTenAppId(bidProject);
        DynamicObject[] tenders = BusinessDataServiceHelper.load((String)(tenAppId + "_mytender"), (String)"tenderstatus,supplier,entry,sectionname,sectionstatus,untenderflag", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("tenderstatus", "!=", (Object)"FAILURE"), new QFilter("supplier", "in", supplierIdList)});
        if (tenders == null || tenders.length == 0) {
            BizLog.log((String)"BID REBACKBID ================ CONFIRMOPEN ENDOPERATIONTRANSACTION ===========NO MYTENDERS FOUND");
            return;
        }
        ArrayList untenderSupplierList = new ArrayList(16);
        bidsection.forEach(section -> {
            String sectionname = section.getString("sectionname");
            section.getDynamicObjectCollection("supplierentry").forEach(detail -> {
                DynamicObject supplier = detail.getDynamicObject("supplier");
                if (supplier == null) {
                    return;
                }
                Object supplierId = supplier.getPkValue();
                boolean istender = detail.getBoolean("supplier_istender");
                if (istender) {
                    detail.set("untendertype", null);
                    detail.set("untenderflag", (Object)Boolean.FALSE);
                    detail.set("untenderreason", null);
                    return;
                }
                boolean untenderflag = detail.getBoolean("untenderflag");
                if (untenderflag) {
                    return;
                }
                untenderSupplierList.add(sectionname + supplierId);
                detail.set("untendertype", (Object)"1");
                detail.set("untenderflag", (Object)Boolean.TRUE);
                detail.set("untenderreason", (Object)ResManager.loadKDString((String)"\u903e\u671f\u672a\u6295\u6807", (String)"BidOpenOperationServicePlugIn_151", (String)"scm-bid-opplugin", (Object[])new Object[0]));
            });
        });
        for (DynamicObject tender : tenders) {
            Object supplierId = tender.getDynamicObject("supplier").getPkValue();
            DynamicObjectCollection entry = tender.getDynamicObjectCollection("entry");
            boolean flag = false;
            for (DynamicObject e : entry) {
                String sectionname = e.getString("sectionname");
                if (untenderSupplierList.contains(sectionname + supplierId)) {
                    e.set("sectionstatus", (Object)"UNTENDERED");
                    e.set("untenderflag", (Object)Boolean.TRUE);
                    continue;
                }
                String sectionstatus = e.getString("sectionstatus");
                if ("UNTENDERED".equals(sectionstatus)) continue;
                flag = true;
            }
            tender.set("tenderstatus", (Object)(flag ? "TENDERED" : "UNTENDERED"));
        }
        SaveServiceHelper.save((DynamicObject[])tenders);
    }

    protected void updateRateEntityData(DynamicObject obj) {
        DynamicObjectCollection bidSectionColl1 = obj.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidSectionColl1.size(); ++i) {
            DynamicObjectCollection supplierentry1 = ((DynamicObject)bidSectionColl1.get(i)).getDynamicObjectCollection("supplierentry");
            DynamicObjectCollection supplierdetail1 = ((DynamicObject)bidSectionColl1.get(i)).getDynamicObjectCollection("supplierdetail");
            if (supplierentry1 != null && supplierentry1.size() > 0) {
                for (int j = 0; j < supplierentry1.size(); ++j) {
                    ((DynamicObject)supplierentry1.get(j)).set("supplier_taxrate", (Object)((DynamicObject)supplierentry1.get(j)).getBigDecimal("supplier_taxrate").divide(new BigDecimal("100")));
                    ((DynamicObject)supplierentry1.get(j)).set("supplier_rate", (Object)((DynamicObject)supplierentry1.get(j)).getBigDecimal("supplier_rate").divide(new BigDecimal("100")));
                }
            }
            if (supplierdetail1 == null || supplierdetail1.size() <= 0) continue;
            for (int m = 0; m < supplierdetail1.size(); ++m) {
                ((DynamicObject)supplierdetail1.get(m)).set("taxrate", (Object)((DynamicObject)supplierdetail1.get(m)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                ((DynamicObject)supplierdetail1.get(m)).set("costrate", (Object)((DynamicObject)supplierdetail1.get(m)).getBigDecimal("costrate").divide(new BigDecimal("100")));
            }
        }
    }

    public void restoreRateEntityDate(DynamicObject obj, DynamicObject now, String appId) {
        if (now != null) {
            DynamicObject supplier;
            DynamicObject supplier2;
            int i;
            DynamicObjectCollection bidSectionColl = obj.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection oldBidSectionColl = now.getDynamicObjectCollection("bidsection");
            HashMap<String, BigDecimal> oldTaxRateMap = new HashMap<String, BigDecimal>();
            for (i = 0; i < oldBidSectionColl.size(); ++i) {
                Object oldSupplierEntry2;
                String sectionName = ((DynamicObject)oldBidSectionColl.get(i)).getString("sectionname");
                DynamicObjectCollection oldSupplierEntryList = ((DynamicObject)oldBidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                for (Object oldSupplierEntry2 : oldSupplierEntryList) {
                    supplier2 = oldSupplierEntry2.getDynamicObject("supplier");
                    if (supplier2 == null) continue;
                    String taxRateKey = sectionName + supplier2.getString("id") + "taxRate";
                    String rateKey = sectionName + supplier2.getString("id") + "rate";
                    oldTaxRateMap.put(taxRateKey, oldSupplierEntry2.getBigDecimal("supplier_taxrate"));
                    oldTaxRateMap.put(rateKey, oldSupplierEntry2.getBigDecimal("supplier_rate"));
                }
                DynamicObjectCollection oldSupplierDetailList = ((DynamicObject)oldBidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                oldSupplierEntry2 = oldSupplierDetailList.iterator();
                while (oldSupplierEntry2.hasNext()) {
                    DynamicObject oldSupplierDetail = (DynamicObject)oldSupplierEntry2.next();
                    supplier = oldSupplierDetail.getDynamicObject("pursupplier");
                    if (supplier == null) continue;
                    DynamicObject biddingDetailMaterial = oldSupplierDetail.getDynamicObject("materialid");
                    StringBuilder keySb = new StringBuilder();
                    keySb.append(sectionName).append(supplier.getString("id"));
                    keySb.append('|').append(oldSupplierDetail.getString("purentrycontent"));
                    keySb.append('|').append(biddingDetailMaterial == null ? "" : biddingDetailMaterial.getPkValue().toString());
                    keySb.append('|').append(oldSupplierDetail.getDynamicObject("purentryproject") == null ? "" : oldSupplierDetail.getDynamicObject("purentryproject").getString("id"));
                    keySb.append('|').append(oldSupplierDetail.getString("materialdes") == null ? "" : oldSupplierDetail.getString("materialdes"));
                    if ("rebm".equals(appId)) {
                        keySb.append('|').append(oldSupplierDetail.getDynamicObject("resourceitem") == null ? "" : oldSupplierDetail.getDynamicObject("resourceitem").getPkValue().toString());
                    }
                    String key = keySb.toString();
                    String detailTaxRateKey = key + "detailTaxRate";
                    String detailRateKey = key + "detailRate";
                    oldTaxRateMap.put(detailTaxRateKey, oldSupplierDetail.getBigDecimal("taxrate"));
                    oldTaxRateMap.put(detailRateKey, oldSupplierDetail.getBigDecimal("costrate"));
                }
            }
            for (i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObjectCollection supplierEntry = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection supplierDetail = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                String sectionName = ((DynamicObject)bidSectionColl.get(i)).getString("sectionname");
                if (supplierEntry != null && supplierEntry.size() > 0) {
                    for (int j = 0; j < supplierEntry.size(); ++j) {
                        supplier2 = ((DynamicObject)supplierEntry.get(j)).getDynamicObject("supplier");
                        if (supplier2 == null) continue;
                        String supplierId = supplier2.getString("id");
                        String taxRateKey = sectionName + supplierId + "taxRate";
                        String rateKey = sectionName + supplierId + "rate";
                        ((DynamicObject)supplierEntry.get(j)).set("supplier_taxrate", oldTaxRateMap.get(taxRateKey));
                        ((DynamicObject)supplierEntry.get(j)).set("supplier_rate", oldTaxRateMap.get(rateKey));
                    }
                }
                if (supplierDetail == null || supplierDetail.size() <= 0) continue;
                for (int m = 0; m < supplierDetail.size(); ++m) {
                    DynamicObject supplierDetailEntry = (DynamicObject)supplierDetail.get(m);
                    supplier = supplierDetailEntry.getDynamicObject("pursupplier");
                    if (supplier == null) continue;
                    String supplierId = supplier.getString("id");
                    DynamicObject detailMaterial = supplierDetailEntry.getDynamicObject("materialid");
                    StringBuilder keySb = new StringBuilder();
                    keySb.append(sectionName).append(supplierId);
                    keySb.append('|').append(supplierDetailEntry.getString("purentrycontent"));
                    keySb.append('|').append(detailMaterial == null ? "" : detailMaterial.getPkValue().toString());
                    keySb.append('|').append(supplierDetailEntry.getDynamicObject("purentryproject") == null ? "" : supplierDetailEntry.getDynamicObject("purentryproject").getString("id"));
                    keySb.append('|').append(supplierDetailEntry.getString("materialdes") == null ? "" : supplierDetailEntry.getString("materialdes"));
                    if ("rebm".equals(appId)) {
                        keySb.append('|').append(supplierDetailEntry.getDynamicObject("resourceitem") == null ? "" : supplierDetailEntry.getDynamicObject("resourceitem").getPkValue().toString());
                    }
                    String key = keySb.toString();
                    String detailTaxRateKey = key + "detailTaxRate";
                    String detailRateKey = key + "detailRate";
                    ((DynamicObject)supplierDetail.get(m)).set("taxrate", oldTaxRateMap.get(detailTaxRateKey));
                    ((DynamicObject)supplierDetail.get(m)).set("costrate", oldTaxRateMap.get(detailRateKey));
                }
            }
        }
    }

    public void sendMessage(DynamicObject bidproject, String openType) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        String appid = bidProject.getString("entitytypeid").split("_")[0];
        String content = "";
        DynamicObject bidOpen = new DynamicObject();
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        String name = bidProject.getString("name");
        if (openType.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
            content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684%s\u9879\u76ee\u5df2\u8fdb\u5165\u5546\u52a1\u6807\u5f00\u6807\u4e1a\u52a1\u529e\u7406\u73af\u8282\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidOpenOperationServicePlugIn_120", (String)"scm-bid-opplugin", (Object[])new Object[0]), name);
            bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())});
            msgParam.put("tplScene", "createbidbuopen");
        }
        if (openType.equals(BidOpenTypeEnum.BUSSINESS.getValue())) {
            content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684%s\u9879\u76ee\u5df2\u8fdb\u5165\u6280\u672f\u6807\u5f00\u6807\u4e1a\u52a1\u529e\u7406\u73af\u8282\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidOpenOperationServicePlugIn_121", (String)"scm-bid-opplugin", (Object[])new Object[0]), name);
            bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue())});
            msgParam.put("tplScene", "createbidteopen");
        }
        if (bidOpen == null) {
            return;
        }
        String title = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u6761%s\u4e1a\u52a1\u5f85\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidOpenOperationServicePlugIn_122", (String)"scm-bid-opplugin", (Object[])new Object[0]), name);
        msgParam.put("msgentity", "bid_bidopen");
        if ("bid".equals(appid)) {
            msgParam.put("formId", "bid_bidopen");
        } else {
            msgParam.put("formId", "rebm_bidopen");
        }
        msgParam.put("appId", appid);
        msgParam.put("id", bidOpen.getPkValue());
        msgParam.put("pkId", bidOpen.getPkValue());
        msgParam.put("title", title);
        msgParam.put("operation", "save");
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        for (DynamicObject member : memberColl) {
            String[] values = member.getString("respbusiness").split(",");
            if (values != null && values.length > 0) {
                for (int m = 0; m < values.length; ++m) {
                    if ("11".equals(values[m]) && openType.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
                        memberSet.add(member.getDynamicObject("user"));
                    }
                    if (!"12".equals(values[m]) || !openType.equals(BidOpenTypeEnum.BUSSINESS.getValue())) continue;
                    memberSet.add(member.getDynamicObject("user"));
                }
            }
            if (!member.getBoolean("isdirector")) continue;
            memberSet.add(member.getDynamicObject("user"));
        }
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        msgParam.put("msgentity", FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
        msgParam.put("content", content);
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds);
    }

    public void changeAnswerQuesStatus(DynamicObject project, DynamicObject data, Long projectId) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
        String bidOpenSelectType = project.getString("bidopentype");
        String openType = data.getString("opentype");
        BidProjectServiceImpl projectService = new BidProjectServiceImpl();
        DynamicObject tempProject = projectService.getBidProjectAllById(projectId);
        Date answerQuestionTime = tempProject.getDate("answerquestiontime");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DynamicObject answer = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"answerquestion", ((Object)((Object)this)).getClass()), (String)"billstatus,realanswertime,modifytime,modifier,auditor,auditdate", (QFilter[])new QFilter[]{qFilter});
        if (null != answer) {
            if (!StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)bidOpenSelectType)) {
                Date date;
                if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenSelectType) && StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)openType)) {
                    date = new Date();
                    if (null == answerQuestionTime || formatter.format(date).compareTo(formatter.format(answerQuestionTime)) < 0) {
                        answer.set("billstatus", (Object)BillStatusEnum.QUESTIONING.getVal());
                    }
                    if (null != answerQuestionTime && formatter.format(date).compareTo(formatter.format(answerQuestionTime)) > 0) {
                        answer.set("billstatus", (Object)BillStatusEnum.ENDED.getVal());
                    }
                    answer.set("realanswertime", null);
                    answer.set("modifytime", null);
                    answer.set("modifier", null);
                    answer.set("auditor", null);
                    answer.set("auditdate", null);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{answer});
                    projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.BidAnswerQuestion});
                }
                if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenSelectType) && StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)openType)) {
                    date = new Date();
                    if (null == answerQuestionTime || formatter.format(date).compareTo(formatter.format(answerQuestionTime)) < 0) {
                        answer.set("billstatus", (Object)BillStatusEnum.QUESTIONING.getVal());
                    }
                    if (null != answerQuestionTime && formatter.format(date).compareTo(formatter.format(answerQuestionTime)) > 0) {
                        answer.set("billstatus", (Object)BillStatusEnum.ENDED.getVal());
                    }
                    answer.set("realanswertime", null);
                    answer.set("modifytime", null);
                    answer.set("modifier", null);
                    answer.set("auditor", null);
                    answer.set("auditdate", null);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{answer});
                    projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.BidAnswerQuestion});
                }
            } else {
                Date date = new Date();
                if (null == answerQuestionTime || formatter.format(date).compareTo(formatter.format(answerQuestionTime)) < 0) {
                    answer.set("billstatus", (Object)BillStatusEnum.QUESTIONING.getVal());
                }
                if (null != answerQuestionTime && formatter.format(date).compareTo(formatter.format(answerQuestionTime)) > 0) {
                    answer.set("billstatus", (Object)BillStatusEnum.ENDED.getVal());
                }
                answer.set("realanswertime", null);
                answer.set("modifytime", null);
                answer.set("modifier", null);
                answer.set("auditor", null);
                answer.set("auditdate", null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{answer});
                projectService.saveCurrentBidStep((Object)projectId, new BidStepEnum[]{BidStepEnum.BidAnswerQuestion});
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntityArray = e.getDataEntities();
        if ("confirmopen".equals(key)) {
            NextStepSendMessage nextStepSendMessage = null;
            String appId = this.billEntityType.getAppId();
            for (DynamicObject dataEntity : dataEntityArray) {
                DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
                bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
                nextStepSendMessage = new NextStepSendMessage();
                nextStepSendMessage.nextStepSendMessage(bidProject, BidStepEnum.BidOpen);
                DynamicObject bidMode = bidProject.getDynamicObject("bidmode");
                if (!((Boolean)bidMode.get("bidevaluation")).booleanValue()) continue;
                String docType = bidProject.getString("doctype");
                if ("BUSSINESS".equals(docType)) {
                    if (!this.isBidOpenConfirm(dataEntityArray)) continue;
                    this.confirmOpenSendMessage(dataEntity, bidProject);
                    continue;
                }
                String bidOpenType = bidProject.getString("bidopentype");
                String openType = dataEntity.getString("opentype");
                if ("TECHBUSINESS".equals(bidOpenType)) {
                    if (!this.isBidOpenConfirm(dataEntityArray)) continue;
                    this.sendMessageToProficients(dataEntity, bidProject, appId);
                    continue;
                }
                if ("BUSSINESSTECH".equals(bidOpenType)) {
                    if (!"BUSSINESS".equals(openType) || !this.isBidOpenConfirm(dataEntityArray)) continue;
                    this.sendMessageToProficients(dataEntity, bidProject, appId);
                    continue;
                }
                if (!this.isBidOpenConfirm(dataEntityArray)) continue;
                this.sendMessageToProficients(dataEntity, bidProject, appId);
            }
        }
    }

    public boolean isBidOpenConfirm(DynamicObject[] dataEntities) {
        boolean myflag = true;
        Long id = null;
        DynamicObject project = null;
        HashSet<String> memberIdSet = null;
        for (DynamicObject obj : dataEntities) {
            int i;
            id = obj.getLong("id");
            String openType = obj.getString("opentype");
            DynamicObject bidProject = obj.getDynamicObject("bidproject");
            String appId = this.getAppId(bidProject);
            DynamicObject now = this.bidOpenService.getBidOpenByIdAndType(id, appId);
            Long projectId = now.getLong("bidproject.id");
            project = this.bidProjectService.getBidProjectAllById(projectId);
            String userId = RequestContext.get().getUserId();
            String member = now.getString("member");
            String openStatus = "";
            memberIdSet = new HashSet<String>();
            memberIdSet.add(userId);
            if (member != null && !member.equals("")) {
                String[] members = member.split(",");
                for (i = 0; i < members.length; ++i) {
                    memberIdSet.add(members[i]);
                }
                member = member + "," + userId;
            } else {
                member = userId;
            }
            DynamicObjectCollection memberEntityColl = project.getDynamicObjectCollection("memberentity");
            for (i = 0; i < memberEntityColl.size(); ++i) {
                String str;
                String memberUserName;
                String memberUserId;
                DynamicObject user;
                DynamicObject entry = (DynamicObject)memberEntityColl.get(i);
                String respBusiness = entry.getString("respbusiness");
                if (respBusiness != null && respBusiness.contains(RespBusiness.BidOpen.getVal())) {
                    user = entry.getDynamicObject("user");
                    memberUserId = user.get("id").toString();
                    memberUserName = user.get("name").toString();
                    memberUserName = memberIdSet.contains(memberUserId) ? (str = String.format(ResManager.loadKDString((String)"%s:\u5df2\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_152", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName)) : (str = String.format(ResManager.loadKDString((String)"%s:\u672a\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_153", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName));
                    if (openStatus.equals("")) {
                        openStatus = memberUserName;
                        continue;
                    }
                    openStatus = openStatus + "," + memberUserName;
                    continue;
                }
                if (respBusiness != null && respBusiness.contains(RespBusiness.TechnicalOpen.getVal()) && BidOpenTypeEnum.TECHNICAL.getValue().equals(openType)) {
                    user = entry.getDynamicObject("user");
                    memberUserId = user.get("id").toString();
                    memberUserName = user.get("name").toString();
                    memberUserName = memberIdSet.contains(memberUserId) ? (str = String.format(ResManager.loadKDString((String)"%s:\u5df2\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_152", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName)) : (str = String.format(ResManager.loadKDString((String)"%s:\u672a\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_153", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName));
                    if (openStatus.equals("")) {
                        openStatus = memberUserName;
                        continue;
                    }
                    openStatus = openStatus + "," + memberUserName;
                    continue;
                }
                if (respBusiness == null || !respBusiness.contains(RespBusiness.BusinessOpen.getVal()) || !BidOpenTypeEnum.BUSSINESS.getValue().equals(openType)) continue;
                user = entry.getDynamicObject("user");
                memberUserId = user.get("id").toString();
                memberUserName = user.get("name").toString();
                memberUserName = memberIdSet.contains(memberUserId) ? (str = String.format(ResManager.loadKDString((String)"%s:\u5df2\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_152", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName)) : (str = String.format(ResManager.loadKDString((String)"%s:\u672a\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_153", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName));
                openStatus = openStatus.equals("") ? memberUserName : openStatus + "," + memberUserName;
            }
            if (!openStatus.contains(ResManager.loadKDString((String)"\u672a\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_2", (String)"scm-bid-opplugin", (Object[])new Object[0]))) continue;
            myflag = false;
        }
        return myflag;
    }

    public void confirmOpenSendMessage(DynamicObject proObj, DynamicObject bidProject) {
        String appId = this.billEntityType.getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)kd.scm.bid.formplugin.bill.helper.OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        this.sendMessageToProficients(proObj, bidProject, appId);
    }

    protected void sendMessageToProficients(DynamicObject proObj, DynamicObject bidProject, String appId) {
        String notifyTypes = MessageChannelUtil.getNotifyType((String)"comfiropenToExperter", (String)"bid_bidopen");
        if (StringUtils.isEmpty((CharSequence)notifyTypes)) {
            return;
        }
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        DynamicObjectCollection proficientColl = proObj.getDynamicObjectCollection("bidopen_proficient");
        String openType = proObj.getString("opentype");
        boolean isonlineeval = proObj.getBoolean("isonlineeval");
        HashSet<Long> proficientIds = new HashSet<Long>(proficientColl.size());
        for (int i = 0; i < proficientColl.size(); ++i) {
            DynamicObject proficient;
            if ("TECHNICAL".equals(openType)) {
                proficient = (DynamicObject)proficientColl.get(i);
                if (!proficient.getBoolean("proficient_technical")) continue;
                proficientIds.add(proficient.getDynamicObject("proficient").getLong("id"));
                continue;
            }
            if ("BUSSINESS".equals(openType)) {
                proficient = (DynamicObject)proficientColl.get(i);
                if (!proficient.getBoolean("proficient_commercial")) continue;
                proficientIds.add(proficient.getDynamicObject("proficient").getLong("id"));
                continue;
            }
            proficient = (DynamicObject)proficientColl.get(i);
            proficientIds.add(proficient.getDynamicObject("proficient").getLong("id"));
        }
        QFilter qFilterid = new QFilter("id", "in", (Object)proficientIds.toArray());
        DynamicObject[] proficients = BusinessDataServiceHelper.load((String)(appId + "_proficient"), (String)"id,proficientname", (QFilter[])new QFilter[]{qFilterid}, (String)"id");
        ArrayList<Long> proficientReceiveUserIds = new ArrayList<Long>();
        for (int i = 0; i < proficients.length; ++i) {
            DynamicObject proficient = proficients[i];
            DynamicObject proficientName = proficient.getDynamicObject("proficientname");
            if (proficientName == null) continue;
            proficientReceiveUserIds.add(proficientName.getLong("id"));
        }
        ArrayList<String> onlinePKids = new ArrayList<String>();
        if (isonlineeval) {
            if ("bid".equals(appId)) {
                param.put("formId", "bid_onlinebideval");
            } else {
                param.put("formId", "rebm_onlinebideval");
            }
            QFilter qFilter = new QFilter("bidevaluator", "in", (Object)proficientIds.toArray());
            QFilter qFilteropen = new QFilter("bidopenid", "=", proObj.getPkValue());
            QFilter qFiltert = new QFilter("evaltype", "=", (Object)"TECHNICAL");
            QFilter qFilterb = new QFilter("evaltype", "=", (Object)"BUSSINESS");
            QFilter qFilterm = new QFilter("evaltype", "=", (Object)"MULTI");
            DynamicObject[] onlinebidevals = null;
            onlinebidevals = "TECHNICAL".equals(openType) ? BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"id", (QFilter[])new QFilter[]{qFilter, qFilteropen, qFiltert}, (String)"bidevaluator") : ("BUSSINESS".equals(openType) ? BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"id", (QFilter[])new QFilter[]{qFilter, qFilteropen, qFilterb}, (String)"bidevaluator") : BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"id", (QFilter[])new QFilter[]{qFilter, qFilteropen}, (String)"bidevaluator"));
            for (DynamicObject onlinebideval : onlinebidevals) {
                Long onid = onlinebideval.getLong("id");
                param.put("pkId", onid);
                List<String> urlParams = Arrays.asList("formId", "pkId");
                if (urlParams == null || urlParams.size() <= 0) continue;
                StringBuilder buf = new StringBuilder();
                String contentUrl = System.getProperty("domain.contextUrl");
                logger.info("First contentUrl---------------" + contentUrl);
                String tenantCode = RequestContext.get().getTenantCode();
                logger.info("tenantCode---------------" + tenantCode);
                contentUrl = contentUrl.replace("{tenantCode}", tenantCode);
                logger.info("Second contentUrl---------------" + contentUrl);
                buf.append(contentUrl);
                int urlParamIndex = 0;
                for (String urlParam : urlParams) {
                    String temp;
                    if (urlParamIndex == 0) {
                        temp = "?" + urlParam + "=" + param.get(urlParam);
                        buf.append(temp);
                    } else {
                        temp = "&" + urlParam + "=" + param.get(urlParam);
                        buf.append(temp);
                    }
                    ++urlParamIndex;
                }
                onlinePKids.add(buf.toString());
            }
        }
        if (!proficientReceiveUserIds.isEmpty()) {
            for (int i = 0; i < proficientReceiveUserIds.size(); ++i) {
                Long proficientReceiveUserId = (Long)proficientReceiveUserIds.get(i);
                MessageInfo messageProficientInfo = new MessageInfo();
                messageProficientInfo.setType("message");
                messageProficientInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
                messageProficientInfo.setSenderName(RequestContext.get().getUserName());
                messageProficientInfo.setUserIds(Collections.singletonList(proficientReceiveUserId));
                messageProficientInfo.setBizDataId((Long)proObj.getPkValue());
                messageProficientInfo.setEntityNumber("bid_bidopen");
                messageProficientInfo.setOperation("confirmopen");
                messageProficientInfo.setTitle(null);
                messageProficientInfo.setContent(null);
                messageProficientInfo.setTplScene("comfiropenToExperter");
                messageProficientInfo.setNotifyType(notifyTypes);
                if (isonlineeval && onlinePKids.size() == proficientReceiveUserIds.size()) {
                    messageProficientInfo.setContentUrl((String)onlinePKids.get(i));
                }
                MessageCenterServiceHelper.sendMessage((MessageInfo)messageProficientInfo);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject now;
        String appId;
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        Long id = null;
        MainEntityType type = null;
        DynamicObject project = null;
        if (StringUtils.equals((CharSequence)key, (CharSequence)"save")) {
            for (DynamicObject obj : dataEntities) {
                id = obj.getLong("id");
                boolean exists = QueryServiceHelper.exists((String)"bid_bidopen", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                if (!exists) continue;
                DynamicObject bidProject = obj.getDynamicObject("bidproject");
                String appId2 = this.getAppId(bidProject);
                DynamicObject now2 = this.bidOpenService.getBidOpenByIdAndType(id, appId2);
                now2.set("billstatus", (Object)"A");
                BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)(appId2 + "_bidopen")), (Object[])new Object[]{now2});
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"confirmopen")) {
            HashSet<Long> bidProjectIDSet = new HashSet<Long>();
            HashSet<String> memberIdSet = null;
            for (DynamicObject obj : dataEntities) {
                id = obj.getLong("id");
                String openType = obj.getString("opentype");
                DynamicObject bidProject = obj.getDynamicObject("bidproject");
                String appId3 = this.getAppId(bidProject);
                DynamicObject now3 = this.bidOpenService.getBidOpenByIdAndType(id, appId3);
                Long projectId = now3.getLong("bidproject.id");
                project = this.bidProjectService.getBidProjectAllById(projectId);
                type = EntityMetadataCache.getDataEntityType((String)(appId3 + "_bidopen"));
                String userId = RequestContext.get().getUserId();
                String member = now3.getString("member");
                String openStatus = "";
                memberIdSet = new HashSet<String>();
                memberIdSet.add(userId);
                if (member != null && !member.equals("")) {
                    String[] members = member.split(",");
                    for (int i = 0; i < members.length; ++i) {
                        memberIdSet.add(members[i]);
                    }
                    member = member + "," + userId;
                } else {
                    member = userId;
                }
                DynamicObjectCollection memberEntityColl = project.getDynamicObjectCollection("memberentity");
                String billStatus = BillStatusEnum.OPEN.getVal();
                for (int i = 0; i < memberEntityColl.size(); ++i) {
                    String str;
                    String memberUserName;
                    BidStepEnum[] memberUserId;
                    DynamicObject user;
                    DynamicObject entry = (DynamicObject)memberEntityColl.get(i);
                    String respBusiness = entry.getString("respbusiness");
                    if (respBusiness != null && respBusiness.contains(RespBusiness.BidOpen.getVal())) {
                        user = entry.getDynamicObject("user");
                        memberUserId = user.get("id").toString();
                        memberUserName = user.get("name").toString();
                        memberUserName = memberIdSet.contains(memberUserId) ? (str = String.format(ResManager.loadKDString((String)"%s:\u5df2\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_152", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName)) : (str = String.format(ResManager.loadKDString((String)"%s:\u672a\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_153", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName));
                        if (openStatus.equals("")) {
                            openStatus = memberUserName;
                            continue;
                        }
                        openStatus = openStatus + "," + memberUserName;
                        continue;
                    }
                    if (respBusiness != null && respBusiness.contains(RespBusiness.TechnicalOpen.getVal()) && BidOpenTypeEnum.TECHNICAL.getValue().equals(openType)) {
                        user = entry.getDynamicObject("user");
                        memberUserId = user.get("id").toString();
                        memberUserName = user.get("name").toString();
                        memberUserName = memberIdSet.contains(memberUserId) ? (str = String.format(ResManager.loadKDString((String)"%s:\u5df2\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_152", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName)) : (str = String.format(ResManager.loadKDString((String)"%s:\u672a\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_153", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName));
                        if (openStatus.equals("")) {
                            openStatus = memberUserName;
                            continue;
                        }
                        openStatus = openStatus + "," + memberUserName;
                        continue;
                    }
                    if (respBusiness == null || !respBusiness.contains(RespBusiness.BusinessOpen.getVal()) || !BidOpenTypeEnum.BUSSINESS.getValue().equals(openType)) continue;
                    user = entry.getDynamicObject("user");
                    memberUserId = user.get("id").toString();
                    memberUserName = user.get("name").toString();
                    memberUserName = memberIdSet.contains(memberUserId) ? (str = String.format(ResManager.loadKDString((String)"%s:\u5df2\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_152", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName)) : (str = String.format(ResManager.loadKDString((String)"%s:\u672a\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_153", (String)"scm-bid-opplugin", (Object[])new Object[0]), memberUserName));
                    openStatus = openStatus.equals("") ? memberUserName : openStatus + "," + memberUserName;
                }
                now3.set("openstatus", (Object)openStatus);
                if (!bidProject.getBoolean("is_single_open") && openStatus.contains(ResManager.loadKDString((String)"\u672a\u5f00\u6807", (String)"BidOpenOperationServicePlugIn_2", (String)"scm-bid-opplugin", (Object[])new Object[0]))) {
                    billStatus = "P";
                }
                now3.set("billstatus", (Object)billStatus);
                now3.set("member", (Object)member);
                if ("O".equals(billStatus)) {
                    now3.set("realbidopendate", (Object)new Date());
                }
                SaveServiceHelper.save((IDataEntityType)type, (Object[])new Object[]{now3});
                if (BillStatusEnum.OPEN.getVal().equals(billStatus)) {
                    DynamicObject targetOpenBill;
                    DynamicObjectCollection curSectionEntry;
                    DynamicObjectCollection sectionEntry;
                    DynamicObject openBill;
                    DynamicObject curOpenBill;
                    DynamicObject tempOpen;
                    boolean isOnlineEval;
                    Long profiId;
                    DynamicObject proficient;
                    DynamicObjectCollection profis;
                    boolean enable = SystemParamHelper.getSystemParameter((String)appId3, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
                    String bidOpenSelectType = project.getString("bidopentype");
                    BidStepEnum[] steps = BidStepInteractiveHelper.getNextStep((DynamicObject)project, (BidStepEnum)BidStepEnum.BidOpen);
                    boolean isNextDecision = false;
                    for (BidStepEnum step : steps) {
                        if (BidStepEnum.BidDecision != step) continue;
                        isNextDecision = true;
                    }
                    if (isNextDecision) {
                        if (StringUtils.isBlank((CharSequence)bidOpenSelectType) || BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType)) {
                            this.bidOpenService.createNextStep(project, BidStepEnum.BidOpen);
                            this.bidProjectService.saveCurrentBidStep((Object)now3.getLong("bidproject.id"), steps);
                            profis = obj.getDynamicObjectCollection("bidopen_proficient");
                            for (DynamicObject profi : profis) {
                                proficient = profi.getDynamicObject("proficient");
                                profiId = proficient.getLong("id");
                                this.proficientService.insertProficientProByIds(profiId, project);
                            }
                            isOnlineEval = now3.getBoolean("isonlineeval");
                            if (isOnlineEval) {
                                this.deleteOnlineEvalUnStartedData(project);
                                this.onlineBidEvalService.createByLastStep(project);
                            }
                            bidProjectIDSet.add(projectId);
                        } else if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidOpenSelectType) && BidOpenTypeEnum.BUSSINESS.getValue().equals(openType)) {
                            this.bidOpenService.createNextStep(project, BidStepEnum.BidOpen);
                            this.bidProjectService.saveCurrentBidStep((Object)now3.getLong("bidproject.id"), steps);
                            profis = obj.getDynamicObjectCollection("bidopen_proficient");
                            for (DynamicObject profi : profis) {
                                proficient = profi.getDynamicObject("proficient");
                                profiId = proficient.getLong("id");
                                this.proficientService.insertProficientProByIds(profiId, project);
                            }
                            isOnlineEval = now3.getBoolean("isonlineeval");
                            if (isOnlineEval) {
                                this.deleteOnlineEvalUnStartedData(project);
                                this.onlineBidEvalService.createByLastStep(project);
                            }
                            bidProjectIDSet.add(projectId);
                        } else if (BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidOpenSelectType) && BidOpenTypeEnum.TECHNICAL.getValue().equals(openType)) {
                            this.bidOpenService.createNextStep(project, BidStepEnum.BidOpen);
                            this.bidProjectService.saveCurrentBidStep((Object)now3.getLong("bidproject.id"), steps);
                            profis = obj.getDynamicObjectCollection("bidopen_proficient");
                            for (DynamicObject profi : profis) {
                                proficient = profi.getDynamicObject("proficient");
                                profiId = proficient.getLong("id");
                                this.proficientService.insertProficientProByIds(profiId, project);
                            }
                            isOnlineEval = now3.getBoolean("isonlineeval");
                            if (isOnlineEval) {
                                this.deleteOnlineEvalUnStartedData(project);
                                this.onlineBidEvalService.createByLastStep(project);
                            }
                            bidProjectIDSet.add(projectId);
                        }
                    } else {
                        this.bidOpenService.createNextStep(project, BidStepEnum.BidOpen);
                        this.bidProjectService.saveCurrentBidStep((Object)now3.getLong("bidproject.id"), new BidStepEnum[]{steps[0]});
                        profis = obj.getDynamicObjectCollection("bidopen_proficient");
                        for (DynamicObject profi : profis) {
                            proficient = profi.getDynamicObject("proficient");
                            profiId = proficient.getLong("id");
                            this.proficientService.insertProficientProByIds(profiId, project);
                        }
                        isOnlineEval = now3.getBoolean("isonlineeval");
                        if (isOnlineEval) {
                            this.deleteOnlineEvalUnStartedData(project);
                            this.onlineBidEvalService.createByLastStep(project);
                        }
                        bidProjectIDSet.add(projectId);
                    }
                    String openSelectType = obj.getString("bidproject.bidopentype");
                    MainEntityType newOneType = EntityMetadataCache.getDataEntityType((String)(appId3 + "_bidopen"));
                    if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)openSelectType)) {
                        if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)openType)) {
                            QFilter qFilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
                            qFilter = qFilter.and(new QFilter("bidproject", "=", project.getPkValue()));
                            qFilter = qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
                            tempOpen = QueryServiceHelper.queryOne((String)(appId3 + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{qFilter});
                            curOpenBill = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (DynamicObjectType)obj.getDynamicObjectType());
                            openBill = BusinessDataServiceHelper.loadSingle((Object)tempOpen.getLong("id"), (DynamicObjectType)curOpenBill.getDynamicObjectType());
                            sectionEntry = openBill.getDynamicObjectCollection("bidsection");
                            curSectionEntry = curOpenBill.getDynamicObjectCollection("bidsection");
                            openBill.set("evaluatedmethod", (Object)obj.getString("evaluatedmethod"));
                            openBill.set("quotationscoresch", obj.get("quotationscoresch"));
                            openBill.set("bidevaltemplate", (Object)obj.getString("bidevaltemplate"));
                            openBill.set("isonlineeval", (Object)obj.getString("isonlineeval"));
                            openBill.set("comweight", obj.get("comweight"));
                            openBill.set("techweight", obj.get("techweight"));
                            this.copyBidOpenSupplierEntryAndDetailEntry(appId3, curSectionEntry, sectionEntry, newOneType, enable);
                            this.updateSupplierIsinvalid(curSectionEntry, sectionEntry);
                            BidOpenOperationServicePlugIn.resetBottomSection(curOpenBill, openBill);
                            SaveServiceHelper.save((IDataEntityType)openBill.getDataEntityType(), (Object[])new DynamicObject[]{openBill});
                        } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)openType)) {
                            QFilter qFilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
                            qFilter = qFilter.and(new QFilter("bidproject", "=", project.getPkValue()));
                            qFilter = qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
                            DynamicObject targeOpen = QueryServiceHelper.queryOne((String)(appId3 + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{qFilter});
                            curOpenBill = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (DynamicObjectType)obj.getDynamicObjectType());
                            targetOpenBill = BusinessDataServiceHelper.loadSingle((Object)targeOpen.getLong("id"), (DynamicObjectType)curOpenBill.getDynamicObjectType());
                            targetOpenBill.set("evaluatedmethod", (Object)obj.getString("evaluatedmethod"));
                            targetOpenBill.set("quotationscoresch", (Object)obj.getString("quotationscoresch"));
                            targetOpenBill.set("bidevaltemplate", (Object)obj.getString("bidevaltemplate"));
                            targetOpenBill.set("isonlineeval", (Object)obj.getString("isonlineeval"));
                            BidOpenOperationServicePlugIn.resetBottomSection(curOpenBill, targetOpenBill);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{targetOpenBill});
                        }
                    } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)openSelectType)) {
                        if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)openType)) {
                            QFilter qFilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
                            qFilter = qFilter.and(new QFilter("bidproject", "=", project.getPkValue()));
                            qFilter = qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
                            tempOpen = QueryServiceHelper.queryOne((String)(appId3 + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{qFilter});
                            curOpenBill = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (DynamicObjectType)obj.getDynamicObjectType());
                            openBill = BusinessDataServiceHelper.loadSingle((Object)tempOpen.getLong("id"), (DynamicObjectType)curOpenBill.getDynamicObjectType());
                            sectionEntry = openBill.getDynamicObjectCollection("bidsection");
                            curSectionEntry = curOpenBill.getDynamicObjectCollection("bidsection");
                            openBill.set("evaluatedmethod", (Object)obj.getString("evaluatedmethod"));
                            openBill.set("quotationscoresch", (Object)obj.getString("quotationscoresch"));
                            openBill.set("bidevaltemplate", (Object)obj.getString("bidevaltemplate"));
                            openBill.set("isonlineeval", (Object)obj.getString("isonlineeval"));
                            this.copyBidOpenSupplierEntryAndDetailEntry(appId3, curSectionEntry, sectionEntry, newOneType, enable);
                            BidOpenOperationServicePlugIn.resetBottomSection(curOpenBill, openBill);
                            BusinessDataServiceHelper.save((IDataEntityType)openBill.getDataEntityType(), (Object[])new DynamicObject[]{openBill});
                        } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)openType)) {
                            QFilter qFilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
                            qFilter = qFilter.and(new QFilter("bidproject", "=", project.getPkValue()));
                            qFilter = qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
                            DynamicObject targetOpen = QueryServiceHelper.queryOne((String)(appId3 + "_bidopen"), (String)"id", (QFilter[])new QFilter[]{qFilter});
                            curOpenBill = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (DynamicObjectType)obj.getDynamicObjectType());
                            targetOpenBill = BusinessDataServiceHelper.loadSingle((Object)targetOpen.getLong("id"), (DynamicObjectType)curOpenBill.getDynamicObjectType());
                            BidOpenOperationServicePlugIn.resetBottomSection(curOpenBill, targetOpenBill);
                            BusinessDataServiceHelper.save((IDataEntityType)targetOpenBill.getDataEntityType(), (Object[])new DynamicObject[]{targetOpenBill});
                        }
                    }
                }
                this.refreshMyTenderStatus(bidProjectIDSet, dataEntities, billStatus);
                this.updateSupplierDetailUntenStatus(now3);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{now3});
                BidStepEnum[] bidStepEnums = BidProjectQueryUtil.filterClarificaitonArr(projectId);
                this.projectService.saveCurrentBidStep((Object)projectId, bidStepEnums);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            for (DynamicObject obj : dataEntities) {
                id = obj.getLong("id");
                DynamicObject bidProject = obj.getDynamicObject("bidproject");
                appId = this.getAppId(bidProject);
                now = this.bidOpenService.getBidOpenByIdAndType(id, appId);
                project = this.bidProjectService.getBidProjectAllById(Long.valueOf(now.getLong("bidproject.id")));
                this.bidOpenService.deleteNextStepUnStarted(project, BidStepEnum.BidOpen);
                boolean isOnlineEval = now.getBoolean("isonlineeval");
                if (isOnlineEval) {
                    this.onlineBidEvalService.deleteNextStepUnStarted(project);
                }
                long projectId = project.getLong("id");
                BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)project, (BidStepEnum)BidStepEnum.BidAnswerQuestion);
                if (null != nextStep && BidStepEnum.BidOpen == nextStep[0]) {
                    this.changeAnswerQuesStatus(project, obj, projectId);
                }
                project.set("bidopentime", obj.get("lbidopentime"));
                project.set("techopenbidtime", obj.get("ltechopenbidtime"));
                project.set("busopenbidtime", obj.get("lbusopenbidtime"));
                SaveServiceHelper.update((DynamicObject)project);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"doaudit")) {
            for (DynamicObject obj : dataEntities) {
                id = (Long)obj.getPkValue();
                DynamicObject bidProject = obj.getDynamicObject("bidproject");
                appId = this.getAppId(bidProject);
                now = this.bidOpenService.getBidOpenByIdAndType(id, appId);
                type = EntityMetadataCache.getDataEntityType((String)(appId + "_bidopen"));
                now.set("billstatus", (Object)BillStatusEnum.AUDITING.getVal());
                BusinessDataServiceHelper.save((IDataEntityType)type, (Object[])new Object[]{now});
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"audit")) {
            for (DynamicObject obj : dataEntities) {
                DynamicObject bidProject = obj.getDynamicObject("bidproject");
                DynamicObject bidproject = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidopentime,techopenbidtime,busopenbidtime", (QFilter[])new QFilter[]{new QFilter("id", "=", bidProject.getPkValue())});
                bidproject.set("bidopentime", obj.get("bidopentime"));
                bidproject.set("techopenbidtime", obj.get("techopenbidtime"));
                bidproject.set("busopenbidtime", obj.get("busopenbidtime"));
                SaveServiceHelper.update((DynamicObject)bidproject);
            }
        }
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)key)) {
            for (DynamicObject obj : dataEntities) {
                DynamicObject bidProject = obj.getDynamicObject("bidproject");
                Long projectId = (Long)bidProject.getPkValue();
                DeleteServiceHelper.delete((String)"bid_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", obj.getPkValue())});
                this.bidOpenService.saveBidOpen(projectId, false);
            }
        }
    }

    public void updateSupplierIsinvalid(DynamicObjectCollection curSectionEntry, DynamicObjectCollection sectionEntry) {
        HashBasedTable invalidMap = HashBasedTable.create();
        curSectionEntry.stream().forEach(arg_0 -> BidOpenOperationServicePlugIn.lambda$updateSupplierIsinvalid$5((Table)invalidMap, arg_0));
        sectionEntry.forEach(arg_0 -> BidOpenOperationServicePlugIn.lambda$updateSupplierIsinvalid$8((Table)invalidMap, arg_0));
    }

    public static void resetBottomSection(DynamicObject curOpenBill, DynamicObject targetOpen) {
        DynamicObjectCollection targetBottomSectionEntryCol = targetOpen.getDynamicObjectCollection("bottomsection");
        DynamicObjectCollection curOpenBottomSectionSectionEntryCol = curOpenBill.getDynamicObjectCollection("bottomsection");
        String appId = curOpenBill.getString("entitytypeid").split("_")[0];
        targetBottomSectionEntryCol.clear();
        BigDecimal basePrice = BigDecimal.ZERO;
        for (DynamicObject sourceBottomSectionSectionEntry : curOpenBottomSectionSectionEntryCol) {
            DynamicObject tempBottomSectionEntry = targetBottomSectionEntryCol.addNew();
            tempBottomSectionEntry.set("botsectionname", sourceBottomSectionSectionEntry.get("botsectionname"));
        }
        for (DynamicObject sourceBottomSectionSectionEntry : curOpenBottomSectionSectionEntryCol) {
            String curSectionName = sourceBottomSectionSectionEntry.getString("botsectionname");
            for (DynamicObject tempBottomSectionEntry : targetBottomSectionEntryCol) {
                String sectionName = tempBottomSectionEntry.getString("botsectionname");
                if (!StringUtils.equals((CharSequence)curSectionName, (CharSequence)sectionName)) continue;
                DynamicObjectCollection supplierEntry = tempBottomSectionEntry.getDynamicObjectCollection("bottomentry");
                DynamicObjectCollection sourceSupplierEntry = sourceBottomSectionSectionEntry.getDynamicObjectCollection("bottomentry");
                supplierEntry.clear();
                for (DynamicObject curSupplierEntryRow : sourceSupplierEntry) {
                    DynamicObject supplierEntryRow = supplierEntry.addNew();
                    supplierEntryRow.set("botpurentrycontent", curSupplierEntryRow.get("botpurentrycontent"));
                    supplierEntryRow.set("botpurentryproject", curSupplierEntryRow.get("botpurentryproject"));
                    supplierEntryRow.set("botmaterialid", curSupplierEntryRow.get("botmaterialid"));
                    supplierEntryRow.set("botmaterialdes", curSupplierEntryRow.get("botmaterialdes"));
                    supplierEntryRow.set("botcontrolamount", curSupplierEntryRow.get("botcontrolamount"));
                    supplierEntryRow.set("botcontrolvat", curSupplierEntryRow.get("botcontrolvat"));
                    supplierEntryRow.set("botctrlamtexceptvat", curSupplierEntryRow.get("botctrlamtexceptvat"));
                    supplierEntryRow.set("declareamount", curSupplierEntryRow.get("declareamount"));
                    supplierEntryRow.set("finalauditamount", curSupplierEntryRow.get("finalauditamount"));
                    supplierEntryRow.set("botqty", curSupplierEntryRow.get("botqty"));
                    supplierEntryRow.set("planamount", curSupplierEntryRow.get("planamount"));
                    supplierEntryRow.set("nottaxplanamount", curSupplierEntryRow.get("nottaxplanamount"));
                    basePrice = basePrice.add(curSupplierEntryRow.getBigDecimal("finalauditamount"));
                    if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) continue;
                    supplierEntryRow.set("botlistnumber", curSupplierEntryRow.get("botlistnumber"));
                    supplierEntryRow.set("botlistname", curSupplierEntryRow.get("botlistname"));
                    supplierEntryRow.set("botresourceitem", curSupplierEntryRow.get("botresourceitem"));
                }
            }
            targetOpen.set("baseprice", (Object)basePrice);
        }
    }

    public void copyBidOpenSupplierEntryAndDetailEntry(String appId, DynamicObjectCollection curSectionEntry, DynamicObjectCollection sectionEntry, MainEntityType newOneType, boolean enable) {
        if (!enable) {
            for (int i = 0; i < curSectionEntry.size(); ++i) {
                DynamicObject curSectionEntryRow = (DynamicObject)curSectionEntry.get(i);
                String curSectionName = curSectionEntryRow.getString("sectionname");
                for (DynamicObject sectionEntryRow : sectionEntry) {
                    String sectionName = sectionEntryRow.getString("sectionname");
                    if (!StringUtils.equals((CharSequence)curSectionName, (CharSequence)sectionName)) continue;
                    DynamicObjectCollection supplierEntry = sectionEntryRow.getDynamicObjectCollection("supplierentry");
                    DynamicObjectCollection curSupplierEntry = curSectionEntryRow.getDynamicObjectCollection("supplierentry");
                    supplierEntry.clear();
                    for (DynamicObject curSupplierEntryRow : curSupplierEntry) {
                        DynamicObject supplierEntryRow = new DynamicObject((DynamicObjectType)newOneType.getAllEntities().get("supplierentry"));
                        boolean isTender = curSupplierEntryRow.getBoolean("supplier_istender");
                        boolean isInvalid = curSupplierEntryRow.getBoolean("supplier_isinvalid");
                        DynamicObject supplier = curSupplierEntryRow.getDynamicObject("supplier");
                        if (!isTender || isInvalid || supplier == null) continue;
                        Long supId = ID.genLongId();
                        supplierEntryRow.set("id", (Object)supId);
                        supplierEntryRow.set("seq", curSupplierEntryRow.get("seq"));
                        supplierEntryRow.set("supplier", (Object)curSupplierEntryRow.getDynamicObject("supplier"));
                        supplierEntryRow.set("suppliercontact", (Object)curSupplierEntryRow.getString("suppliercontact"));
                        supplierEntryRow.set("contactphone", (Object)curSupplierEntryRow.getString("contactphone"));
                        supplierEntryRow.set("supplier_deposittype", (Object)curSupplierEntryRow.getString("supplier_deposittype"));
                        supplierEntryRow.set("supplier_deposit", (Object)curSupplierEntryRow.getBigDecimal("supplier_deposit"));
                        supplierEntryRow.set("supplier_istender", (Object)curSupplierEntryRow.getBoolean("supplier_istender"));
                        supplierEntryRow.set("supplier_tenderdate", (Object)curSupplierEntryRow.getDate("supplier_tenderdate"));
                        supplierEntryRow.set("supplier_manager", (Object)curSupplierEntryRow.getString("supplier_manager"));
                        supplierEntryRow.set("supplier_workday", (Object)curSupplierEntryRow.getInt("supplier_workday"));
                        this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_techattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_techattach"));
                        this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_comattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_comattach"));
                        this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_tenattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_tenattach"));
                        this.copyAttach(supplierEntryRow.getDynamicObjectCollection("supplier_otherattach"), curSupplierEntryRow.getDynamicObjectCollection("supplier_otherattach"));
                        supplierEntryRow.set("supplier_tenderprice", (Object)curSupplierEntryRow.getBigDecimal("supplier_tenderprice"));
                        supplierEntryRow.set("supplier_taxrate", (Object)curSupplierEntryRow.getBigDecimal("supplier_taxrate"));
                        supplierEntryRow.set("supplier_pricevat", (Object)curSupplierEntryRow.getBigDecimal("supplier_pricevat"));
                        supplierEntryRow.set("supplier_exceptvat", (Object)curSupplierEntryRow.getBigDecimal("supplier_exceptvat"));
                        supplierEntryRow.set("supplier_rate", (Object)curSupplierEntryRow.getBigDecimal("supplier_rate"));
                        supplierEntryRow.set("supplier_revokebidnumber", (Object)curSupplierEntryRow.getInt("supplier_revokebidnumber"));
                        supplierEntryRow.set("supplier_ip", (Object)curSupplierEntryRow.getString("supplier_ip"));
                        supplierEntryRow.set("isnew", (Object)curSupplierEntryRow.getString("isnew"));
                        supplierEntryRow.set("isfromproject", (Object)curSupplierEntryRow.getString("isfromproject"));
                        supplierEntryRow.set("supplier_isfrombackbid", (Object)curSupplierEntryRow.getString("supplier_isfrombackbid"));
                        supplierEntryRow.set("supplier_illustration", (Object)curSupplierEntryRow.getString("supplier_illustration"));
                        supplierEntryRow.set("supplier_isinvalid", (Object)curSupplierEntryRow.getBoolean("supplier_isinvalid"));
                        supplierEntryRow.set("supplier_invalidreason", (Object)curSupplierEntryRow.getString("supplier_invalidreason"));
                        supplierEntryRow.set("supplier_comment", (Object)curSupplierEntryRow.getString("supplier_comment"));
                        supplierEntry.add((Object)supplierEntryRow);
                    }
                    DynamicObjectCollection curSupplierDetail = curSectionEntryRow.getDynamicObjectCollection("supplierdetail");
                    DynamicObjectCollection supplierDetail = sectionEntryRow.getDynamicObjectCollection("supplierdetail");
                    supplierDetail.clear();
                    for (DynamicObject curSupplierDetailRow : curSupplierDetail) {
                        DynamicObject supplierDetailRow = new DynamicObject((DynamicObjectType)newOneType.getAllEntities().get("supplierdetail"));
                        supplierDetailRow.set("seq", curSupplierDetailRow.get("seq"));
                        supplierDetailRow.set("pursupplier", (Object)curSupplierDetailRow.getDynamicObject("pursupplier"));
                        supplierDetailRow.set("purentrycontent", (Object)curSupplierDetailRow.getString("purentrycontent"));
                        supplierDetailRow.set("purentryproject", (Object)curSupplierDetailRow.getDynamicObject("purentryproject"));
                        supplierDetailRow.set("materialid", (Object)curSupplierDetailRow.getDynamicObject("materialid"));
                        supplierDetailRow.set("materialdes", (Object)curSupplierDetailRow.getString("materialdes"));
                        supplierDetailRow.set("qty", (Object)curSupplierDetailRow.getBigDecimal("qty"));
                        supplierDetailRow.set("inclutaxprice", (Object)curSupplierDetailRow.getBigDecimal("inclutaxprice"));
                        supplierDetailRow.set("inclutaxamount", (Object)curSupplierDetailRow.getBigDecimal("inclutaxamount"));
                        supplierDetailRow.set("bd_taxrate", curSupplierDetailRow.get("bd_taxrate"));
                        supplierDetailRow.set("taxrate", (Object)curSupplierDetailRow.getBigDecimal("taxrate"));
                        supplierDetailRow.set("taxamount", (Object)curSupplierDetailRow.getBigDecimal("taxamount"));
                        supplierDetailRow.set("excepttaxamount", (Object)curSupplierDetailRow.getBigDecimal("excepttaxamount"));
                        supplierDetailRow.set("costrate", (Object)curSupplierDetailRow.getBigDecimal("costrate"));
                        if (StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) {
                            supplierDetailRow.set("listnumber", curSupplierDetailRow.get("listnumber"));
                            supplierDetailRow.set("listname", curSupplierDetailRow.get("listname"));
                            supplierDetailRow.set("resourceitem", curSupplierDetailRow.get("resourceitem"));
                        }
                        supplierDetail.add((Object)supplierDetailRow);
                    }
                }
            }
        }
    }

    protected void copyAttach(DynamicObjectCollection newAttachFiles, DynamicObjectCollection oldAttachFiles) {
        oldAttachFiles.stream().forEach(item -> {
            DynamicObject inviteAttach = newAttachFiles.addNew();
            inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
        });
    }

    public void refreshMyTenderStatus(HashSet<Long> bidProjectIDSet, DynamicObject[] dataEntities, String billStatus) {
        String selectFields = "bidproject,supplier,entry,entry.sectionname,entry.projectsection,entry.sectionstatus,ispublicbid,tenderstatus";
        DynamicObject[] myTenderArr = BusinessDataServiceHelper.load((String)"ten_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet), new QFilter("tenderstatus", "=", (Object)MyTenderStatus.PRETENDERED)});
        if (myTenderArr.length > 0) {
            Long[] idArr = bidProjectIDSet.toArray(new Long[bidProjectIDSet.size()]);
            DynamicObjectCollection projectColl = this.bidProjectService.listBidProjectByIds(idArr, "bidopendeadline");
            for (int i = 0; i < projectColl.size(); ++i) {
                if (((DynamicObject)projectColl.get(i)).get("bidopendeadline") != null) continue;
                for (DynamicObject myTender : myTenderArr) {
                    if (!billStatus.equals("O")) continue;
                    int unIndex = 0;
                    int index = 0;
                    DynamicObjectCollection myTenderEntryColl = myTender.getDynamicObjectCollection("entry");
                    for (DynamicObject myTenderEntry : myTenderEntryColl) {
                        String sectionStatus = myTenderEntry.getString("sectionstatus");
                        if (StringUtils.isNotEmpty((CharSequence)sectionStatus) && sectionStatus.equals("PRETENDERED")) {
                            myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.UNTENDERED);
                            ++unIndex;
                            continue;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)sectionStatus) && sectionStatus.equals("UNTENDERED")) {
                            ++unIndex;
                            continue;
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)sectionStatus) || !sectionStatus.equals("TENDERED")) continue;
                        ++index;
                    }
                    if (unIndex == myTenderEntryColl.size()) {
                        myTender.set("tenderstatus", (Object)MyTenderStatus.UNTENDERED);
                        continue;
                    }
                    if (index <= 0) continue;
                    myTender.set("tenderstatus", (Object)MyTenderStatus.TENDERED);
                }
            }
            SaveServiceHelper.update((DynamicObject[])myTenderArr);
        }
    }

    public String getAppId(DynamicObject bidProject) {
        String typeId;
        String appId = "bid";
        if (!bidProject.getDataEntityType().getProperties().containsKey((Object)"entitytypeid")) {
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
        }
        if ((typeId = bidProject.getString("entitytypeid")) != null && typeId.indexOf(95) != -1) {
            appId = typeId.substring(0, typeId.indexOf(95));
        }
        return appId;
    }

    public boolean deleteOnlineEvalUnStartedData(DynamicObject bidProject) {
        if (bidProject != null && bidProject.get("id") != null) {
            Object bidProjectPk = bidProject.getPkValue();
            QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectPk);
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.DISBEGIN.getVal()));
            QFilter[] qFilters = new QFilter[]{qFilter};
            Object[] onlineBidEvalColl = BusinessDataServiceHelper.load((String)"bid_onlinebideval", (String)"id,billstatus", (QFilter[])qFilters);
            HashSet<Long> onlineBidEvalIdSet = new HashSet<Long>(100);
            for (int i = 0; i < onlineBidEvalColl.length; ++i) {
                DynamicObject onlineBidEval = onlineBidEvalColl[i];
                String billStatus = onlineBidEval.getString("billstatus");
                if (!BillStatusEnum.DISBEGIN.getVal().equals(billStatus)) continue;
                onlineBidEvalIdSet.add(onlineBidEval.getLong("id"));
            }
            qFilter = new QFilter("onlinebideval.id", "in", onlineBidEvalIdSet);
            qFilters = new QFilter[]{qFilter};
            Object[] onlineScoreDetailColl = BusinessDataServiceHelper.load((String)"bid_onlinescoredetail", (String)"id", (QFilter[])qFilters);
            Object[] onlineSupplierDetailColl = BusinessDataServiceHelper.load((String)"bid_onlinesupplierdetail", (String)"id", (QFilter[])qFilters);
            if (onlineBidEvalColl.length > 0) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_onlinebideval");
                MainEntityType scoreType = EntityMetadataCache.getDataEntityType((String)"bid_onlinescoredetail");
                MainEntityType suppType = EntityMetadataCache.getDataEntityType((String)"bid_onlinesupplierdetail");
                BusinessDataServiceHelper.delete((IDataEntityType)type, (Object[])onlineBidEvalColl);
                BusinessDataServiceHelper.delete((IDataEntityType)scoreType, (Object[])onlineScoreDetailColl);
                BusinessDataServiceHelper.delete((IDataEntityType)suppType, (Object[])onlineSupplierDetailColl);
            }
            return true;
        }
        return false;
    }

    protected String getTenAppId(DynamicObject bidProject) {
        return "bid".equalsIgnoreCase(this.getAppId(bidProject)) ? "ten" : "resp";
    }

    private static /* synthetic */ void lambda$updateSupplierIsinvalid$8(Table invalidMap, DynamicObject row) {
        String sectionname = row.getString("sectionname");
        if (StringUtils.isEmpty((CharSequence)sectionname)) {
            return;
        }
        ArrayList removeIdList = new ArrayList();
        DynamicObjectCollection supplierEntrys = row.getDynamicObjectCollection("supplierentry");
        supplierEntrys.forEach(subRow -> {
            DynamicObject tSubRow;
            DynamicObject supplier = subRow.getDynamicObject("supplier");
            if (supplier != null && (tSubRow = (DynamicObject)invalidMap.get((Object)sectionname, supplier.getPkValue())) != null && (tSubRow.getBoolean("supplier_isinvalid") || !tSubRow.getBoolean("supplier_istender"))) {
                removeIdList.add(subRow.getPkValue());
            }
        });
        supplierEntrys.removeIf(subRow -> removeIdList.contains(subRow.getPkValue()));
    }

    private static /* synthetic */ void lambda$updateSupplierIsinvalid$5(Table invalidMap, DynamicObject row) {
        String sectionname = row.getString("sectionname");
        if (StringUtils.isEmpty((CharSequence)sectionname)) {
            return;
        }
        DynamicObjectCollection supplierEntrys = row.getDynamicObjectCollection("supplierentry");
        supplierEntrys.forEach(subRow -> {
            DynamicObject supplier = subRow.getDynamicObject("supplier");
            if (supplier != null) {
                invalidMap.put((Object)sectionname, supplier.getPkValue(), subRow);
            }
        });
    }

    public class ValidatorForBidOpen
    extends AbstractValidator {
        protected String appId = "";

        public void validate() {
            block90: {
                ExtendedDataEntity dataEntities;
                String key;
                block89: {
                    Object billStatus;
                    key = this.getOperateKey();
                    dataEntities = this.getDataEntities();
                    DynamicObject project = null;
                    Long projectId = null;
                    if (StringUtils.equals((CharSequence)key, (CharSequence)"save") || StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            String appId = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
                            DynamicObject data = dataEntity.getDataEntity();
                            DynamicObject bidproject = (DynamicObject)dataEntity.getValue("bidproject");
                            QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidproject.getLong("id"));
                            String supplierInvitationId = data.getString("supplierinvitationid");
                            if (!"0".equals(supplierInvitationId) && SupplierInvitationUtil.existAgainSupplierInvitation((Object)supplierInvitationId)) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4fee\u8ba2\u4e2d\u72b6\u6001\u7684\u589e\u8865\u5165\u56f4\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"BidOpenOperationServicePlugIn_130", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                            DynamicObject[] bidpublish = BusinessDataServiceHelper.load((String)(appId + "_bidpublish"), (String)"billstatus", (QFilter[])qFilter.toArray());
                            for (int i = 0; i < bidpublish.length; ++i) {
                                String billstatus = bidpublish[i].getString("billstatus");
                                if (billstatus.equals("C") || billstatus.equals("X") || billstatus.equals("P") || billstatus.equals("J")) continue;
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4fee\u8ba2\u4e2d\u72b6\u6001\u7684\u53d1\u6807\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"BidOpenOperationServicePlugIn_76", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                    }
                    if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)key)) {
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            DynamicObject bidPublish = dataEntity.getDataEntity();
                            billStatus = bidPublish.get("billstatus");
                            if (billStatus.equals("O")) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidOpenOperationServicePlugIn_77", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            if (billStatus.equals("C") || billStatus.equals("O")) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"BidOpenOperationServicePlugIn_78", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                    } else if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            project = (DynamicObject)dataEntity.getValue("bidproject");
                            projectId = project.getLong("id");
                            if (BidOpenOperationServicePlugIn.this.documentService.checkDocumentAudited(projectId).booleanValue()) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u672a\u5ba1\u6279\u7684\u6807\u4e66\u7f16\u5236\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"BidOpenOperationServicePlugIn_79", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                    } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                        String app = BizAppServiceHelp.getAppIdByAppNumber((String)this.appId);
                        Object enableObj = SystemParamServiceHelper.getSystemParameter((String)"", (String)app, (String)"02", (Long)OrgUnitHelper.getRootOrgId(), (String)"enable");
                        boolean enable = enableObj != null ? (Boolean)enableObj : false;
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            boolean isAudit;
                            DynamicObject data = dataEntity.getDataEntity();
                            project = data.getDynamicObject("bidproject");
                            projectId = project.getLong("id");
                            String openType = data.getString("opentype");
                            String docType = project.getString("doctype");
                            boolean isRateBidding = project.getBoolean("isratebidding");
                            boolean isEmptySupplier = false;
                            DynamicObjectCollection bidSections = (DynamicObjectCollection)dataEntity.getValue("bidsection");
                            BigDecimal one = data.getBigDecimal("techweight");
                            BigDecimal two = data.getBigDecimal("comweight");
                            Boolean isMulti = project.getBoolean("enablemultisection");
                            if (!BidOpenOperationServicePlugIn.this.documentService.checkDocumentAudited(projectId).booleanValue()) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u672a\u5ba1\u6279\u7684\u6807\u4e66\u7f16\u5236\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_80", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                            DynamicObject bidProject = data.getDynamicObject("bidproject");
                            boolean bidBottomMake = bidProject.getBoolean("bidbottommake");
                            if (bidBottomMake && !(isAudit = this.checkIsAuditBottomMake(bidProject))) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u72b6\u6001\u7684\u6807\u5e95\u7f16\u5236\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"BidOpenOperationServicePlugIn_125", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            if (one.doubleValue() < 0.0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u201c\u6280\u672f\u6807\u6743\u91cd\u201d<0\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_83", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            } else if (one.doubleValue() > 100.0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u201d\u6280\u672f\u6807\u6743\u91cd\u201c>100\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_84", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            if (two.doubleValue() < 0.0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u201c\u5546\u52a1\u6807\u6743\u91cd\u201d<0\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_85", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            } else if (two.doubleValue() > 100.0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u201d\u5546\u52a1\u6807\u6743\u91cd\u201c>100\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_86", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            String chargingstage = bidProject.getString("chargingstage");
                            if (StringUtils.equals((CharSequence)"openproject", (CharSequence)chargingstage)) {
                                this.validateCharge(dataEntity);
                            }
                            for (DynamicObject section : bidSections) {
                                DynamicObjectCollection suppliers = section.getDynamicObjectCollection("supplierentry");
                                if (suppliers.size() == 0) {
                                    isEmptySupplier = true;
                                }
                                this.validatePrice(dataEntity, isMulti, section, suppliers, isRateBidding, enable);
                            }
                            if (isEmptySupplier) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u6807\u6bb5\u4f9b\u5e94\u5546\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_87", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            DynamicObjectCollection proficients = (DynamicObjectCollection)dataEntity.getValue("bidopen_proficient");
                            Boolean isEvaluation = BidStepInteractiveHelper.checkContainStep((Long)projectId, (BidStepEnum)BidStepEnum.BidEvaluation);
                            String evaluatedmethod = dataEntity.getValue("evaluatedmethod").toString();
                            if (isEvaluation.booleanValue()) {
                                if ((proficients == null || proficients.size() == 0) && isEvaluation.booleanValue()) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u201c\u8bc4\u6807\u4e13\u5bb6\u201d\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_88", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                }
                                if (proficients != null && proficients.size() > 0) {
                                    Boolean isProNull = Boolean.FALSE;
                                    for (DynamicObject proficient : proficients) {
                                        Boolean isTech = proficient.getBoolean("proficient_technical");
                                        Boolean isCom = proficient.getBoolean("proficient_commercial");
                                        if (isTech.booleanValue() || isCom.booleanValue()) continue;
                                        isProNull = Boolean.TRUE;
                                    }
                                    if (isProNull.booleanValue()) {
                                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u8bbe\u7f6e\u8bc4\u6807\u5185\u5bb9\u7684\u4e13\u5bb6\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_89", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                    }
                                }
                                DynamicObjectCollection entryentity = (DynamicObjectCollection)dataEntity.getValue("entryentity");
                                boolean isonlineeval = (Boolean)dataEntity.getValue("isonlineeval");
                                if (isonlineeval && !StringUtils.equals((CharSequence)"1", (CharSequence)evaluatedmethod)) {
                                    if (entryentity == null || entryentity.isEmpty()) {
                                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_133", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                        return;
                                    }
                                    Object scoremode = dataEntity.getValue("scoremode");
                                    Object scoretype = dataEntity.getValue("scoretype");
                                    for (DynamicObject entry : entryentity) {
                                        String type = entry.getString("type1");
                                        DynamicObjectCollection templateColl = entry.getDynamicObjectCollection("bidopen_evalitementry");
                                        DynamicObject[] typeAlias = "";
                                        if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                                            typeAlias = EvalItemType.TECHNICAL.getAlias();
                                        } else if (EvalItemType.COMMERCIAL.getVal().equals(type)) {
                                            typeAlias = EvalItemType.COMMERCIAL.getAlias();
                                        }
                                        if (templateColl == null || templateColl.size() == 0) {
                                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u8bc4\u6807\u9879\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_90", (String)"scm-bid-opplugin", (Object[])new Object[0]), new Object[]{typeAlias}));
                                            continue;
                                        }
                                        if (scoretype == null) continue;
                                        BigDecimal technicalSum = new BigDecimal(0);
                                        BigDecimal commercialSum = new BigDecimal(0);
                                        boolean iscorrect = true;
                                        for (int i = 0; i < templateColl.size(); ++i) {
                                            BigDecimal obj;
                                            DynamicObject coll = (DynamicObject)templateColl.get(i);
                                            String tempType = coll.getString("type");
                                            if (StringUtils.isBlank((CharSequence)tempType)) {
                                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u7c7b\u522b\u201d\u5b57\u6bb5\u3002", (String)"BidOpenOperationServicePlugIn_91", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                                                iscorrect = false;
                                            }
                                            if (StringUtils.isBlank((CharSequence)coll.getString("item"))) {
                                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u8bc4\u5206\u9879\u201d\u5b57\u6bb5\u3002", (String)"BidOpenOperationServicePlugIn_92", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                                                iscorrect = false;
                                            }
                                            if (ScoreMode.STANDARD.getVal().equals(scoremode)) {
                                                obj = coll.getBigDecimal("score");
                                                if (obj.doubleValue() <= 0.0) {
                                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u6807\u51c6\u5206\u201d\u5b57\u6bb5\u3002", (String)"BidOpenOperationServicePlugIn_93", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                                                    iscorrect = false;
                                                }
                                                if (EvalItemType.TECHNICAL.getVal().equals(tempType)) {
                                                    technicalSum = technicalSum.add(obj);
                                                    continue;
                                                }
                                                if (!EvalItemType.COMMERCIAL.getVal().equals(tempType)) continue;
                                                commercialSum = commercialSum.add(obj);
                                                continue;
                                            }
                                            if (!ScoreMode.WEIGHT.getVal().equals(scoremode)) continue;
                                            obj = coll.getBigDecimal("weight");
                                            if (obj.doubleValue() <= 0.0) {
                                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc4\u6807\u9879\u533a\u57df\u7684\u7b2c%s\u884c\u201c\u6240\u5360\u6743\u91cd\u201d\u5b57\u6bb5\u3002", (String)"BidOpenOperationServicePlugIn_94", (String)"scm-bid-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                                                iscorrect = false;
                                            }
                                            if (EvalItemType.TECHNICAL.getVal().equals(tempType)) {
                                                technicalSum = technicalSum.add(obj);
                                                continue;
                                            }
                                            if (!EvalItemType.COMMERCIAL.getVal().equals(tempType)) continue;
                                            commercialSum = commercialSum.add(obj);
                                        }
                                        if (!iscorrect) continue;
                                        if (ScoreType.SUM.getVal().equals(scoretype)) {
                                            if (ScoreMode.STANDARD.getVal().equals(scoremode)) {
                                                if (technicalSum.add(commercialSum).compareTo(new BigDecimal(100)) != 0) {
                                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u603b\u5206\u4e0d\u7b49\u4e8e100\u5206\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_95", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                                    continue;
                                                }
                                                if (!BidOpenTypeEnum.MULTI.getValue().equals(docType)) continue;
                                                if (technicalSum.compareTo(BigDecimal.ZERO) == 0) {
                                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u6280\u672f\u6807\u90e8\u5206", (String)"BidOpenOperationServicePlugIn_28", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                                }
                                                if (commercialSum.compareTo(BigDecimal.ZERO) != 0) continue;
                                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u5546\u52a1\u6807\u90e8\u5206", (String)"BidOpenOperationServicePlugIn_29", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                                continue;
                                            }
                                            if (technicalSum.add(commercialSum).compareTo(BigDecimal.ONE) != 0) {
                                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6743\u91cd\u5408\u8ba1\u4e0d\u7b49\u4e8e100%\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_96", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                                continue;
                                            }
                                            if (!BidOpenTypeEnum.MULTI.getValue().equals(docType)) continue;
                                            if (technicalSum.compareTo(BigDecimal.ZERO) == 0) {
                                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u6280\u672f\u6807\u90e8\u5206", (String)"BidOpenOperationServicePlugIn_28", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                            }
                                            if (commercialSum.compareTo(BigDecimal.ZERO) != 0) continue;
                                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5fc5\u987b\u5b58\u5728\u5546\u52a1\u6807\u90e8\u5206", (String)"BidOpenOperationServicePlugIn_29", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                            continue;
                                        }
                                        if (!ScoreType.PART.getVal().equals(scoretype)) continue;
                                        if (ScoreMode.STANDARD.getVal().equals(scoremode)) {
                                            if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                                                if (technicalSum.compareTo(new BigDecimal(100)) == 0) continue;
                                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u6280\u672f\u6807\u90e8\u5206\u603b\u5206\u4e0d\u7b49\u4e8e100\u5206\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_97", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                                continue;
                                            }
                                            if (!EvalItemType.COMMERCIAL.getVal().equals(type) || commercialSum.compareTo(new BigDecimal(100)) == 0) continue;
                                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5546\u52a1\u6807\u90e8\u5206\u603b\u5206\u4e0d\u7b49\u4e8e100\u5206\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_98", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                            continue;
                                        }
                                        if (EvalItemType.TECHNICAL.getVal().equals(type)) {
                                            if (technicalSum.compareTo(BigDecimal.ONE) == 0) continue;
                                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u6280\u672f\u6807\u90e8\u5206\u6743\u91cd\u5408\u8ba1\u4e0d\u7b49\u4e8e100%\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_99", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                            continue;
                                        }
                                        if (!EvalItemType.COMMERCIAL.getVal().equals(type) || commercialSum.compareTo(BigDecimal.ONE) == 0) continue;
                                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc4\u6807\u9879\u4e2d\u5546\u52a1\u6807\u90e8\u5206\u6743\u91cd\u5408\u8ba1\u4e0d\u7b49\u4e8e100%\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_100", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                    }
                                } else {
                                    BigDecimal comWeight;
                                    BigDecimal techWeight = data.getBigDecimal("techweight");
                                    BigDecimal sumWeight = techWeight.add(comWeight = data.getBigDecimal("comweight"));
                                    if (sumWeight.compareTo(BigDecimal.ONE) != 0 && !StringUtils.equals((CharSequence)"1", (CharSequence)evaluatedmethod)) {
                                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6280\u672f\u6807\u6743\u91cd\u4e0e\u5546\u52a1\u6807\u6743\u91cd\u4e4b\u548c\u4e0d\u7b49\u4e8e1\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_131", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                    }
                                }
                            }
                            String bidOpenSelectType = project.getString("bidopentype");
                            if (!StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)bidOpenSelectType)) {
                                DynamicObject bidOpen;
                                DynamicObject bidOpen2;
                                QFilter qFilterOpen;
                                DynamicObject evaluation;
                                if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenSelectType)) {
                                    if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)openType)) {
                                        if (isEvaluation.booleanValue()) {
                                            QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                                            evaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"billstatus", (QFilter[])new QFilter[]{qFilter = qFilter.and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL)).and(new QFilter("billstatus", "!=", (Object)"XX"))});
                                            if (evaluation != null) {
                                                if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)evaluation.getString("billstatus"))) {
                                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u5c1a\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u5f00\u5546\u52a1\u6807\u3002", (String)"BidOpenOperationServicePlugIn_102", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                                }
                                            } else {
                                                qFilterOpen = new QFilter("bidproject.id", "=", (Object)projectId);
                                                qFilterOpen.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL)).and(new QFilter("billstatus", "!=", (Object)"XX"));
                                                bidOpen2 = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"billstatus", (QFilter[])new QFilter[]{qFilterOpen});
                                                if (bidOpen2 != null && !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)bidOpen2.getString("billstatus"))) {
                                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u6280\u672f\u6807\u3002", (String)"BidOpenOperationServicePlugIn_103", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                                }
                                            }
                                        } else {
                                            QFilter qFilterOpen2 = new QFilter("bidproject.id", "=", (Object)projectId);
                                            qFilterOpen2 = qFilterOpen2.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL));
                                            bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"billstatus", (QFilter[])new QFilter[]{qFilterOpen2 = qFilterOpen2.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()))});
                                            if (bidOpen != null && !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)bidOpen.getString("billstatus"))) {
                                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u6280\u672f\u6807\u3002", (String)"BidOpenOperationServicePlugIn_103", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                            }
                                        }
                                    }
                                } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenSelectType) && StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)openType)) {
                                    if (isEvaluation.booleanValue()) {
                                        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                                        qFilter = qFilter.and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS));
                                        evaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"billstatus", (QFilter[])new QFilter[]{qFilter = qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()))});
                                        if (evaluation != null) {
                                            if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)evaluation.getString("billstatus"))) {
                                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u5c1a\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u5f00\u6280\u672f\u6807\u3002", (String)"BidOpenOperationServicePlugIn_104", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                            }
                                        } else {
                                            qFilterOpen = new QFilter("bidproject.id", "=", (Object)projectId);
                                            qFilterOpen = qFilterOpen.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS));
                                            bidOpen2 = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"billstatus", (QFilter[])new QFilter[]{qFilterOpen = qFilterOpen.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()))});
                                            if (bidOpen2 != null && !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)bidOpen2.getString("billstatus"))) {
                                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u5546\u52a1\u6807\u3002", (String)"BidOpenOperationServicePlugIn_105", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                            }
                                        }
                                    } else {
                                        QFilter qFilterOpen3 = new QFilter("bidproject.id", "=", (Object)projectId);
                                        qFilterOpen3 = qFilterOpen3.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS));
                                        bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"billstatus", (QFilter[])new QFilter[]{qFilterOpen3 = qFilterOpen3.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()))});
                                        if (bidOpen != null && !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)bidOpen.getString("billstatus"))) {
                                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u5546\u52a1\u6807\u3002", (String)"BidOpenOperationServicePlugIn_105", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                        }
                                    }
                                }
                            }
                            String opentype = BidOpenTypeEnum.MULTI.getValue();
                            if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)openType)) {
                                opentype = BidOpenTypeEnum.TECHNICAL.getValue();
                            } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)openType)) {
                                opentype = BidOpenTypeEnum.BUSSINESS.getValue();
                            }
                            boolean exsit = new ReBackBidUtil(BidOpenOperationServicePlugIn.this.getAppId(project)).checkBackBidFinished((Object)projectId, opentype);
                            if (exsit) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidOpenOperationServicePlugIn_150", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                            DynamicObject tempProject = BidOpenOperationServicePlugIn.this.projectService.getBidProjectAllById(projectId);
                            BidStepEnum[] nextStep = BidStepInteractiveHelper.getNextStep((DynamicObject)project, (BidStepEnum)BidStepEnum.BidAnswerQuestion);
                            if (nextStep == null || BidStepEnum.BidOpen != nextStep[0]) continue;
                            QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                            DynamicObject[] AnswerQuestionReco = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter});
                            boolean flag = true;
                            for (DynamicObject question : AnswerQuestionReco) {
                                if (question.get("billstatus").equals("C")) continue;
                                flag = false;
                                break;
                            }
                            Date date = new Date();
                            Date answerQuestionTime = tempProject.getDate("answerquestiontime");
                            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            if (flag) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6279\u7684\u7b54\u7591\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidOpenOperationServicePlugIn_127", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        }
                    } else if (StringUtils.equals((CharSequence)"confirmopen", (CharSequence)key)) {
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            project = (DynamicObject)dataEntity.getValue("bidproject");
                            projectId = project.getLong("id");
                            DynamicObject[] bidPayList = BusinessDataServiceHelper.load((String)"bid_pay_list", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)projectId), new QFilter("status", "=", (Object)"1")});
                            if (null != bidPayList && bidPayList.length > 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5904\u7406\u7f34\u8d39\u4fe1\u606f\u3002", (String)"BidOpenOperationServicePlugIn_106", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                            if (!BidOpenOperationServicePlugIn.this.documentService.checkDocumentAudited(projectId).booleanValue()) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5b58\u5728\u672a\u5ba1\u6279\u7684\u6807\u4e66\u7f16\u5236\uff0c\u4e0d\u5141\u8bb8\u5f00\u6807\u3002", (String)"BidOpenOperationServicePlugIn_107", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            }
                            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bid_project", (String)"bidopendeadline");
                            billStatus = project.getDate("bidopendeadline");
                        }
                    }
                    if (!StringUtils.equals((CharSequence)"delete", (CharSequence)key)) break block89;
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        DynamicObject tempObj = dataEntity.getDataEntity();
                        DynamicObject bidOpen = BidOpenOperationServicePlugIn.this.bidOpenService.getAllBidOpenById((Long)tempObj.getPkValue());
                        Object billstatus = bidOpen.get("billstatus");
                        if (!billstatus.equals("A")) continue;
                        DynamicObjectCollection bidSection = bidOpen.getDynamicObjectCollection("bidsection");
                        for (int i = 0; i < bidSection.size(); ++i) {
                            DynamicObjectCollection supplierEntry = ((DynamicObject)bidSection.get(i)).getDynamicObjectCollection("supplierentry");
                            for (int j = 0; j < supplierEntry.size(); ++j) {
                                Boolean istender = ((DynamicObject)supplierEntry.get(j)).getBoolean("supplier_istender");
                                Boolean isFormBackBid = ((DynamicObject)supplierEntry.get(j)).getBoolean("supplier_isfrombackbid");
                                if (!isFormBackBid.booleanValue() || !istender.booleanValue()) continue;
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4f9b\u5e94\u5546\u56de\u6807\u8bb0\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BidOpenOperationServicePlugIn_110", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                    }
                    break block90;
                }
                if (!"submit".equals(key) && !"save".equals(key)) break block90;
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    boolean exists;
                    DynamicObject data = dataEntity.getDataEntity();
                    boolean isfromreback = data.getBoolean("isfromreback");
                    if (!isfromreback || !(exists = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"rebackbid", ((Object)((Object)this)).getClass()), (QFilter[])new QFilter[]{new QFilter("createopenid", "=", data.getPkValue()), new QFilter("billstatus", "!=", (Object)"C")}))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidOpenOperationServicePlugIn_150", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }

        protected void validateCharge(ExtendedDataEntity dataEntity) {
            DynamicObjectCollection bidSections = (DynamicObjectCollection)dataEntity.getValue("bidsection");
            Iterator bidSectionIter = bidSections.iterator();
            boolean flag = false;
            if (bidSections.size() > 1) {
                flag = true;
            }
            while (bidSectionIter.hasNext()) {
                DynamicObject section = (DynamicObject)bidSectionIter.next();
                DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
                Iterator supplierIter = supplierEntry.iterator();
                String sectoinName = "";
                if (flag) {
                    sectoinName = section.getString("sectionname");
                }
                while (supplierIter.hasNext()) {
                    String supplierDeposittype;
                    DynamicObject row = (DynamicObject)supplierIter.next();
                    boolean supplierIstender = row.getBoolean("supplier_istender");
                    boolean supplierIsinvalid = row.getBoolean("supplier_isinvalid");
                    if (!supplierIstender || supplierIsinvalid || StringUtils.equals((CharSequence)"PAID", (CharSequence)(supplierDeposittype = row.getString("supplier_deposittype"))) || StringUtils.equals((CharSequence)"NOTPAY", (CharSequence)supplierDeposittype)) continue;
                    String tip = "";
                    String supplierName = row.getDynamicObject("supplier").getString("name");
                    tip = flag ? String.format(ResManager.loadKDString((String)"\u6807\u6bb5\u540d\u79f0\u4e3a\uff1a%1$s,\u4f9b\u5e94\u5546\u4e3a\uff1a%2$s,\u5b58\u5728\u6295\u6807\u4fdd\u8bc1\u91d1\u672a\u7f34\u7eb3\u6216\u672a\u786e\u8ba4\u3002", (String)"BidOpenOperationServicePlugIn_128", (String)"scm-bid-opplugin", (Object[])new Object[0]), sectoinName, supplierName) : String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e3a\uff1a%s,\u5b58\u5728\u6295\u6807\u4fdd\u8bc1\u91d1\u672a\u7f34\u7eb3\u6216\u672a\u786e\u8ba4\u3002", (String)"BidOpenOperationServicePlugIn_129", (String)"scm-bid-opplugin", (Object[])new Object[0]), supplierName);
                    this.addErrorMessage(dataEntity, tip);
                    return;
                }
            }
        }

        protected void validatePrice(ExtendedDataEntity dataEntity, Boolean isMulti, DynamicObject section, DynamicObjectCollection suppliers, Boolean isRateBidding, boolean enable) {
            String msgPre = "";
            if (isMulti.booleanValue()) {
                msgPre = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6807\u6bb5\u201c%s\u201d\u5bf9\u5e94\u7684", (String)"BidOpenOperationServicePlugIn_7", (String)"scm-bid-opplugin", (Object[])new Object[0]), section.getLocaleString("sectionname").getLocaleValue());
            }
            msgPre = String.format(ResManager.loadKDString((String)"%s\u4f9b\u5e94\u5546\u4fe1\u606f\u4e2d", (String)"BidOpenOperationServicePlugIn_43", (String)"scm-bid-opplugin", (Object[])new Object[0]), msgPre);
            String openType = dataEntity.getDataEntity().getString("opentype");
            for (int i = 0; i < suppliers.size(); ++i) {
                DynamicObject supplier = (DynamicObject)suppliers.get(i);
                String msgStr = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c", (String)"BidOpenOperationServicePlugIn_61", (String)"scm-bid-opplugin", (Object[])new Object[0]), msgPre, String.valueOf(i + 1));
                Boolean isTender = supplier.getBoolean("supplier_istender");
                Boolean isInvalid = supplier.getBoolean("supplier_isinvalid");
                if (enable) break;
                if (isInvalid.booleanValue() || !BidOpenTypeEnum.MULTI.getValue().equals(openType) && !BidOpenTypeEnum.BUSSINESS.getValue().equals(openType)) continue;
                if (isRateBidding.booleanValue()) {
                    BigDecimal rate = supplier.getBigDecimal("supplier_rate");
                    if (!isTender.booleanValue() || rate != null && !(rate.doubleValue() <= 0.0)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u201c\u8d39\u7387\u201d\u9700>0\u3002", (String)"BidOpenOperationServicePlugIn_114", (String)"scm-bid-opplugin", (Object[])new Object[0]), msgStr));
                    continue;
                }
                BigDecimal exceptVat = supplier.getBigDecimal("supplier_exceptvat");
                if (isTender.booleanValue()) {
                    BigDecimal tenderPrice = supplier.getBigDecimal("supplier_tenderprice");
                    BigDecimal priceVat = supplier.getBigDecimal("supplier_pricevat");
                    if (tenderPrice == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u201c\u6295\u6807\u62a5\u4ef7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidOpenOperationServicePlugIn_115", (String)"scm-bid-opplugin", (Object[])new Object[0]), msgStr));
                    }
                    if (priceVat == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u201c\u7a0e\u989d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BidOpenOperationServicePlugIn_116", (String)"scm-bid-opplugin", (Object[])new Object[0]), msgStr));
                    }
                }
                if (exceptVat == null || isInvalid.booleanValue() || exceptVat.compareTo(BigDecimal.ZERO) >= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u201c\u6295\u6807\u62a5\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"BidOpenOperationServicePlugIn_119", (String)"scm-bid-opplugin", (Object[])new Object[0]), msgStr));
            }
        }

        public boolean checkIsAuditBottomMake(DynamicObject bidProjectData) {
            DynamicObject[] bidBottomMakes = BusinessDataServiceHelper.load((String)"bid_bottom_make", (String)"bidbottomamount,bidsection.totalfinalauditamount", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectData.getPkValue()), new QFilter("billstatus", "=", (Object)"C")});
            return bidBottomMakes.length > 0;
        }
    }
}

