/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.IPurProjectService;
import kd.scm.bid.business.basedata.serviceImpl.PurProjectServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;

public class BidPurProjectOperationServicePlugin
extends AbstractOperationServicePlugIn {
    protected IPurProjectService purProjectService = new PurProjectServiceImpl();
    public static final String BID_PURPROJECT = "bid_purproject";
    public static final String BD_PROJECT = "bd_project";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("level");
        e.getFieldKeys().add("longnumber");
        e.getFieldKeys().add("fullname");
        e.getFieldKeys().add("isleaf");
        e.getFieldKeys().add("projectsource");
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("bdproject");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        MainEntityType bdProjectType = EntityMetadataCache.getDataEntityType((String)BD_PROJECT);
        for (DynamicObject dataEntity : dataEntities) {
            Object purProjectNumber;
            if ("save".equals(key)) {
                String longNumber;
                Object purProjectPkValue = dataEntity.getPkValue();
                DynamicObject parent = dataEntity.getDynamicObject("parent");
                boolean exists = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"purproject", ((Object)((Object)this)).getClass()), (Object)purProjectPkValue);
                purProjectNumber = dataEntity.getString("number");
                String purProjectName = dataEntity.getLocaleString("name").getLocaleValue();
                if (exists) {
                    DynamicObject oldPurProject = BusinessDataServiceHelper.loadSingle((Object)purProjectPkValue, (String)FormTypeConstants.getFormConstant((String)"purproject", ((Object)((Object)this)).getClass()), (String)String.join((CharSequence)",", "name", "number"));
                    if (!((String)purProjectNumber).equals(oldPurProject.getString("number"))) {
                        String updateLongNumber = this.updateLongNumber(parent, (String)purProjectNumber);
                        dataEntity.set("longnumber", (Object)updateLongNumber);
                    }
                    if (!purProjectName.equals(oldPurProject.getLocaleString("name").getLocaleValue())) {
                        String updateFullName = this.updateFullName(parent, purProjectName);
                        dataEntity.set("fullname", (Object)updateFullName);
                    }
                    this.purProjectService.updateBdProjectByPurProject(dataEntity);
                }
                if (!StringUtils.isEmpty((CharSequence)(longNumber = dataEntity.getString("longnumber")))) continue;
                if (parent == null) {
                    dataEntity.set("level", (Object)1);
                    dataEntity.set("longnumber", purProjectNumber);
                    dataEntity.set("fullname", dataEntity.get("name"));
                    dataEntity.set("isleaf", (Object)"1");
                    dataEntity.set("projectsource", (Object)"addnew");
                    continue;
                }
                dataEntity.set("level", (Object)(parent.getInt("level") + 1));
                dataEntity.set("longnumber", (Object)(parent.getString("longnumber") + "." + (String)purProjectNumber));
                dataEntity.set("fullname", (Object)(parent.getLocaleString("fullname").getLocaleValue() + "." + purProjectName));
                dataEntity.set("isleaf", (Object)"1");
                dataEntity.set("projectsource", (Object)"addnew");
                DynamicObject parentLoadSingle = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"purproject", ((Object)((Object)this)).getClass()), (String)"isleaf");
                if (parentLoadSingle.getBoolean("isleaf")) {
                    parentLoadSingle.set("isleaf", (Object)"0");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentLoadSingle});
                dataEntity.set("enable", parent.get("enable"));
                continue;
            }
            if (!"delete".equals(key)) continue;
            DynamicObject parent = dataEntity.getDynamicObject("parent");
            if (parent != null) {
                DynamicObject[] sameLevelPurProjectArray = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"purproject", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "=", parent.getPkValue()), new QFilter("id", "!=", dataEntity.getPkValue())});
                if (sameLevelPurProjectArray != null && sameLevelPurProjectArray.length > 0 && "addnew".equals(dataEntity.getString("projectsource"))) {
                    TXHandle h = TX.requiresNew();
                    purProjectNumber = null;
                    try {
                        DynamicObject bdProject = dataEntity.getDynamicObject("bdproject");
                        DeleteServiceHelper.delete((IDataEntityType)bdProjectType, (Object[])new Object[]{bdProject.getPkValue()});
                        continue;
                    }
                    catch (Throwable throwable) {
                        purProjectNumber = throwable;
                        throw throwable;
                    }
                    finally {
                        if (h != null) {
                            if (purProjectNumber != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)purProjectNumber).addSuppressed(throwable);
                                }
                            } else {
                                h.close();
                            }
                        }
                    }
                }
                this.deleteAllPurProjectTree(dataEntity);
                continue;
            }
            if (!"addnew".equals(dataEntity.getString("projectsource"))) continue;
            try (TXHandle h = TX.requiresNew();){
                DynamicObject bdProject = dataEntity.getDynamicObject("bdproject");
                DeleteServiceHelper.delete((IDataEntityType)bdProjectType, (Object[])new Object[]{bdProject.getPkValue()});
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            if ("save".equals(key)) {
                this.purProjectService.exportPurProjectToSysProject(dataEntity, "SCM");
                continue;
            }
            if ("enable".equals(key)) {
                this.updateAllPurProjectTreeToEnableOrDisable(dataEntity, "enable");
                continue;
            }
            if (!"disable".equals(key)) continue;
            this.updateAllPurProjectTreeToEnableOrDisable(dataEntity, "disable");
        }
    }

    protected void deleteAllPurProjectTree(DynamicObject purProject) {
        List purProjectIdList = this.purProjectService.getAllPurProjectTree(purProject);
        DynamicObject[] allPurProjectTreeLoadArray = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"purproject", ((Object)((Object)this)).getClass()), (String)String.join((CharSequence)",", "id", "bdproject"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)purProjectIdList)});
        HashSet<Object> bdProjectIdSet = new HashSet<Object>();
        for (DynamicObject allPurProjectTreeLoadArrayOne : allPurProjectTreeLoadArray) {
            DynamicObject bdProject = allPurProjectTreeLoadArrayOne.getDynamicObject("bdproject");
            if (bdProject == null) continue;
            bdProjectIdSet.add(bdProject.getPkValue());
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"purproject", ((Object)((Object)this)).getClass()));
        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])purProjectIdList.toArray());
        if ("addnew".equals(purProject.getString("projectsource"))) {
            try (TXHandle h = TX.requiresNew();){
                MainEntityType bdProjectType = EntityMetadataCache.getDataEntityType((String)BD_PROJECT);
                DeleteServiceHelper.delete((IDataEntityType)bdProjectType, (Object[])bdProjectIdSet.toArray());
            }
        }
    }

    public void updateAllPurProjectTreeToEnableOrDisable(DynamicObject purProject, String enable) {
        DynamicObject[] purProjectArray;
        List purProjectIdList = this.purProjectService.getAllPurProjectTree(purProject);
        for (DynamicObject purProjectArrayOne : purProjectArray = BusinessDataServiceHelper.load((String)BID_PURPROJECT, (String)String.join((CharSequence)",", "id", "enable"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)purProjectIdList)})) {
            purProjectArrayOne.set("enable", (Object)(StringUtils.equals((CharSequence)"enable", (CharSequence)enable) ? "1" : "0"));
        }
        SaveServiceHelper.update((DynamicObject[])purProjectArray);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ValidatorBidPurProject());
    }

    protected String updateLongNumber(DynamicObject parent, String newStr) {
        String result = "";
        result = parent == null ? newStr : parent.getString("longnumber") + "." + newStr;
        return result;
    }

    protected String updateFullName(DynamicObject parent, String newStr) {
        String result = "";
        result = parent == null ? newStr : parent.getLocaleString("name").getLocaleValue() + "." + newStr;
        return result;
    }

    private class ValidatorBidPurProject
    extends AbstractValidator {
        private ValidatorBidPurProject() {
        }

        public void validate() {
            String key = this.getOperateKey();
            if (StringUtils.equals((CharSequence)"disable", (CharSequence)key) || StringUtils.equals((CharSequence)"enable", (CharSequence)key)) {
                this.disAbleEnableVarify();
                return;
            }
            if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
                this.saveVarify();
            } else if (StringUtils.equals((CharSequence)"delete", (CharSequence)key)) {
                this.deleteVarify();
            }
        }

        private void deleteVarify() {
            String formConstant = FormTypeConstants.getFormConstant((String)"purproject", ((Object)((Object)this)).getClass());
            HashSet<Object> bdProjectIdSet = null;
            BaseDataCheckRefrence checkBdProjectRefrence = null;
            HashSet<Object> needDeleteIdsForThere = null;
            block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject purProject = dataEntity.getDataEntity();
                Object thisPurProjectPKValue = purProject.getPkValue();
                DynamicObject[] sonPurProjectLoadArray = BusinessDataServiceHelper.load((String)formConstant, (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "=", thisPurProjectPKValue)});
                if (sonPurProjectLoadArray != null && sonPurProjectLoadArray.length > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5220\u9664\u672b\u7ea7\u8282\u70b9\u9879\u76ee\u3002", (String)"BidPurProjectOperationServicePlugin_0", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String projectSource = purProject.getString("projectsource");
                if (!StringUtils.equals((CharSequence)"addnew", (CharSequence)projectSource) && !StringUtils.equals((CharSequence)"sys", (CharSequence)projectSource)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u4e3a\u4ece\u5176\u4ed6\u4e1a\u52a1\u7248\u5757\u81ea\u52a8\u540c\u6b65\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BidPurProjectOperationServicePlugin_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject parent = purProject.getDynamicObject("parent");
                boolean needDeleteAllProjectTree = false;
                if (parent != null) {
                    DynamicObject[] sameLevelPurProjectArray = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"purproject", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "=", parent.getPkValue()), new QFilter("id", "!=", thisPurProjectPKValue)});
                    needDeleteAllProjectTree = sameLevelPurProjectArray == null || sameLevelPurProjectArray.length <= 0;
                }
                if (!needDeleteAllProjectTree) continue;
                List allPurProjectTree = BidPurProjectOperationServicePlugin.this.purProjectService.getAllPurProjectTree(purProject);
                needDeleteIdsForThere = new HashSet<Object>();
                checkBdProjectRefrence = new BaseDataCheckRefrence();
                Set ignoreRefEntityIds = checkBdProjectRefrence.getIgnoreRefEntityIds();
                ignoreRefEntityIds.add(BidPurProjectOperationServicePlugin.BID_PURPROJECT);
                ignoreRefEntityIds.add("rebm_purproject");
                checkBdProjectRefrence.setDraftValidReference(true);
                Map resultMap = checkBdProjectRefrence.checkRef((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)formConstant), allPurProjectTree.toArray(new Object[0]));
                if (resultMap.isEmpty()) continue;
                boolean needContinue = false;
                for (Map.Entry entry : resultMap.entrySet()) {
                    BaseDataCheckRefrenceResult checkRefrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
                    if (!checkRefrenceResult.isRefence()) continue;
                    if (entry.getKey().equals(thisPurProjectPKValue)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u91c7\u8d2d\u9879\u76ee\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BidPurProjectOperationServicePlugin_2", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        needContinue = true;
                        break;
                    }
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u91c7\u8d2d\u9879\u76ee\u4e0a\u7ea7\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u4e0a\u7ea7\u3002", (String)"BidPurProjectOperationServicePlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    needDeleteIdsForThere.add(thisPurProjectPKValue);
                    needContinue = true;
                    break;
                }
                if (needContinue) {
                    if (needDeleteIdsForThere == null || needDeleteIdsForThere.size() <= 0) continue;
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formConstant), (Object[])needDeleteIdsForThere.toArray(new Object[0]));
                    continue;
                }
                DynamicObject[] allPurProjectTreeLoadArray = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"purproject", ((Object)((Object)this)).getClass()), (String)String.join((CharSequence)",", "id", "bdproject"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)allPurProjectTree)});
                bdProjectIdSet = new HashSet<Object>();
                for (DynamicObject allPurProjectTreeLoadArrayOne : allPurProjectTreeLoadArray) {
                    DynamicObject bdProject = allPurProjectTreeLoadArrayOne.getDynamicObject("bdproject");
                    if (bdProject == null) continue;
                    bdProjectIdSet.add(bdProject.getPkValue());
                }
                if (bdProjectIdSet == null || bdProjectIdSet.size() <= 0) continue;
                checkBdProjectRefrence = new BaseDataCheckRefrence();
                Set set = checkBdProjectRefrence.getIgnoreRefEntityIds();
                set.add(BidPurProjectOperationServicePlugin.BID_PURPROJECT);
                set.add("rebm_purproject");
                checkBdProjectRefrence.setDraftValidReference(true);
                Map bdProjectResultMap = checkBdProjectRefrence.checkRef((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)BidPurProjectOperationServicePlugin.BD_PROJECT), bdProjectIdSet.toArray(new Object[0]));
                for (Map.Entry bdProjectResultMapEntry : bdProjectResultMap.entrySet()) {
                    BaseDataCheckRefrenceResult bdProjectheckRefrenceResult = (BaseDataCheckRefrenceResult)bdProjectResultMapEntry.getValue();
                    if (!bdProjectheckRefrenceResult.isRefence()) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u91c7\u8d2d\u9879\u76ee\u9879\u76ee\u6811\u79cd\u540c\u6b65\u5230\u7cfb\u7edf\u4e91\u4e2d\u7684\u6570\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BidPurProjectOperationServicePlugin_4", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    continue block0;
                }
            }
        }

        private void saveVarify() {
            ORM createOrm = ORM.create();
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject purProject = dataEntity.getDataEntity();
                DynamicObject parent = purProject.getDynamicObject("parent");
                if (parent == null) {
                    boolean existsRootNumber = QueryServiceHelper.exists((String)BidPurProjectOperationServicePlugin.BID_PURPROJECT, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)purProject.getString("number")), new QFilter("id", "!=", purProject.getPkValue())});
                    if (!existsRootNumber) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u9879\u76ee\u7f16\u7801\uff0c\u4e0d\u80fd\u91cd\u590d\u5efa\u7acb\u3002", (String)"BidPurProjectOperationServicePlugin_6", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                boolean existsSubNumber = QueryServiceHelper.exists((String)BidPurProjectOperationServicePlugin.BID_PURPROJECT, (QFilter[])new QFilter[]{new QFilter("parent", "=", parent.getPkValue()).and(new QFilter("number", "=", (Object)purProject.getString("number"))), new QFilter("id", "!=", purProject.getPkValue())});
                if (existsSubNumber) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u7ea7\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u9879\u76ee\u7f16\u7801\uff0c\u4e0d\u80fd\u91cd\u590d\u5efa\u7acb\u3002", (String)"BidPurProjectOperationServicePlugin_8", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                boolean existsSubName = QueryServiceHelper.exists((String)BidPurProjectOperationServicePlugin.BID_PURPROJECT, (QFilter[])new QFilter[]{new QFilter("parent", "=", parent.getPkValue()).and(new QFilter("name", "=", (Object)purProject.getLocaleString("name").getLocaleValue())), new QFilter("id", "!=", purProject.getPkValue())});
                if (!existsSubName) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u7ea7\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u9879\u76ee\u540d\u79f0\uff0c\u4e0d\u80fd\u91cd\u590d\u5efa\u7acb\u3002", (String)"BidPurProjectOperationServicePlugin_9", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                return;
            }
        }

        private void disAbleEnableVarify() {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                boolean exists;
                DynamicObject purProject = dataEntity.getDataEntity();
                DynamicObject parent = purProject.getDynamicObject("parent");
                if (parent == null || !(exists = QueryServiceHelper.exists((String)BidPurProjectOperationServicePlugin.BID_PURPROJECT, (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)purProject.getLong("id"))}))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728\u9876\u7ea7\u9879\u76ee\u6216\u6700\u672b\u7ea7\u9879\u76ee\u542f\u7528\u7981\u7528\u6570\u636e\u3002", (String)"BidPurProjectOperationServicePlugin_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

