/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidDarkService;
import kd.scm.bid.business.bill.IMyTenderService;
import kd.scm.bid.business.bill.serviceImpl.BidDarkServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.MyTenderServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.util.BidOpenUtil;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.InvalidBillUtil;
import kd.scm.bid.opplugin.bill.BidReBackBidValidator;

public class BidReBackBidOperationPlugin
extends AbstractOperationServicePlugIn {
    private final String BIDOPEN = FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass());
    private final String BIDEVALUATION = FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass());
    private final String ONLINEBIDEVAL = FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass());
    private final String BIDPROJECT = FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass());
    private static final String SPLIT = "@@@";
    private static final String INVALIDSTATUS = "XX";
    private IMyTenderService myTenderService = new MyTenderServiceImpl();
    private IBidDarkService bidDarkService = new BidDarkServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("endtime");
        fieldKeys.add("bidsection");
        fieldKeys.add("supplierentry");
        fieldKeys.add("bidproject");
        fieldKeys.add("billno");
        fieldKeys.add("sourceid");
        fieldKeys.add("type");
        fieldKeys.add("sectionname");
        fieldKeys.add("supplier");
        fieldKeys.add("createopenid");
        fieldKeys.add("source");
        fieldKeys.add("openendtime");
        fieldKeys.add("evaltioninfo");
        fieldKeys.add("onlineevalinfo");
        fieldKeys.add("answerquestionflag");
        fieldKeys.add("answerquestiontime");
        fieldKeys.add("reason");
        fieldKeys.add("mulqusclarifyids");
        fieldKeys.add("qusclarifyids");
        fieldKeys.add("decisionid");
        fieldKeys.add("laststep");
        fieldKeys.add("bidopendeadline");
        fieldKeys.add("techbackbidtime");
        fieldKeys.add("busbackbidtime");
        fieldKeys.add("round");
        fieldKeys.add("rebackbidflag");
        fieldKeys.add("supplier_techattach");
        fieldKeys.add("supplier_comattach");
        fieldKeys.add("supplier_tenattach");
        fieldKeys.add("supplier_otherattach");
        fieldKeys.add("isdark");
        fieldKeys.add("shuffleorderflag");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BidReBackBidValidator(this.getAppId()));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if ("save".equals(operationKey) || "submit".equals(operationKey)) {
            DynamicObject dataEntity = dataEntities[0];
            long sourceId = dataEntity.getLong("sourceid");
            if (sourceId == 0L) {
                BizLog.log((String)"There is no openid in rebackbid bill");
                return;
            }
            DynamicObject open = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)this.BIDOPEN);
            Set<String> curNeedReBackSupplierSet = this.getCurNeedReBackSupplierSet(dataEntity);
            this.updateNeedReBackSupplierEntry(open, curNeedReBackSupplierSet, true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{open});
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject dataEntity = e.getDataEntities()[0];
        if ("save".equals(operationKey) || "submit".equals(operationKey)) {
            this.saveEndOperationTrans(dataEntity);
        } else if ("audit".equals(operationKey)) {
            this.auditEndOperationTrans(dataEntity);
        } else if ("delete".equals(operationKey)) {
            this.deleteEndOperationTrans(dataEntity);
        } else if ("unaudit".equals(operationKey)) {
            this.unAuditEndOperationTrans(dataEntity);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("audit".equals(operationKey)) {
            DynamicObject dataEntity = dataEntities[0];
            HashSet<Long> supplierIds = new HashSet<Long>();
            DynamicObjectCollection bidSectionCol = dataEntity.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidSection : bidSectionCol) {
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    Long supplierId = (Long)supplierEntry.getDynamicObject("supplier").getPkValue();
                    boolean isTender = supplierEntry.getBoolean("rebackbidflag");
                    if (supplierId == null || !isTender) continue;
                    supplierIds.add(supplierId);
                }
            }
            this.sendMessage(dataEntity, supplierIds);
        }
    }

    public void sendMessage(DynamicObject data, Set<Long> supplierIds) {
        DynamicObject bidProject = data.getDynamicObject("bidproject");
        for (Long supplierId : supplierIds) {
            HashMap<String, Object> msgParam = new HashMap<String, Object>();
            String appId = this.getAppId();
            String type = data.getString("type");
            String notifyType = null;
            if ("bid".equals(appId)) {
                msgParam.put("formId", "ten_mytender");
                msgParam.put("msgentity", "bid_rebackbid");
                msgParam.put("operation", "audit");
                msgParam.put("appId", "bid");
            } else {
                msgParam.put("formId", "resp_mytender");
                msgParam.put("appId", "rebm");
                msgParam.put("operation", "audit");
                msgParam.put("msgentity", "bid_rebackbid");
            }
            msgParam.put("content", null);
            msgParam.put("title", null);
            if ("TECHNICAL".equals(type)) {
                msgParam.put("tplScene", "rebackbid_tec");
                notifyType = MessageChannelUtil.getNotifyType((String)"rebackbid_tec", (String)"bid_rebackbid");
            } else if ("BUSSINESS".equals(type)) {
                msgParam.put("tplScene", "rebackbid_bus");
                notifyType = MessageChannelUtil.getNotifyType((String)"rebackbid_bus", (String)"bid_rebackbid");
            } else if ("MULTI".equals(type)) {
                msgParam.put("tplScene", "rebackbid_mul");
                notifyType = MessageChannelUtil.getNotifyType((String)"rebackbid_mul", (String)"bid_rebackbid");
            }
            msgParam.put("notifyType", notifyType);
            msgParam.put("id", data.getPkValue());
            msgParam.put("pkId", data.getPkValue());
            this.sendRebackbidMessage(msgParam, bidProject.getPkValue(), supplierId, notifyType);
        }
    }

    public void sendRebackbidMessage(HashMap<String, Object> msgParam, Object bidProjectPk, Long currentSupplierId, String notifyTypes) {
        String appId = (String)msgParam.get("appId");
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)notifyTypes)) {
            return;
        }
        DynamicObject[] bidPublishArray = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (String)"bidsection,bidsection.supplierentry,supplierentry,supplierentry.supplier,supplierentry.projectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProjectPk), new QFilter("billstatus", "!=", (Object)"X")}, (String)"createtime desc");
        if (bidPublishArray != null && bidPublishArray.length > 0) {
            DynamicObject bidPublish = bidPublishArray[0];
            DynamicObjectCollection bidSectionCol = bidPublish.getDynamicObjectCollection("bidsection");
            HashMap<Long, Long> hasMap = new HashMap<Long, Long>();
            for (DynamicObject bidSection : bidSectionCol) {
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject projectPartner;
                    Long supplierId = supplierEntry.getLong("supplier.id");
                    if (!currentSupplierId.equals(supplierId) || (projectPartner = supplierEntry.getDynamicObject("projectpartner")) == null) continue;
                    hasMap.put(supplierId, projectPartner.getLong("id"));
                }
            }
            DynamicObject myTender = this.myTenderService.getMyTenderByBidProjectAndSupplier((Long)bidProjectPk, currentSupplierId);
            Long tenderPk = 0L;
            if (myTender != null) {
                tenderPk = myTender.getLong("id");
            }
            msgParam.put("pkId", tenderPk);
            msgParam.put("targetButtonId", "btn_tender");
            msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "targetButtonId"));
            Long supplierUserId = (Long)hasMap.get(currentSupplierId);
            msgParam.put("supplierId", currentSupplierId);
            if (supplierUserId != null) {
                msgParam.put("supplierBizUser", supplierUserId);
            }
            MessageCenterHelper.sendMessages(msgParam, (boolean)true, (String)appId, (String)notifyTypes);
        }
    }

    protected void unAuditEndOperationTrans(DynamicObject dataEntity) {
        long sourceId = dataEntity.getLong("sourceid");
        if (sourceId == 0L) {
            BizLog.log((String)"There is no openid in rebackbid bill");
            return;
        }
        this.unAuditUpdateOpen(sourceId);
        this.unAuditUpdateEvalAndOnlineEval(dataEntity);
        Object bidprojectId = dataEntity.getDynamicObject("bidproject").getPkValue();
        this.updateTenderAndOnlineTen(dataEntity, bidprojectId, false);
        this.updateClaifyAndDecicion(dataEntity, false);
        this.updateBidProjectData(bidprojectId, dataEntity);
    }

    private void unAuditUpdateOpen(long sourceId) {
        DynamicObject bidOpen = this.getBidOpen(sourceId);
        String billstatus = bidOpen.getString("billstatus");
        if (INVALIDSTATUS.equals(billstatus)) {
            bidOpen.set("billstatus", (Object)"O");
        }
        SaveServiceHelper.update((DynamicObject)bidOpen);
        InvalidBillUtil.validBidAssinviteBill((String)this.getAppId(), (Long)bidOpen.getLong("id"));
    }

    protected void updateBidProjectData(Object bidprojectId, DynamicObject dataEntity) {
        DynamicObject bidProject = this.getBidProject(bidprojectId);
        bidProject.set("currentstep", dataEntity.get("laststep"));
        long sourceId = dataEntity.getLong("sourceid");
        DynamicObject bidOpen = this.getBidOpen(sourceId);
        bidProject.set("bidopentime", bidOpen.get("lbidopentime"));
        bidProject.set("techopenbidtime", bidOpen.get("ltechopenbidtime"));
        bidProject.set("busopenbidtime", bidOpen.get("lbusopenbidtime"));
        bidProject.set("bidopendeadline", dataEntity.get("bidopendeadline"));
        bidProject.set("techbackbidtime", dataEntity.get("techbackbidtime"));
        bidProject.set("busbackbidtime", dataEntity.get("busbackbidtime"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidProject});
    }

    protected void unAuditUpdateEvalAndOnlineEval(DynamicObject dataEntity) {
        DynamicObject[] evaluation = this.getEvaluation(dataEntity);
        this.rollBackBillstatus(dataEntity, evaluation, "evaltioninfo");
        DynamicObject[] onlineEvaluation = this.getOnlineEval(dataEntity);
        this.rollBackBillstatus(dataEntity, onlineEvaluation, "onlineevalinfo");
    }

    protected void rollBackBillstatus(DynamicObject dataEntity, DynamicObject[] datas, String field) {
        if (datas == null || datas.length == 0) {
            BizLog.log((String)"No evaltion or onlineeval datas");
            return;
        }
        Map<Long, String> idAndBillstatusMap = this.getIdAndBillstatusMap(dataEntity, field);
        Arrays.stream(datas).forEach(eval -> {
            long evaltionId = (Long)eval.getPkValue();
            String billstatus = (String)idAndBillstatusMap.get(evaltionId);
            if (billstatus != null) {
                eval.set("billstatus", (Object)billstatus);
            }
        });
        SaveServiceHelper.save((DynamicObject[])datas);
    }

    protected void deleteEndOperationTrans(DynamicObject dataEntity) {
        long sourceId = dataEntity.getLong("sourceid");
        if (sourceId == 0L) {
            BizLog.log((String)"There is no openid in rebackbid bill");
            return;
        }
        this.deleteUpdateOpen(dataEntity, sourceId);
        this.deleteUpdateEvalAndOnlineEval(dataEntity);
        Object bidprojectId = dataEntity.getDynamicObject("bidproject").getPkValue();
        this.updateBidProjectData(bidprojectId, dataEntity);
    }

    protected void deleteUpdateEvalAndOnlineEval(DynamicObject dataEntity) {
        DynamicObject[] onlineEvals;
        DynamicObject[] evaluations = this.getEvaluation(dataEntity);
        if (evaluations != null && evaluations.length > 0) {
            for (DynamicObject evaluation : evaluations) {
                String name = evaluation.getString("bidproject.name");
                evaluation.set("bidprojectname", (Object)name);
            }
            SaveServiceHelper.save((DynamicObject[])evaluations);
        }
        if ((onlineEvals = this.getOnlineEval(dataEntity)) != null && onlineEvals.length > 0) {
            for (DynamicObject onlineEval : onlineEvals) {
                String name = onlineEval.getString("bidproject.name");
                onlineEval.set("bidprojectname", (Object)name);
            }
            SaveServiceHelper.update((DynamicObject[])onlineEvals);
        }
    }

    protected void deleteUpdateOpen(DynamicObject dataEntity, long sourceId) {
        DynamicObject bidOpen = this.getBidOpen(sourceId);
        String name = bidOpen.getString("bidproject.name");
        bidOpen.set("bidprojectname", (Object)name);
        Set<String> curNeedReBackSupplierSet = this.getCurNeedReBackSupplierSet(dataEntity);
        this.updateNeedReBackSupplierEntry(bidOpen, curNeedReBackSupplierSet, false);
        bidOpen.set("rebackid", null);
        SaveServiceHelper.update((DynamicObject)bidOpen);
        InvalidBillUtil.validBidAssinviteBill((String)this.getAppId(), (Long)bidOpen.getLong("id"));
        long createOpenId = dataEntity.getLong("createopenid");
        boolean existsOpen = QueryServiceHelper.exists((String)this.BIDOPEN, (QFilter[])new QFilter[]{new QFilter("isfromreback", "=", (Object)Boolean.TRUE), new QFilter("id", "=", (Object)createOpenId)});
        if (existsOpen) {
            DeleteServiceHelper.delete((String)"bid_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", (Object)createOpenId)});
        }
        DeleteServiceHelper.delete((String)this.BIDOPEN, (QFilter[])new QFilter[]{new QFilter("isfromreback", "=", (Object)Boolean.TRUE), new QFilter("id", "=", (Object)createOpenId)});
        InvalidBillUtil.validBidAssinviteBill((String)this.getAppId(), (Long)createOpenId);
    }

    protected void saveEndOperationTrans(DynamicObject dataEntity) {
        DynamicObject open;
        OperationResult result;
        long sourceId = dataEntity.getLong("sourceid");
        if (sourceId == 0L) {
            return;
        }
        long createOpenId = this.getCreateOpenId(dataEntity);
        DynamicObject exsitNewBidOpen = QueryServiceHelper.queryOne((String)this.BIDOPEN, (String)"id", (QFilter[])new QFilter[]{new QFilter("isfromreback", "=", (Object)Boolean.TRUE), new QFilter("id", "=", (Object)createOpenId)});
        if (exsitNewBidOpen != null) {
            DeleteServiceHelper.delete((String)"bid_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", (Object)createOpenId)});
            DeleteServiceHelper.delete((String)this.BIDOPEN, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)createOpenId)});
        }
        if (!(result = OperationServiceHelper.executeOperate((String)"pushandsave", (String)this.BIDOPEN, (DynamicObject[])new DynamicObject[]{open = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)this.BIDOPEN)}, (OperateOption)OperateOption.create())).isSuccess()) {
            List allErrorOrValidateInfo;
            String message = result.getValidateResult().getMessage();
            if ((message == null || message.isEmpty()) && (allErrorOrValidateInfo = result.getAllErrorOrValidateInfo()) != null && allErrorOrValidateInfo.size() > 0) {
                message = ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage();
            }
            if (message != null && !message.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u5f00\u6807\u5355\u5931\u8d25\uff1a%s", (String)"BidReBackBidOperationPlugin_1", (String)"scm-bid-opplugin", (Object[])new Object[0]), message));
            }
        }
        Object bidprojectId = dataEntity.getDynamicObject("bidproject").getPkValue();
        this.reWriteBidprojectName(bidprojectId, dataEntity, open);
        DynamicObject newOpenBill = BusinessDataServiceHelper.loadSingle((String)this.BIDOPEN, (String)String.join((CharSequence)",", "billstatus", "rounds", "listrounds", "opentype", "bidprojectname", "bidsection", "sectionname", "supplierentry", "supplier", "supplier_isinvalid", "supplier_ip", "tender", "supplier_tenderdate", "supplier_invalidreason", "supplier_comment", "isdark", "rebackorderflag"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidprojectId), new QFilter("isfromreback", "=", (Object)Boolean.TRUE), new QFilter("billstatus", "=", (Object)"A")});
        if (newOpenBill != null) {
            newOpenBill = BusinessDataServiceHelper.loadSingle((Object)newOpenBill.getPkValue(), (String)this.BIDOPEN);
            DynamicObject rebackbid = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getLong("id"), (String)FormTypeConstants.getFormConstant((String)"rebackbid", ((Object)((Object)this)).getClass()), (String)"createopenid");
            if (rebackbid != null) {
                rebackbid.set("createopenid", newOpenBill.getPkValue());
                SaveServiceHelper.update((DynamicObject)rebackbid);
            }
            newOpenBill.set("billstatus", (Object)"D");
            newOpenBill.set("bidprojectname", (Object)open.getString("bidproject.name"));
            int rounds = BidOpenUtil.getOpenRounds((Object)bidprojectId, (String)this.getAppId(), (String)newOpenBill.getString("opentype"));
            newOpenBill.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5f00\u6807", (String)"BidReBackBidOperationPlugin_0", (String)"scm-bid-opplugin", (Object[])new Object[0]), rounds > 1 ? BidOpenServiceImpl.toChinese((String)String.valueOf(rounds - 1)) : BidOpenServiceImpl.toChinese((String)String.valueOf(1))));
            this.setSupplierEntryInvalidStatus(dataEntity, newOpenBill);
            newOpenBill.set("isdark", dataEntity.get("isdark"));
            newOpenBill.set("rebackorderflag", dataEntity.get("shuffleorderflag"));
            SaveServiceHelper.update((DynamicObject)newOpenBill);
        }
    }

    private void setSupplierEntryInvalidStatus(DynamicObject dataEntity, DynamicObject newOpenBill) {
        Set<String> curNeedReBackSupplierSet = this.getCurNeedReBackSupplierSet(dataEntity);
        DynamicObjectCollection bidSection = newOpenBill.getDynamicObjectCollection("bidsection");
        bidSection.forEach(section -> {
            String sectionname = section.getString("sectionname");
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(entry -> {
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier != null && curNeedReBackSupplierSet.contains(sectionname + SPLIT + supplier.getPkValue())) {
                    entry.set("supplier_isinvalid", (Object)Boolean.FALSE);
                    entry.set("supplier_invalidreason", null);
                    entry.set("supplier_comment", null);
                    entry.set("supplier_ip", null);
                    entry.set("tender", null);
                    entry.set("supplier_tenderdate", null);
                }
            });
        });
    }

    protected long getCreateOpenId(DynamicObject dataEntity) {
        long createOpenId = 0L;
        DynamicObject reBackBid = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"rebackbid", ((Object)((Object)this)).getClass()), (String)"createopenid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataEntity.getLong("id"))});
        if (reBackBid != null) {
            createOpenId = reBackBid.getLong("createopenid");
        }
        return createOpenId;
    }

    protected Set<String> getCurNeedReBackSupplierSet(DynamicObject dataEntity) {
        HashSet<String> needReBackSupplierSet = new HashSet<String>(16);
        DynamicObjectCollection bidSection = dataEntity.getDynamicObjectCollection("bidsection");
        bidSection.forEach(section -> {
            String sectionname = section.getString("sectionname");
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(entry -> {
                boolean reBackBidFlag = entry.getBoolean("rebackbidflag");
                if (!reBackBidFlag) {
                    return;
                }
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier != null) {
                    needReBackSupplierSet.add(sectionname + SPLIT + supplier.getPkValue());
                    BizLog.log((String)("BID rebackBid audit NEEDREBACKSUPPLIER KEY ==" + sectionname + SPLIT + supplier.getPkValue() + "!!!!!!!!!!!!!!!!!!!!!!!!!"));
                }
            });
        });
        return needReBackSupplierSet;
    }

    protected void updateNeedReBackSupplierEntry(DynamicObject open, Set<String> curNeedReBackSupplierSet, boolean flag) {
        DynamicObjectCollection bidSection = open.getDynamicObjectCollection("bidsection");
        bidSection.forEach(section -> {
            String sectionname = section.getString("sectionname");
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(entry -> {
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier != null) {
                    if (curNeedReBackSupplierSet.contains(sectionname + SPLIT + supplier.getPkValue())) {
                        entry.set("isrebackbid", (Object)flag);
                    } else {
                        entry.set("isrebackbid", (Object)Boolean.FALSE);
                    }
                }
            });
        });
    }

    protected void updateNewOpenBillAttr(DynamicObject newOpenBill, Set<String> curNeedReBackSupplierSet, DynamicObject dataEntity) {
        Map<String, DynamicObject> supplieEntryMap = this.getSupplieEntryMap(dataEntity);
        String type = dataEntity.getString("type");
        DynamicObjectCollection bidSection = newOpenBill.getDynamicObjectCollection("bidsection");
        bidSection.forEach(section -> {
            String sectionName = section.getString("sectionname");
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(entry -> {
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier == null) {
                    return;
                }
                String key = sectionName + SPLIT + supplier.getPkValue();
                DynamicObject oldEntry = (DynamicObject)supplieEntryMap.get(key);
                if (!curNeedReBackSupplierSet.contains(key)) {
                    this.copyOldFileToNew((DynamicObject)entry, oldEntry, BidOpenTypeEnum.MULTI.getValue());
                } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(type)) {
                    entry.getDynamicObjectCollection("supplier_comattach").clear();
                    this.clearSupplierEntryPrice((DynamicObject)entry);
                    this.copyOldFileToNew((DynamicObject)entry, oldEntry, BidOpenTypeEnum.BUSSINESS.getValue());
                } else if (BidOpenTypeEnum.TECHNICAL.getValue().equals(type)) {
                    entry.getDynamicObjectCollection("supplier_tenattach").clear();
                    this.copyOldFileToNew((DynamicObject)entry, oldEntry, BidOpenTypeEnum.TECHNICAL.getValue());
                } else {
                    entry.getDynamicObjectCollection("supplier_comattach").clear();
                    entry.getDynamicObjectCollection("supplier_tenattach").clear();
                    this.clearSupplierEntryPrice((DynamicObject)entry);
                }
            });
            this.clearSupplierDetailPriceFieldsData(curNeedReBackSupplierSet, type, (DynamicObject)section, sectionName);
        });
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newOpenBill});
    }

    protected Map<String, DynamicObject> getSupplieEntryMap(DynamicObject dataEntity) {
        HashMap<String, DynamicObject> supplieEntryMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection bidSection = dataEntity.getDynamicObjectCollection("bidsection");
        bidSection.forEach(section -> {
            String sectionname = section.getString("sectionname");
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(entry -> {
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier != null) {
                    supplieEntryMap.put(sectionname + SPLIT + supplier.getPkValue(), (DynamicObject)entry);
                    BizLog.log((String)("BID rebackBid audit getSupplieEntryMap KEY ==" + sectionname + SPLIT + supplier.getPkValue() + "!!!!!!!!!!!!!!!!!!!!!!!!!"));
                }
            });
        });
        return supplieEntryMap;
    }

    protected void clearSupplierDetailPriceFieldsData(Set<String> curNeedReBackSupplierSet, String type, DynamicObject section, String sectionName) {
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(type)) {
            return;
        }
        DynamicObjectCollection supplierdetail = section.getDynamicObjectCollection("supplierdetail");
        supplierdetail.forEach(detail -> {
            DynamicObject pursupplier = detail.getDynamicObject("pursupplier");
            if (pursupplier == null) {
                return;
            }
            if (curNeedReBackSupplierSet.contains(sectionName + SPLIT + pursupplier.getPkValue())) {
                detail.set("inclutaxprice", null);
                detail.set("inclutaxamount", null);
                detail.set("bd_taxrate", null);
                detail.set("taxrate", null);
                detail.set("taxamount", null);
                detail.set("excepttaxamount", null);
            }
        });
    }

    public void clearSupplierEntryPrice(DynamicObject entry) {
        entry.set("supplier_tenderprice", null);
        entry.set("supplier_taxrate", null);
        entry.set("supplier_pricevat", null);
        entry.set("supplier_exceptvat", null);
        entry.set("supplier_illustration", null);
    }

    protected void copyOldFileToNew(DynamicObject entry, DynamicObject oldEntry, String type) {
        if (oldEntry == null) {
            return;
        }
        if (!BidOpenTypeEnum.TECHNICAL.getValue().equals(type)) {
            this.copyFile(entry.getDynamicObjectCollection("supplier_techattach"), oldEntry.getDynamicObjectCollection("supplier_techattach"));
        }
        this.copyFile(entry.getDynamicObjectCollection("supplier_tenattach"), oldEntry.getDynamicObjectCollection("supplier_tenattach"));
        if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(type)) {
            this.copyFile(entry.getDynamicObjectCollection("supplier_comattach"), oldEntry.getDynamicObjectCollection("supplier_comattach"));
        }
        this.copyFile(entry.getDynamicObjectCollection("supplier_otherattach"), oldEntry.getDynamicObjectCollection("supplier_otherattach"));
    }

    protected void copyFile(DynamicObjectCollection newAttachFiles, DynamicObjectCollection oldAttachFiles) {
        oldAttachFiles.stream().forEach(item -> {
            DynamicObject inviteAttach = newAttachFiles.addNew();
            inviteAttach.set("fbasedataid", (Object)item.getDynamicObject("fbasedataid"));
        });
    }

    protected DynamicObject getOpenBillForBotp(Object openId) {
        return BusinessDataServiceHelper.loadSingle((Object)openId, (String)this.BIDOPEN);
    }

    protected void auditEndOperationTrans(DynamicObject dataEntity) {
        long sourceId = dataEntity.getLong("sourceid");
        if (sourceId == 0L) {
            return;
        }
        Object bidprojectId = dataEntity.getDynamicObject("bidproject").getPkValue();
        this.reWriteOpenAndDeadlineDate(bidprojectId, dataEntity);
        this.reWriteAnswerQuestion(bidprojectId, dataEntity);
        this.invalidDownProcessBills(dataEntity, sourceId, bidprojectId);
        this.updateClaifyAndDecicion(dataEntity, true);
        this.updateTenderAndOnlineTen(dataEntity, bidprojectId, true);
        InvalidBillUtil.invalidBidAssinviteBill((String)this.getAppId(), (Long)sourceId);
        DynamicObject reBackBid = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"rebackbid", ((Object)((Object)this)).getClass()), (String)"createopenid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataEntity.getLong("id"))});
        DynamicObject newOpenBill = this.getOpenBillForBotp(reBackBid.getLong("createopenid"));
        Set<String> curNeedReBackSupplierSet = this.getCurNeedReBackSupplierSet(dataEntity);
        if (newOpenBill != null) {
            Date date = dataEntity.getDate("openendtime");
            newOpenBill.set("bidopentime", (Object)date);
            newOpenBill.set("techopenbidtime", (Object)date);
            newOpenBill.set("busopenbidtime", (Object)date);
            newOpenBill.set("member", null);
            this.updateNewOpenBillAttr(newOpenBill, curNeedReBackSupplierSet, dataEntity);
            DynamicObject query = QueryServiceHelper.queryOne((String)"bid_project", (String)"is_enc_enable", (QFilter[])new QFilter[]{new QFilter("id", "=", bidprojectId)});
            if (query.getBoolean("is_enc_enable")) {
                this.bidDarkService.saveBidDark(newOpenBill, this.getAppId());
            }
        }
    }

    public void updateClaifyAndDecicion(DynamicObject dataEntity, boolean isAudit) {
        DynamicObject[] bustalks;
        DynamicObject decision;
        long decisionid;
        String qusclarifyids;
        String mulqusclarifyids = dataEntity.getString("mulqusclarifyids");
        if (mulqusclarifyids != null) {
            DynamicObject[] multiquestclarifies;
            List newIds = Arrays.stream(mulqusclarifyids.split(SPLIT)).filter(id -> id != null && !id.isEmpty()).map(Long::valueOf).collect(Collectors.toList());
            for (DynamicObject multiquestclarify : multiquestclarifies = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"multiquestclarify", ((Object)((Object)this)).getClass()), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", newIds)})) {
                multiquestclarify.set("billstatus", (Object)(isAudit ? "INVALIDXX" : "A"));
            }
            SaveServiceHelper.save((DynamicObject[])multiquestclarifies);
        }
        if ((qusclarifyids = dataEntity.getString("qusclarifyids")) != null) {
            DynamicObject[] multiquestclarifies;
            List newIds = Arrays.stream(qusclarifyids.split(SPLIT)).filter(id -> id != null && !id.isEmpty()).map(Long::valueOf).collect(Collectors.toList());
            for (DynamicObject multiquestclarify : multiquestclarifies = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"questionclarify", ((Object)((Object)this)).getClass()), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", newIds)})) {
                multiquestclarify.set("billstatus", (Object)(isAudit ? "INVALIDXX" : "CLARIFIED"));
            }
            SaveServiceHelper.save((DynamicObject[])multiquestclarifies);
        }
        if ((decisionid = dataEntity.getLong("decisionid")) != 0L && (decision = BusinessDataServiceHelper.loadSingle((Object)decisionid, (String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"billstatus")) != null) {
            decision.set("billstatus", (Object)(isAudit ? INVALIDSTATUS : "D"));
            SaveServiceHelper.update((DynamicObject)decision);
        }
        Object bidprojectId = dataEntity.getDynamicObject("bidproject").getPkValue();
        QFilter qFilter = new QFilter("bidproject", "=", bidprojectId);
        QFilter qFilterstu = new QFilter("billstatus", "=", (Object)"C");
        for (DynamicObject bustalk : bustalks = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()), (String)"is_again_ten", (QFilter[])new QFilter[]{qFilter, qFilterstu})) {
            bustalk.set("is_again_ten", (Object)"1");
        }
        SaveServiceHelper.save((DynamicObject[])bustalks);
    }

    protected void updateTenderAndOnlineTen(DynamicObject dataEntity, Object bidprojectId, boolean isAudit) {
        Set<String> curNeedReBackSupplierSet;
        Set<Long> supplierIdSet;
        String tenAppId = this.getTenAppId();
        DynamicObject[] tenders = this.getTender(tenAppId, bidprojectId, supplierIdSet = (curNeedReBackSupplierSet = this.getCurNeedReBackSupplierSet(dataEntity)).stream().map(item -> Long.valueOf(item.split(SPLIT)[1])).collect(Collectors.toSet()));
        if (tenders == null || tenders.length == 0) {
            return;
        }
        Map<Object, Object> oldSupplierTenStatusMap = new HashMap(16);
        if (!isAudit) {
            long bidOpenId = dataEntity.getLong("sourceid");
            DynamicObject bidOpen = this.getBidOpen(bidOpenId);
            oldSupplierTenStatusMap = this.getOldSupplierTenStatusMap(bidOpen, curNeedReBackSupplierSet);
        }
        HashSet<Object> tenderIds = new HashSet<Object>(16);
        HashMap finalOldSupplierTenStatusMap = oldSupplierTenStatusMap;
        Arrays.stream(tenders).forEach(tender -> {
            DynamicObject supplier = tender.getDynamicObject("supplier");
            if (supplier == null) {
                return;
            }
            tenderIds.add(tender.getPkValue());
            BizLog.log((String)("BID:rebackbid audit tenderIds == " + tender.getPkValue() + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
            Object supplierId = supplier.getPkValue();
            DynamicObjectCollection sectionEntry = tender.getDynamicObjectCollection("entry");
            HashSet sb = new HashSet(16);
            sectionEntry.forEach(entry -> {
                String sectionName = entry.getString("sectionname");
                String key = sectionName + SPLIT + supplierId;
                if (isAudit) {
                    if (curNeedReBackSupplierSet.contains(key)) {
                        entry.set("sectionstatus", (Object)"PRETENDERED");
                        entry.set("fromrebackflag", (Object)Boolean.TRUE);
                    } else {
                        entry.set("fromrebackflag", (Object)Boolean.FALSE);
                    }
                } else {
                    String status = (String)finalOldSupplierTenStatusMap.get(key);
                    if (status != null) {
                        entry.set("sectionstatus", (Object)status);
                        entry.set("fromrebackflag", (Object)Boolean.FALSE);
                        sb.add(status);
                    }
                }
            });
            if (isAudit) {
                int currentRounds = tender.getInt("rounds") + 1;
                tender.set("rounds", (Object)currentRounds);
                tender.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6b21", (String)"BidReBackBidOperationPlugin_2", (String)"scm-bid-opplugin", (Object[])new Object[0]), CommonUtil.toChinese((String)(currentRounds + ""))));
                tender.set("node", dataEntity.get("reason"));
                tender.set("backbidtype", (Object)("MULTI".equals(dataEntity.getString("type")) ? "TECHANDBUSS" : dataEntity.getString("type")));
                tender.set("biddingdate", null);
                tender.set("tenderstatus", (Object)"PRETENDERED");
            } else {
                int currentRounds = tender.getInt("rounds") - 1;
                if (currentRounds <= 0) {
                    currentRounds = 1;
                }
                tender.set("rounds", (Object)currentRounds);
                tender.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6b21", (String)"BidReBackBidOperationPlugin_2", (String)"scm-bid-opplugin", (Object[])new Object[0]), CommonUtil.toChinese((String)(currentRounds + ""))));
                tender.set("tenderstatus", (Object)(sb.contains("TENDERED") ? "TENDERED" : "PRETENDERED"));
            }
        });
        if (isAudit) {
            this.updateOnlineBidStatus(tenAppId, bidprojectId, supplierIdSet);
            SaveServiceHelper.save((DynamicObject[])tenders);
        } else {
            this.unAuditUpdateOnlineBidStatus(tenderIds, tenAppId, supplierIdSet, tenders);
        }
    }

    public void unAuditUpdateOnlineBidStatus(Set<Object> tenderIds, String tenAppId, Set<Long> supplierIdSet, DynamicObject[] tenders) {
        DynamicObject[] onlineBids = BusinessDataServiceHelper.load((String)(tenAppId + "_online_bid"), (String)"rounds,billstatus,biddate,mytender,\nnode,backbidtype", (QFilter[])new QFilter[]{new QFilter("mytender", "in", tenderIds), new QFilter("billstatus", "=", (Object)INVALIDSTATUS), new QFilter("supplier", "in", supplierIdSet)}, (String)"rounds");
        if (onlineBids == null || onlineBids.length == 0) {
            return;
        }
        DeleteServiceHelper.delete((String)(tenAppId + "_online_bid"), (QFilter[])new QFilter[]{new QFilter("mytender", "in", tenderIds), new QFilter("billstatus", "!=", (Object)INVALIDSTATUS), new QFilter("supplier", "in", supplierIdSet)});
        Map<Object, DynamicObject> onlineBidMapByTenderId = this.getOnlineBidMapByTenderId(onlineBids);
        if (onlineBidMapByTenderId == null || onlineBidMapByTenderId.size() == 0) {
            return;
        }
        Set<Object> tenderIdSet = onlineBidMapByTenderId.keySet();
        ArrayList<DynamicObject> onlineBidValue = new ArrayList<DynamicObject>(16);
        for (Map.Entry<Object, DynamicObject> item : onlineBidMapByTenderId.entrySet()) {
            DynamicObject value = item.getValue();
            if (value == null) continue;
            value.set("billstatus", (Object)"B");
            onlineBidValue.add(value);
        }
        for (DynamicObject tender : tenders) {
            Object tenderId = tender.getPkValue();
            if (!tenderIdSet.contains(tenderId)) continue;
            DynamicObject onlineTen = onlineBidMapByTenderId.get(tenderId);
            tender.set("biddingdate", onlineTen == null ? null : onlineTen.get("biddate"));
            tender.set("node", onlineTen == null ? null : onlineTen.get("node"));
            tender.set("backbidtype", onlineTen == null ? null : onlineTen.get("backbidtype"));
        }
        SaveServiceHelper.save((DynamicObject[])tenders);
        SaveServiceHelper.save((DynamicObject[])onlineBidValue.toArray(new DynamicObject[0]));
    }

    public Map<Object, DynamicObject> getOnlineBidMapByTenderId(DynamicObject[] onlineBids) {
        HashMap<Object, DynamicObject> onlineBidMap = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject onlineBid : onlineBids) {
            int oldRounds;
            DynamicObject mytender = onlineBid.getDynamicObject("mytender");
            if (mytender == null) continue;
            Object mytenderId = mytender.getPkValue();
            DynamicObject oldOnlineBid = (DynamicObject)onlineBidMap.get(mytenderId);
            if (oldOnlineBid == null) {
                onlineBidMap.put(mytenderId, onlineBid);
                continue;
            }
            int rounds = onlineBid.getInt("rounds");
            if (rounds <= (oldRounds = oldOnlineBid.getInt("rounds"))) continue;
            onlineBidMap.put(mytenderId, onlineBid);
        }
        return onlineBidMap;
    }

    protected Map<String, String> getOldSupplierTenStatusMap(DynamicObject bidOpen, Set<String> curNeedReBackSupplierSet) {
        HashMap<String, String> oldSupplierTenStatusMap = new HashMap<String, String>(16);
        DynamicObjectCollection bidSection = bidOpen.getDynamicObjectCollection("bidsection");
        bidSection.forEach(section -> {
            String sectionName = section.getString("sectionname");
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(entry -> {
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier == null) {
                    return;
                }
                Object supplierId = supplier.getPkValue();
                if (curNeedReBackSupplierSet.contains(sectionName + SPLIT + supplierId)) {
                    boolean supIdTender = entry.getBoolean("supplier_istender");
                    oldSupplierTenStatusMap.put(sectionName + SPLIT + supplierId, supIdTender ? "TENDERED" : "PRETENDERED");
                }
            });
        });
        return oldSupplierTenStatusMap;
    }

    protected void updateOnlineBidStatus(String tenAppId, Object bidprojectId, Set<Long> supplierIdSet) {
        DynamicObject[] onlineBid = BusinessDataServiceHelper.load((String)(tenAppId + "_online_bid"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidprojectId), new QFilter("billstatus", "!=", (Object)INVALIDSTATUS), new QFilter("supplier", "in", supplierIdSet)});
        if (onlineBid == null || onlineBid.length == 0) {
            return;
        }
        Arrays.stream(onlineBid).forEach(item -> item.set("billstatus", (Object)INVALIDSTATUS));
        SaveServiceHelper.save((DynamicObject[])onlineBid);
    }

    protected String getTenAppId() {
        String appId = this.getAppId();
        if ("bid".equals(appId)) {
            return "ten";
        }
        return "resp";
    }

    protected void reWriteOpenAndDeadlineDate(Object bidprojectId, DynamicObject dataEntity) {
        DynamicObject bidProject = this.getBidProject(bidprojectId);
        this.updateProjectTimeField(dataEntity, bidProject);
        Boolean answerQuestionFlag = dataEntity.getBoolean("answerquestionflag");
        if (answerQuestionFlag.booleanValue()) {
            boolean bidAnswerQuestion = bidProject.getBoolean("bidmode.bidanswerquestion");
            if (bidAnswerQuestion) {
                bidProject.set("currentstep", (Object)",BidAnswerQuestion,");
            }
        } else {
            bidProject.set("currentstep", (Object)",BidOpen,");
        }
        SaveServiceHelper.update((DynamicObject)bidProject);
    }

    protected void reWriteAnswerQuestion(Object bidprojectId, DynamicObject dataEntity) {
        Boolean answerQuestionFlag = dataEntity.getBoolean("answerquestionflag");
        if (answerQuestionFlag.booleanValue()) {
            Date answerQuestionTime = dataEntity.getDate("answerquestiontime");
            DynamicObject answerQuestion = BusinessDataServiceHelper.loadSingle((String)(this.getAppId() + "_answerquestion"), (String)"billstatus,answerquestiondeadline,realanswertime", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidprojectId)});
            if (answerQuestion != null) {
                answerQuestion.set("billstatus", (Object)"Q");
                answerQuestion.set("answerquestiondeadline", (Object)answerQuestionTime);
                answerQuestion.set("realanswertime", null);
                SaveServiceHelper.update((DynamicObject)answerQuestion);
            }
        }
    }

    protected void updateProjectTimeField(DynamicObject dataEntity, DynamicObject bidProject) {
        boolean answerQuestionFlag = dataEntity.getBoolean("answerquestionflag");
        if (answerQuestionFlag) {
            Date answerQuestionTime = dataEntity.getDate("answerquestiontime");
            bidProject.set("answerquestiontime", (Object)answerQuestionTime);
        }
        Object endtime = dataEntity.get("endtime");
        Object opentime = dataEntity.get("openendtime");
        String doctype = bidProject.getString("doctype");
        if ("BUSSINESS".equals(doctype)) {
            bidProject.set("busopenbidtime", opentime);
            bidProject.set("busbackbidtime", endtime);
            return;
        }
        String bidopentype = bidProject.getString("bidopentype");
        String backbidway = bidProject.getString("backbidway");
        String type = dataEntity.getString("type");
        if ("totaltechnical".equals(backbidway)) {
            if ("UNIONOPEN".equals(bidopentype)) {
                bidProject.set("bidopentime", opentime);
                bidProject.set("techopenbidtime", opentime);
                bidProject.set("busopenbidtime", opentime);
                bidProject.set("bidopendeadline", endtime);
                bidProject.set("techbackbidtime", endtime);
                bidProject.set("busbackbidtime", endtime);
            } else if ("TECHBUSINESS".equals(bidopentype)) {
                if ("TECHNICAL".equals(type)) {
                    bidProject.set("techopenbidtime", opentime);
                    bidProject.set("bidopentime", opentime);
                    bidProject.set("bidopendeadline", endtime);
                    bidProject.set("techbackbidtime", endtime);
                } else if ("BUSSINESS".equals(type)) {
                    bidProject.set("bidopentime", opentime);
                    bidProject.set("busopenbidtime", opentime);
                    bidProject.set("bidopendeadline", endtime);
                    bidProject.set("busbackbidtime", endtime);
                }
            }
        } else if ("firsttechnical".equals(backbidway)) {
            if ("TECHNICAL".equals(type)) {
                bidProject.set("techopenbidtime", opentime);
                bidProject.set("techbackbidtime", endtime);
            } else if ("BUSSINESS".equals(type)) {
                bidProject.set("busopenbidtime", opentime);
                bidProject.set("busbackbidtime", endtime);
            }
        }
    }

    protected void invalidDownProcessBills(DynamicObject dataEntity, long sourceId, Object bidprojectId) {
        DynamicObject[] onlineEvals;
        DynamicObject bidOpen = this.getBidOpen(sourceId);
        bidOpen.set("billstatus", (Object)INVALIDSTATUS);
        bidOpen.set("sourcebillstatus", (Object)"O");
        SaveServiceHelper.update((DynamicObject)bidOpen);
        DynamicObject[] evaluations = this.getEvaluation(dataEntity);
        if (evaluations != null && evaluations.length > 0) {
            for (DynamicObject evaluation : evaluations) {
                evaluation.set("billstatus", (Object)INVALIDSTATUS);
            }
            SaveServiceHelper.save((DynamicObject[])evaluations);
        }
        if ((onlineEvals = this.getOnlineEval(dataEntity)) != null && onlineEvals.length > 0) {
            for (DynamicObject onlineEval : onlineEvals) {
                onlineEval.set("billstatus", (Object)INVALIDSTATUS);
            }
            SaveServiceHelper.save((DynamicObject[])onlineEvals);
        }
    }

    protected void reWriteBidprojectName(Object bidprojectId, DynamicObject dataEntity, DynamicObject bidopen) {
        DynamicObject[] onlinebidevals;
        boolean isonlineeval;
        String bidProjectName = bidopen.getString("bidproject.name");
        if (bidProjectName != null && !bidProjectName.isEmpty()) {
            bidopen.set("bidprojectname", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u91cd\u65b0\u56de\u6807\u4e2d\uff09", (String)"BidReBackBidOperationPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]), bidProjectName));
        } else {
            String name = bidopen.getDynamicObject("bidproject").getString("name");
            bidopen.set("bidprojectname", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u91cd\u65b0\u56de\u6807\u4e2d\uff09", (String)"BidReBackBidOperationPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]), name));
        }
        bidopen.set("rebacktype", dataEntity.get("type"));
        bidopen.set("rebackid", (Object)dataEntity.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidopen});
        DynamicObject[] bidevaluations = this.getEvaluation(dataEntity);
        if (bidevaluations != null && bidevaluations.length > 0) {
            for (DynamicObject bidevaluation : bidevaluations) {
                String evalProjectName = bidevaluation.getString("bidproject.name");
                if (evalProjectName != null && !evalProjectName.isEmpty()) {
                    bidevaluation.set("bidprojectname", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u91cd\u65b0\u56de\u6807\u4e2d\uff09", (String)"BidReBackBidOperationPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]), evalProjectName));
                    continue;
                }
                String name = bidevaluation.getDynamicObject("bidproject").getString("name");
                bidevaluation.set("bidprojectname", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u91cd\u65b0\u56de\u6807\u4e2d\uff09", (String)"BidReBackBidOperationPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]), name));
            }
            SaveServiceHelper.save((DynamicObject[])bidevaluations);
        }
        if ((isonlineeval = bidopen.getBoolean("isonlineeval")) && (onlinebidevals = this.getOnlineEval(dataEntity)) != null && onlinebidevals.length > 0) {
            for (DynamicObject onlinebideval : onlinebidevals) {
                String evalProjectName = onlinebideval.getString("bidproject.name");
                if (evalProjectName != null && !evalProjectName.isEmpty()) {
                    onlinebideval.set("bidprojectname", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u91cd\u65b0\u56de\u6807\u4e2d\uff09", (String)"BidReBackBidOperationPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]), evalProjectName));
                    continue;
                }
                String name = onlinebideval.getDynamicObject("bidproject").getString("name");
                onlinebideval.set("bidprojectname", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u91cd\u65b0\u56de\u6807\u4e2d\uff09", (String)"BidReBackBidOperationPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]), name));
            }
            SaveServiceHelper.save((DynamicObject[])onlinebidevals);
        }
    }

    protected String getAppId() {
        return ((Object)((Object)this)).getClass().getName().split("\\.")[2];
    }

    protected Map<Long, String> getIdAndBillstatusMap(DynamicObject dataEntity, String field) {
        String[] infos;
        HashMap<Long, String> idAndBillStatusMap = new HashMap<Long, String>(16);
        String value = dataEntity.getString(field);
        if (value == null || value.isEmpty()) {
            return idAndBillStatusMap;
        }
        for (String info : infos = value.split("###")) {
            String[] val = info.split(SPLIT);
            if (val.length <= 1) continue;
            idAndBillStatusMap.put(Long.valueOf(val[0]), val[1]);
        }
        return idAndBillStatusMap;
    }

    protected DynamicObject getBidOpen(Object sourceId) {
        return BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)this.BIDOPEN);
    }

    protected DynamicObject[] getEvaluation(DynamicObject dataEntity) {
        Set<Long> evaluationIds = this.getEvaluationIds(dataEntity, "evaltioninfo");
        boolean exists = QueryServiceHelper.exists((String)this.BIDEVALUATION, (QFilter[])new QFilter[]{new QFilter("id", "in", evaluationIds)});
        if (!exists) {
            DynamicObject open = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getLong("sourceid"), (String)this.BIDOPEN, (String)"opentype");
            DynamicObjectCollection evaluations = QueryServiceHelper.query((String)this.BIDEVALUATION, (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", dataEntity.getDynamicObject("bidproject").getPkValue()), new QFilter("evaltype", "=", (Object)open.getString("opentype")), new QFilter("billstatus", "not in", (Object)new String[]{"X", INVALIDSTATUS})});
            evaluationIds = evaluations.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        return BusinessDataServiceHelper.load((String)this.BIDEVALUATION, (String)String.join((CharSequence)",", "bidprojectname", "bidproject", "billstatus"), (QFilter[])new QFilter[]{new QFilter("id", "in", evaluationIds)});
    }

    protected Set<Long> getEvaluationIds(DynamicObject dataEntity, String field) {
        HashSet<Long> evaltionIds = new HashSet<Long>(16);
        String evalInfo = dataEntity.getString(field);
        if (evalInfo == null || evalInfo.isEmpty()) {
            return evaltionIds;
        }
        String[] idAndStatus = evalInfo.split("###");
        if (idAndStatus.length == 0) {
            return evaltionIds;
        }
        for (String item : idAndStatus) {
            String[] ids = item.split(SPLIT);
            if (ids.length == 0) continue;
            evaltionIds.add(Long.parseLong(ids[0]));
        }
        return evaltionIds;
    }

    protected DynamicObject[] getOnlineEval(DynamicObject dataEntity) {
        Set<Long> evaluationIds = this.getEvaluationIds(dataEntity, "onlineevalinfo");
        boolean exists = QueryServiceHelper.exists((String)this.ONLINEBIDEVAL, (QFilter[])new QFilter[]{new QFilter("id", "in", evaluationIds)});
        if (!exists) {
            DynamicObject open = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getLong("sourceid"), (String)this.BIDOPEN, (String)"opentype");
            DynamicObjectCollection evaluations = QueryServiceHelper.query((String)this.ONLINEBIDEVAL, (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", dataEntity.getDynamicObject("bidproject").getPkValue()), new QFilter("evaltype", "=", (Object)open.getString("opentype")), new QFilter("billstatus", "not in", (Object)new String[]{"X", INVALIDSTATUS})});
            evaluationIds = evaluations.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        return BusinessDataServiceHelper.load((String)this.ONLINEBIDEVAL, (String)String.join((CharSequence)",", "bidprojectname", "bidproject", "billstatus"), (QFilter[])new QFilter[]{new QFilter("id", "in", evaluationIds)});
    }

    protected DynamicObject getBidProject(Object bidProjectId) {
        return BusinessDataServiceHelper.loadSingle((String)this.BIDPROJECT, (String)"backbidway,bidopentype,bidopentime,techopenbidtime,busopenbidtime,bidopendeadline,techbackbidtime,busbackbidtime,currentstep,bidmode,doctype,answerquestiontime,currentstep", (QFilter[])new QFilter[]{new QFilter("id", "=", bidProjectId)});
    }

    protected DynamicObject[] getTender(String tenAppId, Object bidProjectId, Set<Long> supplierIdsSet) {
        return BusinessDataServiceHelper.load((String)(tenAppId + "_mytender"), (String)"node,rounds,listrounds,backbidtype,biddingdate,tenderstatus,supplier,entry,sectionname,sectionstatus,fromrebackflag", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("supplier", "in", supplierIdsSet), new QFilter("tenderstatus", "not in", (Object)new String[]{"FAILURE"})});
    }

    protected DynamicObject[] getOnlineBid(Set<Object> tenderIds, String tenAppId) {
        return BusinessDataServiceHelper.load((String)(tenAppId + "_online_bid"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("mytender", "in", tenderIds), new QFilter("billstatus", "!=", (Object)INVALIDSTATUS)});
    }
}

