/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

class BidReBackBidValidator
extends AbstractValidator {
    private final String appId;

    public BidReBackBidValidator(String appId) {
        this.appId = appId;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey) || "audit".equals(operateKey)) {
            this.saveOperateValidator(dataEntities);
        } else if ("unaudit".equals(operateKey)) {
            this.unAudtiOperateValidator(dataEntities);
        }
    }

    protected void saveOperateValidator(ExtendedDataEntity[] dataEntities) {
        Arrays.asList(dataEntities).forEach(data -> {
            DynamicObject dataEntity = data.getDataEntity();
            String billno = dataEntity.getString("billno");
            Object bidProjectId = dataEntity.getDynamicObject("bidproject").getPkValue();
            boolean exists = QueryServiceHelper.exists((String)(this.appId + "_rebackbid"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("billno", "=", (Object)billno), new QFilter("id", "!=", (Object)dataEntity.getLong("id"))});
            if (exists) {
                this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u5df2\u5b58\u5728\u3002", (String)"BidReBackBidOperationPlugin_4", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                return;
            }
            Date endTime = dataEntity.getDate("endtime");
            if (endTime != null && endTime.before(new Date())) {
                this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u56de\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"BidReBackBidOperationPlugin_5", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection bisection = dataEntity.getDynamicObjectCollection("bidsection");
            boolean flag = false;
            block0: for (DynamicObject section : bisection) {
                DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
                for (DynamicObject entry : supplierEntry) {
                    flag = entry.getBoolean("rebackbidflag");
                    if (!flag) continue;
                    break block0;
                }
            }
            if (!flag) {
                this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9700\u8981\u91cd\u65b0\u56de\u6807\u7684\u4f9b\u5e94\u5546\u3002", (String)"BidReBackBidOperationPlugin_6", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                return;
            }
            Boolean answerQuestionFlag = dataEntity.getBoolean("answerquestionflag");
            Date answerQuestionTime = dataEntity.getDate("answerquestiontime");
            if (answerQuestionFlag.booleanValue() && answerQuestionTime != null) {
                if (answerQuestionTime.before(new Date())) {
                    this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u7b54\u7591\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"BidReBackBidOperationPlugin_7", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (endTime != null && answerQuestionTime.after(endTime)) {
                    this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u7b54\u7591\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u6295\u6807\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidReBackBidOperationPlugin_8", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        });
    }

    protected void unAudtiOperateValidator(ExtendedDataEntity[] dataEntities) {
        Arrays.asList(dataEntities).forEach(data -> {
            String billstatus;
            DynamicObject bidopen;
            DynamicObject dataEntity = data.getDataEntity();
            long createBidOpenId = this.getCreateOpenId(dataEntity);
            Set<String> needReBackBidSupplierSet = this.getNeedReBackBidSupplierSet(dataEntity);
            Map<String, Boolean> needReBackBidSupplierTenMap = this.isNeedReBackBidSupplierTen(dataEntity, needReBackBidSupplierSet, createBidOpenId);
            if (needReBackBidSupplierTenMap != null && !needReBackBidSupplierTenMap.isEmpty()) {
                Boolean alreadyTen = needReBackBidSupplierTenMap.get("alreadyTen");
                Boolean activeUnTen = needReBackBidSupplierTenMap.get("activeUnTen");
                if (alreadyTen != null && alreadyTen.booleanValue()) {
                    this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u5df2\u6709\u4f9b\u5e94\u5546\u91cd\u65b0\u56de\u6807\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidReBackBidOperationPlugin_9", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (activeUnTen != null && activeUnTen.booleanValue()) {
                    this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u5df2\u6709\u4f9b\u5e94\u5546\u4e3b\u52a8\u5f03\u6807\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidReBackBidOperationPlugin_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
            Object bidProjectId = dataEntity.getDynamicObject("bidproject").getPkValue();
            ReBackBidUtil reBackBidUtil = new ReBackBidUtil(this.getAppId());
            List invitationFilters = reBackBidUtil.getFiltesByBillName(reBackBidUtil.getCommonFilters(bidProjectId), "_supplierinvitation");
            boolean isInviInProcess = reBackBidUtil.getBillstatus(reBackBidUtil.getBillName("_supplierinvitation"), invitationFilters);
            List publishFilters = reBackBidUtil.getFiltesByBillName(reBackBidUtil.getCommonFilters(bidProjectId), "_bidpublish");
            boolean ispublishInProcess = reBackBidUtil.getBillstatus(reBackBidUtil.getBillName("_bidpublish"), publishFilters);
            if (isInviInProcess || ispublishInProcess) {
                this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u505a\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidReBackBidOperationPlugin_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                return;
            }
            if (createBidOpenId != 0L && (bidopen = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)createBidOpenId)})) != null && !"D".equals(billstatus = bidopen.getString("billstatus"))) {
                this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u505a\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"BidReBackBidOperationPlugin_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                return;
            }
        });
    }

    protected long getCreateOpenId(DynamicObject dataEntity) {
        long createOpenId = 0L;
        DynamicObject reBackBid = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"rebackbid", ((Object)((Object)this)).getClass()), (String)"createopenid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataEntity.getLong("id"))});
        if (reBackBid != null) {
            createOpenId = reBackBid.getLong("createopenid");
        }
        return createOpenId;
    }

    protected String getAppId() {
        return this.appId;
    }

    protected Set<String> getNeedReBackBidSupplierSet(DynamicObject dataEntity) {
        HashSet<String> needReBackBidSupplierSet = new HashSet<String>(16);
        DynamicObjectCollection bidSection = dataEntity.getDynamicObjectCollection("bidsection");
        bidSection.forEach(section -> {
            String sectionName = section.getString("sectionname");
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(entry -> {
                boolean rebackFlag;
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier != null && (rebackFlag = entry.getBoolean("rebackbidflag"))) {
                    needReBackBidSupplierSet.add(sectionName + "@@@" + supplier.getPkValue());
                }
            });
        });
        return needReBackBidSupplierSet;
    }

    protected Map<String, Boolean> isNeedReBackBidSupplierTen(DynamicObject dataEntity, Set<String> needReBackBidSupplierSet, long bidOpenId) {
        if (bidOpenId == 0L) {
            return null;
        }
        DynamicObject bidopen = BusinessDataServiceHelper.loadSingle((String)(this.appId + "_bidopen"), (String)String.join((CharSequence)",", "bidsection", "sectionname", "supplierentry", "supplier", "supplier_istender", "supplier_istender", "billstatus", "untendertype"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidOpenId)});
        if (bidopen == null) {
            return null;
        }
        String billstatus = bidopen.getString("billstatus");
        if ("XX".equals(billstatus)) {
            return null;
        }
        HashMap<String, Boolean> isNeedReBackBidSupplierTenMap = new HashMap<String, Boolean>(16);
        DynamicObjectCollection bidsection = bidopen.getDynamicObjectCollection("bidsection");
        bidsection.forEach(section -> {
            String sectionName = section.getString("sectionname");
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            supplierEntry.forEach(entry -> {
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier == null) {
                    return;
                }
                Object supplierId = supplier.getPkValue();
                if (needReBackBidSupplierSet.contains(sectionName + "@@@" + supplierId)) {
                    boolean isTen = entry.getBoolean("supplier_istender");
                    String untendertype = entry.getString("untendertype");
                    if (isTen) {
                        isNeedReBackBidSupplierTenMap.put("alreadyTen", true);
                    }
                    if ("0".equals(untendertype)) {
                        isNeedReBackBidSupplierTenMap.put("activeUnTen", true);
                    }
                }
            });
        });
        return isNeedReBackBidSupplierTenMap;
    }
}

