/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class BidSupplierInvalSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bidsection");
        fieldKeys.add("supplierentry");
        fieldKeys.add("bidproject");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4SaleCheck());
    }

    private static class Validator4SaleCheck
    extends AbstractValidator {
        private Validator4SaleCheck() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject dataEntity = dataEntities[i].getDataEntity();
                DynamicObjectCollection sectionEntry = dataEntity.getDynamicObjectCollection("bidsection");
                int supplierCount = 0;
                for (int j = 0; j < sectionEntry.size(); ++j) {
                    DynamicObjectCollection suppilerEntry = ((DynamicObject)sectionEntry.get(j)).getDynamicObjectCollection("supplierentry");
                    supplierCount += suppilerEntry.size();
                }
                if (supplierCount == 0) {
                    this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9700\u8981\u6dd8\u6c70\u7684\u4f9b\u5e94\u5546\u3002", (String)"BidSupplierInvalSaveOp_0", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject bidproject = dataEntity.getDynamicObject("bidproject");
                String appid = ((Object)((Object)this)).getClass().getName().split("\\.")[2];
                boolean flag = new ReBackBidUtil(appid).checkBackBidFinished(bidproject.getPkValue());
                if (!flag) continue;
                this.addErrorMessage(dataEntities[i], ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u6570\u636e\uff0c\u8bf7\u5904\u7406\u540e\u518d\u8fdb\u884c\u4f9b\u5e94\u5546\u6dd8\u6c70\u3002", (String)"BidSupplierInvalSaveOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }
}

