/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IMyTenderService;
import kd.scm.bid.business.bill.serviceImpl.MyTenderServiceImpl;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SupplierHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class NegotiateInviteOp
extends AbstractOperationServicePlugIn {
    protected IMyTenderService myTenderService = new MyTenderServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bustalkid");
        fieldKeys.add("name");
        fieldKeys.add("org");
        fieldKeys.add("bidproject");
        fieldKeys.add("offerstoptime");
        fieldKeys.add("creator");
        fieldKeys.add("publishstatus");
        fieldKeys.add("publishdate");
        fieldKeys.add("publicman");
        fieldKeys.add("modifytime");
        fieldKeys.add("modifier");
        fieldKeys.add("status");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject dataEntity;
        int i;
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("publish".equals(key)) {
            for (i = 0; i < dataEntities.length; ++i) {
                dataEntity = dataEntities[i];
                DynamicObject bustalkid = dataEntity.getDynamicObject("bustalkid");
                if (bustalkid == null) continue;
                DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)bustalkid.getPkValue(), (String)(this.getAppId() + "_bustalk"));
                Map<String, DynamicObject> supplierQC = this.getSupplierQC(bustalk);
                Set entries = supplierQC.entrySet();
                for (Map.Entry entry : entries) {
                    String supplierId = (String)entry.getKey();
                    this.createOnlieBustalkData(dataEntity, bustalk, supplierId);
                }
                dataEntity.set("publishstatus", (Object)"1");
                dataEntity.set("publishdate", (Object)new Date());
                dataEntity.set("publicman", (Object)RequestContext.get().getUserId());
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dataEntity});
            }
        }
        if ("unpublish".equals(key)) {
            for (i = 0; i < dataEntities.length; ++i) {
                DynamicObject[] bustalkIpOpData;
                dataEntity = dataEntities[i];
                DynamicObject[] onlieBustalk = this.getOnlieBustalk(dataEntity.getPkValue());
                ArrayList<Object> ids = new ArrayList<Object>(16);
                for (DynamicObject dynamicObject : onlieBustalk) {
                    ids.add(dynamicObject.getPkValue());
                }
                if (ids.size() > 0) {
                    DeleteServiceHelper.delete((String)(this.getTenAppId() + "_onlie_bustalk"), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                }
                ids.clear();
                DynamicObject bustalkF7 = dataEntity.getDynamicObject("bustalkid");
                DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)bustalkF7.getPkValue(), (String)(this.getAppId() + "_bustalk"));
                for (DynamicObject bustalkIpOpDatum : bustalkIpOpData = this.getBustalkIpOpData(bustalk)) {
                    ids.add(bustalkIpOpDatum.getPkValue());
                }
                if (ids.size() > 0) {
                    DeleteServiceHelper.delete((String)(this.getAppId() + "_bustalk_operationip"), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                }
                dataEntity.set("publishstatus", (Object)"0");
                dataEntity.set("modifytime", (Object)new Date());
                dataEntity.set("modifier", (Object)RequestContext.get().getUserId());
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dataEntity});
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"unaudit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)key, (CharSequence)"submitandaudit")) {
            for (int i = 0; i < dataEntities.length; ++i) {
                if (StringUtils.equals((CharSequence)key, (CharSequence)"audit")) {
                    dataEntities[i].set("publishstatus", (Object)"0");
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
                    dataEntities[i].set("publishstatus", (Object)"");
                    dataEntities[i].set("status", (Object)"A");
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"submitandaudit")) {
                    dataEntities[i].set("publishstatus", (Object)"0");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntities[i]});
            }
        }
    }

    private DynamicObject[] getBustalkIpOpData(DynamicObject bustalk) {
        Map<String, DynamicObject> supplierQC = this.getSupplierQC(bustalk);
        ArrayList<Long> supplierIds = new ArrayList<Long>(20);
        Set<Map.Entry<String, DynamicObject>> entries = supplierQC.entrySet();
        for (Map.Entry<String, DynamicObject> entry : entries) {
            supplierIds.add(Long.valueOf(entry.getKey()));
        }
        QFilter filter = new QFilter("bustalkid.id", "=", (Object)Long.valueOf(bustalk.getPkValue().toString()));
        QFilter filter2 = new QFilter("supplier.id", "in", supplierIds);
        return BusinessDataServiceHelper.load((String)(this.getAppId() + "_bustalk_operationip"), (String)"id", (QFilter[])new QFilter[]{filter, filter2});
    }

    public DynamicObject[] getOnlieBustalk(Object negotiateinviteId) {
        QFilter filter = new QFilter("negotiateinvite", "=", negotiateinviteId);
        return BusinessDataServiceHelper.load((String)(this.getTenAppId() + "_onlie_bustalk"), (String)"id,offerstoptime", (QFilter[])new QFilter[]{filter});
    }

    private void createOnlieBustalkData(DynamicObject dataEntity, DynamicObject bustalk, String supplierId) {
        String appid = "ten";
        if ("rebm".equals(this.getAppId())) {
            appid = "resp";
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(appid + "_onlie_bustalk"));
        DynamicObject onlie_bustalk = new DynamicObject((DynamicObjectType)mainType);
        ORM orm = ORM.create();
        long id = orm.genLongId((IDataEntityType)mainType);
        onlie_bustalk.set("id", (Object)id);
        onlie_bustalk.set("creator", dataEntity.get("creator"));
        onlie_bustalk.set("modifytime", (Object)new Date());
        onlie_bustalk.set("createtime", (Object)new Date());
        onlie_bustalk.set("billstatus", (Object)"A");
        onlie_bustalk.set("currency", bustalk.get("currency"));
        onlie_bustalk.set("negotiateinvite", (Object)dataEntity);
        onlie_bustalk.set("bustalktheme", (Object)dataEntity.getString("name"));
        onlie_bustalk.set("org", (Object)dataEntity.getDynamicObject("org"));
        onlie_bustalk.set("bidproject", (Object)dataEntity.getDynamicObject("bidproject"));
        onlie_bustalk.set("offerstoptime", (Object)dataEntity.getDate("offerstoptime"));
        DynamicObjectCollection entrys = onlie_bustalk.getDynamicObjectCollection("entry");
        DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
        DynamicObject bidProject = bustalk.getDynamicObject("bidproject");
        for (DynamicObject bidsection : bidsections) {
            DynamicObjectCollection querySupplierEntity = bidsection.getDynamicObjectCollection("supplierentry");
            DynamicObjectCollection supplierdetail = bidsection.getDynamicObjectCollection("supplierdetail");
            Iterator supplierIter = querySupplierEntity.iterator();
            Iterator supplierdetailIter = supplierdetail.iterator();
            int seq = 1;
            while (supplierIter.hasNext()) {
                DynamicObject supplierentity = (DynamicObject)supplierIter.next();
                DynamicObject supplier = supplierentity.getDynamicObject("supplier");
                if (supplier == null || !StringUtils.equals((CharSequence)supplierId, (CharSequence)supplier.getPkValue().toString())) continue;
                onlie_bustalk.set("supplier", (Object)supplier);
                DynamicObject entry = entrys.addNew();
                entry.set("seq", (Object)seq++);
                entry.set("sectionid", bidsection.getPkValue());
                entry.set("sectionname", (Object)bidsection.getString("sectionname"));
                DynamicObjectCollection onSupplierDetails = entry.getDynamicObjectCollection("supplierdetail");
                int index = 1;
                while (supplierdetailIter.hasNext()) {
                    DynamicObject supplierdetailentity = (DynamicObject)supplierdetailIter.next();
                    DynamicObject pursupplier = supplierdetailentity.getDynamicObject("pursupplier");
                    if (pursupplier == null || !StringUtils.equals((CharSequence)supplierId, (CharSequence)pursupplier.getPkValue().toString())) continue;
                    DynamicObject onSupplierDetail = onSupplierDetails.addNew();
                    onSupplierDetail.set("seq", (Object)index++);
                    onSupplierDetail.set("purentrycontent", (Object)supplierdetailentity.getString("purentrycontent"));
                    onSupplierDetail.set("purentryproject", (Object)supplierdetailentity.getDynamicObject("purentryproject"));
                    if (this.getAppId().equals("rebm")) {
                        onSupplierDetail.set("resourceitem", (Object)supplierdetailentity.getDynamicObject("resourceitem"));
                    }
                    onSupplierDetail.set("materialid", (Object)supplierdetailentity.getDynamicObject("materialid"));
                    onSupplierDetail.set("baseunit", (Object)supplierdetailentity.getDynamicObject("baseunit"));
                    onSupplierDetail.set("materialdes", (Object)supplierdetailentity.getString("materialdes"));
                    onSupplierDetail.set("qty", supplierdetailentity.get("qty"));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{onlie_bustalk});
        this.sendMessage(dataEntity, bidProject, Long.valueOf(supplierId), this.getAppId());
    }

    public void sendMessage(DynamicObject dataEntity, DynamicObject bidProject, Long supplierId, String appId) {
        Long adminUserId;
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            return;
        }
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        if ("rebm".equals(appId)) {
            msgParam.put("formId", "resp_mytender");
        } else {
            msgParam.put("formId", "ten_mytender");
        }
        msgParam.put("appId", appId);
        msgParam.put("msgentity", "bid_negotiate_invite");
        msgParam.put("tplScene", "publishnegotiate");
        msgParam.put("operation", "publish");
        msgParam.put("title", null);
        msgParam.put("content", null);
        DynamicObject myTender = this.myTenderService.getMyTenderByBidProjectAndSupplier((Long)bidProject.getPkValue(), supplierId);
        long tenderPk = myTender == null ? 0L : (Long)myTender.getPkValue();
        msgParam.put("pkId", tenderPk);
        msgParam.put("id", dataEntity.getPkValue());
        msgParam.put("targetButtonId", "button_negotiate_info");
        msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "targetButtonId"));
        HashSet<Long> receiveUserIds = new HashSet<Long>();
        if ("rebm".equals(appId)) {
            adminUserId = SupplierHelper.listAdminUserIdByResmSupplier((Long)supplierId);
            receiveUserIds.add(adminUserId);
        } else {
            adminUserId = SupplierHelper.listAdminUserIdBySupplier((Long)supplierId);
            receiveUserIds.add(adminUserId);
        }
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidpublish"), (String)"bidsection,sectionname,supplier,projectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)"P")});
        DynamicObjectCollection bidSection = bidPublish.getDynamicObjectCollection("bidsection");
        for (DynamicObject sectionEntry : bidSection) {
            DynamicObjectCollection supplierentry = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject entry : supplierentry) {
                DynamicObject projectPartner;
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (!supplierId.equals(supplier.getLong("id")) || (projectPartner = entry.getDynamicObject("projectpartner")) == null) continue;
                receiveUserIds.add((Long)projectPartner.getPkValue());
            }
        }
        String notifyType = MessageChannelUtil.getNotifyType((String)"publishnegotiate", (String)"bid_negotiate_invite");
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, new ArrayList(receiveUserIds), (String)notifyType);
    }

    private Map<String, DynamicObject> getSupplierQC(DynamicObject bustalk) {
        HashMap<String, DynamicObject> supplierMap = new HashMap<String, DynamicObject>();
        if (bustalk != null) {
            DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidsection : bidsections) {
                DynamicObjectCollection querySupplierEntity = bidsection.getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection supplierdetail = bidsection.getDynamicObjectCollection("supplierdetail");
                Iterator supplierIter = querySupplierEntity.iterator();
                Iterator supplierdetailIter = supplierdetail.iterator();
                while (supplierIter.hasNext()) {
                    DynamicObject supplierentity = (DynamicObject)supplierIter.next();
                    DynamicObject supplier = supplierentity.getDynamicObject("supplier");
                    if (supplier == null || supplierMap.containsKey(supplier.getPkValue().toString())) continue;
                    supplierMap.put(supplier.getPkValue().toString(), supplier);
                }
            }
        }
        return supplierMap;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ValidatorForBidPublish());
    }

    public String getAppId() {
        String appName = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
        return appName;
    }

    private String getTenAppId() {
        return this.getAppId().equals("bid") ? "ten" : "resp";
    }

    private static class ValidatorForBidPublish
    extends AbstractValidator {
        private ValidatorForBidPublish() {
        }

        public void validate() {
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"publish")) {
                Date nowDate = new Date();
                ExtendedDataEntity[] extendedDataEntityArray = dataEntities;
                int n = extendedDataEntityArray.length;
                for (int i = 0; i < n; ++i) {
                    int compareTo;
                    ExtendedDataEntity de = extendedDataEntityArray[i];
                    String billsatus = (String)de.getValue("status");
                    String publishstatus = (String)de.getValue("publishstatus");
                    if (!"C".equals(billsatus) || !"0".equals(publishstatus)) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u4e14\u672a\u53d1\u5e03\u7684\u6570\u636e\u8fdb\u884c\u53d1\u5e03\u3002", (String)"NegotiateInviteOp_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    Date offerstoptime = (Date)de.getValue("offerstoptime");
                    if (offerstoptime == null || (compareTo = nowDate.compareTo(offerstoptime)) < 0) continue;
                    this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u5230\u8fbe\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u3002", (String)"NegotiateInviteOp_2", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"unpublish")) {
                for (ExtendedDataEntity de : dataEntities) {
                    String billsatus = (String)de.getValue("status");
                    String publishstatus = (String)de.getValue("publishstatus");
                    if (!"C".equals(billsatus) || !"1".equals(publishstatus)) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u4e14\u5df2\u53d1\u5e03\u7684\u6570\u636e\u8fdb\u884c\u64a4\u9500\u53d1\u5e03\u3002", (String)"NegotiateInviteOp_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject bustalkid = (DynamicObject)de.getValue("bustalkid");
                    if (bustalkid != null) {
                        boolean isoffer = false;
                        DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)bustalkid.getPkValue(), (String)"bid_bustalk");
                        DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
                        block2: for (DynamicObject bidsection : bidsections) {
                            DynamicObjectCollection querySupplierEntity = bidsection.getDynamicObjectCollection("supplierentry");
                            for (DynamicObject entity : querySupplierEntity) {
                                isoffer = entity.getBoolean("isoffer");
                                if (!isoffer) continue;
                                break block2;
                            }
                        }
                        if (!isoffer) continue;
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u5df2\u6709\u4f9b\u5e94\u5546\u63d0\u4ea4\u8c08\u5224\u62a5\u4ef7\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u64a4\u9500\u53d1\u5e03\u3002", (String)"NegotiateInviteOp_5", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.addErrorMessage(de, ResManager.loadKDString((String)"\u5173\u8054\u7684\u5546\u52a1\u8c08\u5224\u6570\u636e\u5f02\u5e38\u3002", (String)"NegotiateInviteOp_4", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }
}

