/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.ClarifyReplyStatusEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.util.BidMessageUtil;

public class QuestionClarifyOP
extends AbstractOperationServicePlugIn {
    protected IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    private static final String KEY_ADJUSTDEADLINE = "tbl_adjustdeadline";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("clarifysupplier");
        e.getFieldKeys().add("bidsection");
        e.getFieldKeys().add("supplierdetail");
        e.getFieldKeys().add("clarifydeadline");
        e.getFieldKeys().add("clarifytheme");
        e.getFieldKeys().add("rate");
        e.getFieldKeys().add("opentype");
        e.getFieldKeys().add("workday");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("resubmisstenders");
        e.getFieldKeys().add("clarifytype");
        e.getFieldKeys().add("multiquestclarifyid");
        e.getFieldKeys().add("is_again_bidding");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ValidatorQuestionClarify());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block8: {
            String supplierName;
            DynamicObject data;
            String key;
            block7: {
                super.beginOperationTransaction(e);
                key = e.getOperationKey();
                DynamicObject[] datas = e.getDataEntities();
                data = datas[0];
                String clarifysupplier = data.getString("clarifysupplier");
                String[] values = clarifysupplier.split("&&");
                supplierName = values[1];
                if (!StringUtils.equals((CharSequence)"send", (CharSequence)key)) break block7;
                this.addBidSectionSupplierDetail(data);
                Date now = new Date();
                data.set("senddate", (Object)now);
                data.set("supplier", (Object)supplierName);
                data.set("is_again_bidding", (Object)"0");
                BigDecimal pricevat = data.getBigDecimal("pricevat");
                BigDecimal rate = data.getBigDecimal("rate");
                data.set("pricevat", (Object)pricevat.divide(new BigDecimal("100")));
                data.set("rate", (Object)rate.divide(new BigDecimal("100")));
                DynamicObjectCollection bidSectionColl = data.getDynamicObjectCollection("bidsection");
                if (bidSectionColl == null || bidSectionColl.size() <= 0) break block8;
                for (int i = 0; i < bidSectionColl.size(); ++i) {
                    DynamicObjectCollection supplierdetail = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                    if (supplierdetail == null || supplierdetail.size() <= 0) continue;
                    for (int j = 0; j < supplierdetail.size(); ++j) {
                        ((DynamicObject)supplierdetail.get(j)).set("taxrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                        ((DynamicObject)supplierdetail.get(j)).set("costrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("costrate").divide(new BigDecimal("100")));
                    }
                }
                break block8;
            }
            if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                String billstatus = data.getString("billstatus");
                data.set("supplier", (Object)supplierName);
                if (ClarifyStatusEnum.SUBMITTED.getValue().equals(billstatus) || ClarifyStatusEnum.UNSENT.getValue().equals(billstatus)) {
                    data.set("billstatus", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
                    data.set("replystatus", (Object)ClarifyReplyStatusEnum.B.getValue());
                }
                Date now = new Date();
                data.set("submitdate", (Object)now);
                data.set("is_again_bidding", (Object)"0");
                BigDecimal pricevat = data.getBigDecimal("pricevat");
                BigDecimal rate = data.getBigDecimal("rate");
                data.set("pricevat", (Object)pricevat.divide(new BigDecimal("100")));
                data.set("rate", (Object)rate.divide(new BigDecimal("100")));
                DynamicObjectCollection bidSectionColl = data.getDynamicObjectCollection("bidsection");
                if (bidSectionColl != null && bidSectionColl.size() > 0) {
                    for (int i = 0; i < bidSectionColl.size(); ++i) {
                        DynamicObjectCollection supplierdetail = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                        if (supplierdetail == null || supplierdetail.size() <= 0) continue;
                        for (int j = 0; j < supplierdetail.size(); ++j) {
                            ((DynamicObject)supplierdetail.get(j)).set("taxrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                            ((DynamicObject)supplierdetail.get(j)).set("costrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("costrate").divide(new BigDecimal("100")));
                        }
                    }
                }
            }
        }
    }

    private void addBidSectionSupplierDetail(DynamicObject data) {
        DynamicObject bidProject = data.getDynamicObject("bidproject");
        try (TXHandle h = TX.requiresNew();){
            try {
                if ("rebm".equals(this.getAppId())) {
                    BidFileHelper.synFileFromAToB((String)"rebm_questionclarify", (Object)data.getPkValue(), (String)"clarifyattachpanel", (String)"resp_questionclarify", (Object)data.getPkValue(), (String)"clarifyattachpanel");
                } else {
                    BidFileHelper.synFileFromAToB((String)"bid_questionclarify", (Object)data.getPkValue(), (String)"clarifyattachpanel", (String)"ten_questionclarify", (Object)data.getPkValue(), (String)"clarifyattachpanel");
                }
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
        String opentype = data.getString("opentype");
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)opentype);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,bidsection,bidsection.sectionname,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.qty,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate", (QFilter[])new QFilter[]{bidProjectFilter, openTypeFilter, statusFilter});
        String clarifysupplier = data.getString("clarifysupplier");
        String[] values = clarifysupplier.split("&&");
        Long supplierId = Long.parseLong(values[0]);
        String clarifySectionName = "";
        if (values.length == 3) {
            clarifySectionName = values[2];
        }
        Boolean reloadDetail = Boolean.TRUE;
        DynamicObjectCollection clarifybidsections = data.getDynamicObjectCollection("bidsection");
        if (clarifybidsections.size() > 0) {
            DynamicObject supplierdetail;
            long currentSupplierId;
            DynamicObject clarifybidsection = (DynamicObject)clarifybidsections.get(0);
            String currentSection = clarifybidsection.getString("sectionname");
            if ((StringUtils.isEmpty((CharSequence)clarifySectionName) || clarifySectionName.equals(currentSection)) && supplierId.equals(currentSupplierId = ((Long)(supplierdetail = (DynamicObject)clarifybidsection.getDynamicObjectCollection("supplierdetail").get(0)).getDynamicObject("pursupplier").getPkValue()).longValue())) {
                reloadDetail = Boolean.FALSE;
            }
        }
        if (reloadDetail.booleanValue()) {
            data.getDynamicObjectCollection("bidsection").clear();
            DynamicObjectCollection bidsectioncoll = bidOpen.getDynamicObjectCollection("bidsection");
            boolean enablemultisection = bidProject.getBoolean("enablemultisection");
            for (int i = 0; i < bidsectioncoll.size(); ++i) {
                DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
                String sectionName = bidsection.getString("sectionname");
                int k = 1;
                if (enablemultisection && !clarifySectionName.equals(sectionName)) continue;
                DynamicObjectCollection supplierDetail = bidsection.getDynamicObjectCollection("supplierdetail");
                DynamicObject clarifyBidsection = data.getDynamicObjectCollection("bidsection").addNew();
                clarifyBidsection.set("seq", (Object)k++);
                clarifyBidsection.set("sectionname", (Object)sectionName);
                DynamicObjectCollection clarifySupplierDetailColl = clarifyBidsection.getDynamicObjectCollection("supplierdetail");
                int index = 1;
                for (int j = 0; j < supplierDetail.size(); ++j) {
                    DynamicObject supplierentry = (DynamicObject)supplierDetail.get(j);
                    DynamicObject pursupplier = supplierentry.getDynamicObject("pursupplier");
                    if (!supplierId.equals(pursupplier.getPkValue())) continue;
                    DynamicObject newSupplierDetail = clarifySupplierDetailColl.addNew();
                    newSupplierDetail.set("pursupplier", supplierentry.get("pursupplier"));
                    newSupplierDetail.set("seq", (Object)index++);
                    newSupplierDetail.set("purentrycontent", supplierentry.get("purentrycontent"));
                    newSupplierDetail.set("purentryproject", supplierentry.get("purentryproject"));
                    newSupplierDetail.set("materialid", supplierentry.get("materialid"));
                    newSupplierDetail.set("materialdes", supplierentry.get("materialdes"));
                    newSupplierDetail.set("qty", supplierentry.get("qty"));
                }
            }
        }
        this.sendMessage(data, bidProject, supplierId);
    }

    public void sendMessage(DynamicObject data, DynamicObject bidProject, Long supplierId) {
        BidMessageUtil.sendMsgByQuestionClarify((DynamicObject)data, (DynamicObject)bidProject, (Long)supplierId, (String)this.getAppId());
    }

    public String getAppId() {
        String appName = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
        return appName;
    }

    private class ValidatorQuestionClarify
    extends AbstractValidator {
        private ValidatorQuestionClarify() {
        }

        public void validate() {
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (StringUtils.equals((CharSequence)"send", (CharSequence)key) || StringUtils.equals((CharSequence)"tbl_send", (CharSequence)key)) {
                for (ExtendedDataEntity de : dataEntities) {
                    String[] values;
                    Long supplierId;
                    Boolean checkRepeatedSupplier;
                    Date nowDate;
                    int compareTo;
                    String billsatus = (String)de.getValue("billstatus");
                    if (!ClarifyStatusEnum.UNSENT.getValue().equals(billsatus) && !ClarifyStatusEnum.SAVED.getValue().equals(billsatus)) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u53d1\u9001\u72b6\u6001\u7684\u6570\u636e\u624d\u5141\u8bb8\u53d1\u9001\u3002", (String)"QuestionClarifyOP_24", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject bidProject = (DynamicObject)de.getValue("bidproject");
                    Object bidProjectId = bidProject.getPkValue();
                    String openType = (String)de.getValue("opentype");
                    String multiquestclarifyid = de.getValue("multiquestclarifyid").toString();
                    OrmLocaleValue clarifyTheme = (OrmLocaleValue)de.getValue("clarifytheme");
                    Boolean checkRepeatedFlag = QuestionClarifyOP.this.questionClarifyService.checkRepeatedClarifytheme(bidProjectId, openType, clarifyTheme.getLocaleValue(), de.getBillPkId(), multiquestclarifyid);
                    if (checkRepeatedFlag.booleanValue()) {
                        this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u8d28\u7591/\u6f84\u6e05\u4e3b\u9898\uff1a%s\u91cd\u590d\uff0c\u4e0d\u80fd\u53d1\u9001\u3002", (String)"QuestionClarifyOP_1", (String)"scm-bid-opplugin", (Object[])new Object[0]), clarifyTheme));
                        return;
                    }
                    Date clarifydeadline = (Date)de.getValue("clarifydeadline");
                    if (clarifydeadline != null && (compareTo = (nowDate = new Date()).compareTo(clarifydeadline)) >= 0) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u5fc5\u987b\u665a\u4e8e\u670d\u52a1\u5668\u5f53\u524d\u65f6\u95f4\u3002", (String)"QuestionClarifyOP_26", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    String clarifysupplier = (String)de.getValue("clarifysupplier");
                    if (!StringUtils.isNotEmpty((CharSequence)clarifysupplier) || !(checkRepeatedSupplier = QuestionClarifyOP.this.questionClarifyService.checkRepeatedSupplier(bidProjectId, openType, (Object)(supplierId = Long.valueOf(Long.parseLong((values = clarifysupplier.split("&&"))[0]))))).booleanValue()) continue;
                    this.addErrorMessage(de, ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u5f85\u6f84\u6e05\u95ee\u9898\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u65b0\u7684\u6f84\u6e05\u3002", (String)"QuestionClarifyOP_27", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (QuestionClarifyOP.KEY_ADJUSTDEADLINE.equals(key)) {
                if (dataEntities.length > 0) {
                    String clarifysupplier;
                    ExtendedDataEntity questionClarify = dataEntities[0];
                    String billstatus = (String)questionClarify.getValue("billstatus");
                    if (ClarifyStatusEnum.NOCLARIFIED.getValue().equals(billstatus) && StringUtils.isNotEmpty((CharSequence)(clarifysupplier = (String)questionClarify.getValue("clarifysupplier")))) {
                        String openType;
                        String[] values = clarifysupplier.split("&&");
                        Long supplierId = Long.parseLong(values[0]);
                        DynamicObject bidProject = (DynamicObject)questionClarify.getValue("bidproject");
                        Object bidProjectId = bidProject.getPkValue();
                        Boolean checkRepeatedSupplier = QuestionClarifyOP.this.questionClarifyService.checkRepeatedSupplier(bidProjectId, openType = (String)questionClarify.getValue("opentype"), (Object)supplierId);
                        if (checkRepeatedSupplier.booleanValue()) {
                            this.addErrorMessage(questionClarify, ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u5f85\u6f84\u6e05\u95ee\u9898\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u65b0\u7684\u6f84\u6e05\u3002", (String)"QuestionClarifyOP_27", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                }
            } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)key) || StringUtils.equals((CharSequence)"audit", (CharSequence)key)) {
                for (ExtendedDataEntity data : dataEntities) {
                    DynamicObject bidevaluation = BusinessDataServiceHelper.loadSingle((Object)data.getValue("bidevaluationid"), (String)"bid_bidevaluation");
                    DynamicObject bidopen = BusinessDataServiceHelper.loadSingle((Object)bidevaluation.getLong("bidopenid"), (String)"bid_bidopen");
                    if ("X".equals(bidopen.getString("billstatus"))) continue;
                    DynamicObjectCollection supplierentryInfoColl = ((DynamicObject)bidopen.getDynamicObjectCollection("bidsection").get(0)).getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierentryInfo : supplierentryInfoColl) {
                        Object supName;
                        Object clarifysupplier = data.getValue("clarifysupplier");
                        if (!clarifysupplier.equals(supName = supplierentryInfo.get("supplier.name")) || !supplierentryInfo.getBoolean("supplier_isinvalid")) continue;
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s\u5df2\u5728\u5f00\u6807\u51c6\u5907\u65f6\u88ab\u6dd8\u6c70\uff0c\u8bf7\u64a4\u9500\u6d41\u7a0b", (String)"QuestionClarifyOP_28", (String)"scm-bid-opplugin", (Object[])new Object[0]), supName));
                    }
                }
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)key) && dataEntities.length > 0) {
                    Integer workDay;
                    ExtendedDataEntity data = dataEntities[0];
                    Boolean resubmisstenders = (Boolean)data.getValue("resubmisstenders");
                    if (!resubmisstenders.booleanValue()) {
                        return;
                    }
                    String clarifytype = (String)data.getValue("clarifytype");
                    if (BidOpenTypeEnum.TECHNICAL.getValue().equals(clarifytype)) {
                        return;
                    }
                    DynamicObject bidProject = (DynamicObject)data.getValue("bidproject");
                    DynamicObject bidProjectdata = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
                    Boolean ismaterialpur = bidProject.getBoolean("ismaterialpur");
                    int bidtype = bidProjectdata.getInt("bidtype");
                    if (bidtype != 1 && (workDay = (Integer)data.getValue("workday")) != null && workDay < 0) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u5de5\u671f\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"QuestionClarifyOP_29", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
        }
    }
}

