/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill.bidcenter;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bidcenter.IBidCenterService;
import kd.scm.bid.business.bidcenter.impl.BidCenterServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.bidcenter.BidCenterConstant;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;

public class BidCenterOP
extends AbstractOperationServicePlugIn {
    private IBidCenterService bidCenterService = new BidCenterServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidopentype");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("entrustmentorgunit");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ValidatorBidCenter());
    }

    private boolean checkOpPermission(String permisionCode, DynamicObject entity, String formId) {
        String appId = this.billEntityType.getAppId();
        if ("rebm".equals(appId) && !formId.startsWith("rebm")) {
            formId = this.replaceBeforeTip(formId);
        }
        long orgId = (Long)entity.getDynamicObject("org").getPkValue();
        boolean orgHasPermission = PermissionUtils.checkPermission((String)permisionCode, (Long)orgId, (String)appId, (String)formId);
        DynamicObject entrustmentorgunit = entity.getDynamicObject("entrustmentorgunit");
        if (entrustmentorgunit == null) {
            return orgHasPermission;
        }
        Long entrustmentorgunitId = (Long)entrustmentorgunit.getPkValue();
        boolean entrustmentorgHasPermission = PermissionUtils.checkPermission((String)permisionCode, (Long)entrustmentorgunitId, (String)appId, (String)formId);
        return orgHasPermission || entrustmentorgHasPermission;
    }

    private BidStepEnum getCheckStepByOpKey(String opKey) {
        BidStepEnum checkStep = null;
        switch (opKey) {
            case "bidproject": {
                break;
            }
            case "biddocument": {
                checkStep = BidStepEnum.BidDocument;
                break;
            }
            case "supplierinvitation": {
                checkStep = BidStepEnum.SupplierInvitation;
                break;
            }
            case "bidpublish": {
                checkStep = BidStepEnum.BidPublish;
                break;
            }
            case "bidanswerquestion": {
                checkStep = BidStepEnum.BidAnswerQuestion;
                break;
            }
            case "bidopen": {
                checkStep = BidStepEnum.BidOpen;
                break;
            }
            case "bidevaluation": {
                checkStep = BidStepEnum.BidEvaluation;
                break;
            }
            case "bidbustalk": {
                checkStep = BidStepEnum.BidBustalk;
                break;
            }
            case "biddecision": {
                checkStep = BidStepEnum.BidDecision;
                break;
            }
            case "bidclarificaiton": {
                checkStep = BidStepEnum.Clarificaiton;
                break;
            }
            case "bidbottommake": {
                checkStep = BidStepEnum.BidBottomMake;
                break;
            }
        }
        return checkStep;
    }

    public String getBidAdminRoleID() {
        return "/FFXFSRKI73+";
    }

    public String getRespBusinessNo(String formId) {
        switch (formId) {
            case "bid_project": {
                return "01";
            }
            case "bid_supplierinvitation": {
                return "02";
            }
            case "bid_biddocument_edit": {
                return "09";
            }
            case "bid_bidpublish": {
                return "05";
            }
            case "bid_answerquestion": 
            case "bid_answerquestion_reco": {
                return "10";
            }
            case "bid_bidopen": {
                return "06";
            }
            case "bid_bidevaluation": {
                return "07";
            }
            case "bid_decision": {
                return "08";
            }
            case "bid_bustalk": {
                return "15";
            }
            case "bid_clarificaiton": {
                return "18";
            }
            case "bid_bottom_make": {
                return "19";
            }
        }
        return "null";
    }

    public String replaceBeforeTip(String step) {
        String name = null;
        if ("bid_project".equals(step)) {
            name = "rebm_project";
        } else if ("bid_supplierinvitation".equals(step)) {
            name = "rebm_supplierinvitation";
        } else if ("bid_biddocument_edit".equals(step)) {
            name = "rebm_biddocument_edit";
        } else if ("bid_bidpublish".equals(step)) {
            name = "rebm_bidpublish";
        } else if ("bid_answerquestion_reco".equals(step)) {
            name = "rebm_answerquestion_reco";
        } else if ("bid_bidopen".equals(step)) {
            name = "rebm_bidopen";
        } else if ("bid_bidevaluation".equals(step)) {
            name = "rebm_bidevaluation";
        } else if ("bid_bustalk".equals(step)) {
            name = "rebm_bustalk";
        } else if ("bid_decision".equals(step)) {
            name = "rebm_decision";
        } else if ("bid_bidcenter".equals(step)) {
            name = "rebm_bidcenter";
        } else if ("bid_bottom_make".equals(step)) {
            name = "rebm_bottom_make";
        } else if ("bid_clarificaiton".equals(step)) {
            name = "rebm_clarificaiton";
        }
        return name;
    }

    public Map<String, Boolean> getMapOnlineEvalBusinessFlag(DynamicObject permissionMember, String userId, Long bidProjectId, String bidOpenType, Class class1, QFilter bidFilter) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(16);
        Boolean isProficient = Boolean.FALSE;
        Boolean havePermisionAnd = Boolean.FALSE;
        Boolean havePermisionOr = Boolean.FALSE;
        Boolean haveCommCan = Boolean.FALSE;
        Boolean haveTechCan = Boolean.FALSE;
        if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenType)) {
            if (permissionMember == null) {
                String openFormId = FormTypeConstants.getFormConstant((String)"bidopen", (Class)class1);
                String selectpro = "id,billstatus,isonlineeval,bidopen_proficient,bidopen_proficient.proficient";
                QFilter invalidFilter = new QFilter("billstatus", "!=", (Object)"XX");
                DynamicObject openData = BusinessDataServiceHelper.loadSingle((String)openFormId, (String)selectpro, (QFilter[])new QFilter[]{bidFilter, invalidFilter});
                DynamicObjectCollection proficientRecos = openData.getDynamicObjectCollection("bidopen_proficient");
                for (DynamicObject proficientReco : proficientRecos) {
                    String pkValue;
                    DynamicObject proficient = proficientReco.getDynamicObject("proficient");
                    DynamicObject proficientname = proficient.getDynamicObject("proficientname");
                    if (proficientname == null || !StringUtils.equals((CharSequence)(pkValue = proficientname.getPkValue().toString()), (CharSequence)userId)) continue;
                    isProficient = Boolean.TRUE;
                    break;
                }
            }
        } else {
            if (permissionMember != null) {
                boolean isdirector = permissionMember.getBoolean("isdirector");
                if (!isdirector) {
                    String respbusiness = permissionMember.getString("respbusiness");
                    if (respbusiness.contains(RespBusiness.BusinessEval.getVal()) && respbusiness.contains(RespBusiness.TechnicalEval.getVal())) {
                        haveCommCan = true;
                        haveTechCan = true;
                    } else if (respbusiness.contains(RespBusiness.TechnicalEval.getVal())) {
                        haveTechCan = true;
                    } else if (respbusiness.contains(RespBusiness.BusinessEval.getVal())) {
                        haveCommCan = true;
                    }
                    DynamicObject project = BusinessDataServiceHelper.loadSingleFromCache((Object)bidProjectId, (String)"bid_project", (String)"id,doctype");
                    String doctype = project.getString("doctype");
                    if (StringUtils.isNotEmpty((CharSequence)doctype) && doctype.equals("BUSSINESS") && respbusiness.contains(RespBusiness.BidEvaluation.getVal())) {
                        haveCommCan = true;
                    }
                } else {
                    haveCommCan = true;
                    haveTechCan = true;
                }
            }
            String openFormId = FormTypeConstants.getFormConstant((String)"bidopen", (Class)class1);
            String selectpro = "id,billstatus,isonlineeval,bidopen_proficient,bidopen_proficient.proficient,bidopen_proficient.proficient_technical,bidopen_proficient.proficient_commercial";
            QFilter typeQFilter = null;
            if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenType)) {
                typeQFilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
            } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenType)) {
                typeQFilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
            }
            QFilter invalidFilter = new QFilter("billstatus", "!=", (Object)"XX");
            DynamicObject openData = BusinessDataServiceHelper.loadSingle((String)openFormId, (String)selectpro, (QFilter[])new QFilter[]{bidFilter, typeQFilter, invalidFilter});
            DynamicObjectCollection proficientRecos = openData.getDynamicObjectCollection("bidopen_proficient");
            for (DynamicObject proficientReco : proficientRecos) {
                String pkValue;
                DynamicObject proficient = proficientReco.getDynamicObject("proficient");
                DynamicObject proficientname = proficient.getDynamicObject("proficientname");
                if (proficientname == null || !StringUtils.equals((CharSequence)(pkValue = proficientname.getPkValue().toString()), (CharSequence)userId)) continue;
                if (proficientReco.getBoolean("proficient_commercial")) {
                    haveCommCan = true;
                }
                if (!proficientReco.getBoolean("proficient_technical")) break;
                haveTechCan = true;
                break;
            }
            havePermisionAnd = haveCommCan != false && haveTechCan != false;
            havePermisionOr = haveCommCan != false || haveTechCan != false;
        }
        result.put("isProficient", isProficient);
        result.put("havePermisionAnd", havePermisionAnd);
        result.put("havePermisionOr", havePermisionOr);
        result.put("haveCommCan", haveCommCan);
        result.put("haveTechCan", haveTechCan);
        return result;
    }

    public Class getClassFromApp() {
        return ((Object)((Object)this)).getClass();
    }

    private class ValidatorBidCenter
    extends AbstractValidator {
        private ValidatorBidCenter() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void validate() {
            BidStepEnum checkStep;
            boolean haveOnlineData;
            boolean hasPermission;
            String permisionCode;
            String evalFromId;
            RequestContext context = RequestContext.get();
            String userId = context.getUserId();
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            ExtendedDataEntity de = dataEntities[0];
            DynamicObject entity = de.getDataEntity();
            Long bidProjectId = (Long)entity.getPkValue();
            String bidopentype = entity.getString("bidopentype");
            QFilter bidFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
            Class class1 = BidCenterOP.this.getClassFromApp();
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"id,entitytypeid");
            String appId = bidProject.getString("entitytypeid").split("_")[0];
            boolean isAdmin = CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
            if (StringUtils.equals((CharSequence)key, (CharSequence)"bidproject")) {
                DynamicObject permissionMember = BidCenterOP.this.bidCenterService.getPermissionMember((Object)userId, (Object)bidProjectId, "01");
                String permisionCode2 = (String)BidCenterConstant.OPKEY_PERMISIONCODE_MAP.get(key);
                boolean hasPermission2 = BidCenterOP.this.checkOpPermission(permisionCode2, entity, FormTypeConstants.getFormConstant((String)"project", (Class)class1));
                if (!isAdmin) {
                    if (permissionMember == null) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u62db\u6807\u7acb\u9879\u7684\u4e1a\u52a1\u7ecf\u529e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterOP_0", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!hasPermission2) {
                        String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get(key);
                        this.addErrorMessage(de, tip);
                        return;
                    }
                } else if (!hasPermission2 && permissionMember == null) {
                    String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get(key);
                    this.addErrorMessage(de, tip);
                    return;
                }
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"onlineevaluation")) {
                evalFromId = FormTypeConstants.getFormConstant((String)"onlinebideval", (Class)class1);
                boolean haveOnlineData2 = QueryServiceHelper.exists((String)evalFromId, (QFilter[])new QFilter[]{bidFilter});
                if (!haveOnlineData2) {
                    String selectpro;
                    QFilter billstaus = new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALID.getVal()));
                    String openFormId = FormTypeConstants.getFormConstant((String)"bidopen", (Class)class1);
                    DynamicObject openData = BusinessDataServiceHelper.loadSingle((String)openFormId, (String)(selectpro = "id,billstatus,isonlineeval"), (QFilter[])new QFilter[]{bidFilter, billstaus});
                    if (openData == null) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u62db\u6807\u65e0\u5728\u7ebf\u8bc4\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (openData.getBoolean("isonlineeval")) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u5728\u7ebf\u8bc4\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_2", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u62db\u6807\u65e0\u5728\u7ebf\u8bc4\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject permissionMember = BidCenterOP.this.bidCenterService.getPermissionMember((Object)userId, (Object)bidProjectId, "07");
                permisionCode = (String)BidCenterConstant.OPKEY_PERMISIONCODE_MAP.get(key);
                hasPermission = BidCenterOP.this.checkOpPermission(permisionCode, entity, FormTypeConstants.getFormConstant((String)"onlinebideval", (Class)class1));
                Map<String, Boolean> onlineEvalBusinessMap = BidCenterOP.this.getMapOnlineEvalBusinessFlag(permissionMember, userId, bidProjectId, bidopentype, class1, bidFilter);
                Boolean isProficient = onlineEvalBusinessMap.getOrDefault("isProficient", Boolean.FALSE);
                Boolean havePermisionAnd = onlineEvalBusinessMap.getOrDefault("havePermisionAnd", Boolean.FALSE);
                Boolean havePermisionOr = onlineEvalBusinessMap.getOrDefault("havePermisionOr", Boolean.FALSE);
                Boolean haveCommCan = onlineEvalBusinessMap.getOrDefault("haveCommCan", Boolean.FALSE);
                Boolean haveTechCan = onlineEvalBusinessMap.getOrDefault("haveTechCan", Boolean.FALSE);
                if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype)) {
                    if (!isAdmin) {
                        if (permissionMember == null && !isProficient.booleanValue()) {
                            this.addErrorMessage(de, ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u5f53\u524d\u7acb\u9879\u7684\u8bc4\u6807\u4e13\u5bb6\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"BidCenterOP_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    } else if (!hasPermission && permissionMember == null) {
                        String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get(key);
                        this.addErrorMessage(de, tip);
                        return;
                    }
                } else if (!isAdmin) {
                    if (!havePermisionOr.booleanValue()) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u5f53\u524d\u7acb\u9879\u7684\u8bc4\u6807\u4e13\u5bb6\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"BidCenterOP_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!havePermisionAnd.booleanValue()) {
                        boolean existTechCan;
                        QFilter typeFilter;
                        boolean existCommCan;
                        if (haveCommCan.booleanValue() && !(existCommCan = QueryServiceHelper.exists((String)evalFromId, (QFilter[])new QFilter[]{bidFilter, typeFilter = new QFilter("evaltype", "=", (Object)"BUSSINESS")}))) {
                            this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u5546\u52a1\u6807\u5728\u7ebf\u8bc4\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_4", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (haveTechCan.booleanValue() && !(existTechCan = QueryServiceHelper.exists((String)evalFromId, (QFilter[])new QFilter[]{bidFilter, typeFilter = new QFilter("evaltype", "=", (Object)"TECHNICAL")}))) {
                            this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u6280\u672f\u6807\u5728\u7ebf\u8bc4\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_5", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                } else if (!hasPermission && permissionMember == null) {
                    String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get(key);
                    this.addErrorMessage(de, tip);
                    return;
                }
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"biddecision")) {
                QFilter bidStatusFilter;
                evalFromId = FormTypeConstants.getFormConstant((String)"decision", (Class)class1);
                haveOnlineData = QueryServiceHelper.exists((String)evalFromId, (QFilter[])new QFilter[]{bidFilter, bidStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
                if (!haveOnlineData) {
                    this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u5b9a\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_6", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (isAdmin && !(hasPermission = BidCenterOP.this.checkOpPermission(permisionCode = (String)BidCenterConstant.OPKEY_PERMISIONCODE_MAP.get(key), entity, FormTypeConstants.getFormConstant((String)"onlinebideval", (Class)class1)))) {
                    String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get(key);
                    this.addErrorMessage(de, tip);
                    return;
                }
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"bidbottommake")) {
                DynamicObject permissionMember_make = BidCenterOP.this.bidCenterService.getPermissionMember((Object)userId, (Object)bidProjectId, "19");
                if (!isAdmin) {
                    if (permissionMember_make == null) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6807\u5e95\u7f16\u5236\u7684\u4e1a\u52a1\u7ecf\u529e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterOP_22", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    String bidbottommake = FormTypeConstants.getFormConstant((String)"bottom_make", (Class)class1);
                    haveOnlineData = QueryServiceHelper.exists((String)bidbottommake, (QFilter[])new QFilter[]{bidFilter});
                    if (!haveOnlineData) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u6807\u5e95\u7f16\u5236\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_7", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    boolean hasPermission3 = BidCenterOP.this.checkOpPermission("QXX0001", entity, FormTypeConstants.getFormConstant((String)"bottom_make", (Class)class1));
                    if (!hasPermission3) {
                        String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get(key);
                        this.addErrorMessage(de, tip);
                        return;
                    }
                }
            }
            if ((checkStep = BidCenterOP.this.getCheckStepByOpKey(key)) == null) return;
            boolean haveStep = BidCenterOP.this.bidCenterService.checkContainStep((Object)bidProjectId, checkStep);
            String stepName = checkStep.getAlias();
            if (!haveStep) {
                this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u62db\u6807\u65e0%s\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_8", (String)"scm-bid-opplugin", (Object[])new Object[0]), stepName));
                return;
            }
            if (!BidCenterConstant.checkOPKeyHaveFormId((String)key).booleanValue()) return;
            String formId = BidCenterConstant.getFormIdByOPKey((String)key, (Class)class1);
            boolean isAnswer = StringUtils.equals((CharSequence)"bidanswerquestion", (CharSequence)key);
            boolean isBustalk = StringUtils.equals((CharSequence)"bidbustalk", (CharSequence)key);
            if (isAnswer) {
                String answerquestRecoformId;
                boolean haveAnswerDataReco;
                String answerQuestionFormId = FormTypeConstants.getFormConstant((String)"answerquestion", (Class)class1);
                boolean haveAnswerData = QueryServiceHelper.exists((String)answerQuestionFormId, (QFilter[])new QFilter[]{bidFilter});
                if (!haveAnswerData) {
                    BizLog.log((String)"dayi====8");
                    this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u7b54\u7591\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject answerData = BusinessDataServiceHelper.loadSingle((String)answerQuestionFormId, (String)"billstatus", (QFilter[])new QFilter[]{bidFilter});
                String billstatus = answerData.getString("billstatus");
                if (!"Q".equals(billstatus) && !(haveAnswerDataReco = QueryServiceHelper.exists((String)(answerquestRecoformId = FormTypeConstants.getFormConstant((String)"answerquestion_reco", (Class)class1)), (QFilter[])new QFilter[]{bidFilter}))) {
                    this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u4e0d\u5b58\u5728\u4e1a\u52a1\u6570\u636e\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"BidCenterOP_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (isBustalk) {
                String bustalkFormId = FormTypeConstants.getFormConstant((String)"bustalk", (Class)class1);
                boolean haveBustalkData = QueryServiceHelper.exists((String)bustalkFormId, (QFilter[])new QFilter[]{bidFilter});
                if (!haveBustalkData) {
                    this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u5546\u52a1\u8c08\u5224\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_12", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject[] bustalkDatas = BusinessDataServiceHelper.load((String)bustalkFormId, (String)"billstatus,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier", (QFilter[])new QFilter[]{bidFilter});
                if (bustalkDatas.length == 1) {
                    boolean haveData = false;
                    DynamicObject bustalkOne = bustalkDatas[0];
                    String billstatus = bustalkOne.getString("billstatus");
                    if ("F".equals(billstatus)) {
                        DynamicObjectCollection bidsections = bustalkOne.getDynamicObjectCollection("bidsection");
                        for (DynamicObject bidsection : bidsections) {
                            DynamicObjectCollection supplierentry = bidsection.getDynamicObjectCollection("supplierentry");
                            if (supplierentry.size() <= 0) continue;
                            haveData = true;
                        }
                        if (!haveData) {
                            this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u73af\u8282\u4e0d\u5b58\u5728\u4e1a\u52a1\u6570\u636e\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"BidCenterOP_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                }
            } else {
                boolean haveData = QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{bidFilter});
                if (!haveData) {
                    this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f%s\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_13", (String)"scm-bid-opplugin", (Object[])new Object[0]), stepName));
                    return;
                }
            }
            DynamicObject permissionMember = null;
            if (!isAdmin) {
                String permisionCode3;
                boolean hasPermission4;
                boolean isdirector;
                permissionMember = BidCenterOP.this.bidCenterService.getPermissionMember((Object)userId, (Object)bidProjectId, BidCenterOP.this.getRespBusinessNo(formId));
                if (permissionMember == null) {
                    this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u4e1a\u52a1\u7ecf\u529e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidCenterOP_21", (String)"scm-bid-opplugin", (Object[])new Object[0]), stepName));
                    return;
                }
                if (!BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype) && !(isdirector = permissionMember.getBoolean("isdirector"))) {
                    boolean isEval;
                    String respbusiness = permissionMember.getString("respbusiness");
                    boolean isOpen = StringUtils.equals((CharSequence)"bidopen", (CharSequence)key);
                    if (!(!isOpen || respbusiness.contains(RespBusiness.TechnicalOpen.getVal()) && respbusiness.contains(RespBusiness.BusinessOpen.getVal()))) {
                        DynamicObject bidOpenCheck;
                        if (respbusiness.contains(RespBusiness.TechnicalOpen.getVal())) {
                            if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidopentype)) {
                                bidFilter = bidFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                                bidOpenCheck = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", (Class)class1), (String)"opentype,billstatus,bidproject.id,bidproject.bidopentype", (QFilter[])new QFilter[]{bidFilter});
                                if (bidOpenCheck != null && !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)bidOpenCheck.getString("billstatus")) && !StringUtils.equals((CharSequence)BillStatusEnum.INVALID.getVal(), (CharSequence)bidOpenCheck.getString("billstatus"))) {
                                    this.addErrorMessage(de, ResManager.loadKDString((String)"\u5546\u52a1\u6807\u5f00\u6807\u5c1a\u672a\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u6280\u672f\u6807\u3002", (String)"BidCenterOP_17", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                    return;
                                }
                            }
                        } else if (respbusiness.contains(RespBusiness.BusinessOpen.getVal()) && StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidopentype)) {
                            bidFilter = bidFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                            bidOpenCheck = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", (Class)class1), (String)"opentype,billstatus,bidproject.id,bidproject.bidopentype", (QFilter[])new QFilter[]{bidFilter});
                            if (bidOpenCheck != null && !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)bidOpenCheck.getString("billstatus")) && !StringUtils.equals((CharSequence)BillStatusEnum.INVALID.getVal(), (CharSequence)bidOpenCheck.getString("billstatus"))) {
                                this.addErrorMessage(de, ResManager.loadKDString((String)"\u6280\u672f\u6807\u5f00\u6807\u5c1a\u672a\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u5546\u52a1\u6807\u3002", (String)"BidCenterOP_18", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                        }
                    }
                    if (!(!(isEval = StringUtils.equals((CharSequence)"bidevaluation", (CharSequence)key)) || respbusiness.contains(RespBusiness.BusinessEval.getVal()) && respbusiness.contains(RespBusiness.TechnicalEval.getVal()))) {
                        DynamicObject commEvalData;
                        if (respbusiness.contains(RespBusiness.TechnicalEval.getVal())) {
                            DynamicObject techEvalData;
                            if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidopentype) && (techEvalData = BidCenterOP.this.bidCenterService.getTechEvalDataByBidId((Object)bidProjectId, null)) == null) {
                                this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u6280\u672f\u6807\u8bc4\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_19", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                                return;
                            }
                        } else if (respbusiness.contains(RespBusiness.BusinessEval.getVal()) && StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidopentype) && (commEvalData = BidCenterOP.this.bidCenterService.getCommEvalDataByBidId((Object)bidProjectId, null)) == null) {
                            this.addErrorMessage(de, ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c1a\u672a\u53d1\u751f\u5546\u52a1\u6807\u8bc4\u6807\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidCenterOP_20", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                }
                if (hasPermission4 = BidCenterOP.this.checkOpPermission(permisionCode3 = (String)BidCenterConstant.OPKEY_PERMISIONCODE_MAP.get(key), entity, formId)) return;
                String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get(key);
                this.addErrorMessage(de, tip);
                return;
            } else {
                String permisionCode4 = (String)BidCenterConstant.OPKEY_PERMISIONCODE_MAP.get(key);
                boolean hasPermission5 = BidCenterOP.this.checkOpPermission(permisionCode4, entity, formId);
                if (hasPermission5) return;
                String tip = (String)BidCenterConstant.OPKEY_PERMISIONTIP_MAP.get(key);
                this.addErrorMessage(de, tip);
                return;
            }
        }
    }
}

