/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill.cancel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;

public class ValidatorBidProject
extends AbstractValidator {
    static final Map<String, String> BIDPROJECT_PROCESS = new HashMap<String, String>();
    Map<String, String> FORM_NAME = new HashMap<String, String>();
    private String APPID = "";

    public void validate() {
        String key = this.getOperateKey();
        if (StringUtils.equals((CharSequence)"invalid", (CharSequence)key)) {
            return;
        }
        HashSet<String> billStatusSet = new HashSet<String>();
        billStatusSet.add("D");
        billStatusSet.add("A");
        billStatusSet.add("C");
        billStatusSet.add("P");
        billStatusSet.add("F");
        billStatusSet.add("X");
        billStatusSet.add("XX");
        billStatusSet.add("UNCLARIFIED");
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        QuestionClarifyServiceImpl questionClarifyService = new QuestionClarifyServiceImpl();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject project = (DynamicObject)dataEntity.getValue("bidproject");
            Set<String> sonFormIdSet = this.getSonFormIdSet(this.APPID, project);
            if (sonFormIdSet == null || sonFormIdSet.size() <= 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u62db\u6807\u6d41\u7a0b\u6ca1\u6709\u4e0b\u4e00\u6b65\uff0c\u8bf7\u7ba1\u7406\u5458\u8fdb\u884c\u786e\u8ba4\uff01", (String)"ValidatorBidProject_15", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("bidproject.id", "=", project.getPkValue());
            for (String table : sonFormIdSet) {
                DynamicObject[] load = BusinessDataServiceHelper.load((String)table, (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
                if (load == null || load.length <= 0) continue;
                if ((this.APPID + "_bidopen").equals(table)) {
                    int i;
                    for (i = 0; i < load.length; ++i) {
                        String status = load[i].getString("billstatus");
                        if (!"I".equals(status) && !"P".equals(status) && !"B".equals(status)) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u6807\u5355\u5904\u4e8e\u5ba1\u6838\u4e2d\u6216\u5f00\u6807\u4e2d\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f\uff01", (String)"ValidatorBidProject_16", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    load = BusinessDataServiceHelper.load((String)(this.APPID + "_supplierinvalid"), (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
                    if (load == null || load.length <= 0) continue;
                    for (i = 0; i < load.length; ++i) {
                        if (billStatusSet.contains(load[i].getString("billstatus"))) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u6dd8\u6c70\u6ca1\u5b8c\u6210\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u8fdb\u884c\u4f5c\u5e9f\uff01", (String)"ValidatorBidProject_17", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    continue;
                }
                if ((this.APPID + "_decision").equals(table)) {
                    for (int i = 0; i < load.length; ++i) {
                        if ("XX".equals(load[i].getString("billstatus")) || load[i].getString("billstatus").equals("D")) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9a\u6807\u5df2\u5904\u4e8e\u975e\u672a\u5f00\u59cb\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4f5c\u5e9f\uff01", (String)"ValidatorBidProject_34", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    continue;
                }
                if ((this.APPID + "_pay").equals(table)) {
                    for (int i = 0; i < load.length; ++i) {
                        DynamicObject payTaltol = load[i];
                        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)payTaltol.getPkValue(), (String)table);
                        DynamicObjectCollection bidsections = loadSingle.getDynamicObjectCollection("bidsection");
                        for (DynamicObject nextSection : bidsections) {
                            DynamicObjectCollection supplierentry = nextSection.getDynamicObjectCollection("supplierentry");
                            for (DynamicObject row : supplierentry) {
                                if (!row.getString("status").equals("1")) continue;
                                String tip = this.getTip(table);
                                this.addErrorMessage(dataEntity, tip);
                                return;
                            }
                        }
                    }
                    continue;
                }
                if ((this.APPID + "_adjustmentrecord").equals(table)) {
                    QFilter qFilter = new QFilter("name", "=", (Object)project.getString("name"));
                    load = BusinessDataServiceHelper.load((String)table, (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter});
                    if (load == null || load.length <= 0) continue;
                    for (int i = 0; i < load.length; ++i) {
                        if (load[i].getString("billstatus").equals("C")) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u7acb\u9879\u8c03\u6574\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4f5c\u5e9f\uff01", (String)"ValidatorBidProject_19", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    continue;
                }
                if ((this.APPID + "_multiquestclarify").equals(table)) {
                    QFilter qFilter = new QFilter("bidproject", "=", project.getPkValue());
                    load = BusinessDataServiceHelper.load((String)table, (String)"id,billstatus,publicstatis", (QFilter[])new QFilter[]{qFilter});
                    if (load == null || load.length <= 0) continue;
                    for (int i = 0; i < load.length; ++i) {
                        boolean b = questionClarifyService.checkMultiquestclarifyIsEnable(load[i]);
                        if (!b) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8d28\u7591\u6f84\u6e05\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4f5c\u5e9f\uff01", (String)"ValidatorBidProject_20", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    continue;
                }
                if ((this.APPID + "_questionclarify").equals(table)) {
                    QFilter statusQFilter;
                    QFilter qFilter = new QFilter("bidproject", "=", project.getPkValue());
                    boolean exists = QueryServiceHelper.exists((String)table, (QFilter[])new QFilter[]{qFilter, statusQFilter = new QFilter("billstatus", "=", (Object)"UNCLARIFIED")});
                    if (!exists) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5f85\u6f84\u6e05\u95ee\u9898\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4f5c\u5e9f\uff01", (String)"ValidatorBidProject_21", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                for (int i = 0; i < load.length; ++i) {
                    if (billStatusSet.contains(load[i].getString("billstatus"))) continue;
                    String tip = this.getTip(table);
                    this.addErrorMessage(dataEntity, tip);
                    return;
                }
            }
        }
    }

    public String getTip(String step) {
        this.FORM_NAME.put("supplierinvitation", ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4", (String)"ValidatorBidProject_0", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("biddocument_edit", ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236", (String)"ValidatorBidProject_1", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("bottom_make", ResManager.loadKDString((String)"\u6807\u5e95\u7f16\u5236", (String)"ValidatorBidProject_2", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("clarificaiton", ResManager.loadKDString((String)"\u62db\u6807\u4ea4\u5e95", (String)"ValidatorBidProject_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("bidpublish", ResManager.loadKDString((String)"\u53d1\u6807", (String)"ValidatorBidProject_4", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("answerquestion_reco", ResManager.loadKDString((String)"\u7b54\u7591", (String)"ValidatorBidProject_5", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("bidopen", ResManager.loadKDString((String)"\u5f00\u6807", (String)"ValidatorBidProject_6", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("bidevaluation", ResManager.loadKDString((String)"\u8bc4\u6807", (String)"ValidatorBidProject_7", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("bustalk", ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224", (String)"ValidatorBidProject_8", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("biddecision", ResManager.loadKDString((String)"\u5b9a\u6807", (String)"ValidatorBidProject_9", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("adjustmentrecord", ResManager.loadKDString((String)"\u7acb\u9879\u8c03\u6574", (String)"ValidatorBidProject_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("pay", ResManager.loadKDString((String)"\u7f34\u8d39\u8bb0\u5f55", (String)"ValidatorBidProject_11", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("onlinebideval", ResManager.loadKDString((String)"\u5728\u7ebf\u8bc4\u6807", (String)"ValidatorBidProject_12", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("multiquestclarify", ResManager.loadKDString((String)"\u8d28\u7591\u5355\u636e", (String)"ValidatorBidProject_13", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("questionclarify", ResManager.loadKDString((String)"\u6f84\u6e05\u5355\u636e", (String)"ValidatorBidProject_14", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        this.FORM_NAME.put("rebackbid", ResManager.loadKDString((String)"\u91cd\u65b0\u56de\u6807\u5355", (String)"ValidatorBidProject_33", (String)"scm-bid-opplugin", (Object[])new Object[0]));
        String tableProffix = "";
        tableProffix = this.APPID.equals("bid") ? step.substring(4) : step.substring(5);
        StringBuilder tipBuffer = new StringBuilder();
        String str = String.format(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u4e2d\u7684%s,\u8fd8\u5728\u5904\u7406\u4e2d,\u8bf7\u5904\u7406\u5b8c\u6210\u540e,\u8fdb\u884c\u4f5c\u5e9f\uff01", (String)"ValidatorBidProject_35", (String)"scm-bid-opplugin", (Object[])new Object[0]), this.FORM_NAME.get(tableProffix));
        tipBuffer.append(str);
        return tipBuffer.toString();
    }

    public Set<String> getSonFormIdSet(String appId, DynamicObject project) {
        return BIDPROJECT_PROCESS.entrySet().parallelStream().map(e -> appId + ((String)e.getValue()).toLowerCase()).collect(Collectors.toSet());
    }

    public void setAppIDD(String appid) {
        this.APPID = appid;
    }

    public String getAppID() {
        return this.APPID;
    }

    static {
        BIDPROJECT_PROCESS.put("supplierinvitation", "_supplierinvitation");
        BIDPROJECT_PROCESS.put("biddocument", "_biddocument_edit");
        BIDPROJECT_PROCESS.put("bidbottommake", "_bottom_make");
        BIDPROJECT_PROCESS.put("clarificaiton", "_clarificaiton");
        BIDPROJECT_PROCESS.put("bidpublish", "_bidpublish");
        BIDPROJECT_PROCESS.put("bidanswerquestion", "_answerquestion_reco");
        BIDPROJECT_PROCESS.put("bidopen", "_bidopen");
        BIDPROJECT_PROCESS.put("bidevaluation", "_bidevaluation");
        BIDPROJECT_PROCESS.put("bidbustalk", "_bustalk");
        BIDPROJECT_PROCESS.put("bidDecision", "_decision");
        BIDPROJECT_PROCESS.put("adjustmentrecord", "_adjustmentrecord");
        BIDPROJECT_PROCESS.put("onlinebideval", "_onlinebideval");
        BIDPROJECT_PROCESS.put("multiquestclarify", "_multiquestclarify");
        BIDPROJECT_PROCESS.put("questionclarify", "_questionclarify");
        BIDPROJECT_PROCESS.put("rebackbid", "_rebackbid");
    }
}

