/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill.clarify;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.util.BidDarkUtil;
import kd.scm.bid.common.util.BidMessageUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class MultiQuestionClarifyOP
extends AbstractOperationServicePlugIn {
    protected IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    protected String OP_KEY_SEND = "send";
    protected String OP_KEY_UNSEND = "unsend";
    protected String SEND_QUES = "send_ques";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("clarifysupplier");
        e.getFieldKeys().add("clarifydeadline");
        e.getFieldKeys().add("clarifytheme");
        e.getFieldKeys().add("opentype");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("multiclarifyentry");
        e.getFieldKeys().add("resubmisstenders");
        e.getFieldKeys().add("clarifytype");
        e.getFieldKeys().add("questclarifyid");
        e.getFieldKeys().add("qcbillstatus");
        e.getFieldKeys().add("questiondescription");
        e.getFieldKeys().add("questiondescription_tag");
        e.getFieldKeys().add("sectionname");
        e.getFieldKeys().add("bidevaluationid");
        e.getFieldKeys().add("supplierinvitationid");
        e.getFieldKeys().add("bidpublishid");
        e.getFieldKeys().add("bidopenid");
        e.getFieldKeys().add("isletter");
        e.getFieldKeys().add("supclarifyattach");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ValidatorMultiQuestionClarify());
    }

    public Boolean unsubmitStatus(Object mulPk, String openType, Object supplierId, String bidName) {
        QFilter bidProjectFilter = new QFilter("multiquestclarifyid", "=", mulPk);
        String appId = this.getAppId();
        DynamicObject[] clarifyQest = BusinessDataServiceHelper.load((String)(appId + "_questionclarify"), (String)"id,billstatus", (QFilter[])new QFilter[]{bidProjectFilter});
        if (clarifyQest == null || clarifyQest.length <= 0) {
            return Boolean.FALSE;
        }
        for (DynamicObject clarify : clarifyQest) {
            String billstatus = clarify.getString("billstatus");
            if (!billstatus.equals(ClarifyStatusEnum.CLARIFIED.getValue())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String opkey = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if (StringUtils.equals((CharSequence)this.OP_KEY_UNSEND, (CharSequence)opkey)) {
            this.unSubmitQuestionClarifyDataByModel(datas[0], opkey);
        } else if (StringUtils.equals((CharSequence)this.OP_KEY_SEND, (CharSequence)opkey)) {
            this.createQuestionClarifyDataByModel(datas[0], opkey);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String opkey = e.getOperationKey();
        DynamicObject data = e.getDataEntities()[0];
        String table = FormTypeConstants.getFormConstant((String)"multiquestclarify", ((Object)((Object)this)).getClass());
        data = BusinessDataServiceHelper.loadSingle((Object)data.getPkValue(), (String)table);
        if (StringUtils.equals((CharSequence)this.OP_KEY_UNSEND, (CharSequence)opkey)) {
            data.set("publicstatis", (Object)"B");
            ArrayList<Object> ids = new ArrayList<Object>();
            DynamicObjectCollection bidsections = data.getDynamicObjectCollection("bidsection");
            for (DynamicObject section : bidsections) {
                DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierRow : supplierentry) {
                    DynamicObject questclarifyid = supplierRow.getDynamicObject("questclarifyid");
                    if (questclarifyid == null) continue;
                    ids.add(questclarifyid.getPkValue());
                    supplierRow.set("questclarifyid", null);
                }
            }
            String questionclarify = String.format("%s%s", this.getAppId(), "_questionclarify");
            QFilter qFilter = new QFilter("id", "in", ids);
            DeleteServiceHelper.delete((String)questionclarify, (QFilter[])new QFilter[]{qFilter});
        } else if (StringUtils.equals((CharSequence)this.OP_KEY_SEND, (CharSequence)opkey)) {
            data.set("publicstatis", (Object)"S");
            String variableValue = this.getOption().getVariableValue(this.SEND_QUES);
            if (StringUtils.isNotEmpty((CharSequence)variableValue)) {
                String[] split;
                for (String value : split = variableValue.split(";")) {
                    if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                    String[] quArr = value.split("_");
                    DynamicObject questclarify = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(quArr[0]), (String)FormTypeConstants.getFormConstant((String)"questionclarify", ((Object)((Object)this)).getClass()));
                    BidMessageUtil.sendMsgByQuestionClarify((DynamicObject)questclarify, (DynamicObject)questclarify.getDynamicObject("bidproject"), (Long)Long.parseLong(quArr[1]), (String)this.getAppId());
                }
                this.getOption().removeVariable(this.SEND_QUES);
            }
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{data});
    }

    public void unSubmitQuestionClarifyDataByModel(DynamicObject model, String opkey) {
        DynamicObjectCollection bidsections = model.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidRow : bidsections) {
            DynamicObjectCollection supplierentry = bidRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject next : supplierentry) {
                DynamicObject questionClarify = next.getDynamicObject("questclarifyid");
                if (questionClarify == null) continue;
                DynamicObject questionClarifyForm = BusinessDataServiceHelper.loadSingle((Object)questionClarify.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"questionclarify", ((Object)((Object)this)).getClass()), (String)"billstatus");
                questionClarifyForm.set("billstatus", (Object)ClarifyStatusEnum.UNSENT.getValue());
                SaveServiceHelper.update((DynamicObject)questionClarifyForm);
            }
        }
    }

    public void createQuestionClarifyDataByModel(DynamicObject model, String opkey) {
        DynamicObject bidProject = model.getDynamicObject("bidproject");
        String opentype = model.getString("opentype");
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)opentype);
        QFilter statusFilter = new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX"});
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,currency,bidsection,bidsection.sectionname,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.baseunit,supplierdetail.resourceitem,supplierdetail.materialdes,supplierdetail.qty,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.listnumber,supplierdetail.listname,supplierdetail.costrate", (QFilter[])new QFilter[]{bidProjectFilter, openTypeFilter, statusFilter});
        String entityName = FormTypeConstants.getFormConstant((String)"multiquestclarify", ((Object)((Object)this)).getClass());
        Object pkId = model.getPkValue();
        String questFormId = FormTypeConstants.getFormConstant((String)"questionclarify", ((Object)((Object)this)).getClass());
        boolean isDark = BidDarkUtil.isDarkEvaluation((String)this.getAppId(), (Object)bidOpen.getPkValue(), (String)opentype);
        boolean exist = QueryServiceHelper.exists((String)questFormId, (QFilter[])new QFilter[]{new QFilter("multiquestclarifyid", "=", pkId)});
        if (exist) {
            HashMap<String, DynamicObject> supplierMap_database = new HashMap<String, DynamicObject>();
            DynamicObject multiQuestionClarify = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityName);
            DynamicObjectCollection bidsections = multiQuestionClarify.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidRow : bidsections) {
                String sectionname = bidRow.getString("sectionname");
                DynamicObjectCollection supplierentry = bidRow.getDynamicObjectCollection("supplierentry");
                for (DynamicObject next : supplierentry) {
                    String supplierId = next.getDynamicObject("clarifysupplier").getPkValue().toString();
                    String supplierName = next.getDynamicObject("clarifysupplier").getString("name");
                    String clarifysupplierName = supplierId + "&&" + supplierName + "&&" + sectionname;
                    supplierMap_database.put(clarifysupplierName, next);
                }
            }
            HashMap<String, DynamicObject> supplierMap_model = new HashMap<String, DynamicObject>();
            bidsections = model.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidRow : bidsections) {
                String sectionname = bidRow.getString("sectionname");
                DynamicObjectCollection dynamicObjectCollection = bidRow.getDynamicObjectCollection("supplierentry");
                for (DynamicObject entry : dynamicObjectCollection) {
                    String supplierId = entry.getDynamicObject("clarifysupplier").getPkValue().toString();
                    String supplierName = entry.getDynamicObject("clarifysupplier").getString("name");
                    String clarifysupplierName = supplierId + "&&" + supplierName + "&&" + (String)sectionname;
                    if (!supplierMap_database.containsKey(clarifysupplierName)) {
                        DynamicObject questionClarifyForm = this.newQuestionClarify(model, entry, bidOpen, opkey, sectionname, isDark);
                        entry.set("questclarifyid", questionClarifyForm.getPkValue());
                    } else {
                        DynamicObject questionClarify = entry.getDynamicObject("questclarifyid");
                        if (questionClarify == null) {
                            DynamicObject questionClarifyDB = (DynamicObject)supplierMap_database.get(clarifysupplierName);
                            questionClarify = questionClarifyDB.getDynamicObject("questclarifyid");
                            entry.set("questclarifyid", (Object)questionClarify);
                        }
                        this.updateQuestionClarify(model, entry, bidOpen, opkey);
                    }
                    supplierMap_model.put(clarifysupplierName, entry);
                }
            }
            ArrayList<Object> deleteList = new ArrayList<Object>(supplierMap_database.size());
            for (Map.Entry entry : supplierMap_database.entrySet()) {
                DynamicObject questclarify;
                String key = (String)entry.getKey();
                if (supplierMap_model.containsKey(key) || (questclarify = ((DynamicObject)entry.getValue()).getDynamicObject("questclarifyid")) == null) continue;
                deleteList.add(questclarify.getPkValue());
            }
            if (deleteList.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"questionclarify", ((Object)((Object)this)).getClass())), (Object[])deleteList.toArray());
            }
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{model});
        } else {
            DynamicObjectCollection bidsections = model.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidRow : bidsections) {
                String sectionname = bidRow.getString("sectionname");
                DynamicObjectCollection supplierentry = bidRow.getDynamicObjectCollection("supplierentry");
                for (DynamicObject next : supplierentry) {
                    DynamicObject dynamicObject = this.newQuestionClarify(model, next, bidOpen, opkey, sectionname, isDark);
                    next.set("questclarifyid", (Object)dynamicObject);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model});
        }
    }

    public void updateQuestionClarify(DynamicObject model, DynamicObject entry, DynamicObject bidOpen, String opKey) {
        DynamicObject questionClarify = entry.getDynamicObject("questclarifyid");
        DynamicObject questionClarifyForm = BusinessDataServiceHelper.loadSingle((Object)questionClarify.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"questionclarify", ((Object)((Object)this)).getClass()));
        questionClarifyForm.set("clarifytheme", model.get("clarifytheme"));
        questionClarifyForm.set("clarifydeadline", model.get("clarifydeadline"));
        questionClarifyForm.set("initiationtime", model.get("initiationtime"));
        questionClarifyForm.set("clarifytype", model.get("clarifytype"));
        questionClarifyForm.set("bigquestiondescription_tag", entry.get("questiondescription"));
        String bigText = entry.getString("questiondescription_tag");
        if (StringUtils.isNotBlank((CharSequence)bigText)) {
            questionClarifyForm.set("bigquestiondescription_tag", (Object)bigText);
        }
        questionClarifyForm.set("resubmisstenders", entry.get("resubmisstenders"));
        questionClarifyForm.set("billstatus", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue());
        questionClarifyForm.set("senddate", (Object)new Date());
        String clarifysupplier = entry.getDynamicObject("clarifysupplier").getPkValue().toString();
        Long supplierId = Long.parseLong(clarifysupplier);
        this.putVariableValue(questionClarifyForm.getPkValue(), supplierId);
        this.putVariableValue(questionClarifyForm.getPkValue(), supplierId);
        SaveServiceHelper.update((DynamicObject)questionClarifyForm);
        this.copyClarifyAttachEntryToBill(entry, questionClarifyForm.getPkValue(), opKey);
    }

    public DynamicObject newQuestionClarify(DynamicObject model, DynamicObject entry, DynamicObject bidOpen, String opKey, String bidSectionName, boolean isDark) {
        String serviceAppId = "bid";
        String name = model.getDataEntityType().getName();
        if (name.startsWith("rebm")) {
            serviceAppId = "rebm";
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(serviceAppId + "_" + "questionclarify"));
        DynamicObject questionClarifyForm = new DynamicObject((DynamicObjectType)mainType);
        ORM orm = ORM.create();
        long id = orm.genLongId((IDataEntityType)mainType);
        questionClarifyForm.set("id", (Object)id);
        questionClarifyForm.set("org", model.get("org"));
        questionClarifyForm.set("creator", model.get("creator"));
        questionClarifyForm.set("modifytime", (Object)new Date());
        questionClarifyForm.set("createtime", (Object)new Date());
        questionClarifyForm.set("currency", bidOpen.get("currency"));
        questionClarifyForm.set("clarifytheme", model.get("clarifytheme"));
        questionClarifyForm.set("clarifydeadline", model.get("clarifydeadline"));
        questionClarifyForm.set("initiationtime", model.get("initiationtime"));
        questionClarifyForm.set("clarifytype", model.get("clarifytype"));
        questionClarifyForm.set("bigquestiondescription_tag", entry.get("questiondescription"));
        String bigText = entry.getString("questiondescription_tag");
        if (StringUtils.isNotBlank((CharSequence)bigText)) {
            questionClarifyForm.set("bigquestiondescription_tag", (Object)bigText);
        }
        questionClarifyForm.set("resubmisstenders", entry.get("resubmisstenders"));
        DynamicObject clarifysupplier = entry.getDynamicObject("clarifysupplier");
        String supplierName = clarifysupplier.getString("name");
        Long supplierId = Long.parseLong(clarifysupplier.getPkValue().toString());
        questionClarifyForm.set("supplier", (Object)supplierName);
        String clarifysupplierName = clarifysupplier.getPkValue().toString() + "&&" + supplierName + "&&" + bidSectionName;
        questionClarifyForm.set("clarifysupplier", (Object)clarifysupplierName);
        if (isDark) {
            Table evaluationDarkTable = BidDarkUtil.getEvaluationDark((String)this.getAppId(), (Object)bidOpen.getPkValue());
            String supDarkName = (String)evaluationDarkTable.get((Object)bidSectionName, clarifysupplier.getPkValue());
            questionClarifyForm.set("supdarkname", (Object)supDarkName);
        }
        questionClarifyForm.set("opentype", model.get("opentype"));
        questionClarifyForm.set("bidproject", model.get("bidproject"));
        questionClarifyForm.set("multiquestclarifyid", model.getPkValue());
        if (StringUtils.equals((CharSequence)"save", (CharSequence)opKey)) {
            questionClarifyForm.set("billstatus", (Object)ClarifyStatusEnum.UNSENT.getValue());
        } else if (StringUtils.equals((CharSequence)this.OP_KEY_SEND, (CharSequence)opKey)) {
            questionClarifyForm.set("billstatus", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue());
            questionClarifyForm.set("senddate", (Object)new Date());
        }
        DynamicObjectCollection bidsectioncoll = bidOpen.getDynamicObjectCollection("bidsection");
        DynamicObject bidProject = model.getDynamicObject("bidproject");
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        for (int i = 0; i < bidsectioncoll.size(); ++i) {
            DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
            String sectionName = bidsection.getString("sectionname");
            int k = 1;
            if (enablemultisection && !bidSectionName.equals(sectionName)) continue;
            DynamicObjectCollection supplierDetail = bidsection.getDynamicObjectCollection("supplierdetail");
            DynamicObject clarifyBidsection = questionClarifyForm.getDynamicObjectCollection("bidsection").addNew();
            clarifyBidsection.set("seq", (Object)k++);
            clarifyBidsection.set("sectionname", (Object)sectionName);
            DynamicObjectCollection clarifySupplierDetailColl = clarifyBidsection.getDynamicObjectCollection("supplierdetail");
            int index = 1;
            for (int j = 0; j < supplierDetail.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)supplierDetail.get(j);
                DynamicObject pursupplier = supplierentry.getDynamicObject("pursupplier");
                if (!supplierId.equals(pursupplier.getPkValue())) continue;
                DynamicObject newSupplierDetail = clarifySupplierDetailColl.addNew();
                newSupplierDetail.set("pursupplier", supplierentry.get("pursupplier"));
                newSupplierDetail.set("seq", (Object)index++);
                newSupplierDetail.set("purentrycontent", supplierentry.get("purentrycontent"));
                newSupplierDetail.set("purentryproject", supplierentry.get("purentryproject"));
                newSupplierDetail.set("materialid", supplierentry.get("materialid"));
                newSupplierDetail.set("baseunit", supplierentry.get("baseunit"));
                newSupplierDetail.set("materialdes", supplierentry.get("materialdes"));
                newSupplierDetail.set("qty", supplierentry.get("qty"));
                if (!"rebm".equals(this.getAppId())) continue;
                newSupplierDetail.set("listnumber", supplierentry.get("listnumber"));
                newSupplierDetail.set("listname", supplierentry.get("listname"));
                newSupplierDetail.set("resourceitem", supplierentry.get("resourceitem"));
            }
        }
        questionClarifyForm.set("bidevaluationid", model.get("bidevaluationid"));
        questionClarifyForm.set("supplierinvitationid", model.get("supplierinvitationid"));
        questionClarifyForm.set("bidpublishid", model.get("bidpublishid"));
        questionClarifyForm.set("bidopenid", model.get("bidopenid"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{questionClarifyForm});
        this.copyClarifyAttachEntryToBill(entry, questionClarifyForm.getPkValue(), opKey);
        if (StringUtils.equals((CharSequence)this.OP_KEY_SEND, (CharSequence)opKey)) {
            this.putVariableValue(questionClarifyForm.getPkValue(), supplierId);
        }
        return questionClarifyForm;
    }

    public void putVariableValue(Object questionClarifyId, Object supplierId) {
        String variableValue = this.getOption().getVariableValue(this.SEND_QUES, "");
        variableValue = variableValue + ";" + questionClarifyId + "_" + supplierId;
        this.getOption().setVariableValue(this.SEND_QUES, variableValue);
    }

    public void copyClarifyAttachEntryToBill(DynamicObject entry, Object questionClarifyFormId, String opKey) {
        DynamicObjectCollection comAttachCol = entry.getDynamicObjectCollection("supclarifyattach");
        List fileList = comAttachCol.stream().map(item -> item.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fileList)) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                String clarifyattachpanel = "clarifyattachpanel";
                if ("rebm".equals(this.getAppId())) {
                    BidFileHelper.entryToPanelAttachment(fileList, (String)"rebm_questionclarify", (Object)questionClarifyFormId, (String)clarifyattachpanel);
                    if (StringUtils.equals((CharSequence)this.OP_KEY_SEND, (CharSequence)opKey)) {
                        BidFileHelper.entryToPanelAttachment(fileList, (String)"resp_questionclarify", (Object)questionClarifyFormId, (String)clarifyattachpanel);
                    }
                } else {
                    BidFileHelper.entryToPanelAttachment(fileList, (String)"bid_questionclarify", (Object)questionClarifyFormId, (String)clarifyattachpanel);
                    if (StringUtils.equals((CharSequence)this.OP_KEY_SEND, (CharSequence)opKey)) {
                        BidFileHelper.entryToPanelAttachment(fileList, (String)"ten_questionclarify", (Object)questionClarifyFormId, (String)clarifyattachpanel);
                    }
                }
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    public void sendMessage(DynamicObject data, DynamicObject bidProject, Long supplierId) {
        BidMessageUtil.sendMsgByQuestionClarify((DynamicObject)data, (DynamicObject)bidProject, (Long)supplierId, (String)this.getAppId());
    }

    public String getAppId() {
        String appName = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
        return appName;
    }

    private class ValidatorMultiQuestionClarify
    extends AbstractValidator {
        private ValidatorMultiQuestionClarify() {
        }

        public void validate() {
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            Date nowDate = new Date();
            for (ExtendedDataEntity de : dataEntities) {
                boolean isletter;
                boolean exsitunFinishback;
                DynamicObject data = de.getDataEntity();
                DynamicObject bidProject = data.getDynamicObject("bidproject");
                Object bidProjectId = bidProject.getPkValue();
                String openType = data.getString("openType");
                if ((StringUtils.equals((CharSequence)"save", (CharSequence)key) || "submit".equals(key)) && (exsitunFinishback = new ReBackBidUtil(((Object)((Object)this)).getClass().getName().split("\\.")[2]).checkBackBidFinished(bidProjectId))) {
                    this.addErrorMessage(de, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u5728\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MultiQuestionClarifyOP_7", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.equals((CharSequence)"audit", (CharSequence)key) || "submit".equals(key)) {
                    int compareTo;
                    OrmLocaleValue clarifyTheme = (OrmLocaleValue)de.getValue("clarifytheme");
                    Object billPkId = de.getBillPkId();
                    Boolean checkRepeatedFlag = MultiQuestionClarifyOP.this.questionClarifyService.checkRepeatedClarifytheme(bidProjectId, openType, clarifyTheme.getLocaleValue(), billPkId, billPkId.toString());
                    if (checkRepeatedFlag.booleanValue()) {
                        this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u8d28\u7591/\u6f84\u6e05\u4e3b\u9898\uff1a\u201c%s\u201d\u91cd\u590d\uff0c\u4e0d\u80fd\u53d1\u9001\u3002", (String)"MultiQuestionClarifyOP_9", (String)"scm-bid-opplugin", (Object[])new Object[0]), clarifyTheme));
                        return;
                    }
                    Date clarifydeadline = data.getDate("clarifydeadline");
                    if (clarifydeadline != null && (compareTo = nowDate.compareTo(clarifydeadline)) >= 0) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u5fc5\u987b\u665a\u4e8e\u670d\u52a1\u5668\u5f53\u524d\u65f6\u95f4\u3002", (String)"MultiQuestionClarifyOP_2", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    QFilter qTaotaiPro = new QFilter("bidproject", "=", bidProjectId);
                    QFilter qTaotaiSta = new QFilter("billstatus", "!=", (Object)"C");
                    boolean exists = QueryServiceHelper.exists((String)(MultiQuestionClarifyOP.this.getAppId() + "_supplierinvalid"), (QFilter[])new QFilter[]{qTaotaiPro, qTaotaiSta});
                    if (exists) {
                        this.addErrorMessage(de, ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u5ba1\u6838\u5b8c\u6210\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u5355\u636e\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff01", (String)"MultiQuestionClarifyOP_3", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObjectCollection bidsections = data.getDynamicObjectCollection("bidsection");
                    for (DynamicObject section : bidsections) {
                        String sectionname = section.getString("sectionname");
                        DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierRow : supplierentry) {
                            Object supplierId = supplierRow.getDynamicObject("clarifysupplier").getPkValue();
                            String supplierName = supplierRow.getDynamicObject("clarifysupplier").getString("name");
                            Boolean checkRepeatedSupplier = MultiQuestionClarifyOP.this.questionClarifyService.checkRepeatedSupplierAndSection(data.getPkValue(), openType, supplierId, sectionname);
                            if (!checkRepeatedSupplier.booleanValue()) continue;
                            this.addErrorMessage(de, String.format(ResManager.loadKDString((String)"\u6807\u6bb5\u540d\u79f0\u4e3a\uff1a%1$s,\u4f9b\u5e94\u5546\uff1a%2$s", (String)"MultiQuestionClarifyOP_4", (String)"scm-bid-opplugin", (Object[])new Object[0]), sectionname, supplierName));
                        }
                    }
                    continue;
                }
                if (StringUtils.equals((CharSequence)MultiQuestionClarifyOP.this.OP_KEY_UNSEND, (CharSequence)key)) {
                    DynamicObjectCollection bidsections = data.getDynamicObjectCollection("bidsection");
                    block3: for (DynamicObject section : bidsections) {
                        String sectionname = section.getString("sectionname");
                        DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject supplierRow : supplierentry) {
                            Object supplierId = supplierRow.getDynamicObject("clarifysupplier").getPkValue();
                            String supplierName = supplierRow.getDynamicObject("clarifysupplier").getString("name");
                            Boolean checkRepeatedSupplier = MultiQuestionClarifyOP.this.unsubmitStatus(data.getPkValue(), openType, supplierId, sectionname);
                            if (!checkRepeatedSupplier.booleanValue()) continue;
                            this.addErrorMessage(de, ResManager.loadKDString((String)"\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u53d1\u5e03", (String)"MultiQuestionClarifyOP_10", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                            continue block3;
                        }
                    }
                    continue;
                }
                if (!StringUtils.equals((CharSequence)MultiQuestionClarifyOP.this.OP_KEY_SEND, (CharSequence)key) || !(isletter = data.getBoolean("isletter"))) continue;
                String leterFormId = "";
                leterFormId = MultiQuestionClarifyOP.this.getAppId().equals("rebm") ? "rebm_query_letters_inh" : "bid_query_letters";
                boolean isLetter = QueryServiceHelper.exists((String)leterFormId, (QFilter[])new QFilter[]{new QFilter("queryid", "=", data.getPkValue()), new QFilter("status", "=", (Object)"C")});
                if (isLetter) continue;
                this.addErrorMessage(de, ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5df2\u5ba1\u6838\u7684\u8d28\u7591\u51fd\uff01", (String)"MultiQuestionClarifyOP_6", (String)"scm-bid-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }
}

