/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill.payop;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.paycomon.PaySendMsg;
import kd.scm.bid.common.util.MessageChannelUtil;

public class PayRefundCordOp
extends AbstractOperationServicePlugIn {
    private static DBRoute DBROUTE = DBRoute.of((String)"scm");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billno");
        keys.add("billstatus");
        keys.add("bidproject");
        keys.add("bidsection");
        keys.add("bidsection.sectionname");
        keys.add("supplierentry");
        keys.add("supplierentry.status");
        keys.add("supplierentry.supplier");
        keys.add("supplierentry.paylistid");
        keys.add("submittor");
        keys.add("submittime");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataList = e.getDataEntities();
        if ("submit".equals(operationKey)) {
            Arrays.stream(e.getDataEntities()).forEach(model -> this.beginSubmitTransaction(e, (DynamicObject)model));
        }
        if ("audit".equals(operationKey)) {
            for (DynamicObject data : dataList) {
                this.dealAuditAndUnaudit(data, true);
            }
        }
        if ("unaudit".equals(operationKey)) {
            for (DynamicObject data : dataList) {
                this.dealAuditAndUnaudit(data, false);
            }
        }
    }

    protected void beginSubmitTransaction(BeginOperationTransactionArgs args, DynamicObject model) {
        model.set("submittor", (Object)RequestContext.get().getCurrUserId());
        model.set("submittime", (Object)new Date());
    }

    public void dealAuditAndUnaudit(DynamicObject data, boolean auditFlag) {
        String payStaus = "3";
        if (!auditFlag) {
            payStaus = "2";
        }
        DynamicObjectCollection bidsection = data.getDynamicObjectCollection("bidsection");
        Iterator bidIter = bidsection.iterator();
        StringBuilder ids = new StringBuilder();
        while (bidIter.hasNext()) {
            DynamicObject bidsectionRow = (DynamicObject)bidIter.next();
            DynamicObjectCollection supplierentry = bidsectionRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierRow : supplierentry) {
                String status = supplierRow.getString("status");
                if (StringUtils.equals((CharSequence)status, (CharSequence)"0") || StringUtils.equals((CharSequence)status, (CharSequence)"4") || StringUtils.equals((CharSequence)status, (CharSequence)"1")) continue;
                supplierRow.set("status", (Object)payStaus);
                long paylistid = supplierRow.getLong("paylistid");
                ids.append(paylistid);
                ids.append(',');
            }
        }
        if (ids != null && ids.length() > 0) {
            String sql = String.format("update t_bidpay_list set fstatus = '%s' where fid in ( %s )", payStaus, ids.substring(0, ids.length() - 1));
            DB.execute((DBRoute)new DBRoute("scm"), (String)sql);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String appId;
        DynamicObject bidProject;
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] dataList = e.getDataEntities();
        if ("save".equals(key) || "submit".equals(key)) {
            for (DynamicObject data : dataList) {
                bidProject = data.getDynamicObject("bidproject");
                appId = this.getAppId(bidProject);
                this.generRecordRelease(data, appId);
            }
        }
        if ("delete".equals(key)) {
            for (DynamicObject data : dataList) {
                bidProject = data.getDynamicObject("bidproject");
                appId = this.getAppId(bidProject);
                this.deleteRelease(data, appId);
            }
        }
        if ("audit".equals(key)) {
            for (DynamicObject data : dataList) {
                bidProject = data.getDynamicObject("bidproject");
                appId = this.getAppId(bidProject);
                this.sendMsg(data, appId);
            }
        }
        if ("unaudit".equals(key)) {
            for (DynamicObject dynamicObject : dataList) {
            }
        }
        if ("auditing_save".equals(key)) {
            for (DynamicObject dynamicObject : dataList) {
            }
        }
    }

    public void generRecordRelease(DynamicObject data, String appId) {
        boolean exists = QueryServiceHelper.exists((String)(appId + "_playrecord_playlist"), (QFilter[])new QFilter[]{new QFilter("id", "=", data.getPkValue())});
        if (exists) {
            return;
        }
        MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)(appId + "_playrecord_playlist"));
        DynamicObject typeRecord = new DynamicObject((DynamicObjectType)payMainType);
        Object dataPK = data.getPkValue();
        typeRecord.set("id", dataPK);
        typeRecord.set("entitytypeid", (Object)(appId + "_playrecord_playlist"));
        typeRecord.set("playrecordtype", (Object)"02");
        DynamicObjectCollection entryentity = typeRecord.getDynamicObjectCollection("refrenceentity");
        DynamicObjectCollection bidsection = data.getDynamicObjectCollection("bidsection");
        for (DynamicObject supplierEntry : bidsection) {
            DynamicObjectCollection supplierentry = supplierEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                Object paylistid = row.get("paylistid");
                DynamicObject addNew = entryentity.addNew();
                addNew.set("playlistid", paylistid);
                addNew.set("recordid", dataPK);
                addNew.set("entitytype", (Object)"02");
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{typeRecord});
    }

    public void deleteRelease(DynamicObject data, String appId) {
        DeleteServiceHelper.delete((String)(appId + "_playrecord_playlist"), (QFilter[])new QFilter[]{new QFilter("id", "=", data.getPkValue())});
    }

    public void sendMsg(DynamicObject data, String appId) {
        String operationKey = "refund";
        DynamicObjectCollection bidsection = data.getDynamicObjectCollection("bidsection");
        for (DynamicObject sectionRow : bidsection) {
            DynamicObjectCollection supplierentry = sectionRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                this.dealSendRow(row, appId, operationKey);
            }
        }
    }

    public void dealSendRow(DynamicObject row, String appId, String operationKey) {
        DynamicObject[] myTenderArr;
        HashSet<Long> sentSupplierIds = new HashSet<Long>();
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        Long id = (Long)row.get("paylistid");
        msgParam.put("id", id);
        DynamicObject payList = BusinessDataServiceHelper.loadSingle((Object)id, (String)(appId + "_pay_list"));
        DynamicObject bidProject = payList.getDynamicObject("bidproject");
        Long projectId = (Long)bidProject.getPkValue();
        Long supplierId = (Long)payList.getDynamicObject("supplier").getPkValue();
        String notifyType = null;
        if ("0".equals(payList.getString("type"))) {
            msgParam.put("tplScene", "refundenderfee");
            notifyType = MessageChannelUtil.getNotifyType((String)"bidpaysurepay", (String)"bid_pay_list");
        } else {
            msgParam.put("tplScene", "bidpayrefund");
            notifyType = MessageChannelUtil.getNotifyType((String)"bidpayrefund", (String)"bid_pay_list");
        }
        sentSupplierIds.add(supplierId);
        DynamicObject myTender = null;
        myTender = "bid".equals(appId) ? ((myTenderArr = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ten_mytender"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("supplier", "=", (Object)supplierId)}).values().toArray(new DynamicObject[0])).length > 0 ? myTenderArr[0] : null) : ((myTenderArr = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"resp_mytender"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("supplier", "=", (Object)supplierId)}).values().toArray(new DynamicObject[0])).length > 0 ? myTenderArr[0] : null);
        Long tenderPk = 0L;
        if (myTender != null) {
            tenderPk = myTender.getLong("id");
        }
        msgParam.put("notifyType", notifyType);
        msgParam.put("pkId", tenderPk);
        msgParam.put("title", null);
        msgParam.put("content", null);
        msgParam.put("msgentity", "bid_pay_list");
        msgParam.put("operation", operationKey);
        msgParam.put("targetButtonId", "button_bid_pay");
        msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "targetButtonId"));
        msgParam.put("appId", appId);
        if ("bid".equals(appId)) {
            msgParam.put("formId", "ten_mytender");
        } else {
            msgParam.put("formId", "resp_mytender");
        }
        PaySendMsg.sendMessage(msgParam, (Object)projectId, sentSupplierIds, (String)appId);
    }

    public String getAppId(DynamicObject bidProject) {
        String typeId;
        String appId = "bid";
        if (!bidProject.getDataEntityType().getProperties().containsKey((Object)"entitytypeid")) {
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
        }
        if ((typeId = bidProject.getString("entitytypeid")) != null && typeId.indexOf(95) != -1) {
            appId = typeId.substring(0, typeId.indexOf(95));
        }
        return appId;
    }
}

