/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill.transfer;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.BizLog;
import kd.scm.bid.business.bill.serviceImpl.BidTransferServiceImpl;
import kd.scm.bid.opplugin.bill.transfer.BidTransferValidatorPlugin;

public class BidTransferOperationPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("transferentry");
        fieldKeys.add("entry_bidproject");
        fieldKeys.add("oldmenber");
        fieldKeys.add("newmenber");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BidTransferValidatorPlugin(this.getAppId()));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("audit".equals(operationKey)) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
                this.updateBidProjectMemberEntry(dataEntity);
            }
        }
    }

    protected void updateBidProjectMemberEntry(DynamicObject dataEntity) {
        DynamicObjectCollection tranferEntry = dataEntity.getDynamicObjectCollection("transferentry");
        List bidProjectIds = tranferEntry.stream().filter(entry -> entry.getDynamicObject("entry_bidproject") != null).map(entry -> entry.getDynamicObject("entry_bidproject").getPkValue()).collect(Collectors.toList());
        if (bidProjectIds.size() == 0) {
            BizLog.log((String)"No bidProJect found in entry ");
            return;
        }
        String selectProperties = String.join((CharSequence)",", "memberleaderentity", "memberentity", "userleader", "user", "respbusinessleader", "iswrite", "isdirector", "respbusiness");
        BidTransferServiceImpl bidTransferService = new BidTransferServiceImpl(this.getAppId());
        DynamicObject[] bidProjects = bidTransferService.getBidProjectByIdsAndFields(bidProjectIds, selectProperties);
        Object oldMember = dataEntity.getDynamicObject("oldmenber").getPkValue();
        Object newMember = dataEntity.getDynamicObject("newmenber").getPkValue();
        bidTransferService.updateBidProjectMemberEntityUser(bidProjects, oldMember, newMember);
    }

    protected String getAppId() {
        return ((Object)((Object)this)).getClass().getName().split("\\.")[2];
    }
}

