/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill.transfer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.serviceImpl.BidTransferServiceImpl;

public class BidTransferValidatorPlugin
extends AbstractValidator {
    private String appId;

    public BidTransferValidatorPlugin() {
    }

    public BidTransferValidatorPlugin(String appId) {
        this.appId = appId;
    }

    public void validate() {
        String operateKey = this.getOperateKey();
        if ("submit".equals(operateKey) || "save".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                this.checkNewMemberExsitInAnotherEntry(dataEntity);
            }
        }
    }

    protected void checkNewMemberExsitInAnotherEntry(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObject oldMember = data.getDynamicObject("oldmenber");
        if (oldMember == null) {
            return;
        }
        Object oldMemberId = oldMember.getPkValue();
        DynamicObject newMember = data.getDynamicObject("newmenber");
        if (newMember == null) {
            return;
        }
        Object newMemberId = newMember.getPkValue();
        DynamicObjectCollection transferEntry = data.getDynamicObjectCollection("transferentry");
        if (transferEntry == null || transferEntry.size() == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u6ca1\u6709\u53ef\u8fdb\u884c\u8f6c\u529e\u7684\u7acb\u9879\u6570\u636e\u3002", (String)"BidTransferValidatorPlugin_0", (String)"scm-bid-opplugin", (Object[])new Object[0]));
            return;
        }
        List bidProjectIds = transferEntry.stream().filter(entry -> entry.getDynamicObject("entry_bidproject") != null).map(entry -> entry.getDynamicObject("entry_bidproject").getPkValue()).collect(Collectors.toList());
        DynamicObject[] transfers = BusinessDataServiceHelper.load((String)(this.appId + "_bidtransfer"), (String)String.join((CharSequence)",", "transferentry", "entry_bidproject"), (QFilter[])new QFilter[]{new QFilter("billstatus", "!=", (Object)"C"), new QFilter("transferentry.entry_bidproject", "in", bidProjectIds), new QFilter("id", "!=", data.getPkValue())});
        ArrayList unFinishedProjectIdList = new ArrayList(16);
        if (transfers.length > 0) {
            for (DynamicObject transfer : transfers) {
                DynamicObjectCollection transEntry = transfer.getDynamicObjectCollection("transferentry");
                transEntry.forEach(entry -> {
                    DynamicObject entryProject = entry.getDynamicObject("entry_bidproject");
                    if (entryProject == null) {
                        return;
                    }
                    unFinishedProjectIdList.add(entryProject.getPkValue());
                });
            }
        }
        BidTransferServiceImpl bidTransferService = new BidTransferServiceImpl(this.appId);
        String selectProperties = String.join((CharSequence)",", "userleader", "userleader", "memberentity", "user");
        DynamicObject[] bidProjects = bidTransferService.getBidProjectByIdsAndFields(bidProjectIds, selectProperties);
        Map bidProjectMemberEntryUserMap = bidTransferService.getBidProjectMemberEntryUserMap(bidProjects);
        for (int i = 0; i < transferEntry.size(); ++i) {
            DynamicObject entry2 = (DynamicObject)transferEntry.get(i);
            DynamicObject entry_project = entry2.getDynamicObject("entry_bidproject");
            if (entry_project == null) {
                return;
            }
            Object projectPkValue = entry_project.getPkValue();
            String leaderKey = "leaderUser" + projectPkValue;
            String userKey = "user" + projectPkValue;
            List leaderUserList = bidProjectMemberEntryUserMap.getOrDefault(leaderKey, new ArrayList(16));
            List userList = bidProjectMemberEntryUserMap.getOrDefault(userKey, new ArrayList(16));
            if (leaderUserList.contains(oldMemberId) && userList.contains(newMemberId)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u7b2c%1$s\u884c\u201c%2$s\u201d\u8f6c\u529e\u524d\u540e\u4eba\u5458\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u4e8e\u9886\u5bfc\u5c0f\u7ec4\u548c\u7ecf\u529e\u4eba\uff0c\u8bf7\u5220\u9664\u540e\u63d0\u4ea4\u3002", (String)"BidTransferValidatorPlugin_1", (String)"scm-bid-opplugin", (Object[])new Object[0]), i + 1, entry_project.getString("name")));
                return;
            }
            if (userList.contains(oldMemberId) && leaderUserList.contains(newMemberId)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u7b2c%1$s\u884c\u201c%2$s\u201d\u8f6c\u529e\u524d\u540e\u4eba\u5458\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u4e8e\u9886\u5bfc\u5c0f\u7ec4\u548c\u7ecf\u529e\u4eba\uff0c\u8bf7\u5220\u9664\u540e\u63d0\u4ea4\u3002", (String)"BidTransferValidatorPlugin_1", (String)"scm-bid-opplugin", (Object[])new Object[0]), i + 1, entry_project.getString("name")));
                return;
            }
            if (!unFinishedProjectIdList.contains(projectPkValue)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u7b2c%1$s\u884c\u201c%2$s\u201d\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8f6c\u529e\u4e1a\u52a1\u3002", (String)"BidTransferValidatorPlugin_3", (String)"scm-bid-opplugin", (Object[])new Object[0]), i + 1, entry_project.getString("name")));
            return;
        }
    }
}

