/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.apihandle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.apihandle.PriceHandleProcessor;

public class CgPriceHandleProcessor
extends PriceHandleProcessor {
    @Override
    public Map<String, PriceInfo> afterInvoke(Object result, String ecType) {
        Object res = super.afterInvoke(result, ecType);
        QFilter filter = new QFilter("mallgoods.number", "in", res.keySet()).and(new QFilter("mallgoods.source", "=", (Object)EcPlatformEnum.ECPLATFORM_CG.getVal()));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"mallgoods.number,taxrate", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dyo : col) {
            String skuId = dyo.getString("mallgoods.number");
            if (null == res.get(skuId)) continue;
            this.calPriceByTaxrate((PriceInfo)res.get(skuId), dyo.getBigDecimal("taxrate"));
        }
        return res;
    }

    private void calPriceByTaxrate(PriceInfo priceInfo, BigDecimal taxRate) {
        BigDecimal taxPrice = priceInfo.getTaxPrice();
        BigDecimal price = taxPrice.divide(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100"))), 2, RoundingMode.HALF_UP);
        priceInfo.setPrice(price);
        priceInfo.setTax(taxPrice.subtract(price));
        priceInfo.setTaxRate(taxRate);
    }
}

