/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.apihandle;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.helper.apiconnector.IApiHandleProcessor;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.helper.apiconnector.constant.ApiConstant;

public class FreightHandleProcessor
implements IApiHandleProcessor {
    private static Log logger = LogFactory.getLog(FreightHandleProcessor.class);

    public Map<String, Object> beforeInvoke(Map<String, Object> param, String ecType) {
        Map handleParam = super.beforeInvoke(param, ecType);
        if (null != handleParam.get("townId")) {
            String[] jdAddress = AddressUtil.getNumberArr((Long)Parser.toLong(handleParam.get("townId")), (String)ecType);
            if (null == jdAddress) {
                throw new KDException(new ErrorCode("FreightHandleProcessor error", ResManager.loadKDString((String)"\u83b7\u53d6\u82cd\u7a79\u5730\u5740\u5bf9\u5e94\u7684\u7535\u5546\u5730\u5740\u4e3a\u7a7a\u3002", (String)"FreightHandleProcessor_0", (String)"scm-common-helper", (Object[])new Object[0])), new Object[0]);
            }
            logger.info("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u82cd\u7a79\u5730\u5740\u5bf9\u5e94\u7684\u7535\u5546\u5730\u5740\uff1a" + jdAddress);
            if (StringUtils.isNotBlank((Object)jdAddress) && jdAddress.length >= 3) {
                handleParam.put("provinceId", jdAddress[ApiConstant.PROVINCE_INDEX]);
                handleParam.put("cityId", jdAddress[ApiConstant.CITY_INDEX]);
                handleParam.put("countyId", jdAddress[ApiConstant.COUNTY_INDEX]);
                if (jdAddress.length == 4) {
                    handleParam.put("townId", jdAddress[ApiConstant.TOWN_INDEX]);
                } else {
                    handleParam.put("townId", "0");
                }
            }
            return handleParam;
        }
        if (null != handleParam.get("countyId")) {
            String[] jdAddress = AddressUtil.getNumberArr((Long)(null == handleParam.get("countyId") ? 0L : Parser.toLong(handleParam.get("countyId"))), (String)ecType);
            if (null == jdAddress) {
                throw new KDException(new ErrorCode("FreightHandleProcessor error", ResManager.loadKDString((String)"\u83b7\u53d6\u82cd\u7a79\u5730\u5740\u5bf9\u5e94\u7684\u7535\u5546\u5730\u5740\u4e3a\u7a7a\u3002", (String)"FreightHandleProcessor_0", (String)"scm-common-helper", (Object[])new Object[0])), new Object[0]);
            }
            logger.info("\u65b0\u7248\u5546\u57ce\u83b7\u53d6\u82cd\u7a79\u5730\u5740\u5bf9\u5e94\u7684\u7535\u5546\u5730\u5740\uff1a" + jdAddress);
            if (StringUtils.isNotBlank((Object)jdAddress) && jdAddress.length == 3) {
                handleParam.put("provinceId", jdAddress[ApiConstant.PROVINCE_INDEX]);
                handleParam.put("cityId", jdAddress[ApiConstant.CITY_INDEX]);
                handleParam.put("countyId", jdAddress[ApiConstant.COUNTY_INDEX]);
                handleParam.put("townId", "0");
            }
            return handleParam;
        }
        return handleParam;
    }

    public BigDecimal afterInvoke(Object result, String ecType) {
        BigDecimal freight = BigDecimal.ZERO;
        try {
            Map map = (Map)super.afterInvoke(result, ecType);
            freight = Parser.toBigDecimal(map.get("freight"));
            if (null == freight) {
                throw new KDException(new ErrorCode("FreightHandleProcessor error", ResManager.loadKDString((String)"\u83b7\u53d6\u7535\u5546\u5546\u54c1\u8fd0\u8d39\u4e3a\u7a7a\u3002", (String)"FreightHandleProcessor_1", (String)"scm-common-helper", (Object[])new Object[0])), new Object[0]);
            }
        }
        catch (KDBizException ex) {
            throw new KDBizException(ex.getErrorCode(), new Object[]{MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528{0}\u8fd0\u8d39\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{1}", (String)"FreightHandleProcessor_2", (String)"scm-common-helper", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)ecType).getName(), ex.getMessage())});
        }
        return freight;
    }
}

